/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.jogl;

import java.awt.EventQueue;
import net.java.games.jogl.GLCanvas;
import net.java.games.jogl.GLDrawable;
import net.java.games.jogl.GLException;

public class Animator {
    private GLDrawable drawable;
    private Runnable runnable;
    private Thread thread;
    private boolean shouldStop;

    public Animator(GLDrawable gLDrawable) {
        this.drawable = gLDrawable;
        if (gLDrawable instanceof GLCanvas) {
            ((GLCanvas)gLDrawable).willSetRenderingThread();
        }
    }

    public synchronized void start() {
        if (this.thread != null) {
            throw new GLException("Already started");
        }
        if (this.runnable == null) {
            this.runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object v1;
                    boolean bl = false;
                    try {
                        Animator.this.drawable.setRenderingThread(Thread.currentThread());
                        Animator.this.drawable.setNoAutoRedrawMode(true);
                        while (!Animator.this.shouldStop) {
                            bl = false;
                            Animator.this.drawable.display();
                            bl = true;
                        }
                        Object var3_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object v0;
                        Object var3_3 = null;
                        Animator.this.shouldStop = false;
                        Animator.this.drawable.setNoAutoRedrawMode(false);
                        try {
                            if (bl && Animator.this.drawable.getRenderingThread() != null) {
                                Animator.this.drawable.setRenderingThread(null);
                            }
                            v0 = null;
                        }
                        catch (Throwable throwable2) {
                            v0 = null;
                        }
                        Object var5_7 = v0;
                        Animator animator = Animator.this;
                        synchronized (animator) {
                            Animator.this.thread = null;
                            Animator.this.notify();
                        }
                        throw throwable;
                    }
                    Animator.this.shouldStop = false;
                    Animator.this.drawable.setNoAutoRedrawMode(false);
                    try {
                        if (bl && Animator.this.drawable.getRenderingThread() != null) {
                            Animator.this.drawable.setRenderingThread(null);
                        }
                        v1 = null;
                    }
                    catch (Throwable throwable) {
                        v1 = null;
                    }
                    Object var5_6 = v1;
                    Animator animator = Animator.this;
                    synchronized (animator) {
                        Animator.this.thread = null;
                        Animator.this.notify();
                    }
                }
            };
        }
        this.thread = new Thread(this.runnable);
        this.thread.start();
    }

    public synchronized void stop() {
        this.shouldStop = true;
        if (Thread.currentThread() == this.thread || EventQueue.isDispatchThread()) {
            return;
        }
        while (this.shouldStop && this.thread != null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

