/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.UserEvent;
import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.CallPathTextWindow;
import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.LedgerWindow;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfImageOutput;
import edu.uoregon.tau.paraprof.ParaProfManagerWindow;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.UserEventWindowPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class UserEventWindow
extends JFrame
implements ActionListener,
MenuListener,
Observer,
ChangeListener {
    private ParaProfTrial trial = null;
    private DataSorter dataSorter = null;
    UserEvent userEvent = null;
    private JMenu optionsMenu = null;
    private JMenu windowsMenu = null;
    private JCheckBoxMenuItem descendingOrder = null;
    private JCheckBoxMenuItem showPathTitleInReverse = null;
    private JCheckBoxMenuItem showMetaData = null;
    private JLabel sliderMultipleLabel = new JLabel("Slider Multiple");
    private JComboBox sliderMultiple;
    private JLabel barLengthLabel = new JLabel("Bar Multiple");
    private JSlider barLengthSlider = new JSlider(0, 40, 1);
    private Container contentPane = null;
    private GridBagLayout gbl = null;
    private GridBagConstraints gbc = null;
    UserEventWindowPanel panel = null;
    JScrollPane sp = null;
    JLabel label = null;
    private Vector list = null;
    private int order = 0;
    private int valueType = 12;

    public UserEventWindow(ParaProfTrial paraProfTrial, UserEvent userEvent, DataSorter dataSorter) {
        this.userEvent = userEvent;
        this.trial = paraProfTrial;
        this.dataSorter = dataSorter;
        int n = 650;
        int n2 = 550;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        int n3 = dimension.height;
        int n4 = dimension.width;
        if (n > n4) {
            n = n4;
        }
        if (n2 > n3) {
            n2 = n3;
        }
        int n5 = (n4 - n) / 2;
        int n6 = (n3 - n2) / 2;
        ((Component)this).setSize(new Dimension(n, n2));
        ((Component)this).setLocation(n5, n6);
        this.setTitle("User Event Window: " + paraProfTrial.getTrialIdentifier(true));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                UserEventWindow.this.thisWindowClosing(windowEvent);
            }
        });
        if (ParaProf.helpWindow.isVisible()) {
            this.help(false);
        }
        this.sortLocalData();
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = null;
        JMenuItem jMenuItem = null;
        JMenu jMenu2 = new JMenu("File");
        jMenu = new JMenu("Save ...");
        jMenuItem = new JMenuItem("Save Image");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu2.add(jMenu);
        jMenuItem = new JMenuItem("Preferences...");
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Print");
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Close This Window");
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Exit ParaProf!");
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenu2.addMenuListener(this);
        this.optionsMenu = new JMenu("Options");
        ButtonGroup buttonGroup = null;
        JCheckBoxMenuItem jCheckBoxMenuItem = null;
        JRadioButtonMenuItem jRadioButtonMenuItem = null;
        this.descendingOrder = new JCheckBoxMenuItem("Descending Order", true);
        this.descendingOrder.addActionListener(this);
        this.optionsMenu.add(this.descendingOrder);
        jMenu = new JMenu("Select Value Type");
        buttonGroup = new ButtonGroup();
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Userevents", true);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Min. Value", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Max. Value", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Mean Value", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Standard Deviation", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        this.optionsMenu.add(jMenu);
        jCheckBoxMenuItem = new JCheckBoxMenuItem("Display Sliders", false);
        jCheckBoxMenuItem.addActionListener(this);
        this.optionsMenu.add(jCheckBoxMenuItem);
        this.showPathTitleInReverse = new JCheckBoxMenuItem("Show Path Title in Reverse", true);
        this.showPathTitleInReverse.addActionListener(this);
        this.optionsMenu.add(this.showPathTitleInReverse);
        this.showMetaData = new JCheckBoxMenuItem("Show Meta Data in Panel", true);
        this.showMetaData.addActionListener(this);
        this.optionsMenu.add(this.showMetaData);
        this.optionsMenu.addMenuListener(this);
        this.windowsMenu = new JMenu("Windows");
        jMenuItem = new JMenuItem("Show ParaProf Manager");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show Function Ledger");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show Group Ledger");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show User Event Ledger");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show Call Path Relations");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Close All Sub-Windows");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        this.windowsMenu.addMenuListener(this);
        JMenu jMenu3 = new JMenu("Help");
        jMenuItem = new JMenuItem("Show Help Window");
        jMenuItem.addActionListener(this);
        jMenu3.add(jMenuItem);
        jMenuItem = new JMenuItem("About ParaProf");
        jMenuItem.addActionListener(this);
        jMenu3.add(jMenuItem);
        jMenu3.addMenuListener(this);
        jMenuBar.add(jMenu2);
        jMenuBar.add(this.optionsMenu);
        jMenuBar.add(this.windowsMenu);
        jMenuBar.add(jMenu3);
        this.setJMenuBar(jMenuBar);
        this.contentPane = this.getContentPane();
        this.gbl = new GridBagLayout();
        this.contentPane.setLayout(this.gbl);
        this.gbc = new GridBagConstraints();
        this.gbc.insets = new Insets(5, 5, 5, 5);
        this.panel = new UserEventWindowPanel(paraProfTrial, userEvent, this);
        this.sp = new JScrollPane(this.panel);
        this.setHeader();
        String[] stringArray = new String[]{"1.00", "0.75", "0.50", "0.25", "0.10"};
        this.sliderMultiple = new JComboBox<String>(stringArray);
        this.sliderMultiple.addActionListener(this);
        this.barLengthSlider.setPaintTicks(true);
        this.barLengthSlider.setMajorTickSpacing(5);
        this.barLengthSlider.setMinorTickSpacing(1);
        this.barLengthSlider.setPaintLabels(true);
        this.barLengthSlider.setSnapToTicks(true);
        this.barLengthSlider.addChangeListener(this);
        this.gbc.fill = 1;
        this.gbc.anchor = 10;
        this.gbc.weightx = 0.95;
        this.gbc.weighty = 0.98;
        this.addCompItem(this.sp, this.gbc, 0, 0, 1, 1);
        ParaProf.incrementNumWindows();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                Object object2;
                String string = actionEvent.getActionCommand();
                if (string.equals("Print")) {
                    ParaProfUtils.print(this.panel);
                } else if (string.equals("Preferences...")) {
                    this.trial.getPreferences().showPreferencesWindow();
                } else if (string.equals("Save Image")) {
                    object2 = new ParaProfImageOutput();
                    ((ParaProfImageOutput)object2).saveImage(this.panel);
                }
                if (string.equals("Close This Window")) {
                    this.closeThisWindow();
                } else if (string.equals("Exit ParaProf!")) {
                    ((Component)this).setVisible(false);
                    this.dispose();
                    ParaProf.exitParaProf(0);
                } else if (string.equals("Number of Userevents")) {
                    this.valueType = 12;
                    this.setHeader();
                    this.panel.repaint();
                } else if (string.equals("Min. Value")) {
                    this.valueType = 14;
                    this.setHeader();
                    this.panel.repaint();
                } else if (string.equals("Max. Value")) {
                    this.valueType = 16;
                    this.setHeader();
                    this.panel.repaint();
                } else if (string.equals("Mean Value")) {
                    this.valueType = 18;
                    this.setHeader();
                    this.panel.repaint();
                } else if (string.equals("Standard Deviation")) {
                    this.valueType = 20;
                    this.setHeader();
                    this.panel.repaint();
                } else if (string.equals("Descending Order")) {
                    this.order = ((JCheckBoxMenuItem)this.optionsMenu.getItem(0)).isSelected() ? 0 : 1;
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Display Sliders")) {
                    if (((JCheckBoxMenuItem)this.optionsMenu.getItem(2)).isSelected()) {
                        this.displaySiders(true);
                    } else {
                        this.displaySiders(false);
                    }
                } else if (string.equals("Show Path Title in Reverse")) {
                    this.setTitle("User Event Window: " + this.trial.getTrialIdentifier(this.showPathTitleInReverse.isSelected()));
                } else if (string.equals("Show Meta Data in Panel")) {
                    this.setHeader();
                } else if (string.equals("Show ParaProf Manager")) {
                    new ParaProfManagerWindow().show();
                } else if (string.equals("Show Function Ledger")) {
                    new LedgerWindow(this.trial, 0).show();
                } else if (string.equals("Show Group Ledger")) {
                    new LedgerWindow(this.trial, 1).show();
                } else if (string.equals("Show User Event Ledger")) {
                    new LedgerWindow(this.trial, 2).show();
                } else if (string.equals("Show Call Path Relations")) {
                    object2 = new CallPathTextWindow(this.trial, -1, -1, -1, this.getDataSorter(), 1);
                    this.trial.getSystemEvents().addObserver((Observer)object2);
                    ((Window)object2).show();
                } else if (string.equals("Close All Sub-Windows")) {
                    this.trial.getSystemEvents().updateRegisteredObjects("subWindowCloseEvent");
                } else if (string.equals("About ParaProf")) {
                    JOptionPane.showMessageDialog(this, ParaProf.getInfoString());
                } else if (string.equals("Show Help Window")) {
                    this.help(true);
                }
            } else if (object == this.sliderMultiple) {
                this.panel.changeInMultiples();
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        try {
            this.panel.changeInMultiples();
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void menuSelected(MenuEvent menuEvent) {
        try {
            if (this.trial.groupNamesPresent()) {
                this.windowsMenu.getItem(2).setEnabled(true);
            } else {
                this.windowsMenu.getItem(2).setEnabled(false);
            }
            if (this.trial.userEventsPresent()) {
                this.windowsMenu.getItem(3).setEnabled(true);
            } else {
                this.windowsMenu.getItem(3).setEnabled(false);
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void update(Observable observable, Object object) {
        String string = (String)object;
        if (string.equals("prefEvent")) {
            this.panel.repaint();
        } else if (string.equals("colorEvent")) {
            this.panel.repaint();
        } else if (string.equals("subWindowCloseEvent")) {
            this.closeThisWindow();
        }
    }

    private void help(boolean bl) {
        ParaProf.helpWindow.clearText();
        if (bl) {
            ParaProf.helpWindow.show();
        }
        ParaProf.helpWindow.writeText("This is the userevent data window for:");
        ParaProf.helpWindow.writeText(this.userEvent.getName());
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("This window shows you this userevent's statistics across all the threads.");
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("Use the options menu to select different ways of displaying the data.");
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("Right click anywhere within this window to bring up a popup");
        ParaProf.helpWindow.writeText("menu. In this menu you can change or reset the default color");
        ParaProf.helpWindow.writeText("for this userevent.");
    }

    public DataSorter getDataSorter() {
        return this.dataSorter;
    }

    public void sortLocalData() {
        this.list = this.dataSorter.getUserEventData(this.userEvent, this.valueType + this.order);
    }

    public Vector getData() {
        return this.list;
    }

    public int getValueType() {
        return this.valueType;
    }

    public Dimension getViewportSize() {
        return this.sp.getViewport().getExtentSize();
    }

    public Rectangle getViewRect() {
        return this.sp.getViewport().getViewRect();
    }

    public void setVerticalScrollBarPosition(int n) {
        JScrollBar jScrollBar = this.sp.getVerticalScrollBar();
        jScrollBar.setValue(n);
    }

    public void setHeader() {
        if (this.showMetaData.isSelected()) {
            JTextArea jTextArea = new JTextArea();
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setEditable(false);
            jTextArea.append(this.getHeaderString());
            this.sp.setColumnHeaderView(jTextArea);
        } else {
            this.sp.setColumnHeaderView(null);
        }
    }

    public String getHeaderString() {
        return "Name: " + this.userEvent.getName() + "\n" + "Value Type: " + UtilFncs.getValueTypeString((int)this.valueType) + "\n";
    }

    public int getSliderValue() {
        int n = -1;
        n = this.barLengthSlider.getValue();
        return n;
    }

    public double getSliderMultiple() {
        String string = null;
        string = (String)this.sliderMultiple.getSelectedItem();
        return Double.parseDouble(string);
    }

    private void displaySiders(boolean bl) {
        if (bl) {
            this.contentPane.remove(this.sp);
            this.gbc.fill = 0;
            this.gbc.anchor = 13;
            this.gbc.weightx = 0.1;
            this.gbc.weighty = 0.01;
            this.addCompItem(this.sliderMultipleLabel, this.gbc, 0, 0, 1, 1);
            this.gbc.fill = 0;
            this.gbc.anchor = 17;
            this.gbc.weightx = 0.1;
            this.gbc.weighty = 0.01;
            this.addCompItem(this.sliderMultiple, this.gbc, 1, 0, 1, 1);
            this.gbc.fill = 0;
            this.gbc.anchor = 13;
            this.gbc.weightx = 0.1;
            this.gbc.weighty = 0.01;
            this.addCompItem(this.barLengthLabel, this.gbc, 2, 0, 1, 1);
            this.gbc.fill = 2;
            this.gbc.anchor = 17;
            this.gbc.weightx = 0.7;
            this.gbc.weighty = 0.01;
            this.addCompItem(this.barLengthSlider, this.gbc, 3, 0, 1, 1);
            this.gbc.fill = 1;
            this.gbc.anchor = 10;
            this.gbc.weightx = 0.95;
            this.gbc.weighty = 0.98;
            this.addCompItem(this.sp, this.gbc, 0, 1, 4, 1);
        } else {
            this.contentPane.remove(this.sliderMultipleLabel);
            this.contentPane.remove(this.sliderMultiple);
            this.contentPane.remove(this.barLengthLabel);
            this.contentPane.remove(this.barLengthSlider);
            this.contentPane.remove(this.sp);
            this.gbc.fill = 1;
            this.gbc.anchor = 10;
            this.gbc.weightx = 0.95;
            this.gbc.weighty = 0.98;
            this.addCompItem(this.sp, this.gbc, 0, 0, 1, 1);
        }
        this.validate();
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    void closeThisWindow() {
        try {
            ((Component)this).setVisible(false);
            this.trial.getSystemEvents().deleteObserver(this);
            ParaProf.decrementNumWindows();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dispose();
    }
}

