/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.dms.dss;

import edu.uoregon.tau.dms.dss.CallPathUtilFuncs;
import edu.uoregon.tau.dms.dss.Context;
import edu.uoregon.tau.dms.dss.DataSource;
import edu.uoregon.tau.dms.dss.Function;
import edu.uoregon.tau.dms.dss.FunctionProfile;
import edu.uoregon.tau.dms.dss.LineData;
import edu.uoregon.tau.dms.dss.Node;
import edu.uoregon.tau.dms.dss.Thread;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;

public class DynaprofDataSource
extends DataSource {
    private File[] files;
    private LineData functionDataLine = new LineData();
    private LineData functionChildDataLine = new LineData();
    private boolean headerProcessed = false;

    public DynaprofDataSource(File[] fileArray) {
        this.setMetrics(new Vector());
        this.files = fileArray;
    }

    public void cancelLoad() {
    }

    public int getProgress() {
        return 0;
    }

    public void load() throws FileNotFoundException, IOException {
        int n = -1;
        Function function = null;
        FunctionProfile functionProfile = null;
        Node node = null;
        Context context = null;
        Thread thread = null;
        int n2 = 0;
        int n3 = -1;
        String string = null;
        Object var10_10 = null;
        Object var11_11 = null;
        Object var13_12 = null;
        boolean bl = false;
        long l = System.currentTimeMillis();
        for (int i = 0; i < this.files.length; ++i) {
            FileInputStream fileInputStream = new FileInputStream(this.files[i]);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            if (!this.headerProcessed()) {
                string = bufferedReader.readLine();
                if (string == null) {
                    System.out.println("Error processing file: " + this.files[i].getName());
                    System.out.println("Unexpected end of file!");
                    return;
                }
                if (string.charAt(0) == '#') {
                    if (this.debug()) {
                        System.out.println("Header present");
                    }
                    bufferedReader.readLine();
                    StringTokenizer stringTokenizer = new StringTokenizer(bufferedReader.readLine(), " \t\n\r");
                    stringTokenizer.nextToken();
                    String string2 = stringTokenizer.nextToken();
                    for (int j = Integer.parseInt(string2); j > 0; --j) {
                        string = bufferedReader.readLine();
                        stringTokenizer = new StringTokenizer(string, " :\t\n\r");
                        stringTokenizer.nextToken();
                        String string3 = stringTokenizer.nextToken();
                        this.addMetric(string3);
                        if (!this.debug()) continue;
                        System.out.println("metric name found: " + string3);
                    }
                    if (this.debug()) {
                        System.out.println("Number of metrics: " + this.getNumberOfMetrics());
                    }
                } else {
                    if (this.debug()) {
                        System.out.println("No header present");
                    }
                    this.addMetric("Time");
                    n = 0;
                }
                this.setHeaderProcessed(true);
            }
            int[] nArray = this.getNCT(this.files[i].getName());
            n2 = n2++;
            n3 = nArray[2];
            node = this.addNode(n2);
            context = node.addContext(0);
            thread = context.getThread(n3);
            if (thread == null) {
                thread = context.addThread(n3, this.getNumberOfMetrics());
            }
            while ((string = bufferedReader.readLine()) != null) {
                boolean bl2;
                this.getFunctionDataLine(string);
                boolean bl3 = bl2 = string.indexOf("TOTAL") == 0;
                if (bl2) {
                    ++n;
                }
                double d = this.functionDataLine.d3 / (double)this.functionDataLine.i1;
                if (this.debug()) {
                    System.out.println("function line: " + string);
                    System.out.println("name:" + this.functionDataLine.s0);
                    System.out.println("number_of_children:" + this.functionDataLine.i0);
                    System.out.println("excl.total:" + this.functionDataLine.d0);
                    System.out.println("excl.calls:" + this.functionDataLine.i1);
                    System.out.println("excl.min:" + this.functionDataLine.d1);
                    System.out.println("excl.max:" + this.functionDataLine.d2);
                    System.out.println("incl.total:" + this.functionDataLine.d3);
                    System.out.println("incl.calls:" + this.functionDataLine.i2);
                    System.out.println("incl.min:" + this.functionDataLine.d4);
                    System.out.println("incl.max:" + this.functionDataLine.d5);
                }
                if (!bl2 && this.functionDataLine.i1 != 0) {
                    function = this.addFunction(this.functionDataLine.s0, this.getNumberOfMetrics());
                    functionProfile = thread.getFunctionProfile(function);
                    if (functionProfile == null) {
                        functionProfile = new FunctionProfile(function, this.getNumberOfMetrics());
                        thread.addFunctionProfile(functionProfile);
                    }
                    functionProfile.setExclusive(n, this.functionDataLine.d0);
                    functionProfile.setInclusive(n, this.functionDataLine.d3);
                    functionProfile.setNumCalls(this.functionDataLine.i1);
                    functionProfile.setNumSubr(this.functionDataLine.i2);
                    functionProfile.setInclusivePerCall(n, d);
                }
                for (int j = 0; j < this.functionDataLine.i0; ++j) {
                    string = bufferedReader.readLine();
                    if (string.charAt(1) == ',') continue;
                    this.getFunctionChildDataLine(string);
                    if (this.debug()) {
                        System.out.println("function child line: " + string);
                        System.out.println("name:" + this.functionChildDataLine.s0);
                        System.out.println("incl.total:" + this.functionChildDataLine.d3);
                        System.out.println("incl.calls:" + this.functionChildDataLine.i2);
                        System.out.println("incl.min:" + this.functionChildDataLine.d4);
                        System.out.println("incl.max:" + this.functionChildDataLine.d5);
                    }
                    if (this.functionDataLine.i1 == 0) continue;
                    function = this.addFunction(this.functionDataLine.s0 + " => " + this.functionChildDataLine.s0, this.getNumberOfMetrics());
                    functionProfile = thread.getFunctionProfile(function);
                    if (functionProfile == null) {
                        functionProfile = new FunctionProfile(function, this.getNumberOfMetrics());
                        thread.addFunctionProfile(functionProfile);
                    }
                    double d2 = functionProfile.getInclusive(n) + this.functionChildDataLine.d3;
                    functionProfile.setInclusive(n, d2);
                    functionProfile.setExclusive(n, d2);
                    double d3 = functionProfile.getNumCalls();
                    if (n == 0) {
                        d3 = functionProfile.getNumCalls() + (double)this.functionChildDataLine.i2;
                        functionProfile.setNumCalls(d3);
                    }
                    functionProfile.setInclusivePerCall(n, functionProfile.getInclusive(n) / d3);
                }
            }
        }
        this.generateDerivedData();
        if (CallPathUtilFuncs.checkCallPathsPresent(this.getFunctions())) {
            this.setCallPathDataPresent(true);
        }
        l = System.currentTimeMillis() - l;
    }

    private int[] getNCT(String string) {
        int[] nArray = new int[3];
        Vector vector = new Vector();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".\t\n\r");
        int n = stringTokenizer.countTokens();
        nArray[0] = 0;
        for (int i = 0; i < n - 2; ++i) {
            stringTokenizer.nextToken();
        }
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        try {
            nArray[1] = Integer.parseInt(string2);
            nArray[2] = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                nArray[1] = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException2) {
                // empty catch block
            }
        }
        return nArray;
    }

    private void getFunctionDataLine(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",\t\n\r");
        this.functionDataLine.s0 = stringTokenizer.nextToken();
        this.functionDataLine.i0 = Integer.parseInt(stringTokenizer.nextToken());
        this.functionDataLine.d0 = Double.parseDouble(stringTokenizer.nextToken());
        this.functionDataLine.i1 = Integer.parseInt(stringTokenizer.nextToken());
        this.functionDataLine.d1 = Double.parseDouble(stringTokenizer.nextToken());
        this.functionDataLine.d2 = Double.parseDouble(stringTokenizer.nextToken());
        this.functionDataLine.d3 = Double.parseDouble(stringTokenizer.nextToken());
        this.functionDataLine.i2 = Integer.parseInt(stringTokenizer.nextToken());
        this.functionDataLine.d4 = Double.parseDouble(stringTokenizer.nextToken());
        this.functionDataLine.d5 = Double.parseDouble(stringTokenizer.nextToken());
    }

    private void getFunctionChildDataLine(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",\t\n\r");
        this.functionChildDataLine.s0 = stringTokenizer.nextToken();
        this.functionChildDataLine.d3 = Double.parseDouble(stringTokenizer.nextToken());
        this.functionChildDataLine.i2 = Integer.parseInt(stringTokenizer.nextToken());
        this.functionChildDataLine.d4 = Double.parseDouble(stringTokenizer.nextToken());
        this.functionChildDataLine.d5 = Double.parseDouble(stringTokenizer.nextToken());
    }

    private void setHeaderProcessed(boolean bl) {
        this.headerProcessed = bl;
    }

    private boolean headerProcessed() {
        return this.headerProcessed;
    }
}

