/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.DataSource;
import edu.uoregon.tau.dms.dss.DataSourceException;
import edu.uoregon.tau.dms.dss.DatabaseAPI;
import edu.uoregon.tau.dms.dss.DatabaseException;
import edu.uoregon.tau.dms.dss.DssIterator;
import edu.uoregon.tau.dms.dss.FileList;
import edu.uoregon.tau.dms.dss.Function;
import edu.uoregon.tau.dms.dss.Group;
import edu.uoregon.tau.dms.dss.Metric;
import edu.uoregon.tau.dms.dss.Trial;
import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.ColorChooser;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfExperiment;
import edu.uoregon.tau.paraprof.ParaProfMetric;
import edu.uoregon.tau.paraprof.ParaProfObserver;
import edu.uoregon.tau.paraprof.ParaProfTreeNodeUserObject;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.Preferences;
import edu.uoregon.tau.paraprof.StaticMainWindow;
import edu.uoregon.tau.paraprof.SystemEvents;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class ParaProfTrial
extends Trial
implements ParaProfObserver,
ParaProfTreeNodeUserObject {
    private Group selectedGroup;
    private int groupFilter = 0;
    private DatabaseAPI dbAPI;
    private boolean defaultTrial = false;
    private ParaProfExperiment experiment = null;
    private DefaultMutableTreeNode defaultMutableTreeNode = null;
    private TreePath treePath = null;
    private boolean dBTrial = false;
    private boolean upload = false;
    private boolean loading = false;
    private SystemEvents systemEvents = new SystemEvents();
    private StaticMainWindow sMW = null;
    private ColorChooser clrChooser = new ColorChooser(this, null);
    private Preferences preferences = new Preferences(this, ParaProf.savedPreferences);
    private String path = null;
    private String pathReverse = null;
    private int selectedMetricID = 0;
    private Vector observers = new Vector();
    private boolean debug = UtilFncs.debug;

    public ParaProfTrial() {
        super(0);
        this.setID(-1);
        this.setExperimentID(-1);
        this.setApplicationID(-1);
        this.setName("");
    }

    public ParaProfTrial(Trial trial) {
        super(trial);
    }

    public void setExperiment(ParaProfExperiment paraProfExperiment) {
        this.experiment = paraProfExperiment;
    }

    public ParaProfExperiment getExperiment() {
        return this.experiment;
    }

    public void setDMTN(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.defaultMutableTreeNode = defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode getDMTN() {
        return this.defaultMutableTreeNode;
    }

    public void setTreePath(TreePath treePath) {
        this.treePath = treePath;
    }

    public TreePath getTreePath() {
        return this.treePath;
    }

    public void setDBTrial(boolean bl) {
        this.dBTrial = bl;
    }

    public boolean dBTrial() {
        return this.dBTrial;
    }

    public void setDefaultTrial(boolean bl) {
        this.defaultTrial = bl;
    }

    public boolean defaultTrial() {
        return this.defaultTrial;
    }

    public void setUpload(boolean bl) {
        this.upload = bl;
    }

    public boolean upload() {
        return this.upload;
    }

    public void setLoading(boolean bl) {
        this.loading = bl;
    }

    public boolean loading() {
        return this.loading;
    }

    public String getIDString() {
        if (this.experiment != null) {
            return this.experiment.getIDString() + ":" + super.getID();
        }
        return ":" + super.getID();
    }

    public ColorChooser getColorChooser() {
        return this.clrChooser;
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public String getTrialIdentifier(boolean bl) {
        if (this.path != null) {
            if (bl) {
                return this.pathReverse;
            }
            return this.path;
        }
        return "Application " + this.getApplicationID() + ", Experiment " + this.getExperimentID() + ", Trial " + this.getID() + ".";
    }

    public void setPaths(String string) {
        this.path = string;
        this.pathReverse = FileList.getPathReverse((String)string);
    }

    public String getPath() {
        return this.path;
    }

    public String getPathReverse() {
        return this.pathReverse;
    }

    public String toString() {
        if (this.loading()) {
            return super.getName() + " (Loading...)";
        }
        return super.getName();
    }

    public void clearDefaultMutableTreeNodes() {
        this.setDMTN(null);
    }

    public StaticMainWindow getStaticMainWindow() {
        return this.sMW;
    }

    public void showMainWindow() {
        if (this.sMW == null) {
            this.sMW = new StaticMainWindow(this, UtilFncs.debug);
            ParaProf.incrementNumWindows();
            this.sMW.setVisible(true);
            this.getSystemEvents().addObserver(this.sMW);
        } else {
            ParaProf.incrementNumWindows();
            this.getSystemEvents().addObserver(this.sMW);
            this.sMW.show();
        }
    }

    public void closeStaticMainWindow() {
        if (this.sMW != null) {
            this.getSystemEvents().deleteObserver(this.sMW);
            this.sMW.setVisible(false);
        }
    }

    public SystemEvents getSystemEvents() {
        return this.systemEvents;
    }

    public void setSelectedMetricID(int n) {
        this.selectedMetricID = n;
    }

    public int getSelectedMetricID() {
        return this.selectedMetricID;
    }

    public boolean isTimeMetric() {
        String string = this.getMetricName(this.getSelectedMetricID());
        return (string = string.toUpperCase()).indexOf("TIME") != -1;
    }

    public boolean isDerivedMetric() {
        return this.getMetric(this.getSelectedMetricID()).getDerivedMetric();
    }

    public Vector getMetrics() {
        return this.dataSource.getMetrics();
    }

    public DssIterator getMetricList() {
        return new DssIterator(this.getMetrics());
    }

    public int getNumberOfMetrics() {
        return this.dataSource.getNumberOfMetrics();
    }

    public ParaProfMetric getMetric(int n) {
        return (ParaProfMetric)this.dataSource.getMetric(n);
    }

    public String getMetricName(int n) {
        return this.dataSource.getMetricName(n);
    }

    public ParaProfMetric addMetric() {
        ParaProfMetric paraProfMetric = new ParaProfMetric();
        this.dataSource.addMetric((Metric)paraProfMetric);
        return paraProfMetric;
    }

    public boolean groupNamesPresent() {
        return this.dataSource.getGroupNamesPresent();
    }

    public boolean userEventsPresent() {
        return this.dataSource.getUserEventsPresent();
    }

    public boolean callPathDataPresent() {
        return this.dataSource.getCallPathDataPresent();
    }

    public int[] getMaxNCTNumbers() {
        return this.dataSource.getMaxNCTNumbers();
    }

    public void setMeanData(int n) {
        this.dataSource.setMeanData(n, n);
    }

    public boolean displayFunction(Function function) {
        switch (this.groupFilter) {
            case 0: {
                return true;
            }
            case 1: {
                return function.isGroupMember(this.selectedGroup);
            }
            case 2: {
                return !function.isGroupMember(this.selectedGroup);
            }
        }
        return true;
    }

    public void setSelectedGroup(Group group) {
        this.selectedGroup = group;
    }

    public Group getSelectedGroup() {
        return this.selectedGroup;
    }

    public void setGroupFilter(int n) {
        this.groupFilter = n;
    }

    public int getGroupFilter() {
        return this.groupFilter;
    }

    public void update(Object object) throws DatabaseException {
        if (object instanceof DataSourceException) {
            ParaProfUtils.handleException((Exception)object);
        }
        DataSource dataSource = (DataSource)object;
        int n = dataSource.getNumberOfMetrics();
        Vector<ParaProfMetric> vector = new Vector<ParaProfMetric>();
        for (int i = 0; i < n; ++i) {
            ParaProfMetric paraProfMetric = new ParaProfMetric();
            paraProfMetric.setName(dataSource.getMetricName(i));
            paraProfMetric.setID(i);
            paraProfMetric.setTrial(this);
            vector.add(paraProfMetric);
        }
        dataSource.setMetrics(vector);
        this.setDataSource(dataSource);
        this.clrChooser.setColors(this, -1);
        if (this.upload()) {
            this.dbAPI = ParaProf.paraProfManager.getDatabaseAPI();
            if (this.dbAPI != null) {
                this.setID(this.dbAPI.uploadTrial((Trial)this, -1));
                this.dbAPI.terminate();
            }
            this.setDBTrial(true);
        } else {
            this.setLoading(false);
            ParaProf.paraProfManager.populateTrialMetrics(this);
        }
        this.setLoading(false);
    }

    public void update() {
    }

    public DatabaseAPI getDatabaseAPI() {
        return this.dbAPI;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean debug() {
        return this.debug;
    }
}

