#!/bin/sh
#
#	tardy - a tar post-processor
#	Copyright (C) 1993, 1994, 1995, 1998, 1999, 2000 Peter Miller;
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
#
# MANIFEST: shell script to generate the Makefile file
#
man1_files=
test_files=
common_files=
clean_files="core common/lib.a .bin .bindir .man1dir"
for file in $*
do
	case $file in

	tardy/*.y)
		stem=`echo $file | sed 's/\.y$//'`
		clean_files="$clean_files ${stem}.gen.cc ${stem}.gen.h"
		tardy_files="$tardy_files ${stem}.gen.o"
		clean_files="$clean_files ${stem}.gen.o"
		;;

	tardy/*.cc)
		stem=`echo $file | sed 's/\.cc$//'`
		tardy_files="$tardy_files ${stem}.o"
		clean_files="$clean_files ${stem}.o"
		;;

	common/*.cc)
		root=`echo $file | sed 's|\.cc$||'`
		common_files="$common_files ${root}.o"
		clean_files="$clean_files ${root}.o"
		;;

	man1/*.1)
		root=`basename $file .1`
		clean_files="$clean_files man1/${root}.h"
		man1_files="$man1_files \$(mandir)/$file"
		;;

	man1/*.so)
		root=`basename $file .so`
		clean_files="$clean_files man1/${root}.h"
		;;

	test/*/*)
		root=`basename $file .sh`
		test_files="$test_files $root"
		;;

	*)
		;;
	esac
done

echo
echo "TardyFiles =" $tardy_files
echo
echo "CommonFiles =" $common_files
echo
echo "Man1Files =" $man1_files
echo
echo "TestFiles =" $test_files

#
# clean up the area
#	(make sure command lines do not get too long)
#
echo ''
echo 'clean-obj:'
echo $clean_files | tr ' ' '\12' | gawk '{
	if (pos > 0 && pos + length($1) > 71) { printf("\n"); pos = 0; }
	if (pos == 0) { printf "	rm -f"; pos = 13; }
	printf " %s", $1
	pos += 1 + length($1);
}
END { if (pos) printf "\n"; }'

cat << 'fubar'

clean: clean-obj
	rm -f bin/tardy

distclean: clean
	rm -f config.status config.cache config.log
	rm -f Makefile common/config.h etc/Howto.conf

.bin:
	-mkdir bin
	@touch .bin

common/lib.a: $(CommonFiles)
	rm -f common/lib.a
	$(AR) qc common/lib.a $(CommonFiles)
	$(RANLIB) common/lib.a

bin/tardy: $(TardyFiles) common/lib.a .bin
	@sleep 1
	$(CXX) -o bin/tardy $(TardyFiles) common/lib.a $(LIBS)
	@sleep 1

sure: $(TestFiles)
	@echo Passed All Tests

.bindir:
	-$(INSTALL) -m 0755 -d $(bindir)
	@touch $@
	@sleep 1

.man1dir:
	-$(INSTALL) -m 0755 -d $(mandir)/man1
	@touch $@
	@sleep 1

$(bindir)/tardy: bin/tardy .bindir
	$(INSTALL_PROGRAM) bin/tardy $@

install-bin: $(bindir)/tardy

install-man: $(Man1Files)

install: install-bin install-man
fubar
exit 0
