#ifndef TAGGREP_OPTIONS_H
#define TAGGREP_OPTIONS_H

/*
 * Commandline parser for tagcoll
 *
 * Copyright (C) 2003,2004,2005,2006  Enrico Zini
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <tagcoll/Commandline.h>

namespace Tagcoll {
namespace commandline {

struct TaggrepOptions : public MainParser<OptionParser>
{
	struct HelpGroup : public OptionGroup
	{
		BoolOption* help;
		BoolOption* version;

		HelpGroup()
		{
			add(help = new BoolOption("help", 'h', "help"));
			add(version = new BoolOption("version", 'V', "version"));
			help->shortNames.push_back('?');
			help->description = "print an help message and exit";
			version->description = "print the program version and exit";
			description = "Help options";
		}
		~HelpGroup()
		{
			delete help; delete version;
		}
	} helpGroup;

	BoolOption* invert;
	BoolOption* quiet;

	TaggrepOptions() : MainParser<OptionParser>("taggrep")
	{
		add(&helpGroup);

		add(invert = new BoolOption("invert", 'v', "invert-match"));
		invert->description = "invert the sense of matching, to select non-matching lines";

		add(quiet = new BoolOption("quiet", 'q', "quiet"));
		quiet->description = "do not write anything to standard output, but exit with 0 if any match is found";

		usage = "<tag-expression> [file1 [file2 [...]]]";
		description = "Filter the contents of a tagged collection using a tag expression";
	}
	~TaggrepOptions()
	{
		delete invert; delete quiet;
	}
};

}
}

// vim:set ts=4 sw=4:
#endif
