/*
 * Model a collection of derived tags and a TagcollFilter to add them to a
 * collection
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <tagcoll/DerivedTags.h>

using namespace std;
using namespace Tagcoll;


#ifndef INSTANTIATING_TEMPLATES
#include <string>

namespace Tagcoll {
	template class AddDerived<std::string>;
	template class RemoveDerived<std::string>;
}
#endif


#ifdef COMPILE_TESTSUITE

#include <tests/test-utils.h>
#include <tagcoll/InputMerger.h>


namespace tut {
using namespace tut_tagcoll;

struct tagcoll_derivedtags_shar {
};
TESTGRP(tagcoll_derivedtags);


template<> template<>
void to::test<1>()
{
	std::string input_coll(
			"a: coffee, milk\n"
			"b: coffee\n"
			"c: milk\n"
			"d: coffee, milk, sugar\n"
			);
	std::string output_coll(
			"a: coffee, milk, cappuccino\n"
			"b: coffee\n"
			"c: milk\n"
			"d: coffee, milk, sugar, sweet_cappuccino\n"
			);
	InputMerger<string, string> result;
	AddDerived<string> filter(result);

	filter.derivedTags().add("cappuccino", Expression("coffee && milk && !sugar"));
	filter.derivedTags().add("sweet_cappuccino", Expression("coffee && milk && sugar"));

	outputCollection(input_coll, filter); 

	InputMerger<string, string> reference;
	outputCollection(output_coll, reference); 

	gen_ensure_coll_equals(reference, result);
}

template<> template<>
void to::test<2>()
{
	std::string input_coll(
			"a: coffee, milk, cappuccino\n"
			"b: coffee\n"
			"c: milk\n"
			"d: coffee, milk, sugar, sweet_cappuccino\n"
			);
	std::string output_coll(
			"a: coffee, milk\n"
			"b: coffee\n"
			"c: milk\n"
			"d: coffee, milk, sugar\n"
			);
	InputMerger<string, string> result;
	RemoveDerived<string> filter(result);

	filter.derivedTags().add("cappuccino", Expression("coffee && milk && !sugar"));
	filter.derivedTags().add("sweet_cappuccino", Expression("coffee && milk && sugar"));

	outputCollection(input_coll, filter); 

	InputMerger<string, string> reference;
	outputCollection(output_coll, reference); 

	gen_ensure_coll_equals(reference, result);
}

}

#endif

// vim:set ts=4 sw=4:
