var onDoubleClick = false;

// single click function
//
function TM_checkClick (event) {
  if (!event)
    return;
  if (event.button == 2)
    return; // right click
  if (event.button == 0 && event.detail > 1)
    return; // double click (with left button)

  var target = event.originalTarget;
  // don't do anything if user left click on close tab button , or on any other button on tab or tabbar
  if (event.button == 0 && (target.getAttribute("anonid") == "tmp-close-button" ||
      target.localName == "toolbarbutton"))
     return;

  // only allow middle-click on close tab button on tab to go throw as middle-click on the tab
  if (event.button == 1 && target.localName == "toolbarbutton" && target.getAttribute("anonid") != "tmp-close-button")
     return;

  onDoubleClick = false;

  var aTab = target;
  while ( aTab.localName != "tabs" ) {
    if ( aTab.localName == "tab" )
      break;
    if ( aTab.parentNode )
      aTab = aTab.parentNode;
    else
      return;
  }

  var clickOutTabs = aTab.localName == "tabs";
  // for tab flip
  if ( !clickOutTabs && event.button == 0 && aTab.hasAttribute("clickOnCurrent") ) {
    aTab.removeAttribute("clickOnCurrent");
    var tabFlip = TMP_getBoolPref(tabxBranch, "tabFlip", false);
    var tabFlipDelay = TMP_getIntPref (tabxBranch, "tabFlipDelay", 250);
    if (tabFlip && !event.shiftKey && !event.ctrlKey && !event.altKey && !event.metaKey){
      window.setTimeout(function () {
                if (!onDoubleClick) {
                    gBrowser.previousTab(aTab);
                    gBrowser.stopMouseHoverSelect(aTab);
                    content.focus();
                }
      }, tabFlipDelay );
      return;
    }
  }

  var prefName
  /* middle click*/
  if (event.button == 1)
    prefName = "middle"
  /* shift click*/
  else if (event.button == 0 && event.shiftKey && !event.ctrlKey && !event.altKey && !event.metaKey)
    prefName = "shift"
  /* alt click*/
  else if (event.button == 0 && event.altKey && !event.ctrlKey && !event.shiftKey && !event.metaKey)
    prefName = "alt"
  /* ctrl click*/
  else if (event.button == 0 && (event.ctrlKey && !event.metaKey || !event.ctrlKey && event.metaKey) && !event.shiftKey && !event.altKey)
    prefName = "ctrl"

  if (prefName) {
    TMclickAction(prefName, clickOutTabs, aTab);
    event.stopPropagation();
  }
}

// Double click function
//
function TM_onTabBarDblClick (e) {
  if ( !e || e.button != 0 || e.ctrlKey || e.shiftKey || e.altKey || e.metaKey )
    return;
  onDoubleClick = true;
  var aTab = e.originalTarget;

  // don't do anything if user click on close tab button , or on any other button on tab or tabbar
  if (aTab.getAttribute("anonid") == "tmp-close-button" ||
      aTab.localName == "toolbarbutton")
     return;

  while ( aTab.localName != "tabs" ) {
    if ( aTab.localName == "tab" )
      break;
    aTab = aTab.parentNode;
  }

  TMclickAction( "dbl", aTab.localName == "tabs", aTab );
}

// call action function from click on tabs or tabbar
//
function TMclickAction ( pref, clickOutTabs, aTab ) {
  if (!pref) return; // just in case we missed something

  var defaultPref = {middleClickTab:2, middleClickTabbar:10, shiftClickTab:5, shiftClickTabbar:0,
                     altClickTab:6, altClickTabbar:0, ctrlClickTab:22, ctrlClickTabbar:0,
                     dblClickTab:0, dblClickTabbar:1};

  pref += clickOutTabs ? "ClickTabbar" : "ClickTab";
  var action = TMP_getIntPref (tabxBranch, pref , defaultPref[pref]);

  content.focus();

  switch ( action ) {
    case 0 :
      break;
    case 1 :
      BrowserOpenTab();
      break;
    case 2 :
      if (aTab.localName != "tab")
         aTab = gBrowser.mCurrentTab;
      if (aTab && aTab.parentNode)
        gBrowser.removeTab(aTab);
      break;
    case 3 :
      gBrowser.duplicateTab(aTab);
      break;
    case 4 :
      gBrowser.reloadTab(aTab);
      break;
    case 5 :
      gBrowser.protectTab(aTab);
      break;
    case 6 :
      gBrowser.lockTab(aTab);
      break;
    case 7 :
      gBrowser.reloadAllTabs(aTab);
      break;
    case 8:
      gBrowser.removeAllTabsBut(aTab);
      break;
    case 9:
      gBrowser.closeAllTabs();
      break;
    case 10:
      TMP_ClosedTabs.undoCloseTab();
      break;
    case 11:
      gBrowser.renameTab(aTab);
      break;
    case 12: //taken from tco
      if (SessionSaver && SessionSaver.snapBackTab)
        SessionSaver.snapBackTab(SessionSaver.snapback_noFX, SessionSaver.snapback_willFocus);
      break;
    case 13:
      TMP_ClosedTabs.restoreTab("original", -2);
      break;
    case 14:
      gBrowser.duplicateInWindow(aTab, false);
      break;
    case 15:
      gBrowser.freezeTab(aTab);
      break;
    case 16:
      gBrowser.reloadAllTabsBut(aTab);
      break;
    case 17:
      if (window.getComputedStyle(gBrowser, null).direction == "ltr")
        gBrowser.closeLeftTabs(aTab);
      else
        gBrowser.closeRightTabs(aTab);
      break;
    case 18:
      if (window.getComputedStyle(gBrowser, null).direction == "ltr")
        gBrowser.closeRightTabs(aTab);
      else
        gBrowser.closeLeftTabs(aTab);
      break;
    case 19:
      if (window.getComputedStyle(gBrowser, null).direction == "ltr")
        gBrowser.reloadLeftTabs(aTab);
      else
        gBrowser.reloadRightTabs(aTab);
      break;
    case 20:
      if (window.getComputedStyle(gBrowser, null).direction == "ltr")
        gBrowser.reloadRightTabs(aTab);
      else
        gBrowser.reloadLeftTabs(aTab);
      break;
    case 21: // taken from tco
      if (aTab.localName != "tab")
          aTab = gBrowser.mCurrentTab;
      var href;
      if (window.IeView && window.IeView.ieViewLaunch) {
        href = gBrowser.getBrowserForTab(aTab).currentURI.spec;
        IeView.ieViewLaunch("Internet Explorer.lnk", href);
      }
      else if (window.gIeTab && window.gIeTab.switchTabEngine) {
        if (gBrowser.selectedTab != aTab)
          gBrowser.selectedTab = aTab;
        gIeTab.switchTabEngine(aTab, gIeTab.getBoolPref("ietab.alwaysNewTab", false));
      }
      else if(window.ieview && window.ieview.launch) {
        href = gBrowser.getBrowserForTab(aTab).currentURI.spec;
        ieview.launch(href);
      }
      break;
    case 22:
      gBrowser.SelectToMerge(aTab);
      break;
    case 23:
      dtMergeWindows.mergeWindows();
      break;
    case 24:
      gBrowser.closeGroupTabs(aTab);
      break;
    case 25:
        if (aTab.localName != "tab")
          aTab = gBrowser.mCurrentTab;
        PlacesCommandHook.bookmarkPage(aTab.linkedBrowser, PlacesUtils.bookmarksMenuFolderId, true);
        break;
    case 26:
        PlacesCommandHook.bookmarkCurrentPages();
        break;
    case 27:
      gBrowser.duplicateInWindow(aTab, true);
      break;
    case 28:
      gBrowser.copyTabUrl(aTab);
      break;
    case 29:
      var event = document.createEvent("Events");
      event.initEvent("click", true, true);
      middleMousePaste(event);
      break;
    case 30: // enable/disable AutoReload
      if (aTab.autoReloadEnabled == null)
        setupAutoReload(aTab);
      gBrowser.onAutoReloadEnable(aTab);
  }
}

function Tm_checkTabClick(event) {
   // Undo close tab Commands - firefox 3.0 toggle this menu item also when submneu are show
   var undoClose = tabxPrefs.getBoolPref("undoClose");
   TMP_showItem("context_undoCloseTab", tabxPrefs.getBoolPref("undoCloseTabMenu") && undoClose);

   if (event.originalTarget != gBrowser.tabContextMenu)
     return true;

   var item;
   if (document.popupNode.parentNode)
      item = document.popupNode.parentNode.parentNode.id;
   if (item && (item == "btn_tabslist" || item == "btn_tabslistSorted" || item == "alltabs-button")) {
      if (gIsFirefox37)
         TabContextMenu.contextTab = document.popupNode.tab;
      else
         gBrowser.mContextTab = document.popupNode.tab;
   }

   var clickOutTabs = document.popupNode.localName == "tabs";
   var aTab = clickOutTabs ? gBrowser.mCurrentTab : gBrowser.mContextTab;

   var cIndex = aTab._tPos;
   var isOneWindow = numberOfWindows() == 1;

   var newTab = document.getElementById("context_newTab");
   TMP_showItem(newTab, tabxPrefs.getBoolPref("newTabMenu"));
   if (clickOutTabs) {
      TMP_setItem(newTab, "label", newTab.getAttribute("_newtab"));
      TMP_setItem(newTab, "oncommand", "TMP_BrowserOpenTab();");
   }
   else {
      TMP_setItem(newTab, "label", newTab.getAttribute("_newtab") + "  " + newTab.getAttribute("_afterthis"));
      TMP_setItem(newTab, "oncommand", "TMP_BrowserOpenTab(gBrowser.mContextTab);");
   }

   // Duplicate Commands
   TMP_showItem("tm-duplicateTab", tabxPrefs.getBoolPref("duplicateMenu"));
   TMP_showItem("tm-duplicateinWin", tabxPrefs.getBoolPref("duplicateinWinMenu") && !gSingleWindowMode);
   TMP_showItem("context_openTabInWindow", tabxPrefs.getBoolPref("detachTabMenu") && !gSingleWindowMode);

   TMP_showItem("tm-mergeWindowsTab", tabxPrefs.getBoolPref("showMergeWindow") && (!gSingleWindowMode || (gSingleWindowMode && !isOneWindow)));
   var showRenameTabMenu = tabxPrefs.getBoolPref("renameTabMenu");
   TMP_showItem("tm-renameTab", showRenameTabMenu);
   TMP_showItem("tm-copyTabUrl", tabxPrefs.getBoolPref("copyTabUrlMenu"));

   //  ---------------- menuseparator ---------------- //

   // Reload Commands
   TMP_showItem("context_reloadTab", tabxPrefs.getBoolPref("reloadTabMenu"));
   TMP_showItem("context_reloadAllTabs", tabxPrefs.getBoolPref("reloadAllMenu"));
   TMP_showItem("tm-autoreloadTab_menu", tabxPrefs.getBoolPref("autoReloadMenu"));
   TMP_showItem("tm-reloadRight", tabxPrefs.getBoolPref("reloadRightMenu"));
   TMP_showItem("tm-reloadLeft", tabxPrefs.getBoolPref("reloadLeftMenu"));
   TMP_showItem("tm-reloadOther", tabxPrefs.getBoolPref("reloadOtherMenu"));

   //  ---------------- menuseparator ---------------- //

   TMP_showItem("tm-undoCloseList", tabxPrefs.getBoolPref("undoCloseListMenu") && undoClose);

   //  ---------------- menuseparator ---------------- //

   // Close tab Commands
   TMP_showItem("context_closeTab", tabxPrefs.getBoolPref("closeTabMenu"));
   TMP_showItem("tm-closeAllTabs", tabxPrefs.getBoolPref("closeAllMenu"));
   TMP_showItem("tm-closeSimilar", tabxPrefs.getBoolPref("closeSimilarTabs"));
   TMP_showItem("context_closeOtherTabs", tabxPrefs.getBoolPref("closeOtherMenu"));
   TMP_showItem("tm-closeLeftTabs", tabxPrefs.getBoolPref("closeLeftMenu"));
   TMP_showItem("tm-closeRightTabs", tabxPrefs.getBoolPref("closeRightMenu"));

   //  ---------------- menuseparator ---------------- //

   TMP_showItem("tm-docShell", tabxPrefs.getBoolPref("docShellMenu"));
   TMP_showItem("tm-freezeTab", tabxPrefs.getBoolPref("freezeTabMenu"));
   TMP_showItem("tm-protectTab", tabxPrefs.getBoolPref("protectTabMenu"));
   TMP_showItem("tm-lockTab", tabxPrefs.getBoolPref("lockTabMenu"));

   //  ---------------- menuseparator ---------------- //

   TMP_showItem("context_bookmarkTab", tabxPrefs.getBoolPref("bookmarkTabMenu"));
   TMP_showItem("context_bookmarkAllTabs", tabxPrefs.getBoolPref("bookmarkTabsMenu"));

   // we call this again by popupshown to make sure we don't show 2 menuseparator together
   TMP_tabContextMenuShown(event);

   if (showRenameTabMenu) {
      // disabled rename if the title not ready yet
      var titleNotReady;
      if (aTab.hasAttribute("busy")) {
         var browser = gBrowser.getBrowserForTab(aTab);
         var url = browser.contentDocument.baseURI || browser.currentURI.spec;
         var docTitle = getTitleFromBookmark(url, browser.contentDocument.title, aTab.getAttribute("tabmix_bookmarkId"));
         if (!docTitle || docTitle == gBrowser.mStringBundle.getString(gIsFirefox37 ? "tabs.emptyTabTitle" : "tabs.untitled"))
            titleNotReady = true;
      }
      TMP_setItem("tm-renameTab", "disabled", titleNotReady);
   }

   var protectedTab = aTab.hasAttribute("protected");
   var lockedTab = aTab.hasAttribute("locked");
   var tabsCount = gBrowser.tabs.length;

   // In Firefox version prior to 3.5 gBrowser.removeTab don't remove the last tab when the tab bar is hidded
   var keepLastTab = tabsCount == 1 && tabxPrefs.getBoolPref("keepLastTab");
   var tabBarCollapsed = tabsCount == 1 && gTabmixPrefs.getBoolPref("browser.tabs.autoHide") && !gIsFirefox35;
   TMP_setItem("context_closeTab", "disabled", protectedTab || keepLastTab || tabBarCollapsed);
   TMP_setItem("tm-closeAllTabs", "disabled", keepLastTab || tabBarCollapsed);
   TMP_setItem("context_closeOtherTabs", "disabled", tabsCount == 1);

   var closeTabsEmpty = TMP_ClosedTabs.count < 1;
   TMP_setItem("context_undoCloseTab", "disabled", closeTabsEmpty);
   TMP_setItem("tm-undoCloseList", "disabled", closeTabsEmpty);

   TMP_setItem("tm-mergeWindowsTab", "disabled", isOneWindow);

   TMP_setItem("tm-closeRightTabs", "disabled", cIndex == tabsCount - 1);
   TMP_setItem("tm-closeLeftTabs", "disabled", cIndex == 0);
   TMP_setItem("tm-reloadRight", "disabled", cIndex == tabsCount - 1);
   TMP_setItem("tm-reloadLeft", "disabled", cIndex == 0);
   TMP_setItem("tm-reloadOther", "disabled", tabsCount == 1);

   TMP_setItem("tm-docShell", "disabled", clickOutTabs);

   var freezeTabMenu = document.getElementById("tm-freezeTab");
   if ( !freezeTabMenu.hidden )
      TMP_setItem(freezeTabMenu, "checked", lockedTab && protectedTab);

   var lockTabMenu = document.getElementById("tm-lockTab");
   if ( !lockTabMenu.hidden )
      TMP_setItem(lockTabMenu, "checked", lockedTab);

   var protectTabMenu = document.getElementById("tm-protectTab");
   if ( !protectTabMenu.hidden )
      TMP_setItem(protectTabMenu, "checked", protectedTab);

   return true;
}

// don't show 2 menuseparator together
// this function is call by "popupshown" event
// this is only to the case that other extensions popupshowing run after our Tm_checkTabClick
function TMP_tabContextMenuShown(event) {
   var tabContextMenu = gBrowser.tabContextMenu;
   if (event.originalTarget != tabContextMenu)
     return;
   // don't show 2 menuseparator together
   var hideNextSeparator = true, lastVisible, hideMenu = true;
   for(var mi = tabContextMenu.firstChild; mi; mi = mi.nextSibling) {
    if (mi.localName == "menuseparator") {
      if (!lastVisible || !hideNextSeparator) {
        mi.hidden = hideNextSeparator;
        if (!hideNextSeparator) {
          hideNextSeparator = true;
          lastVisible = mi;
        }
      }
      else if (hideNextSeparator) {
        if (lastVisible.getAttribute("type")=="tabmix" && mi.getAttribute("type")!="tabmix") {
          mi.hidden = false;
          lastVisible.hidden = true;
          lastVisible = mi;
        }
        else
          mi.hidden = true;
      }
    }
    else if(!mi.hidden && !mi.collapsed) {
       hideNextSeparator = false;
       hideMenu = false;
    }
   }

   // hide the last visible menuseparator if it is the last visible in the menu
   if (hideNextSeparator && lastVisible)
      lastVisible.hidden = true;

   // if all the menu are hidden don't show the popup
   if (hideMenu)
      tabContextMenu.hidePopup();
}

function TM_checkContentMenu (event) {
  if (!gContextMenu || event.originalTarget != document.getElementById("contentAreaContextMenu"))
    return true;

  try {
    var showFreezeTab = gTabmixPrefs.getBoolPref("extensions.tabmix.freezeTabContent");
    var showLockTab = gTabmixPrefs.getBoolPref("extensions.tabmix.lockTabContent");
    var showProtectTab = gTabmixPrefs.getBoolPref("extensions.tabmix.protectTabContent");
    var showTabsList = gTabmixPrefs.getBoolPref("extensions.tabmix.tabsList");
    var showCloseTab = gTabmixPrefs.getBoolPref("extensions.tabmix.closeTabContent");
    var showUndoCloseTab = gTabmixPrefs.getBoolPref("extensions.tabmix.undoCloseTabContent");
    var showUndoCloseList = gTabmixPrefs.getBoolPref("extensions.tabmix.undoCloseListContent");
    var undoClose = gTabmixPrefs.getBoolPref("extensions.tabmix.undoClose");
    var showDuplicateTab = gTabmixPrefs.getBoolPref("extensions.tabmix.duplicateTabContent");
    var showDuplicateWin = gTabmixPrefs.getBoolPref("extensions.tabmix.duplicateWinContent");
    var showDetachTab = gTabmixPrefs.getBoolPref("extensions.tabmix.detachTabContent");
    var showLinkWithHist = gTabmixPrefs.getBoolPref("extensions.tabmix.linkWithHistory");
    var showMerge = gTabmixPrefs.getBoolPref("extensions.tabmix.mergeWindowContent");
    var showOpenHere = gTabmixPrefs.getBoolPref("extensions.tabmix.openLinkHere");
    var showInverseLink = gTabmixPrefs.getBoolPref("extensions.tabmix.openInverseLink");
    var showAutoReload = gTabmixPrefs.getBoolPref("extensions.tabmix.autoReloadContent");
    var bgPref = gTabmixPrefs.getBoolPref("browser.tabs.loadInBackground");
    var isOneWindow = numberOfWindows() == 1;

  var tabsListMenu = document.getElementById("tm-tabsList");
  var closeTabMenu = document.getElementById("tm-content-closetab");
  var freezeTabMenu = document.getElementById("tm-content-freezeTab");
  var lockTabMenu = document.getElementById("tm-content-lockTab");
  var protectTabMenu = document.getElementById("tm-content-protectTab");
  var undoCloseTabMenu = document.getElementById("tm-content-undoCloseTab");
  var undoCloseListMenu = document.getElementById("tm-content-undoCloseList");
  var undoCloseSep = document.getElementById("tm-content-undoCloseSep");
  var duplicateTabMenu = document.getElementById("tm-duplicateTabContext");
  var duplicateWinMenu = document.getElementById("tm-duplicateinWinContext");
  var detachTabMenu = document.getElementById("tm-detachTabContext");
  var linkWithHist = document.getElementById("tm-linkWithhistory");
  var mergeMenu = document.getElementById("tm-mergeWindows");
  var miscSep = document.getElementById("tm-content-miscSep");
  var textSep = document.getElementById("tm-content-textSep");
  var openHere = document.getElementById("tm-openlinkhere");
  var inverseLink = document.getElementById("tm-openinverselink");
  var autoReload = document.getElementById("tm-autoreload_menu");

  var contentClick = gContextMenu.onTextInput || gContextMenu.onLink || gContextMenu.onImage;
  var tabsCount = gBrowser.tabs.length;
  var closeTabsEmpty = TMP_ClosedTabs.count < 1;
  var protectedTab = gBrowser.mCurrentTab.hasAttribute("protected");
  var lockedTab = gBrowser.mCurrentTab.hasAttribute("locked");

  // from Firefox 3.7 2009-09-11 there is gContextMenu.openLinkInCurrent
  // Firefox only show this menu when the selection text is url see Bug 454518
  // we cahck if gContextMenu.linkURL contain URL
  //
  // we can remove this menu in tabmix.js but it is safer to just hide it each time
  if (gIsFirefox37) {
    // the label for this menu is "Open Link"
    // we use our own menu "Open Link in This Tab"
    document.getElementById("context-openlinkincurrent").hidden = true;
  }
  openHere.hidden = (!gContextMenu.onLink && !gContextMenu.linkURL) || !showOpenHere;
  inverseLink.hidden = !gContextMenu.onLink || !showInverseLink;
  if (!inverseLink.hidden){
    var focusType = bgPref ? "fg":"bg";
    inverseLink.setAttribute("label", inverseLink.getAttribute(focusType+"label"));
    inverseLink.setAttribute("accesskey", inverseLink.getAttribute(focusType+"accesskey"));
  }
  linkWithHist.hidden = !gContextMenu.onLink || !showLinkWithHist;
  closeTabMenu.hidden = !showCloseTab || contentClick;
  var keepLastTab = tabsCount == 1 && tabxPrefs.getBoolPref("keepLastTab");
  var tabBarCollapsed = tabsCount == 1 && gTabmixPrefs.getBoolPref("browser.tabs.autoHide") && !gIsFirefox35;
  closeTabMenu.setAttribute("disabled", protectedTab || keepLastTab || tabBarCollapsed);
  freezeTabMenu.hidden = !showFreezeTab || contentClick;
  lockTabMenu.hidden = !showLockTab || contentClick;
  lockTabMenu.setAttribute("checked", lockedTab);
  protectTabMenu.hidden = !showProtectTab || contentClick;
  protectTabMenu.setAttribute("checked", protectedTab);
  duplicateTabMenu.hidden = !showDuplicateTab || contentClick;
  detachTabMenu.hidden = !showDetachTab || contentClick || gSingleWindowMode;
  duplicateWinMenu.hidden = !showDuplicateWin || contentClick || gSingleWindowMode;
  freezeTabMenu.setAttribute("checked", protectedTab && lockedTab);
  tabsListMenu.hidden = !showTabsList || contentClick;
  undoCloseTabMenu.hidden = closeTabsEmpty || !showUndoCloseTab || !undoClose || contentClick || gContextMenu.isTextSelected;
  undoCloseListMenu.hidden = closeTabsEmpty || !showUndoCloseList || !undoClose || contentClick || gContextMenu.isTextSelected;
  undoCloseSep.hidden = undoCloseTabMenu.hidden && undoCloseListMenu.hidden || gContextMenu.isTextSelected && closeTabMenu.hidden && lockTabMenu.hidden && protectTabMenu.hidden && tabsListMenu.hidden  && freezeTabMenu.hidden;
  mergeMenu.hidden = !showMerge || isOneWindow || contentClick;
  miscSep.hidden = mergeMenu.hidden && closeTabMenu.hidden && duplicateTabMenu.hidden && duplicateWinMenu.hidden && lockTabMenu.hidden && protectTabMenu.hidden && tabsListMenu.hidden  && freezeTabMenu.hidden || gContextMenu.isTextSelected;
  textSep.hidden = !gContextMenu.isTextSelected || mergeMenu.hidden && duplicateTabMenu.hidden && duplicateWinMenu.hidden && closeTabMenu.hidden && lockTabMenu.hidden && protectTabMenu.hidden && tabsListMenu.hidden  && freezeTabMenu.hidden && undoCloseTabMenu.hidden && undoCloseListMenu.hidden;
  autoReload.hidden = !showAutoReload || contentClick || gContextMenu.isTextSelected;

  var hideOpenAllLinks = gTabmixPrefs.getBoolPref("extensions.tabmix.openAllLinks") ?
                  TMP_openMultipleLinks(true) : true;
  document.getElementById("tm-openAllLinks").hidden = hideOpenAllLinks;
  return true;

  } catch (ex) {TMP_ASSERT(ex);}
}

function onAutoReloadPopupShowing(aPopup, aTab) {
  function setLabel(aItem, aTime) {
    var seconds = aTime;
    var timeLabel = aItem.getAttribute("_label") + " ";
    if (seconds > 59) {
      var minutes = parseInt(aTime / 60);
      timeLabel += minutes + " " + (minutes > 1 ? customMenu.getAttribute("minutes") : customMenu.getAttribute("minute"));
      seconds -= 60*minutes;
      if (seconds)
        timeLabel += " ";
    }
    if (seconds || !timeLabel)
      timeLabel += seconds + " " + customMenu.getAttribute("seconds");
    aItem.setAttribute("label", timeLabel);
  }
  var menuItems = aPopup.childNodes;

  aPopup._tab = aTab;
  if (aPopup._tab.autoReloadEnabled == null)
    setupAutoReload(aPopup._tab);

  var customReloadTime = tabxPrefs.getIntPref("custom_reload_time");
  var customMenu = menuItems[3];
  customMenu.setAttribute("value", customReloadTime);
  setLabel(customMenu, customReloadTime);

  menuItems[0].setAttribute("checked", aPopup._tab.autoReloadEnabled);
  setLabel(menuItems[0], aPopup._tab.autoReloadTime);

  var checked = aPopup.getElementsByAttribute("value" , aPopup._tab.autoReloadTime);
  if (checked.length)
    checked[checked.length - 1].setAttribute("checked", "true");
}

function TMP_openMultipleLinks(check) {
   var focusedWindow = document.commandDispatcher.focusedWindow;
   if (focusedWindow == window)
      focusedWindow = _content;

   var nsISelectionObject = focusedWindow.getSelection();
   if (nsISelectionObject.isCollapsed) // nothing selected
     return true;

   var myNodeFilter = {
      acceptNode : function(n) {
         if(n.nodeName == 'A' || n.nodeName == 'li') {
            return NodeFilter.FILTER_ACCEPT;
         }
         else {
            return NodeFilter.FILTER_SKIP;
         }
      }
   };

   // do urlSecurityCheck for each link in the treeWalker....
   var _document = focusedWindow.document.documentElement.ownerDocument;
   const nsIScriptSecurityManager = Components.interfaces.nsIScriptSecurityManager;
   var secMan = Components.classes["@mozilla.org/scriptsecuritymanager;1"]
                          .getService(nsIScriptSecurityManager);
   var flags = nsIScriptSecurityManager.STANDARD;
   function links_urlSecurityCheck(url) {
     if (!url)
        return false;

     if (!_document) // just in case....
        return true;

     try {
        secMan.checkLoadURIStrWithPrincipal(_document.nodePrincipal, url, flags);
     } catch (e) {
        return false;
     }
       return true;
   }

   var range = nsISelectionObject.getRangeAt(0);
   var treeWalker = window._content.document.createTreeWalker(
         range.cloneContents(),
         NodeFilter.SHOW_ELEMENT,
         myNodeFilter,
         true);
   var nextEpisode = treeWalker.nextNode();
   var urls = [];
   while (nextEpisode != null) {
      let url = (nextEpisode.nodeName == "li") ? nextEpisode.firstChild.href : nextEpisode.href;
      if (links_urlSecurityCheck(url)) {
         if (check)
            return false;
        urls.push(url);
      }
      nextEpisode = treeWalker.nextNode();
   }
   TMP_loadTabs(urls, false);
   return true;
}

function checkForCtrlClick(aEvent) {
  var aButton = aEvent.target;
  if (!aButton.disabled && aEvent.button == 0 && (aEvent.ctrlKey || aEvent.metaKey)) {
    if (aButton.id == "btn_undoclose")
      TMP_ClosedTabs.undoCloseTab();
    else
      BrowserCloseTabOrWindow();

    aButton.setAttribute("afterctrlclick", true);
  }
}

function isAfterCtrlClick(aButton) {
  if (aButton.getAttribute("afterctrlclick")) {
    aButton.removeAttribute("afterctrlclick");
    if (aButton.hasAttribute("open"))
      aButton.removeAttribute("open");
    return true;
  }
  return false;
}

// sometimes context popup stay "open", we hide it manually.
function TM_hidePopup () {
   var node = document.popupNode;
   while (node && node.localName != "menubar" && node.localName != "toolbar") {
      if (node.localName == "menupopup" || node.localName == "popup") {
         if (node.hasAttribute("open")) node.removeAttribute("open");
         node.hidePopup();
      }
      node = node.parentNode;
   }
}

// return the indexd tab from the list and remove the tab from the list
function getClosedTab(aWhere, aIndex) {
   var ctabs = gBrowser.closedTabs;
   var aTab = null;
   var updateRDF = SessionManager.enableBackup && SessionPref.getBoolPref("save.closedtabs");
   if(aIndex >= 0) {
      if (updateRDF)
         SessionManager.deleteClosedtabAt(ctabs.length - aIndex);
      aTab = ctabs.splice(aIndex, 1)[0];
   } else if (aIndex == -2)
      gBrowser.delayUndoRemoveAllTab();
   else if (aIndex == -1) {
      while(ctabs.length > 0) ctabs.pop();
      if (updateRDF)
         SessionManager.deleteWinClosedtabs(gSessionPath[0] + "/" + gBrowser.windowID);
   }
   if (ctabs.length < 1)
     TMP_ClosedTabs.setButtonDisableState(true);
   return aTab;
}

// restore the tab. we only use it if sessionStore is off
function _restoreTab(aWhere, aIndex) {
  var newIndex, aTab = getClosedTab(aWhere, aIndex);
  if (!aTab) return;
  switch (aWhere) {
    case "current":
      var cTab = gBrowser.mCurrentTab;
      newIndex = cTab._tPos;
      cTab.collapsed = true;
      var restoredTab = gBrowser.restoreTab(newIndex, aTab.history, aTab.properties, aTab.scroll);
      if (restoredTab != cTab)
         gBrowser.removeTab(cTab);
      else
         cTab.collapsed = false;
      break;
    case "window":
      var newWindow = window.openDialog( getBrowserURL(), "_blank", "chrome,all,dialog=no");
      newWindow.tabmix_afterTabduplicated = true;
      newWindow.tabmix_duplicatData = {
         scroll: aTab.scroll,
         oldHistory: aTab.history,
         prop: aTab.properties
      }
      break;
    case "tab":
      if (getOpenTabNextPref())
         newIndex = gBrowser.mCurrentTab._tPos+1;
      else
         newIndex = gBrowser.tabs.length;
      gBrowser.restoreTab(newIndex, aTab.history, aTab.properties, aTab.scroll);
      break;
    case "original":
      gBrowser.restoreTab(aTab.pos, aTab.history, aTab.properties, aTab.scroll);
  }
}

function NW_waitForSessionHistory(event) {
   waitForSessionHistory(20);
}

//  wait For sessionHistory in new window
function waitForSessionHistory(attempts) {
   var webNav = gBrowser.webNavigation;
   try{ webNav.sessionHistory; } // Test if sessionHistory exists yet
   catch (err) { // webNav.sessionHistory is not yet available, try again later
      if (attempts) window.setTimeout('waitForSessionHistory(' + --attempts + ')', 50);
      return;
   }
   if ((webNav.sessionHistory == null) && attempts){
      window.setTimeout('waitForSessionHistory(' + --attempts + ')', 50);
      return;
   }
   gBrowser.restoreTab(gBrowser.selectedTab._tPos,
                       window.duplicatData.oldHistory,
                       window.duplicatData.prop,
                       window.duplicatData.scroll);
   delete window.duplicatData;
   if (window.opener && window.opener.needToClose)
      setTimeout(function() {window.opener.closeWindow(true);}, 0);
}

function removeTabFromList (event, popup, aType) {
  if (!tabxPrefs.getBoolPref("middleclickDelete"))
    return;

  if (event.target.id == "btn_tabslistSorted")
    return;

  if (event.button == 1) {
    var aTab = event.originalTarget.tab;
    if (popup.parentNode.id == "tm-tabsList" && (gBrowser.mCurrentTab == aTab || gBrowser.isBlankTab(gBrowser.mCurrentTab))) {
         popup.hidePopup();
         gBrowser.removeTab(aTab, true);
         return;
    }
    gBrowser.removeTab(aTab, true);
    if (gBrowser.tabs.length > 0) {
      createTabsList(popup, aType);
      var item = popup.parentNode.parentNode;
      if (item.parentNode.id == "btn_tabslist") createTabsList(item, aType);
    }
    else popup.hidePopup();
  }
}

// called from tabmix.xml tabs scroll buttons
function _createTabsList (event, side) {
   event.stopPropagation();
   event.preventDefault();

   var tablist =  document.getElementById("tabslist");

   beforeCommonList(tablist);
   createCommonList(tablist, 2, side);

   if (tablist.hasChildNodes())
      tablist.showPopup(event.target, -1, -1, "popup", "bottomleft","topleft");
}

// show sort/unsort tabs list popup after click on sorted tab menu
function showTabsListPopup (event) {
   event.stopPropagation();
   setTimeout( function (popup){
      popup.showPopup(popup.parentNode, -1, -1, "popup", "bottomleft", "topleft");
   }, 0, event.target.parentNode);
}

function createTabsList (popup, aType) {
  if (isAfterCtrlClick(popup.parentNode))
    return false;

  var tabContextMenu = gBrowser.tabContextMenu;
  if (popup.hasAttribute("contextmenu") && popup.getAttribute("contextmenu") != tabContextMenu.id)
    popup.setAttribute("contextmenu", tabContextMenu.id);

  if (gTabmixPrefs.getBoolPref("extensions.tabmix.enableScrollSwitch"))
    popup.addEventListener("DOMMouseScroll", TMP_eventListener, true);

  beforeCommonList(popup);
  createCommonList(popup, aType);

  return true;
}

function beforeCommonList(popup) {
  var item = popup.parentNode;
  if (item.id == "btn_tabslist" || item.id == "btn_undoclose")
    item.removeAttribute("tooltiptext");

  // clear out the menu popup if we show the popup after middle click
  while (popup.hasChildNodes()) {
    var menuItem = popup.firstChild;
    if (menuItem.id.indexOf("btn_tabslist") != -1)
      break;
    menuItem.removeEventListener("click", TMP_ClosedTabs.checkForMiddleClick, false);
    popup.removeChild(menuItem);
  }

  popup.addEventListener("DOMMenuItemActive", updateMenuItemActive, false);
  popup.addEventListener("DOMMenuItemInactive", updateMenuItemInactive, false);
}

function createCommonList (popup, aType, side) {
  var tabs;
  var i;

  switch(aType) {
    case 1:
      tabs = new Array(gBrowser.tabs.length);
      for (i = 0; i < gBrowser.tabs.length; i++)
         tabs[i] = new tabSorting(gBrowser.tabs[i], i);
      tabs = tabs.sort();
      for (i = 0; i < tabs.length; i++)
         createMenuItems(popup, tabs[i].Tab, tabs[i].Index, aType);
      break;
    case 2:
      var rtl = window.getComputedStyle(gBrowser, null).direction == "rtl" && gTabmixPrefs.getIntPref("extensions.tabmix.tabBarMode") != 2;
      tabs = gBrowser.tabs;
      for (i = 0; i < tabs.length; i++) {
         let index = tabs[i]._tPos;
         if (side && side == (rtl ? "right" : "left") && !tabs[i].collapsed)
            continue;
         else if (side && side == (rtl ? "left" : "right") &&
               (tabs[i].collapsed || gBrowser.tabContainer.isTabVisible(index)))
            continue;
         createMenuItems(popup, tabs[i], index, aType);
      }
      break;
    case 3:
      for (i = TMP_LastTab.TabHistory.length - 1; i >= 0; i--)
         createMenuItems(popup, TMP_LastTab.TabHistory[i], i, aType);
      break;
  }
}

function createMenuItems(popup, tab, value, aType) {
  var count, mi = document.createElement("menuitem");
  mi.setAttribute("class", "menuitem-iconic bookmark-item alltabs-item");
  var url = gBrowser.getBrowserForTab(tab).currentURI.spec;
  mi.setAttribute("statustext", url);
  mi.setAttribute("tooltiptext", tab.label + "\n" + url);
  count = aType != 3 ? (value + 1) + (value < 9 ? " : " : ": ") : "";
  mi.setAttribute("count", count);
  mi.setAttribute("label", count + tab.label);
  mi.setAttribute("crop", tab.getAttribute("crop"));
  mi.setAttribute("image", tab.getAttribute("image"));

  if (tab.hasAttribute("busy"))
    mi.setAttribute("busy", tab.getAttribute("busy"));
  if (tab.selected)
     mi.setAttribute("selected", "true");

  mi.value = value;
  tab.mCorrespondingMenuitem = mi;
  tab.addEventListener("DOMAttrModified", TMP_tabOnAttrModified, false);
  tab.addEventListener("TabClose", TMP_tabOnTabClose, false);
  mi.tab = tab;

  if (popup.id == "btn_tabslist_menu")
    popup.insertBefore(mi, document.getElementById("btn_tabslist_sep"));
  else
    popup.appendChild(mi);
}

function TMP_tabOnAttrModified(aEvent) {
  var menuItem = aEvent.target.mCorrespondingMenuitem;
  if (menuItem) {
    var attrName = aEvent.attrName;
    var count = "";
    switch (attrName) {
      case "label":
        count = menuItem.getAttribute("count");
      case "crop":
      case "busy":
      case "image":
      case "selected":
        if (aEvent.attrChange == aEvent.REMOVAL)
          menuItem.removeAttribute(attrName);
        else
          menuItem.setAttribute(attrName, count + aEvent.newValue);
    }
  }
}

function TMP_tabOnTabClose(aEvent) {
   var menuItem = aEvent.target.mCorrespondingMenuitem;
   if (menuItem && menuItem.parentNode)
      menuItem.parentNode.removeChild(menuItem);
}

function TMP_TabsListOncommand(event) {
   TMP_tabSelectedFromList(event.originalTarget.tab);
}

function TMP_tabSelectedFromList(aTab) {
   if (gBrowser.selectedTab == aTab)
      gBrowser.tabContainer.ensureTabIsVisible(gBrowser.tabContainer.selectedIndex);
   else
      // if we select another tab _handleTabSelect will call ensureTabIsVisible
      gBrowser.selectedTab = aTab;
}

var gBackupLabel = "";
function hideCommonList(popup) {
  // clear out the menu popup and remove the listeners
  while (popup.hasChildNodes()) {
    var menuItem = popup.firstChild;
    if (menuItem.id.indexOf("btn_tabslist") != -1)
      break;
    if ("tab" in menuItem) {
      menuItem.tab.removeEventListener("DOMAttrModified", TMP_tabOnAttrModified, false);
      menuItem.tab.removeEventListener("TabClose", TMP_tabOnTabClose, false);
      menuItem.tab.mCorrespondingMenuitem = null;
    }
    popup.removeChild(menuItem);
  }

  var item = popup.parentNode;
  if (item.id == "btn_tabslist" || item.id == "btn_undoclose")
    item.setAttribute('tooltiptext', item.getAttribute('_tooltiptext'));

  popup.removeEventListener("DOMMenuItemActive", updateMenuItemActive, false);
  popup.removeEventListener("DOMMenuItemInactive", updateMenuItemInactive, false);
  popup.removeEventListener("DOMMouseScroll", TMP_eventListener, true);

  gBackupLabel = "";
}

function updateMenuItemActive(event, tab) {
   var statusTextFld = document.getElementById("statusbar-display");
   if (gBackupLabel=="") gBackupLabel = statusTextFld.label;
   if (!tab) tab = event.target;
   updateStatusText(tab.getAttribute("statustext"));
}

function updateMenuItemInactive(event) {
   updateStatusText("");
}

function updateStatusText(itemText) {
   var statusTextFld = document.getElementById("statusbar-display");
   var newText = itemText ? itemText : gBackupLabel;
   if (newText != statusTextFld.label)
      statusTextFld.label = newText;
}

function tabSorting(tab, index) {
   this.Tab = tab;
   this.Index = index;
}

tabSorting.prototype.toString = function() { return this.Tab.label.toLowerCase(); }
