// start of definition 
if (!window.TabbrowserBrowserService) {

var gTSDOMWindowOpenObserver;
 
// static class "TabbrowserBrowserService" 
var TabbrowserBrowserService =
{
	
	get service() 
	{
		if (this._service === void(0))
			this._service = 'TabbrowserService' in window ? window.TabbrowserService : null ;

		return this._service;
	},
//	_service : null,
 
	// event handling 
	
	onInit : function() 
	{
		var TS = TabbrowserService;
		var i;

		// Catch up changing of prefs
		if (TS.isBrowserWindow) {
			TS.addPrefListener(gTSTabMenuPrefListener);
 			TS.addPrefListener(gTSPlatformNativeBehaviorPrefListener);
			TS.addPrefListener(gTWindowModePrefListener);
			TS.addPrefListener(gTSOpenTabForWindowOpenPrefListener);

			if (!TS.getPref('browser.tabs.extensions.updateNativeSingleWindowPref.done'))
				gTSOpenTabForWindowOpenPrefListener.updateNativeSingleWindowPref();

			var w = TS.browserWindows;
			for (i in w)
				if (w[i] != window && w[i].gTSDOMWindowOpenObserver) {
					window.gTSDOMWindowOpenObserver = w[i].gTSDOMWindowOpenObserver;
					break;
				}

			if (!window.gTSDOMWindowOpenObserver) {
				window.gTSDOMWindowOpenObserver = this.DOMWindowOpenObserver;
				TS.ObserverService.addObserver(window.gTSDOMWindowOpenObserver, 'domwindowopened', false);
			}

			TS.ObserverService.addObserver(this, 'StartDocumentLoad', false);
		}
		if (TS.browser) {
			window.addEventListener('focus', this.onWindowFocus, true);
			window.addEventListener('blur', this.onWindowBlur, true);

			TS.addPrefListener(gTSTabbarBlankSpacePrefListener);
			TS.addPrefListener(gTSCloseBoxPrefListener);
			TS.addPrefListener(gTSLastTabClosingPrefListener);
			TS.addPrefListener(gTSTabsAutoHidePrefListener);
			TS.addPrefListener(gTSIconOverlayInTabsPrefListener);
			TS.addPrefListener(gTSTabbarPlacePrefListener);
			TS.addPrefListener(gTSGroupModePrefListener);
			TS.addPrefListener(gTSTabsWidthPrefListener);
			TS.addPrefListener(gTSTabScrollerPrefListener);
			TS.addPrefListener(gTSAnotherBindingPrefListener);

			window.addEventListener('resize', this.onWindowResize, false);
		}

		this.updateTabBrowser();

		if (TS.isBrowserWindow) {
			gTSTabMenuPrefListener.observe(null, 'nsPref:changed', null);
			gTSPlatformNativeBehaviorPrefListener.observe(null, 'nsPref:changed', null);
			gTWindowModePrefListener.observe(null, 'nsPref:changed', null);
		}
		if (TS.browser) {
			gTSTabbarPlacePrefListener.update();
//			gTSTabbarPlacePrefListener.observe(null, 'nsPref:changed', null);
			gTSIconOverlayInTabsPrefListener.observe(null, 'nsPref:changed', null);
			gTSTabbarBlankSpacePrefListener.observe(null, 'nsPref:changed', null);
			gTSCloseBoxPrefListener.observe(null, 'nsPref:changed', 'browser.tabs.extensions.show_closebox.tab');
			gTSCloseBoxPrefListener.observe(null, 'nsPref:changed', 'browser.tabs.extensions.show_closebox.tabbar');
			gTSCloseBoxPrefListener.observe(null, 'nsPref:changed', 'browser.tabs.extensions.show_closebox.tab.appearance');
			gTSLastTabClosingPrefListener.observe(null, 'nsPref:changed', null);
			gTSTabsWidthPrefListener.observe(null, 'nsPref:changed', null);
			gTSTabScrollerPrefListener.observe(null, 'nsPref:changed', null);
			gTSAnotherBindingPrefListener.observe(null, 'nsPref:changed', null);

			var defaultFeaturePrefs = [
					'locked',
					'referrerBlocked',
					'allowPlugins',
					'allowJavascript',
					'allowMetaRedirects',
					'allowSubframes',
					'allowImages'
				];
			var j;
			var t = TS.browser.mTabs;
			for (i = 0; i < t.length; i++)
				for (j in defaultFeaturePrefs)
					t[i][defaultFeaturePrefs[j]] = TS.getPref('browser.tabs.extensions.'+defaultFeaturePrefs[j]+'.enabled');
		}


		if (!TS.isNewTypeBrowser) {
			window.addEventListener('close', this.onWindowClose, false);
		}
	},
 
	onAfterInit : function() 
	{
		var b = this.service.browser;
		if (!b) return;


		var hookEvent = function(aNode, aWindow, aType)
		{
			if (aType != 'click' && aType != 'keypress') return;

			var node = TabbrowserBrowserService.findParentNodeByNameOrProp(aNode, null, 'on'+aType, 'function');

			if (!node || !node.localName) return;

			node.__tabextensions__shouldStop = false;
			node.__tabextensions__shouldVoid = false;
			node.__tabextensions__isNotLink  = (
				!node.getAttribute('href') &&
				!node.getAttributeNS('http://www.w3.org/1999/xhtml', 'href') &&
				!node.getAttributeNS('http://www.w3.org/1999/xlink', 'href') &&
				!node.href
			);

			if (
				!('on'+aType in node) ||
				'__tabextensions__on'+aType in node
				)
				return;

			var w = aWindow;

			node['__tabextensions__on'+aType] = node['on'+aType];
			node['on'+aType] = function(event)
			{
				if (node.__tabextensions__shouldStop) {
					w.__tabextensions__currentEvent = event;
					w.__tabextensions__currentNode = node;
					(w.__tabextensions_ctrlpopup__setTimeout || w.setTimeout)('var active = __tabextensions__activeEventType; __tabextensions__activeEventType = "'+aType+'"; __tabextensions__LastEvent = (new Date()).getTime(); try { __tabextensions__currentNode.__tabextensions__retVal = __tabextensions__currentNode.__tabextensions__on'+aType+'(__tabextensions__currentEvent); } catch(e) { __tabextensions__currentNode.__tabextensions__retVal = void(0); }; delete window.__tabextensions__currentEvent; delete window.__tabextensions__currentNode; __tabextensions__activeEventType = active;', 0);
				}
				else if (node.__tabextensions__shouldVoid) {
					return;
				}
				else
					(w.__tabextensions_ctrlpopup__setTimeout || w.setTimeout)(arguments.callee, 0, event);
			};
		}


		b.hookContentAreaEvents.extraHandlers[b.hookContentAreaEvents.extraHandlers.length] = function(aEvent, aOwnerTabBrowser)
		{
			var node = 'originalTarget' in aEvent ? aEvent.originalTarget : aEvent.target ;
			var w = ('defaultView' in node && node.defaultView) ? node.defaultView :
					node.ownerDocument.defaultView ;


			if (
				!aOwnerTabBrowser.mPrefs.getBoolPref('javascript.enabled') ||
				!w.QueryInterface(Components.interfaces.nsIInterfaceRequestor)
					.getInterface(Components.interfaces.nsIWebNavigation)
					.QueryInterface(Components.interfaces.nsIDocShell)
					.allowJavascript
				)
				return;


			w.__tabextensions__activeEventType = aEvent.type;


			if (!('__tabextensions__activeEvents' in w))
				w.__tabextensions__activeEvents = {};
			if (!(aEvent.type in w.__tabextensions__activeEvents))
				w.__tabextensions__activeEvents[aEvent.type] = [];

			w.__tabextensions__activeEvents[aEvent.type].push(aEvent);
			w.__tabextensions__activeEventButton = aEvent.type.match(/mousedown|mouseup|click|dblclick/) ? aEvent.button : null ;

			window.setTimeout(function(aType) {
				try {
					if (
						'__tabextensions__activeEvents' in w &&
						aType in w.__tabextensions__activeEvents
						)
						w.__tabextensions__activeEvents[aType].pop();
				}
				catch(e) {
				}
			}, 0, aEvent.type);



			if (!aEvent.type.match(/^(keypress|click|mousedown|mouseup|dblclick)$/))
				return;

			w.__tabextensions__LastEvent = (new Date()).getTime();

			if (!aOwnerTabBrowser.hookContentAreaClick) return;

			if (
				TabbrowserBrowserService.findParentNodeByNameOrProp(node, 'a') ||
				TabbrowserBrowserService.findParentNodeByNameOrProp(node, 'area') ||
				TabbrowserBrowserService.findParentNodeByNameOrProp(node, 'link')
				)
				hookEvent(node, w, aEvent.type);
		};
	},
 
	onBeforeInitWithDelay : function() 
	{
		// reset tab index (we have to do it for Mac OS X)
		// *2005.1.27:
		//   This section is for old implementation.
		//   I have not texted yet. Can I remove this scrion, or cannot?
		var b = TabbrowserService.browser;
		if (b) {
			function resetTabIndex()
			{
				var tabs = b.mTabs;
				for (var i = 0; i < tabs.length; i++)
					tabs[i].tabIndex = i;
			}
			resetTabIndex();
		}
	},
 
	onInitWithDelay : function() 
	{
		// reset labels
		if (TabbrowserService.browser)
			gTSTabsWidthPrefListener.observe(null, 'nsPref:changed', null);

		// sometimes, menuitems in "chevron" are shown as personal toolbar buttons, like "buttons are doubled".
		// this rebuilding is a fix for this problem.
		if (document.getElementById('bookmarks-chevron'))
			document.getElementById('bookmarks-chevron').builder.rebuild();
		if (document.getElementById('bookmarks-ptf'))
			document.getElementById('bookmarks-ptf').builder.rebuild();
	},
 
	onDestruct : function() 
	{
		var TS = TabbrowserService;
		var i;

		if (TS.isBrowserWindow) {
			TS.removePrefListener(gTSTabMenuPrefListener);
			TS.removePrefListener(gTSPlatformNativeBehaviorPrefListener);
			TS.removePrefListener(gTWindowModePrefListener);
			TS.removePrefListener(gTSOpenTabForWindowOpenPrefListener);

			try {
				var w = TS.browserWindows;
				if (!w.length || (w.length == 1 && w[0] == window))
					TS.ObserverService.removeObserver(window.gTSDOMWindowOpenObserver, 'domwindowopened', false);
			}
			catch(e) {
			}
			delete window.gTSDOMWindowOpenObserver;

			TS.ObserverService.removeObserver(this, 'StartDocumentLoad', false);
		}
		if (TS.browser) {
			window.removeEventListener('focus', this.onWindowFocus, true);
			window.removeEventListener('blur', this.onWindowBlur, true);

			TS.removePrefListener(gTSTabbarBlankSpacePrefListener);
			TS.removePrefListener(gTSCloseBoxPrefListener);
			TS.removePrefListener(gTSLastTabClosingPrefListener);
			TS.removePrefListener(gTSTabsAutoHidePrefListener);
			TS.removePrefListener(gTSIconOverlayInTabsPrefListener);
			TS.removePrefListener(gTSTabbarPlacePrefListener);
			TS.removePrefListener(gTSGroupModePrefListener);
			TS.removePrefListener(gTSTabsWidthPrefListener);
			TS.removePrefListener(gTSTabScrollerPrefListener);
			TS.removePrefListener(gTSAnotherBindingPrefListener);

			window.removeEventListener('resize', this.onWindowResize, false);
		}


		window.removeEventListener('close', this.onWindowClose, false);


		this.destroyTabBrowser();
	},
 
	onWindowResize : function(aEvent) 
	{
		if (aEvent.target == window ||
			aEvent.target == document ||
			aEvent.target.ownerDocument == document)
			TabbrowserService.browser.onTabsModified();
	},
 
	onWindowClose : function(aEvent) // confirm to close, when the window contains tabs 
	{
		var TS  = TabbrowserService;
		var TBS = TabbrowserBrowserService;
		var TSM = 'TabbrowserSessionManager' in window ? TabbrowserSessionManager : null ;

		if (TBS.windowClosing) return false;
		TBS.windowClosing = true;

		var b  = TS.browser;
		var check,
			behavior = TS.getPref('browser.tabs.extensions.window_close.behavior');

		if (TS.activated && b) {
			if (behavior == 10 && b.canRemoveCurrentTab()) {
				b.removeCurrentTab();
				if (aEvent) {
					aEvent.preventDefault();
					aEvent.preventBubble();
					aEvent.preventCapture();
					aEvent.stopPropagation();
				}
				window.setTimeout(function() { TabbrowserBrowserService.windowClosing = false; }, 100);
				return false;
			}
			else if (
				b.mTabs.length > 1 ||
				(
					behavior < 0 &&
					!TS.getPref('browser.tabs.extensions.window_close.behavior.confirmOnlyForMultipleTabs')
				)
				) {
				check = { value: behavior != -1 };
				// if you set TBE to do some window-closing action, do it silently
				if (check.value) {
					if (behavior == 1) {
						var statusText = TS.strbundle.GetStringFromName('message_cancel_windowclose').replace(/%s/gi, b.mTabs.length-1);
						var status = document.getElementById('statusbar-display');
						if (status)
							status.label = statusText;
						else
							window.status = statusText;

						try {
							var sound = Components.classes['@mozilla.org/sound;1'].createInstance(Components.interfaces.nsISound);
							sound.beep();
						}
						catch(e) {
						}
					}
				}
				// if no action is specified, TBE should ask the user to do what actions.
				// but, if the startup action is "load last sessioln", don't ask.
				// because we can restore the last visited tabs automatically on the next startup.
				else if (TSM && TS.getPref('browser.tabs.extensions.startup_action_overlay') == 0) {
					if (TS.getPref('browser.tabs.extensions.window_close.behavior') == 1)
						TS.setPref('browser.tabs.extensions.window_close.behavior', 0);
					return true;
				}
				// if no window-closing action and the startup action are specified,
				// ask user to do what action.
				else {
					var dialogTitle = TS.strbundle.GetStringFromName('message_confirm_windowclose_title'),
						dialogMessage = TS.strbundle.GetStringFromName('message_confirm_windowclose_text').replace(/%s/gi, b.mTabs.length),
						neverShowMessage = TS.strbundle.GetStringFromName('message_never_show_dialog');
					var buttonLabels = (TS.PromptService.BUTTON_TITLE_IS_STRING * TS.PromptService.BUTTON_POS_0) +
							(TS.PromptService.BUTTON_TITLE_CANCEL * TS.PromptService.BUTTON_POS_1),
						buttonLabel1 = TS.strbundle.GetStringFromName('message_confirm_windowclose_ok'),
						buttonLabel2 = null;
					var saveSessionBehavior = 0;
					if (TSM) {
						if (!TSM.shouldResutoreLastVisitedTabs) {
							buttonLabels += (TS.PromptService.BUTTON_TITLE_IS_STRING * TS.PromptService.BUTTON_POS_2);
							 saveSessionBehavior = 2;
							buttonLabel2 = TSM.strbundle.GetStringFromName('message_confirm_windowclose_save');
						}
						else {
							saveSessionBehavior = 1;
							buttonLabel1 = TSM.strbundle.GetStringFromName('message_confirm_windowclose_save');
						}
					}
					behavior = TS.PromptService.confirmEx(
							window,
							dialogTitle, dialogMessage,
							buttonLabels, buttonLabel1, null, buttonLabel2,
							neverShowMessage, check
						);
					if (behavior == saveSessionBehavior) behavior = 2;
					if (check.value && behavior != -1) {
						TS.setPref('browser.tabs.extensions.window_close.behavior', (behavior == 1 ? 1 : 0 ));

						if (behavior == 2) {
							TS.setPref('browser.tabs.extensions.startup_action_overlay', 0);

							check = { value : TS.getPref('browser.tabs.extensions.startup_action_overlay.one_time.hide_changemode_alert') };
							if (TSM && !check.value) {
								TS.PromptService.alertCheck(
									window,
									TSM.strbundle.GetStringFromName('message_confirm_windowclose_save_note_title'),
									TSM.strbundle.GetStringFromName('message_confirm_windowclose_save_note'),
									TS.strbundle.GetStringFromName('message_never_show_dialog'),
									check
								);
								if (check.value) TS.setPref('browser.tabs.extensions.startup_action_overlay.one_time.hide_changemode_alert', true);
							}
							return false;
						}
					}
				}

				switch (behavior)
				{
					default:
					case 0: // close all tabs
						break;

					case 1: // cancel to close
						if (aEvent) {
							aEvent.preventDefault();
							aEvent.preventBubble();
							aEvent.preventCapture();
							aEvent.stopPropagation();
						}

						window.setTimeout(function() { TabbrowserBrowserService.windowClosing = false; }, 100);
						return false;

					case 2: // save all tabs and close window
						if (!TSM) break;

						var checkPref,
							label = '',
							message;
						if (TS.browserWindows.length == 1) {
							TS.setPref('browser.tabs.extensions.startup_action_overlay.one_time', true);
							TS.setPref('browser.tabs.extensions.startup_action_overlay.one_time.backup', TS.getPref('browser.tabs.extensions.startup_action_overlay'));
							checkPref = 'browser.tabs.extensions.startup_action_overlay.one_time.hide_alert';
							message = 'message_confirm_windowclose_alert_one_time';
						}
						else {
							label = TSM.saveTabSession();
							checkPref = 'browser.tabs.extensions.autosave_tabset.hide_alert';
							message = 'message_confirm_windowclose_alert_autosave_tabset';
						}
						TS.setPref('browser.tabs.extensions.startup_action_overlay', 0);
						check = { value : TS.getPref(checkPref) };
						if (!check.value) {
							TS.PromptService.alertCheck(
								window,
								TSM.strbundle.GetStringFromName('message_confirm_windowclose_alert_title'),
								TSM.strbundle.GetStringFromName(message).replace(/%s/gi, label),
								TS.strbundle.GetStringFromName('message_never_show_dialog'),
								check
							);
							if (check.value) TS.setPref(checkPref, true);
						}
						break;
				}
			}
		}

		// failsafe
//		if (TS.activated)
//			TS.destruct();

		return true;
	},
	windowClosing : false,
 
	// lick click 
	
	onStopEvent : function(aInfo) 
	{
		var targetNode = this.findParentNodeByProp(aInfo.DOMEvent.originalTarget, '__tabextensions__on'+aInfo.DOMEvent.type, 'function');
		if (targetNode)
			targetNode.__tabextensions__shouldVoid = true;
	},
 
	// contentAreaClick 
	
	onContentAreaClick_preProcess : function(aInfo) 
	{
		var event = aInfo.DOMEvent;

		var node = (
					findParentNode(event.target, 'a') ||
					findParentNode(event.target, 'area') ||
					findParentNode(event.target, 'link') ||
					null
				);
		var parentEventListener = this.findParentNodeByProp(event.originalTarget, '__tabextensions__on'+event.type, 'function');

		// ignore clicks not on a link
		if (!node || (event.type == 'click' && event.button > 1)) {
			if (parentEventListener)
				parentEventListener.__tabextensions__shouldStop = true;
			aInfo.cancelProcess = true;
			aInfo.retVal = __tabextensions__contentAreaClick(event, aInfo.fieldNormalClicks);
			return;
		}


		// ignore canceled events
		if (
			this.service.getPref('javascript.enabled') &&
			Components.lookupMethod(node.ownerDocument.defaultView, 'top').call(node.ownerDocument.defaultView)
				.QueryInterface(Components.interfaces.nsIInterfaceRequestor)
				.getInterface(Components.interfaces.nsIWebNavigation)
				.QueryInterface(Components.interfaces.nsIDocShell)
				.allowJavascript &&
			!('__tabextensions__allowed' in event) &&
			this.isClickEventCanceled(event, aInfo.fieldNormalClicks)
			) {
			if (parentEventListener)
				parentEventListener.__tabextensions__shouldStop = true;
			aInfo.cancelProcess = true;
			aInfo.retVal = false;
			return;
		}
	},
	
	// ignore canceled events 
	isClickEventCanceled : function(aEvent, aFieldNormalClicks)
	{
		var TS = this.service;
		if (
			!aEvent.currentTarget.hookContentAreaClick ||
			(
				aEvent.type == 'click' &&
				(
					aEvent.button != 0 ||
					(
						!aEvent.originalTarget['on'+aEvent.type] &&
						!this.findParentNodeByProp(aEvent.originalTarget, 'on'+aEvent.type, 'function')
					)
				)
			)
			)
			return false;

		var targetNode = this.findParentNodeByProp(aEvent.originalTarget, '__tabextensions__on'+aEvent.type, 'function');
		if (targetNode && targetNode.__tabextensions__isNotLink)
			return false;


		// Mozilla fails to hand nsIDOMEvent object to callback function.
		// So we have to create a dummy object like the event object.
		var event = {
				__tabextensions__allowed       : true,
				__tabextensions__browserWindow : TS.browserWindow,
				__tabextensions__tabId  : TS.browser.selectedTab.tabId
			};
		for (var i in aEvent)
		{
			try {
				event[i] = typeof aEvent[i] == 'function' ? function() {} : aEvent[i] ;
			}
			catch(e) {
			}
		}


		if (targetNode)
			targetNode.__tabextensions__shouldStop = true;

		window.setTimeout(
			function(aEvent, aFieldNormalClicks)
			{
				var target = targetNode || TabbrowserBrowserService.findParentNodeByProp(aEvent.originalTarget, '__tabextensions__on'+aEvent.type, 'function');

				// wait the function is completely evaluated
				if (!target.__tabextensions__shouldStop ||
					!('__tabextensions__retVal' in target)) {
					if (target && !target.__tabextensions__shouldStop)
						target.__tabextensions__shouldStop = true;

					window.setTimeout(arguments.callee, 0, aEvent, aFieldNormalClicks);
					return;
				}

				var canceled = target.__tabextensions__retVal;
//dump('event handler result has captured : '+(canceled === void(0) ? 'undefined' : canceled )+'\n');
				canceled = (canceled === void(0)) ? false : !canceled ;
				delete target.__tabextensions__retVal;
				target.__tabextensions__shouldStop = false;
				target.__tabextensions__shouldVoid = false;
				target.__tabextensions__isNotLink  = false;
				if (!canceled)
					contentAreaClick(aEvent, aFieldNormalClicks);
			},
			0,
			event,
			aFieldNormalClicks
		);

		return true;
	},
  
	onContentAreaClick_noBrowserWindow : function(aInfo) 
	{
		var parentEventListener = this.findParentNodeByProp(aInfo.DOMEvent.originalTarget, '__tabextensions__on'+aInfo.DOMEvent.type, 'function');
		if (parentEventListener)
			parentEventListener.__tabextensions__shouldVoid = true;
	},
 
	onContentAreaClick_postProcess : function(aInfo) 
	{
		var parentEventListener = this.findParentNodeByProp(aInfo.DOMEvent.originalTarget, '__tabextensions__on'+aInfo.DOMEvent.type, 'function');
		if (parentEventListener)
			parentEventListener.__tabextensions__shouldStop = true;
	},
  
	// doLinkAction 
	
	onDoLinkAction_preProcess : function(aLinkInfo) 
	{
		var uri  = aLinkInfo.uri;

		if (
			!uri ||
			!uri.match(/^javascript:/i) ||
			uri.match(/^javascript:window.__tabextensions__LastEvent/i) ||
			aLinkInfo.causedByLocked ||
			aLinkInfo.causedByAlwaysNewTab ||
			aLinkInfo.causedByMiddleClick ||
			!(aLinkInfo.newTypeBrowserOpenWindow && this.service.winHookMode > 0)
			)
			return;

		var node = aLinkInfo.node;

		uri = 'javascript:void(window.__tabextensions__LastEvent = (new Date()).getTime());'+uri.replace(/^javascript:/i, '');
		aLinkInfo.uri = uri;

		if (node.href)
			node.href = uri;
		else if (node.getAttributeNS(this.service.XHTMLNS, 'href'))
			node.setAttributeNS(this.service.XHTMLNS, 'xhtml:href', uri);
		else if (node.getAttributeNS(this.service.XLinkNS, 'href'))
			node.setAttributeNS(this.service.XLinkNS, 'xlink:href', uri);
		else
			node.setAttribute('href', uri);

		window.setTimeout(
			function()
			{
				if (
					!node ||
					!node.ownerDocument ||
					!node.ownerDocument.defaultView ||
					node.ownerDocument.defaultView.closed
					)
					return;

				uri = uri.replace(/^javascript:void([^;]+);/, 'javascript:');
				if (node.href)
					node.href = uri;
				else if (node.getAttributeNS(this.service.XHTMLNS, 'href'))
					node.setAttributeNS(this.service.XHTMLNS, 'xhtml:href', uri);
				else if (node.getAttributeNS(this.service.XLinkNS, 'href'))
					node.setAttributeNS(this.service.XLinkNS, 'xlink:href', uri);
				else
					node.setAttribute('href', uri);
			},
			100
		);
	},
 
	onDoLinkAction_postProcess : function(aLinkInfo) 
	{
		if (
			// When the event object is a dummy, the default action of the links has been canceled. So, we have to load the page manually.
			(aLinkInfo.retVal && '__tabextensions__allowed' in aLinkInfo.DOMEvent) ||
			// If the name is used for XUL window, browser replaces the chrome window itself to the page invalidly...
			// And, this is also for blocking of new windows from links.
			aLinkInfo.target
			) {
			TabbrowserOverlay.loadLinkNormally(aLinkInfo);
			aLinkInfo.retVal = false;
		}
	},
   
	// set the flag "is this window focused?" 
	// see the definition of "setFocusInternal" in the tabextensions.xml
	
	onWindowFocus : function(aEvent) 
	{
		window.setTimeout('window.__tabextensions__isWindowFocused = true;', 0);
	},
 
	onWindowBlur : function(aEvent) 
	{
		window.__tabextensions__isWindowFocused = false;
	},
  
	// ƎCxg̕ߑ 
	
	onTabbrowserWindowClose : function(aEvent) 
	{
		var t = aEvent.originalTarget || aEvent.target;
		if (t) {
			var doc = t.ownerDocument || t;
			doc.tabbrowserReadyState = 'loading';
		}
	},
 
	onTabbrowserWindowUnload : function(aEvent) 
	{
		var t = aEvent.originalTarget || aEvent.target;
		if (t) {
			var doc = t.ownerDocument || t;
			doc.tabbrowserReadyState = 'loading';
		}
	},
 
	onXULTabbrowserTabLoading : function(aEvent) 
	{
		TabbrowserBrowserService.onTabLoading(aEvent.target.getTabByTabId(aEvent.tabId), aEvent.loadingView, !aEvent.followFrames);
	},
 
	onXULTabbrowserTabLoad : function(aEvent) 
	{
		TabbrowserBrowserService.onTabLoading(aEvent.loadedView, aEvent.target.getTabByTabId(aEvent.tabId));

		if (TabbrowserService.getPref('browser.tabs.extensions.tabs_width_type') == 1)
			TabbrowserService.browser.onTabsModified();
	},
 
	onXULTabbrowserTabStatusChange : function(aEvent) 
	{
		if (
			aEvent.targetURI != 'ANY' &&
			(
				TabbrowserService.shouldSaveBookmarksStatus ||
				aEvent.targetStatus == 'fixedLabel' ||
				(
					TabbrowserService.getPref('browser.tabs.extensions.bookmarks.save_textZoom') &&
					aEvent.targetStatus == 'textZoom'
				)
			)
			)
			TabbrowserService.saveBookmarkStatus(aEvent.target, aEvent.target.getTabByTabId(aEvent.tabId), aEvent.targetStatus);
	},
 
	onXULTabbrowserTabDrop : function(aEvent) 
	{
		TabbrowserBrowserService.onTabDropInternal(aEvent);
	},
 
	onXULTabbrowserURIDrop : function(aEvent) 
	{
		// Make dragged links visited
		var links = TabbrowserService.getSelectionLinks();
		if (links.length == 1 &&
			links[0].uri == aEvent.droppedURI)
			TabbrowserService.markLinkVisited(links[0].uri, links[0].node);
	},
 
	onXULTabbrowserAddTabCanceled : function(aEvent) 
	{
		var TS = TabbrowserService;
		var chromehidden;
		var useOverflow = (
				( // if the tab bar is hidden
					(chromehidden = Components.lookupMethod(window, 'top').call(window).document.documentElement.getAttribute('chromehidden')) &&
					chromehidden.indexOf('location') > -1 &&
					chromehidden.indexOf('toolbar') > -1
				) ||
				(
					TS.getPref('browser.tabs.extensions.limit.overflow') &&
					TS.winHookMode != 2
				)
			);


		if (!useOverflow) {
			TS.popupAlert(TS.strbundle.GetStringFromName('status_tabs_rejected'));
			return;
		}


		// If another browser exists, open tab there.

		var referrer = aEvent.referrerURI ? TS.makeURIFromSpec(aEvent.referrerURI) : null ;
		var max      = TS.getPref('browser.tabs.extensions.limit.number');
		var info,
			b        = TS.browserWindows;
		for (var i = 0; i < b.length; i++)
		{
			if (
				b[i] == window ||
				!b[i].TabbrowserService.browser ||
				!b[i].TabbrowserService.browser.mTabs ||
				(max && b[i].TabbrowserService.browser.mTabs.length >= max)
				)
				continue;

			b[i].focus();
			b[i].TabbrowserService.browser.addTabInternal(
				aEvent.loadingURI,
				referrer,
				aEvent.tabInfo
			);
			return;
		}

		// ɃuEUEBhEȂA邢́ÃEBhESĐς܂Ń^uJĂꍇAVKɃEBhEJ
		// If other navigators have fully tabs, then open new navigator window.
//dump('over:'+aURI+'\n');
		TS.overflowingTabsManager.addTab(
			aEvent.loadingURI,
			referrer,
			aEvent.tabInfo
		);
	},
  
	onTabLoading : function(aRelatedTab, aWindow, aShouldNotFollowFrames) 
	{
		var TS = TabbrowserService;

		if (aWindow == Components.lookupMethod(aWindow, 'top').call(aWindow) &&
			!('__tabextensions__initialized' in aWindow)) {
			// ACRw肳ĂꍇÃACRD悷B
			// URIACRw肳ꂽubN}[NURI艺ʂ̃fBNgłȂꍇAACRZbgB
			var icon = TS.getIconForBookmark(aRelatedTab.getAttribute('tab-loadingURI'), true);
			if (icon) {
				window.setTimeout(
					function(aTab, aURI)
					{
						aTab.setAttribute('image', aURI);
						// y[WJ_ŃACȐ񂪏㏑Ă܂Ă̂ŁAēx㏑
					},
					0,
					aRelatedTab, icon
				);
				TS.setIconForBookmark(aRelatedTab.getAttribute('tab-loadingURI'));
			}
		}

		var frames;
		try {
			frames = Components.lookupMethod(aWindow, 'frames').call(aWindow);
		}
		catch(e) {
		}
		if (frames && !aShouldNotFollowFrames) {
			for (var i = 0; i < frames.length; i++)
				this.onTabLoading(aRelatedTab, frames[i]);
		}

		if (
			'__tabextensions__initialized' in aWindow ||
			!aWindow.Window
			)
			return;


		// set focus
		if (
			aRelatedTab == TS.browser.selectedTab &&
			!document.commandDispatcher.focusedElement // if a node has been focued, do nothing
			)
			TS.browser.setFocusInternal();


		// if there are multiple tabs, we should prevent to do it.
		if (TS.browser.mTabs.length > 1)
			TS.preventModifyWindowState(aWindow);

		aWindow.__tabextensions__LastEvent = (new Date()).getTime();

		aWindow.__tabextensions__initialized = true;
	},
  
	updateTabBrowser : function() 
	{
		var b = TabbrowserService.browser;
		if (!b) return;

		// failsafe
		if (b.mPanelContainer.selectedIndex !== 0 &&
			b.mTabListeners.length) // this "failsafe" section causes a fatal error in the latest nightly build so I skip it. (2004.1.21)
			b.mPanelContainer.selectedIndex = 0;

		this.updateMethods(b);
		this.updateContextMenu(b); // Add new menuitems
		this.supportMovableTabs(b);
		this.updateTabContainer(b);

		// for Firefox
		// Firefox fails to execute "constructor" of tabs. why?
		b.mTabContainer.selectedIndex = 0;
		b.mTabs[0].setAttribute('first-tab', 'true');
		b.mTabs[b.mTabs.length-1].setAttribute('last-tab', 'true');
		b.selectedTab.__tabextensions__lastFocusedTime = (new Date()).getTime();

		b.mTabProgressListenerCreatorInternal.addListenerTo(b.selectedTab);

		b.startHookingContentAreaEvents();

		b.addEventListener('DOMWindowClose', b.onWindowCloseInLastTabEventListener, true);

		// reset tabbrowserReadyState
		b.addEventListener('close', this.onTabbrowserWindowClose, true);
		// failsafe
		b.addEventListener('unload', this.onTabbrowserWindowUnload, true);

		b.addEventListener('XULTabbrowserTabLoading', this.onXULTabbrowserTabLoading, false);
		b.addEventListener('XULTabbrowserTabLoad', this.onXULTabbrowserTabLoad, false);
		b.addEventListener('XULTabbrowserTabStatusChange', this.onXULTabbrowserTabStatusChange, false);
		b.addEventListener('XULTabbrowserTabDrop', this.onXULTabbrowserTabDrop, false);
		b.addEventListener('XULTabbrowserURIDrop', this.onXULTabbrowserURIDrop, false);
		// open tabs in other windows if "addTab" is canceled
		b.addEventListener('XULTabbrowserAddTabCanceled', this.onXULTabbrowserAddTabCanceled, false);


		// To fix the problem "window is always focued even if I prevent window-focus by a pref in the 'Focus' pref panel"
		var updateCurrentBrowser = b.updateCurrentBrowser.toString();
		if (updateCurrentBrowser.match(/window._content.focus\(\)/)) {
			eval('b.updateCurrentBrowser = '+
				updateCurrentBrowser.replace(
					/window._content.focus\(\)/g,
					'gBrowser.setFocusInternal(_content);'
				).replace(
					/^[^\(]*/,
					'function'
				)
			);
		}
		else if (updateCurrentBrowser.match(/setFocus\(element\)/)) {
			eval('b.updateCurrentBrowser = '+
				updateCurrentBrowser.replace(
					/Components.lookupMethod\(element, "focus"\).call\(element\);/g,
					'tabBrowser.setFocusInternal(element);'
				).replace(
					/^[^\(]*/,
					'function'
				).replace(
					'function setFocus',
					'var tabBrowser = this; function setFocus'
				)
			);
		}
		// fix the problem: when tabs are rearranged the URL bar indicates "not-rearranged" URLs. (only in Mozilla Suite)
		updateCurrentBrowser = b.updateCurrentBrowser.toString();
		if (updateCurrentBrowser.match(/this\.mPanelContainer\.childNodes\[.+\.selectedIndex\]/)) {
			eval('b.updateCurrentBrowser = '+
				updateCurrentBrowser.replace(
					/this\.mPanelContainer\.childNodes\[.+\.selectedIndex\]/g,
					'this.getBrowserForTab(this.selectedTab)'
				)
			);
		}
	},
	
	// \bh̏㏑ 
	updateMethods : function(aTabBrowser)
	{
		// from Tab Mix/MiniT
		aTabBrowser.__defineGetter__('mTabs',
			function (){ return this.mTabContainer.childNodes; });
		aTabBrowser.mCurrentTab.__proto__.__defineGetter__('ordinal',
			function (){ return this.tabIndex; });
		aTabBrowser.__defineGetter__('browsers',
			function() {
				var browsers = [];
				for (var i = 0; i < this.mTabs.length; i++)
					browsers.push(this.getBrowserForTab(this.mTabs[i]));
				return browsers;
			}
		);
		aTabBrowser.mPanelContainer.__defineSetter__('selectedIndex',
			aTabBrowser.mPanelContainer.__lookupSetter__('selectedIndex'));
		aTabBrowser.mPanelContainer.__defineGetter__('selectedIndex',
			function() { return aTabBrowser.mTabContainer.selectedIndex; });
		aTabBrowser.getBrowserAtIndex = function(aIndex) {
			if (aIndex < 0) return null;
			return this.getBrowserForTab(this.mTabs[aIndex]);
		};

		try {
			eval('bengoodger.com.tabdownloader._saveSubsequentTabs ='+bengoodger.com.tabdownloader._saveSubsequentTabs.toString().replace(
				'var startBrowser = this._findNextBrowser(tabbrowser.selectedBrowser);',
				'try { var startBrowser = tabbrowser.getBrowserAtIndex(tabbrowser.mCurrentTab.tabIndex+1); } catch(e) { return; }'
			));
		}
		catch(e) {
		}

		var uniqueId;
		for(var i = 0; i < aTabBrowser.mTabs.length; i++)
		{
			var uniqueId = 'panel'+(new Date()).getTime()+i;
			aTabBrowser.mPanelContainer.childNodes[i].id = uniqueId;
			aTabBrowser.mTabs[i].setAttribute('linkedpanel', uniqueId);
			aTabBrowser.mTabs[i].tabIndex = i;

			aTabBrowser.mIdentifiedTabs[aTabBrowser.mTabs[i].tabId] = aTabBrowser.mTabs[i];
		}
		if(gBrowser.mTabs.length > 0) gBrowser.mCurrentTab.selected = true;



		// override "addTab" and "removeTab" methods.

		var method = 'addTab';
		var func   = aTabBrowser[method];
		if (func.toString().indexOf('mTabContainer.appendChild') < 0) {
			func = null;
			for (i in aTabBrowser)
			{
				if (typeof aTabBrowser[i] != 'function' ||
					aTabBrowser[i].toString().indexOf('mTabContainer.appendChild') < 0)
					continue;

				func   = aTabBrowser[i];
				method = i;
				break;
			}
		}
		// from Tab Mix/MiniT
		eval('aTabBrowser[method] ='+
			func.toString().replace(
				'if (!blank)',
				'var uniqueId = "panel"+(new Date()).getTime()+position;'+
				'this.mPanelContainer.lastChild.id = uniqueId;'+
				't.setAttribute("linkedpanel", uniqueId);'+
				't.tabIndex = position;'+
				'if (!blank)'
			)
		);

		aTabBrowser.__tabextensions__addTab = aTabBrowser.addTab;
		aTabBrowser.addTab = this.addTab;


		method = 'removeTab';
		func   = aTabBrowser[method];
		if (func.toString().indexOf('mTabContainer.removeChild') < 0) {
			func = null;
			for (i in aTabBrowser)
			{
				if (typeof aTabBrowser[i] != 'function' ||
					aTabBrowser[i].toString().indexOf('mTabContainer.removeChild') < 0)
					continue;

				func   = aTabBrowser[i];
				method = i;
				break;
			}
		}
		// from Tab Mix/MiniT
		eval('aTabBrowser[method] ='+
			func.toString().replace( // for Netscape 7.1
				'var oldBrowser = this.mPanelContainer.childNodes[index];',
				'var oldBrowser = this.getBrowserForTab(aTab);'
			).replace().replace( // for Firefox
				'this.mPanelContainer.removeChild(this.mPanelContainer.childNodes[index]);',
				'this.mPanelContainer.removeChild(oldBrowser.parentNode == this.mPanelContainer ? oldBrowser : oldBrowser.parentNode );'
			).replace(
				'this.mPanelContainer.selectedIndex = newIndex;',
				'for (var i = oldTab.tabIndex; i < this.mTabs.length; i++) this.mTabs[i].tabIndex = i;'+
				'var nextSelectedBrowser = this.getBrowserForTab(this.mCurrentTab);'+
				'this.mTabBox.selectedPanel = (nextSelectedBrowser.parentNode == this.mPanelContainer) ? nextSelectedBrowser : nextSelectedBrowser.parentNode;'+
				'this.mCurrentTab.selected = true;'
			)
		);

		aTabBrowser.__tabextensions__removeTab = aTabBrowser.removeTab;
		aTabBrowser.removeTab = this.removeTab;



		aTabBrowser.replaceGroup = this.replaceGroup;

		aTabBrowser.getBrowserForTab = this.getBrowserForTab;
		aTabBrowser.onTabClick       = this.onTabClick;

		if (!('selectNewTab' in aTabBrowser))
			aTabBrowser.selectNewTab = this.selectNewTab;

		// from Tab Mix/MiniT
		eval(
			'aTabBrowser.onTitleChanged ='+
			aTabBrowser.onTitleChanged.toString().replace(
				'var tab = tabBrowser.mTabContainer.childNodes[i];',
				'var tab = document.getAnonymousElementByAttribute(tabBrowser, "linkedpanel", this.id || this.parentNode.id);'
			)
		);
		// "this.id" is for NS7 or older versions.

		aTabBrowser.__tabextensions__buildFavIconString = aTabBrowser.buildFavIconString;
		aTabBrowser.buildFavIconString = this.buildFavIconString;
		aTabBrowser.__tabextensions__loadFavIcon = aTabBrowser.loadFavIcon;
		aTabBrowser.loadFavIcon = this.loadFavIcon;
		aTabBrowser.__tabextensions__setTabTitle = aTabBrowser.setTabTitle;
		aTabBrowser.setTabTitle = this.setTabTitle;


		aTabBrowser.__tabextensions__updatePopupMenu = aTabBrowser.updatePopupMenu;
		aTabBrowser.updatePopupMenu = this.updatePopupMenu;

		var popups = aTabBrowser.mStrip.getElementsByAttribute('onpopupshowing', '*');
		for (var i = 0; i < popups.length; i++)
			if (popups[i].localName == 'menupopup') {
				popups[i].setAttribute('onpopupshowing', 'this.parentNode.parentNode.parentNode.updatePopupMenu(this, event);');
				popups[i].mTabBrowser = aTabBrowser;
			}

		aTabBrowser.bookmarksManager = {
			isBookmarked : function(aURI)
			{
				return TabbrowserService.isBookmarked(aURI);
			},
			getName : function(aID)
			{
				return TabbrowserService.getNameForBookmark(aID);
			},
			setName : function(aNewName, aID)
			{
				TabbrowserService.setNameForBookmark(aNewName, aID);
			},
			getIcon : function(aURI, aOnlyUserDefined)
			{
				return TabbrowserService.getIconForBookmark(aURI, aOnlyUserDefined);
			},
			setIcon : function(aURI, aIconURI)
			{
				TabbrowserService.setIconForBookmark(aURI, aIconURI);
			},
			edit : function(aID)
			{
				if (!aID || !this.isBookmarked(aID)) return;

				if (TabbrowserService.isNewTypeBrowser) // Firefox
					window.openDialog('chrome://browser/content/bookmarks/bookmarksProperties.xul', '', 'centerscreen,chrome,resizable=no', aID, {});
				else
					window.openDialog('chrome://communicator/content/bookmarks/bm-props.xul', '', 'centerscreen,chrome,dialog=no,resizable=no,dependent', aID, {});
			},
			bookmarkTabGroup : function(aTab, aShouldBookmarkAllTabs)
			{
				TabbrowserService.bookmarkTabGroup(aTab, aShouldBookmarkAllTabs);
			}
		};
	},
	
	getBrowserForTab : function(aTab) 
	{
		if (!aTab) return this.browser;

		if (aTab._mBrowser) return aTab._mBrowser;


		if (!aTab || aTab.localName == 'tabs') aTab = this.selectedTab;

		if (aTab == this.selectedTab)
			return this.mCurrentBrowser;

		// from Tab Mix/MiniT
		var panel = document.getElementById(aTab.getAttribute('linkedpanel'));
		return (panel.localName == 'browser') ? panel : // trunk
			panel.getElementsByTagNameNS('http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul', 'browser')[0] ; // Firefox 0.9.2 branch

		return null;
	},
 
	// |bvAbvj[̍XV 
	updatePopupMenu : function(aPopup, aEvent)
	{
		// if the popup is a submenu, return
		if (aEvent.originalTarget != aPopup) return;

		var node = document.popupNode;
		// cancel to show popup if any action is bound for right-click on tabs
		if (this.mPrefs.getIntPref((node && node.localName == 'tab') ? 'browser.tabs.extensions.onrightclick' : 'browser.tabs.extensions.tabbar_onrightclick' ) > -1) {
			aEvent.stopPropagation();
			aEvent.preventCapture();
			aEvent.preventDefault();
			aEvent.preventBubble();
			return false;
		}

		var tab = node || this.selectedTab;
		if (tab.localName != 'tab') tab = this.selectedTab;

		this.updateMenuItems(aPopup, this, tab, true);
	},
 
	updateTabsMenu : function(aPopup, aEvent) 
	{
		// if the popup is a submenu, return
		if (aEvent.originalTarget != aPopup) return;

		var nodes = aPopup.getElementsByAttribute('tbattr', 'tabbrowser-multiple');
		var single = gBrowser.mTabs.length == 1 ;
		for (var i = 0;i < nodes.length; i++)
			if (single)
				nodes[i].setAttribute('disabled', true);
			else
				nodes[i].removeAttribute('disabled');

		gBrowser.updateMenuItems(aPopup);
	},
 
	// favicon 
	
	// ACR̎擾 
	buildFavIconString : function(aURI)
	{
		var icon = this.bookmarksManager ? this.bookmarksManager.getIcon(aURI.spec, true) : null ;
		return icon || this.__tabextensions__buildFavIconString(aURI) ;
	},
 
	loadFavIcon : function(aURI, aAttr, aNode) 
	{
		this.__tabextensions__loadFavIcon(aURI, aAttr, aNode);

		var icon = this.bookmarksManager ? this.bookmarksManager.getIcon(aURI.spec, true) : null ;

		if (icon) {
			window.setTimeout(
				function(aNode, aAttr, aURI)
				{
					aNode.setAttribute(aAttr, aURI);
				},
				0,
				aNode, aAttr, icon
			);
			this.bookmarksManager.setIcon(aURI.spec);
		}
	},
  
	addTab : function(aURI, aReferrerURI, aCharset, aPostData) 
	{
		var info = {
				charset  : (aCharset ? aCharset : null ),
				postData : (aPostData ? b.readPostStream(aPostData) : null )
			};
		return this.addTabInternal(aURI, aReferrerURI, info);
	},
 
	removeTab : function(aTab) 
	{
		this.removeTabInternal(aTab);
	},
 
	// ^uE^uo[_uNbNENbN̓ 
	// behavior of clicking on the the tabbar or tabs
	onTabClick : function(aEvent)
	{
		this.updateScrollbarFromEvent(aEvent);

		var type = (aEvent.type == 'dblclick') ? (aEvent.button == 0 ? 'double' : null ) :
					(aEvent.button == 1 || (aEvent.button == 0 && (aEvent.ctrlKey || aEvent.metaKey))) ? 'middle' :
					(aEvent.button == 2) ? 'right' :
					null ;

		if (!type) return;

		var ignoreMiddleClick = false;
		try {
			ignoreMiddleClick = this.mPrefs.getBoolPref('middlemouse.contentLoadURL');
		}
		catch(e) {
		}
		if (type == 'middle' && ignoreMiddleClick) return;

		// in scrollbars
		if (aEvent.originalTarget.localName &&
			aEvent.originalTarget.localName.match(/^(scrollbar(button)?|slider|thumb|popup|menu|menupopup|menuitem|menuseparator)$/)) return;

		var tab    = aEvent.target,
			action = 0,
			pref   = '';

		switch (tab.localName)
		{
			case 'tab':
				switch (type)
				{
					case 'double':
						pref = 'ondblclick';
						break;

					case 'middle':
						pref = 'onmiddleclick';
						break;

					case 'right':
						pref = 'onrightclick';
						break;

					default:
						break;
				}
				break;

			default: // tab bar
				tab = this.selectedTab;
				switch (type)
				{
					case 'double':
						pref = 'tabbar_ondblclick';
						break;

					case 'middle':
						pref = 'tabbar_onmiddleclick';
						break;

					case 'right':
						pref = 'tabbar_onrightclick';
						break;

					default:
						break;
				}
				break;
		}

		if (pref) {
			try {
				action = this.mPrefs.getIntPref('browser.tabs.extensions.'+pref);
			}
			catch(e) {
			}
		}

		switch (action)
		{
			case -1:
				return;

			case 0:
			default:
				break;

			case 1:
				BrowserOpenTab();
				break;
			case 2:
				this.reloadTab(tab);
				break;
			case 3:
				this.reloadAllTabs();
				break;
			case 4:
				this.removeTab(tab);
				break;
			case 5:
				this.removeAllTabsButInternal(tab);
				break;
			case 6:
				if (this.tabGroupsAvailable)
					this.bookmarksManager.bookmarkTabGroup(tab);
				else if ('addGroupmarkAs' in window)
					addGroupmarkAs();
				else
					this.bookmarksManager.bookmarkTabGroup(tab, true);
				break;

			case 101:
				this.duplicateTab(tab);
				break;
			case 102:
				this.toggleTabLocked(tab);
				break;
			case 103:
				this.toggleTabAutoReload(tab);
				break;
			case 104:
				this.removeLeftTabsFrom(tab);
				break;
			case 105:
				this.removeRightTabsFrom(tab);
				break;
			case 106:
				this.duplicateTabInWindow(tab);
				break;
			case 107:
				this.moveTabBy(tab, -1);
				break;
			case 108:
				this.moveTabBy(tab, 1);
				break;
			case 109:
				this.removeTabGroup(tab);
				break;
			case 110:
				this.sortTabsByGroup();
				break;
			case 111:
				this.highlightGroupFromTab(tab);
				break;
			case 112:
				tab.setTabColor(tab);
				break;
			case 113:
				this.undoRemoveTab();
				break;
			case 114:
				this.editBookmarkFromTab(tab);
				break;
			case 115:
				this.toggleReferrerBlocked(tab);
				break;
			case 116:
				window.openDialog('chrome://tabextensions/content/contextMenuEdit.xul', '', 'chrome,modal,resizable=no');
				break;
			case 117:
				this.removeAllTabs();
				break;
			case 118:
				this.setFixedLabelFor(tab);
				break;
			case 119:
				this.removeVisitedTabs();
				break;

			case 200:
				this.toggleDocShellPropertyFor(tab, 'allowPlugins');
				break;
			case 201:
				this.toggleDocShellPropertyFor(tab, 'allowJavascript');
				break;
			case 202:
				this.toggleDocShellPropertyFor(tab, 'allowMetaRedirects');
				break;
			case 203:
				this.toggleDocShellPropertyFor(tab, 'allowSubframes');
				break;
			case 204:
				this.toggleDocShellPropertyFor(tab, 'allowImages');
				break;

			case 300:
				this.toggleAllTabsLocked();
				break;
			case 301:
				this.toggleReferrerBlockedForAllTabs();
				break;
			case 302:
				this.toggleAllTabsAutoReload();
				break;
		}

		aEvent.preventDefault();
		aEvent.preventBubble();
		aEvent.preventCapture();
		aEvent.stopPropagation();
	},
 
	replaceGroup : function(aGroupInfo) 
	{
		var oldTabsInfo = [];
		var i;

		for (i = 0; i < this.mTabs.length; i++)
			oldTabsInfo.push(this.getTabInfo(this.mTabs[i]));

		var t = this.removeAllTabsButInternal(this.addTab('about:blank'), { preventUndo : true });

		for (i = 0; i < aGroupInfo.length; i++)
		{
			if ('SHEntries' in aGroupInfo[i])
				this.addTabWithTabInfo(aGroupInfo[i]);
			else {
				var referrerURI = 'referrerURI' in aGroupInfo[i] ? data.referrerURI : null ;
				this.addTab(aGroupInfo[i].URI, aGroupInfo[i]);
			}
		}

		if (aGroupInfo.length)
			this.removeTabInternal(t, { preventUndo : true });

		return oldTabsInfo;
	},
 
	setTabTitle : function(aTab) 
	{
		if (!aTab) aTab = this.selectedTab;
		this.__tabextensions__setTabTitle(aTab);
		aTab.setAttribute('crop', aTab.getAttribute('tab-titleCrop'));
	},
  
	// j[ڂ̒ǉ 
	updateContextMenu : function(aTabBrowser)
	{
	try {
		var i;
		var TS = TabbrowserService;
		var mpopup = aTabBrowser.mTabContainer.previousSibling;


		/*
			1: name menuitems
			2: create "removeOther" item if it doesn't exist
			3: name menuseparators
			4: insert/append extra items and separators
		*/


		// 1: name menuitems
		var ds;
		try {
			ds = TS.RDF.GetDataSourceBlocking('chrome://tabextensions/content/tabsContextMenuItems.rdf');
		}
		catch(ex) {
			ds = TS.RDF.GetDataSource('chrome://tabextensions/content/tabsContextMenuItems.rdf');
		}
		if (!ds.GetAllResources().hasMoreElements()) {
			dump('ERROR: tabextensions fails to initialize tab\'s context menu.\n');
			return;
		}

		var label,
			res,
			id,
			namedItems = [];
		for (i = 0; i < mpopup.childNodes.length; i++)
		{
			label = mpopup.childNodes[i].getAttribute('label');
			if (!label) continue;

			res = ds.GetSource(
					TS.RDF.GetResource('http://white.sakura.ne.jp/~piro/rdf#Label'),
					TS.RDF.GetLiteral(label),
					true
				);
			if (!res) continue;

			id = ds.GetTarget(
					res,
					TS.RDF.GetResource('http://white.sakura.ne.jp/~piro/rdf#Id'),
					true
				);
			if (!id) continue;

			id = id.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;

			mpopup.childNodes[i].setAttribute('tabid', 'tab-item-'+id);
			namedItems[id] = mpopup.childNodes[i];
		}

		// 2: create "removeOther" and "bookmarkGroup" item
		if (!('removeOther' in namedItems)) {
			this.insertNewItemBefore(mpopup, 'menuseparator', null, null, ['tabid', 'tab-sep-remove']);
			this.insertNewItemBefore(
				mpopup, 'menuitem',
				'label_removeOther', null,
				[
					'oncommand', 'var b = this.parentNode.mTabBrowser; b.removeAllTabsButInternal(b.mContextTab);',
					'tabid', 'tab-item-removeOther',
					'tbattr', 'tabbrowser-multiple'
				]
			);
		}
		var bookmarkGroup;
		if (!('bookmarkGroup' in namedItems)) {
			bookmarkGroup = this.insertNewItemBefore(
				mpopup, 'menuitem',
				'label_bookmarkGroup', null,
				[
					'oncommand', 'var b = this.parentNode.mTabBrowser; b.bookmarksManager.bookmarkTabGroup(b.mContextTab, !b.tabGroupsAvailable);',
					'tabid',     'tab-item-bookmarkGroup',
					'tbattr',    'tabbrowser-multiple',
					'accesskey', TS.strbundle.GetStringFromName('label_bookmarkGroup_accesskey')
				]
			);
			this.insertNewItemBefore(mpopup, 'menuseparator', null, bookmarkGroup, ['tabid', 'tab-sep-bookmarkGroup']);
		}

		// 3: name menuseparators
		var separators = [
				'removeOther',   'remove',
				'newTab',        'new',
				'bookmarkGroup', 'bookmarkGroup',
				'removeTab',     'removeOneTab',
				'reloadAll',     'reload' // for old context menu
			];
		for (i = 0; i < separators.length; i += 2)
		{
			if (
				!(separators[i] in namedItems) ||
				!namedItems[separators[i]] ||
				!('nextSibling' in namedItems[separators[i]]) ||
				!namedItems[separators[i]].nextSibling ||
				namedItems[separators[i]].nextSibling.localName != 'menuseparator'
				)
				continue;

			namedItems[separators[i]].nextSibling.setAttribute('tabid', 'tab-sep-'+separators[i+1]);
		}

		if (namedItems['removeTab'].nextSibling) {
			// In old versions, Mozilla Firebird doesn't have "Close Other Tabs", so the item is generated and put after the "Close Tab".
			if (namedItems['removeTab'].nextSibling.getAttribute('tabid') == 'tab-item-removeOther')
				this.insertNewItemBefore(mpopup, 'menuseparator', null, namedItems['removeOther'], ['tabid', 'tab-sep-removeOneTab']);
		}
		else if (namedItems['removeOther'].nextSibling.getAttribute('tabid') == 'tab-sep-remove') { // for new context menu of Mozilla Firebird/Firefox (later 2003/8/8)
			// In this version, "Close Other Tabs" is previous to the "Close Tab" (a separator is in between them), and, "Close Other Tabs" is just next to the "Reload All".
			namedItems['removeOther'].nextSibling.setAttribute('tabid', 'tab-sep-removeOneTab');
			this.insertNewItemBefore(mpopup, 'menuseparator', null, namedItems['removeOther'], ['tabid', 'tab-sep-remove']);
		}



		// 4: insert/append extra items and separators

		var ref = mpopup.getElementsByAttribute('tabid', 'tab-sep-reload').length ? mpopup.getElementsByAttribute('tabid', 'tab-item-removeTab')[0] :
				bookmarkGroup ? bookmarkGroup.previousSibling :
				null ;
		if (!ref) {
			this.insertNewItemBefore(mpopup, 'menuseparator', null, null, ['tabid', 'tab-sep-reload']);
		}

		// ^üړ
		// move tab to left/right
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_moveLeft', ref,
			[
				'label-for-horizontal-tabbar', TS.strbundle.GetStringFromName('label_moveLeftHorizontal'),
				'label-for-vertical-tabbar', TS.strbundle.GetStringFromName('label_moveLeftVertical'),
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.moveTabBy(b.mContextTab, -1);',
				'tabid', 'tab-item-moveLeft'
			]
		);
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_moveRight', ref,
			[
				'label-for-horizontal-tabbar', TS.strbundle.GetStringFromName('label_moveRightHorizontal'),
				'label-for-vertical-tabbar', TS.strbundle.GetStringFromName('label_moveRightVertical'),
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.moveTabBy(b.mContextTab, 1);',
				'tabid', 'tab-item-moveRight'
			]
		);

		this.insertNewItemBefore(mpopup, 'menuseparator', null, ref, ['tabid', 'tab-sep-move']);

		// ^u̕
		// duplicate tabs
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_duplicateTab', ref,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.duplicateTab(b.mContextTab);',
				'tabid', 'tab-item-duplicateTab'
			]
		);
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_duplicateTabInWindow', ref,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.duplicateTabInWindow(b.mContextTab);',
				'tabid', 'tab-item-duplicateInWindow'
			]
		);

		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_setFixedLabelFor', ref,
			[
				'oncommand', 'this.parentNode.hidePopup(); var b = this.parentNode.mTabBrowser; b.setFixedLabelFor(b.mContextTab);',
				'tabid', 'tab-item-setFixedLabelFor'
			]
		);

		// ^ǔŒ
		// lock tabs
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_toggleTabLocked', ref,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.toggleTabLocked(b.mContextTab);',
				'type', 'checkbox',
				'tabid', 'tab-item-lockTab'
			]
		);

		// t@̃ubN
		// block referrer from tabs
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_toggleReferrerBlocked', ref,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.toggleReferrerBlocked(b.mContextTab);',
				'type', 'checkbox',
				'tabid', 'tab-item-blockReferrer'
			]
		);

		// [h
		// auto-reload
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_toggleTabAutoReload', ref,
			[
				'oncommand', 'this.parentNode.hidePopup(); var b = this.parentNode.mTabBrowser; b.toggleTabAutoReload(b.mContextTab);',
				'type', 'checkbox',
				'tabid', 'tab-item-autoreload'
			]
		);


		// ̑̋@\
		var advanced = this.insertNewItemBefore(mpopup, 'menu', 'label_allow', ref, ['tabid', 'tab-item-allow']);
		this.insertNewItemBefore(advanced, 'menupopup');
		this.insertNewItemBefore(
			advanced.firstChild, 'menuitem',
			'label_allowPlugins', null,
			[
				'oncommand', 'var b = this.parentNode.parentNode.parentNode.mTabBrowser; b.toggleDocShellPropertyFor(b.mContextTab, \'allowPlugins\');',
				'type', 'checkbox',
				'tabid', 'tab-item-allowPlugins'
			]
		);
		this.insertNewItemBefore(
			advanced.firstChild, 'menuitem',
			'label_allowJavascript', null,
			[
				'oncommand', 'var b = this.parentNode.parentNode.parentNode.mTabBrowser; b.toggleDocShellPropertyFor(b.mContextTab, \'allowJavascript\');',
				'type', 'checkbox',
				'tabid', 'tab-item-allowJavascript'
			]
		);
		this.insertNewItemBefore(
			advanced.firstChild, 'menuitem',
			'label_allowMetaRedirects', null,
			[
				'oncommand', 'var b = this.parentNode.parentNode.parentNode.mTabBrowser; b.toggleDocShellPropertyFor(b.mContextTab, \'allowMetaRedirects\');',
				'type', 'checkbox',
				'tabid', 'tab-item-allowMetaRedirects'
			]
		);
		this.insertNewItemBefore(
			advanced.firstChild, 'menuitem',
			'label_allowSubframes', null,
			[
				'oncommand', 'var b = this.parentNode.parentNode.parentNode.mTabBrowser; b.toggleDocShellPropertyFor(b.mContextTab, \'allowSubframes\');',
				'type', 'checkbox',
				'tabid', 'tab-item-allowSubframes'
			]
		);
		this.insertNewItemBefore(
			advanced.firstChild, 'menuitem',
			'label_allowImages', null,
			[
				'oncommand', 'var b = this.parentNode.parentNode.parentNode.mTabBrowser; b.toggleDocShellPropertyFor(b.mContextTab, \'allowImages\');',
				'type', 'checkbox',
				'tabid', 'tab-item-allowImages'
			]
		);


		this.insertNewItemBefore(mpopup, 'menuseparator', null, ref, ['tabid', 'tab-sep-advanced']);


		// SẴ^uւ̑
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_toggleTabLockedAll', ref,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.toggleAllTabsLocked();',
				'type', 'checkbox',
				'tabid', 'tab-item-lockTabAll'
			]
		);
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_toggleReferrerBlockedAll', ref,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.toggleReferrerBlockedForAllTabs();',
				'type', 'checkbox',
				'tabid', 'tab-item-blockReferrerAll'
			]
		);
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_toggleTabAutoReloadAll', ref,
			[
				'oncommand', 'this.parentNode.hidePopup(); var b = this.parentNode.mTabBrowser; b.toggleAllTabsAutoReload();',
				'type', 'checkbox',
				'tabid', 'tab-item-autoreloadAll'
			]
		);
		this.insertNewItemBefore(mpopup, 'menuseparator', null, ref, ['tabid', 'tab-sep-forAll']);


		// O[v
		// close group of tabs
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_removeTabGroup', mpopup.getElementsByAttribute('tabid', 'tab-item-removeTab')[0].nextSibling,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.removeTabGroup(b.mContextTab);',
				'tbattr', 'tabbrowser-group',
				'tabid', 'tab-item-removeTabGroup'
			]
		);

//		ref = mpopup.lastChild;
		ref = mpopup.getElementsByAttribute('tabid', 'tab-item-removeOther')[0];

		// /E
		// close left/right tabs
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_removeLeft', ref,
			[
				'label-for-horizontal-tabbar', TS.strbundle.GetStringFromName('label_removeLeftHorizontal'),
				'label-for-vertical-tabbar', TS.strbundle.GetStringFromName('label_removeLeftVertical'),
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.removeLeftTabsFrom(b.mContextTab);',
				'tabid', 'tab-item-removeLeft'
			]
		);
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_removeRight', ref,
			[
				'label-for-horizontal-tabbar', TS.strbundle.GetStringFromName('label_removeRightHorizontal'),
				'label-for-vertical-tabbar', TS.strbundle.GetStringFromName('label_removeRightVertical'),
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.removeRightTabsFrom(b.mContextTab);',
				'tabid', 'tab-item-removeRight'
			]
		);

		this.insertNewItemBefore(mpopup, 'menuseparator', null, ref, ['tabid', 'tab-sep-removeLR']);

		// close all tabs
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_removeAll', ref,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.removeAllTabs();',
//				'tbattr', 'tabbrowser-multiple',
				'tabid', 'tab-item-removeAll'
			]
		);
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_removeVisited', ref,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.removeVisitedTabs();',
				'tbattr', 'tabbrowser-multiple',
				'tabid', 'tab-item-removeVisited'
			]
		);

		this.insertNewItemBefore(mpopup, 'menuseparator', null, ref, ['tabid', 'tab-sep-removeAll']);


		ref = ref.nextSibling; // ReLXgj[łnull

		this.insertNewItemBefore(mpopup, 'menuseparator', null, ref, ['tabid', 'tab-sep-undo']);

		// u^uv蒼
		// undo close tab
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_undoRemoveTab', ref,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.undoRemoveTab();',
				'tabid', 'tab-item-undoRemoveTab'
			]
		);


		this.insertNewItemBefore(mpopup, 'menuseparator', null, null, ['tabid', 'tab-sep-group']);

		// ^uׂ̕
		// sort tabs
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_sortTabsByGroup', null,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.sortTabsByGroup();',
				'tabid', 'tab-item-sortTabsByGroup',
				'tbattr', 'tabbrowser-group'
			]
		);

		// O[ṽnCCg\
		// highlight group of tabs
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_highlightGroup', null,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.highlightGroupFromTab(b.mContextTab);',
				'tabid', 'tab-item-highlightGroup',
				'tbattr', 'tabbrowser-group'
			]
		);

		// O[v̐Fݒ
		// set group color
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_setTabColorFor', null,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.mContextTab.setTabColor();',
				'tabid', 'tab-item-setTabColorFor'
			]
		);


		// ubN}[N̕ҏW
		// edit bookmark from tab
		var editRef = bookmarkGroup && bookmarkGroup.nextSibling ? bookmarkGroup.nextSibling : null ;
		this.insertNewItemBefore(mpopup, 'menuseparator', null, editRef, ['tabid', 'tab-sep-bookmark']);
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_editBookmark', editRef,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.editBookmarkFromTab(b.mContextTab);',
				'tabid', 'tab-item-editBookmark'
			]
		);


		this.insertNewItemBefore(mpopup, 'menuseparator', null, null, ['tabid', 'tab-sep-editmenu']);
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_editMenu', null,
			[
				'oncommand', 'this.parentNode.hidePopup(); window.openDialog(\'chrome://tabextensions/content/contextMenuEdit.xul\', \'\', \'chrome,modal,resizable=no\');',
				'tabid', 'tab-item-editMenu'
			]
		);
	}
	catch(ex){
		alert('@TabbrowserBrowserService.updateContextMenu()\n'+ex);
	}
	},
	
	// ڂ̒ǉ 
	insertNewItemBefore : function(aMPopup, aLocalName, aLabelID, aRefNode, aAttrArray)
	{
		var newItem = document.createElementNS(TabbrowserService.XULNS, aLocalName);
		if (aRefNode)
			aMPopup.insertBefore(newItem, aRefNode)
		else
			aMPopup.appendChild(newItem);

		if (aLabelID)
			newItem.setAttribute('label', TabbrowserService.strbundle.GetStringFromName(aLabelID));
		if (aAttrArray)
			for (var i = 0; i < aAttrArray.length; i += 2)
				newItem.setAttribute(aAttrArray[i], aAttrArray[i+1]);

		return newItem;
	},
  
	supportMovableTabs : function(aTabBrowser) 
	{
		// initialize the order of tabs, "new tab" and "close tab" button.
		/* Content of tabs:
			Mozilla 1.1+
				<xul:stack/>
				<xul:hbox flex="1" style="min-width: 1px;">
					<children/> (<xul:tab/>)
					<xul:spacer class="tabs-right" flex="1"/>
				</xul:hbox>
				<xul:stack/>
			Netscape 7.0
				<xul:stack/>
				<children/>
				<xul:stack flex="1"/>
			Mozilla 1.0
				<xul:spacer class="tabs-left"/>
				<children/>
				<xul:stack flex="1"/>
			Phoenix/Firebird/Firefox
				<xul:hbox flex="1" style="min-width: 1px;">
					<children/> (<xul:tab/>)
					<xul:spacer class="tabs-right" flex="1"/>
				</xul:hbox>
				<xul:stack/>

			Mozilla on Mac OS X
				defined in:
				- http://lxr.mozilla.org/mozilla/source/themes/classic/global/mac/globalBindings.xml (Mozilla Suite)
				- http://lxr.mozilla.org/mozilla/source/toolkit/skin/mac/globalBindings.xml (Firefox, old)
				- http://lxr.mozilla.org/mozilla/source/toolkit/themes/pinstripe/global/globalBindings.xml (Firefox)
		*/
try{
		var closeBox = document.getAnonymousElementByAttribute(aTabBrowser.mTabContainer, 'class', 'tabs-closebutton-box');
		var prev;
		while (true)
		{
			anonyElem = document.getAnonymousNodes(closeBox.parentNode);
			if (!anonyElem)
				anonyElem = closeBox.parentNode.childNodes;

			for (i = anonyElem.length-1; i > -1 ; i--)
				if (i != 0 && anonyElem[i] == closeBox) {
					prev = anonyElem[i-1];
					break;
				}
			if (!prev || prev.localName == 'spacer') {
				closeBox = closeBox.parentNode;
				if (closeBox.parentNode == aTabBrowser.mStrip) break;
			}
			else
				break;
		}
		aTabBrowser.mTabContainerInnerBox = prev;
		if (aTabBrowser.mTabContainerInnerBox.localName == 'tab') { // for Mozilla 1.0.x
			aTabBrowser.mTabContainerInnerBox = aTabBrowser.mTabContainer;
			closeBox.setAttribute('buttonpack', 'end');
		}

		var tabContents = aTabBrowser.mTabContainerInnerBox.childNodes;
		var isAfter = false;
		for (i = 0; i < tabContents.length; i++)
		{
			if (tabContents[i].localName == 'tab') {
				isAfter = true;
				continue;
			}

			if (isAfter)
				tabContents[i].setAttribute('tabs-scrollbox-spacer', 'after');
			else
				tabContents[i].setAttribute('tabs-scrollbox-spacer', 'before');

			aTabBrowser.scrollboxSpacers.push(tabContents[i]);
		}
		var tabsRight = document.getAnonymousElementByAttribute(aTabBrowser.mTabContainer, 'class', 'tabs-right');
		if (tabsRight) {
			if (!tabsRight.getAttribute('tabs-scrollbox-spacer'))
				aTabBrowser.scrollboxSpacers.push(tabsRight);
			tabsRight.setAttribute('tabs-scrollbox-spacer', 'after');
		}

		aTabBrowser.mTabContainerInnerBox.setAttribute('tabs-scrollbox', true);
		closeBox.setAttribute('tabs-scrollbox-right', true);
}
catch(e) {
	alert('@TabbrowserBrowserService.supportMovableTabs()\nLaunching Error:\nTabbrowser Extensions failed to find out mTabContainerInnerBox.\n\n'+e);
//	window.close();
}


		var container    = aTabBrowser.mTabContainer;
		var tabs         = container.childNodes;
		// add properties and methods without XBL
		container.mTabBrowser        = aTabBrowser;
		container.advanceSelectedTab = this.advanceSelectedTab;
		if (!('selectNewTab' in container))
			container.selectNewTab = this.selectNewTab;


		// Add methods
		aTabBrowser.getDropPosition = this.getTabDropPosition;

		container.setAttribute('ondraggesture', 'nsDragAndDrop.startDrag(event, this.parentNode.parentNode.parentNode); event.stopPropagation();');
		aTabBrowser.onDragStart = this.onTabDragStart;

		container.setAttribute('ondragexit', 'nsDragAndDrop.dragExit(event, this.parentNode.parentNode.parentNode); event.stopPropagation();');
		aTabBrowser.onDragExit = this.onTabDragExit;

		aTabBrowser.__tabextensions__onDrop = aTabBrowser.onDrop;
		aTabBrowser.onDrop = this.onTabDrop;

		aTabBrowser.__tabextensions__onDragOver = aTabBrowser.onDragOver;
		aTabBrowser.onDragOver = this.onTabDragOver;

		aTabBrowser.__tabextensions__getSupportedFlavours = aTabBrowser.getSupportedFlavours;
		aTabBrowser.getSupportedFlavours = this.getTabsSupportedFlavours;
	},
	
	advanceSelectedTab : function(aDir) 
	{
		var fromContent = (document.commandDispatcher.focusedWindow != window);

		var b        = this.mTabBrowser;
		var startTab = this.selectedItem;
		var tabs     = b.mTabs;

		var nextIndex = startTab.tabIndex+aDir;
		if (nextIndex < 0) nextIndex = tabs.length-1;
		if (nextIndex > tabs.length-1) nextIndex = 0;

		var next = tabs[nextIndex];

		if (next && next != startTab)
			this.selectNewTab(next);

		b.scrollTabbarToTab(next);

		// failsafe
		if (fromContent) _content.focus();
	},
 
	selectNewTab : function(aNewTab) // Firefox 1.1 has this method but 1.0.x doesn't, so I emulate it. 
	{
		var isTabFocused = (document.commandDispatcher.focusedElement == this.selectedItem);

		this.selectedItem = aNewTab;

		if (isTabFocused) {
			aNewTab.focus();
        }
		else if (this.getAttribute('setfocus') != 'false') {
			aNewTab.focus();
			document.commandDispatcher.advanceFocusIntoSubtree(aNewTab);
			this.mTabBrowser.setFocusInternal();
		}
	},
 
	// onDragStart 
	onTabDragStart : function(aEvent, aTransferData, aDragAction)
	{
		this.updateScrollbarFromEvent(aEvent);

		var tab = this.getTabFromChild(aEvent.originalTarget);

		// dragging tabbar
		if (!tab) {
			return;
		}

		this.mDraggedTab = tab;

		var uri   = tab.mBrowser.currentURI.spec;
		var label = tab.getAttribute('tab-nextFixedLabel') || tab.getAttribute('tab-fixedLabel') || tab.label || uri ;

		aTransferData.data = new TransferData();
		aTransferData.data.addDataForFlavour('tabbrowser/tab',
			'order='+tab.tabIndex+'\n'+ // current order of the tab.
			'dragId='+tab.tabId+'\n'+ // browser ID. If tab is dropped to other window, the browser opens new tab.
			'uri='+uri);

		aTransferData.data.addDataForFlavour('text/x-moz-url', uri+'\n'+label);
		aTransferData.data.addDataForFlavour('text/html', '<a href="'+uri+'">'+label+'</a>');
		aTransferData.data.addDataForFlavour('text/unicode', uri);
	},
	
	onTabListDragStart : function(aEvent, aTransferData, aDragAction) 
	{
		var tab = gBrowser.mTabs[aEvent.target.value];
		gBrowser.mDraggedTab = tab;

		var uri = tab.mBrowser.currentURI.spec;

		aTransferData.data = new TransferData();
		aTransferData.data.addDataForFlavour('tabbrowser/tab',
			'order='+tab.tabIndex+'\n'+ // current order of the tab.
			'dragId='+tab.tabId+'\n'+ // browser ID. If tab is dropped to other window, the browser opens new tab.
			'uri='+uri);

		aTransferData.data.addDataForFlavour('text/x-moz-url', uri+'\n'+(tab.getAttribute('tab-nextFixedLabel') || tab.getAttribute('tab-fixedLabel') || tab.label));
		aTransferData.data.addDataForFlavour('text/html', '<a href="'+uri+'">'+tab.label+'</a>');
		aTransferData.data.addDataForFlavour('text/unicode', uri);
	},
  
	// onDrop 
	onTabDrop : function(aEvent, aTransferData, aSession)
	{
		var event;
		if (aTransferData.flavour.contentType == 'text/x-moz-url') {
			event = document.createEvent('Events');
			event.initEvent('XULTabbrowserURIDrop', false, true);
			event.droppedURI = aTransferData.data.split('\n')[0];
			this.dispatchEvent(event);
		}

		if (aTransferData.flavour.contentType != 'tabbrowser/tab') {
			this.__tabextensions__onDrop(aEvent, aTransferData, aSession);
			return;
		}

		var toTab   = aEvent.target,
			fromTab = this.mDraggedTab,
			data    = aTransferData.data.split('\n'),
//			order   = data[0].match(/\d+$/)[0],
			dragId  = data[1].match(/[^=]+$/)[0],
			uri     = data[2].replace(/^uri=/, '');

		// ^ũhbvʒu𒲂ׂ
		// get the dropped position of the tab
		var pos = this.getDropPosition(aEvent);

		var toIndex;
		if (toTab.localName == 'tab') {
			toIndex = toTab.tabIndex;
		}
		else {
			var box = this.mTabs[this.mTabs.length-1].boxObject;
			if (aEvent.screenX >= box.screenX+box.width) {
				toIndex = this.mTabs.length-1;
				pos = this.DROP_AFTER;
			}
			else {
				toIndex = 0;
				pos = this.DROP_BEFORE;
			}
			toTab = this.mTabs[toIndex];
		}


		event = document.createEvent('Events');
		event.initEvent('XULTabbrowserTabDrop', false, true);

		event.tabURI           = uri;
		event.droppedTabId     = dragId;
		event.targetTabId      = toTab.tabId;
		event.droppedPosition  = pos;
		event.droppedPosition  = pos;
		event.droppedSourceURI = null;
		try {
			event.droppedSourceURI = aSession.sourceDocument.documentURI;
		}
		catch(e) {
		}

		event.dragdropShiftKey = aEvent.shiftKey;
		event.dragdropAltKey   = aEvent.altKey;
		event.dragdropMetaKey  = aEvent.metaKey;

		event.dragdropTarget         = aEvent.target;
		event.dragdropOriginalTarget = 'originalTtarget' in aEvent ? aEvent.originalTtarget : null ;

		this.dispatchEvent(event);


		this.mDraggedTab = null;
	},
	
	onTabDropInternal : function(aEvent) 
	{
		var b  = aEvent.target; // tabbrowser
		var TS = TabbrowserService;

		var fromId  = aEvent.droppedTabId,
			fromTab = b.getTabByTabId(fromId),
			toTab   = b.getTabByTabId(aEvent.targetTabId),
			toIndex = toTab.tabIndex,
			uri     = aEvent.tabURI,
			pos     = aEvent.droppedPosition,
			i;


		// When the tab is dragged from another window...
		if (!fromTab) {
			// security check
			if (!uri || !uri.length || uri.indexOf(' ', 0) != -1 ||
				/^\s*(javascript|data):/.test(uri))
				return;

			try {
				TS.uriSecurityCheck(uri, droppedSourceURI);
			}
			catch(e) {
				return;
			}

			// when dropped to an existing tab
			if (pos == b.DROP_ON &&
				toTab.getAttribute('tab-loadingURI') &&
				toTab.getAttribute('tab-loadingURI') != 'about:blank' &&
				aEvent.dragdropTarget.localName == 'tab' &&
				(!b.tabGroupsAvailable || aEvent.dragdropShiftKey)) {
				toTab.mBrowser.loadURI(uri);
				return;
			}

			if (TS.getPref('browser.tabs.extensions.dragdrop.only_load_uri')) { // old implementation
				fromTab = b.addTab(uri);
			}
			else {
				var w = TS.browserWindows;
				var browser, tab;
				for (i in w) // find the window the tab is dragged from
				{
					browser = w[i].TabbrowserService.browser;
					tab     = browser.getTabByTabId(fromId);
					if (tab) break;
				}
				if (tab) {
					var info   = browser.getTabInfo(tab);
					var isLast = (browser.mTabs.length == 1);
					browser.removeTabInternal(tab, { preventUndo : true });
					if (isLast) {
						window.setTimeout(function() {
							Components.lookupMethod(browser.ownerDocument.defaultView, 'top').call(browser.ownerDocument.defaultView).close();
						}, 0);
					}
					fromTab = b.addTabWithTabInfo(info);
				}
				else
					fromTab = b.addTab(uri);
			}

			// if the tab is dropped to the blank tab, remove it
			if (
				pos == b.DROP_ON ||
				b.mTabs.length < 3 // if there was only one tab since the tab was dropped
				) {
				var targetTab = (b.mTabs.length < 3) ? b.mTabs[0] : toTab ;
				if (targetTab.isReallyBlank) {
					b.removeTabInternal(targetTab, { preventUndo : yes });
					if (toTab == targetTab) toTab = null;
				}
			}
		}

		// O[vւ̒ǉ insert to the group
		var isSimpleEdit = TS.getPref('browser.tabs.extensions.group.edit_simple_dragdrop');
		if (toTab &&
			pos == b.DROP_ON &&
			(
				b.tabGroupsAvailable &&
				(
					aEvent.dragdropCtrlKey ||
					aEvent.dragdropMetaKey ||
					(
						!aEvent.dragdropCtrlKey &&
						!aEvent.dragdropMetaKey &&
						isSimpleEdit
					)
				)
			)) {
// If there is 3 tabs A, B(child of A) and C(child of A), and you open new tab D from A, tabextensions appends D to it's group. Then it has three children B, C, and D.
// But, D is not accessible when there is too many tabs. In bookmark groups or links opened from the context menu, D shouldn't be the brother of B and C. For example, if new tabs are shown at the right edge of groups, expected result is following: A, D(child of A), B and C(child of B).
			if (toTab.hasChildTabs() &&
				toTab.shouldPurgeChildren) {
				var children  = toTab.childTabs;
				var newParent = toTab.parentTab || children[0] ;
				for (i = 0; i < children.length; i++)
					b.attachTabTo(children[i], children[i] == newParent ? toTab.parentTab : newParent );

				toTab.shouldPurgeChildren     = false;
				newParent.shouldPurgeChildren = true;
			}

			b.moveTabToGroupEdge(fromTab, toTab);

			fromTab.parentTab = toTab;
		}
		else {
			if (toIndex > fromTab.tabIndex)
				toIndex += (pos < 0 ? -1 : 0 );
			else if (!isSimpleEdit || toIndex < fromTab.tabIndex)
				toIndex += (pos > 0 ? 1 : 0 );

			if (toIndex >= 0 && toIndex < b.mTabs.length)
				b.moveTabTo(fromTab, toIndex);


			// ^uȊȌꏊɃhbvꍇAO[v𔲂
			// if the tab is dropped from groups, detach it from the group.
			if (aEvent.dragdropTarget.localName != 'tab' &&
				fromTab.parentTab &&
				!aEvent.dragdropOriginalTarget
				) {
				fromTab.parentTab = null;

				// q̃^u^ủEɍĔzu
				// move child tabs to right of the tab
				var tabs = fromTab.allChildTabs;
				for (i in tabs)
					b.moveTabTo(tabs[i], fromTab.tabIndex+1);
			}
		}
	},
  
	// onDragOver 
	onTabDragOver : function(aEvent, aFlavour, aSession)
	{
		this.updateScrollbarFromEvent(aEvent);

		this.__tabextensions__onDragOver(aEvent, aFlavour, aSession);

		var XferDataSet = nsTransferable.get(
				this.getSupportedFlavours(),
				nsDragAndDrop.getDragData,
				true
			);
		var XferData = XferDataSet.first.first;
		if (XferData.flavour.contentType != 'tabbrowser/tab') return;


		// auto scroll
		if (this.mScrollbar) {
			var wait = 80,
				clientPos,
				maxPos;
			if (this.mTabBox.orient == 'horizontal') { // left or right
				clientPos = aEvent.clientY;
				maxPos    = this.mTabContainerInnerBox.boxObject.height;
			}
			else { // top or bottom
				clientPos = aEvent.clientX;
				maxPos    = this.mTabContainerInnerBox.boxObject.width;
			}
			if (clientPos > 0 && clientPos < 40) {
				if (clientPos < 10)
					wait = 10;
				else if (clientPos < 25)
					wait = 40;
				this.scrollTabbarBy(-10, wait);
			}
			else if (clientPos > maxPos-40 && clientPos < maxPos) {
				if (clientPos > maxPos-10)
					wait = 10;
				else if (clientPos > maxPos-25)
					wait = 40;
				this.scrollTabbarBy(10, wait);
			}
		}


		this.mCurrentDragOverTab = (aEvent.target.localName == 'tab') ? aEvent.target : null ;
		if (!this.mCurrentDragOverTab) return;

		var tab = this.mCurrentDragOverTab;


		// hbOJn^ȕł͕\ςȂ
		// Ignore the tab dragged from.
		if (this.mDraggedTab == aEvent.target) {
			tab.removeAttribute('dragover-at');
			return;
		}


		// rightleft̔
		// Which is the position the tab dropped, left or right?
		var pos = this.getDropPosition(aEvent);
//		dump('drop position: '+pos+'\n');
		if (pos == this.DROP_BEFORE) {
			tab.setAttribute('dragover-at', 'before');
		}
		else if (pos == this.DROP_AFTER) {
			tab.setAttribute('dragover-at', 'after');
		}
		else {
			if (this.mDraggedTab &&
				!this.canAttachTabTo(this.mDraggedTab, tab)) {
				aSession.canDrop = false;
			}

			tab.setAttribute('dragover-at', 'this');
		}
	},
 
	getTabDropPosition : function(aEvent) 
	{
		var isSimpleEdit = false;
		try {
			isSimpleEdit = this.mPrefs.getBoolPref('browser.tabs.extensions.group.edit_simple_dragdrop');
		}
		catch(e) {
		}

		var box = aEvent.target.boxObject.QueryInterface(Components.interfaces.nsIBoxObject);
		var regionCount = (
					this.tabGroupsAvailable &&
					(
						aEvent.ctrlKey ||
						aEvent.metaKey ||
						(
							!aEvent.ctrlKey &&
							!aEvent.metaKey &&
							isSimpleEdit
						)
					)
				) ? 3 : 2 ;
		// This is a number of position. "2" is "Left/Right", "3" is "Left/Middle/Right".

		var side = this.mTabBox.orient == 'horizontal'; // left or right
		var measure          = ((side ? box.height : box.width) / regionCount),
			coordValue       = (side ? box.y : box.x ),
			clientCoordValue = (side ? aEvent.clientY : aEvent.clientX );

		if (this.mScrollbar) // see "updateScrollbarFromEvent" in tabextensions.xml
			coordValue -= Number(this.mScrollbar.getAttribute('curpos'));

		if (clientCoordValue < (coordValue + measure))
			return this.DROP_BEFORE;
		else if (!this.tabGroupsAvailable ||
				clientCoordValue >= (coordValue + (regionCount-1)*measure))
			return this.DROP_AFTER;
		else
			return this.DROP_ON;
	},
 
	// onDragExit 
	onTabDragExit : function(aEvent, aSession)
	{
		if (this.mCurrentDragOverTab)
			this.mCurrentDragOverTab.removeAttribute('dragover-at');
	},
 
	// Supported Flavours 
	getTabsSupportedFlavours : function()
	{
		var flavours = this.__tabextensions__getSupportedFlavours();

		var flavour;

		flavour = new Flavour('tabbrowser/tab');
		flavours.flavours.unshift(flavour);
		flavours.flavourTable[flavour.contentType] = flavour;

		return flavours;
	},
  
	// tabs̃Abvf[g 
	updateTabContainer : function(aTabBrowser)
	{
		if (!('mTabBrowser' in aTabBrowser.mTabContainer.mTabBrowser) ||
			!aTabBrowser.mTabContainer.mTabBrowser)
			aTabBrowser.mTabContainer.mTabBrowser = aTabBrowser;

		// Behavior of tabs with middle-click or double click
		aTabBrowser.onTabClick = this.onTabClick;
		aTabBrowser.mTabContainer.setAttribute('onclick', 'this.parentNode.parentNode.parentNode.onTabClick(event);');
		aTabBrowser.mTabContainer.setAttribute('ondblclick', 'this.parentNode.parentNode.parentNode.onTabClick(event);');

		// when there is no tab bar and the current is blank (after close all of tabs), actions on content area are regarded as onthe tab bar.
		aTabBrowser.addEventListener('click', this.emulateTabbarClick, true);
		aTabBrowser.addEventListener('dblclick', this.emulateTabbarClick, true);
	},
	
	emulateTabbarClick : function(aEvent) 
	{
		if (aEvent.originalTarget.ownerDocument == aEvent.target.ownerDocument ||
			!aEvent.target.isBlank)
			return;

		aEvent.target.onTabClick(aEvent);

/*
		aEvent.stopPropagation();
		aEvent.preventCapture();
		aEvent.preventBubble();
		aEvent.preventDefault();
*/
	},
   
	destroyTabBrowser : function() 
	{
		var b = TabbrowserService.browser;
		if (!b) return;

		// remove event listeners
		b.endHookingContentAreaEvents();

		b.removeEventListener('DOMWindowClose', b.onWindowCloseInLastTabEventListener, true);

		b.removeEventListener('close', this.onTabbrowserWindowClose, true);
		b.removeEventListener('unload', this.onTabbrowserWindowUnload, true);

		b.removeEventListener('XULTabbrowserTabLoading', this.onXULTabbrowserTabLoading, false);
		b.removeEventListener('XULTabbrowserTabLoad', this.onXULTabbrowserTabLoad, false);
		b.removeEventListener('XULTabbrowserTabStatusChange', this.onXULTabbrowserTabStatusChange, false);
		b.removeEventListener('XULTabbrowserTabDrop', this.onXULTabbrowserTabDrop, false);
		b.removeEventListener('XULTabbrowserURIDrop', this.onXULTabbrowserURIDrop, false);
		b.removeEventListener('XULTabbrowserAddTabCanceled', this.onXULTabbrowserAddTabCanceled, false);

		b.removeEventListener('click', this.emulateTabbarClick, true);
		b.removeEventListener('dblclick', this.emulateTabbarClick, true);


		b.bookmarksManager = null;


		var browser;
		for (var i = 0; i < b.mTabs.length; i++)
		{
			try {
				browser = b.mTabs[i].mBrowser;

				browser.stop();
				b.mTabProgressListenerCreatorInternal.removeListenerFrom(b.mTabs[i]);
				browser.contentDocument.defaultView.close = function() {};

				// do destroying steps which aren't done by the destructor of "tabbrowser.xml"
				browser.setAttribute('type', 'content');
				if ('destroy' in browser) browser.destroy();
			}
			catch(e) {
				if (TabbrowserService.debug) dump('Error: Tabbrowser Extensions fails to destroy tabbrowser\n'+e+'\n');
			}
		}

		b.mIdentifiedTabs     = null;
		b.mRemovedTabInfoList = null;
	},
 
	// utils 
	
	findParentNodeByProp : function(aNode, aProp, aType) 
	{
		do {
			if (aProp in aNode && typeof aNode[aProp] == aType)
				return aNode;

			aNode = aNode.parentNode;
		}
		while(aNode && aNode.ownerDocument && aNode != aNode.ownerDocument.documentElement);

		return null;
	},
 
	findParentNodeByNameOrProp : function(aNode, aName, aProp, aType) 
	{
		if (!aName && !aProp) return null;

		do {
			if (
				(aName && aNode.localName && aNode.localName.toLowerCase() == aName.toLowerCase()) ||
				(aProp && aProp in aNode && typeof aNode[aProp] == aType)
				)
				return aNode;

			aNode = aNode.parentNode;
		}
		while(aNode && aNode.ownerDocument && aNode != aNode.ownerDocument.documentElement);

		return null;
	},
  
	observe : function(aSubject, aTopic, aData) 
	{
		if (aTopic != 'StartDocumentLoad')
			return;

		if (
			!gBrowser.selectedTab.getAttribute('tab-loadingURI') ||
			gBrowser.selectedTab.getAttribute('tab-loadingURI') == 'about:blank' ||
			gBrowser.mTabs.length > 1 ||
			gBrowser.getStripVisibility() ||
			gBrowser.mPrefs.getBoolPref('browser.tabs.autoHide')
			)
			return;

		gBrowser.selectedTab.mBrowser.removeAttribute('autoscroll');
		gBrowser.setStripVisibilityTo(true);
	},
 
	DOMWindowOpenObserver : { 
	
		WindowManager : Components.classes['@mozilla.org/appshell/window-mediator;1'].getService(Components.interfaces.nsIWindowMediator), 
		DOMWindow : Components.interfaces.nsIDOMWindow,
		target : null,
 
		get browserWindow() 
		{
			var targets = this.WindowManager.getEnumerator('navigator:browser'),
				target;
			while (targets.hasMoreElements())
			{
				target = targets.getNext().QueryInterface(this.DOMWindow);
				if (target != this.target)
					return target;
			}
			return null;
		},
 
		observe : function(aSubject, aTopic, aData) 
		{
	//			dump('tabextensions : on'+aTopic+'\n');
			if (aTopic != 'domwindowopened')
				return;

			this.onObserve(aSubject, this);
		},
 
		onObserve : function(aSubject, aThis) 
		{
			var win = aThis.target = aSubject;
			var nav = aThis.browserWindow;

			// if there is no navigator window, do nothing.
			if (!nav) return;

			var TS  = nav.TabbrowserService;
			var uri;
			try {
				uri = win.location.href;
			}
			catch(e) {
				uri = 'about:blank';
				if (TS.debug) dump('gTSDOMWindowOpenObserver.onObserve():: '+e+'\n');
				return;
			}

			if (!uri) {
				nav.setTimeout(aThis.onObserve, 0, win, aThis);
				return;
			}

			if (uri != TS.browserURI) // this is not browser
				return;

			 // if the window has been reopened by another thread, end this.)
			if (win.gTSWindowOpenerType) return;


			// not yet initialized
			var dialog = TS.WindowManager.getMostRecentWindow('tabextensions:loadPresetPrefs');
			if (dialog) {
				dialog.TabbrowserService.closeWindow(win, dialog);
				dialog.focus();
				return;
			}


			win.gTSWindowOpenerType = (win.opener) ? 'XULWindow' :
							(
								!('arguments' in win) &&
								!('__tabextensions__opener' in win) &&
								(TS.winHookMode || TS.opentabforJS)
							) ? 'ContentWindow' :
							'PlatformNative' ;


			// ignore "reopen new windows as new tabs" behavior if this window is loaded into a frame, like the DOM Inspector's browser.
			if (win != Components.lookupMethod(win, 'top').call(win)) return;
			var docShell = win.QueryInterface(Components.interfaces.nsIInterfaceRequestor)
					.getInterface(Components.interfaces.nsIWebNavigation)
					.QueryInterface(Components.interfaces.nsIDocShellTreeItem);
			if (docShell.parent) return;
	/*
			var baseWindow = docShell.treeOwner
					.QueryInterface(Components.interfaces.nsIInterfaceRequestor)
					.getInterface(Components.interfaces.nsIXULWindow)
					.QueryInterface(Components.interfaces.nsIBaseWindow);
	*/

			if (
				(
					win.gTSWindowOpenerType == 'PlatformNative' &&
					(
						TS.winHookMode == 1 ||
						TS.platformNativeBehavior == 1 ||
						TS.platformNativeBehavior == 2
					)
				) ||
				(TS.winHookMode == 2 && win.gTSWindowOpenerType != 'ContentWindow')
				) {
				if (
					(
						TS.winHookMode == 2 &&
						win.gTSWindowOpenerType == 'XULWindow' &&
						uri.match(/^(chrome:\/\/navigator\/content\/(navigator.xul)?|chrome:\/\/browser\/content\/(browser.xul)?)$/)
					) ||
					(
						win.gTSWindowOpenerType == 'PlatformNative' &&
						(
							TS.winHookMode == 2 ||
							(
								(
									TS.winHookMode == 1 ||
									TS.platformNativeBehavior == 0 ||
									TS.platformNativeBehavior == 2
								) &&
								(
									!TS.getPref('browser.tabs.extensions.platform_native.allow_window_for_homepage') ||
									!TS.isDefaultStartup(win) ||
									(!('arguments' in win ) || win.arguments.length != 1)
								)
							)
						)
					)
					) {
	if (TS.debug) dump('TABEXTENSIONS: window is opened with not the home page\n');
					TS.hideWindow(win);
					TS.openTabInsteadSelfInternal(win, TS);
				}
			}
			else if ( // window.open̎sɐɎsꍇ̃tFCZ[t
				win.gTSWindowOpenerType == 'ContentWindow' &&
				(TS.winHookMode || TS.opentabforJS)
				) {
	if (TS.debug) dump('TABEXTENSIONS: window is opened by "target" links or JavaScript in webpages\n');
				TS.hideWindow(win);
				win.gTSWindowShouldBeDestructed = true;
				win.gTSOpenTabTimer = win.setTimeout(TS.openTabInsteadSelfInternal, 100, win, TS);
			}
			else if (win.gTSWindowOpenerType == 'PlatformNative') {
	if (TS.debug) dump('TABEXTENSIONS: window is opened by platform native\n');
				TS.hideWindow(win);
				TS.checkWindowShouldBeOpenedForSameURI(win);
			}
		}
 
	} 
  
}; 
  
// pref listeners 
	
// browser 
	
var gTSTabMenuPrefListener = 
{
	domain  : 'browser.tabs.extensions.tab_menu.show',
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (aTopic != 'nsPref:changed') return;

		var menu = document.getElementById('tabMenu');
		if (menu) {
			if (!TabbrowserService.getPref(this.domain))
				menu.setAttribute('hidden', true);
			else
				menu.removeAttribute('hidden');
		}
	}
};
 
var gTSPlatformNativeBehaviorPrefListener = 
{
	domains : [
		'browser.tabs.extensions.platform_native.behavior',
		'advanced.system.supportDDEExec'
	],
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (aTopic != 'nsPref:changed') return;

		var TS = TabbrowserService;

		var value = TS.getPref('browser.tabs.extensions.platform_native.behavior');
		if (aPrefName == 'browser.tabs.extensions.platform_native.behavior') {
			gTWindowModePrefListener.observe(null, 'nsPref:changed', 'browser.tabs.extensions.platform_native.behavior');

			var nsIBrowserDOMWindow = 'nsIBrowserDOMWindow' in Components.interfaces ? Components.interfaces.nsIBrowserDOMWindow : 'nsIBrowserWindow' in Components.interfaces ? Components.interfaces.nsIBrowserWindow : null ;
			if (nsIBrowserDOMWindow) {
				switch (value)
				{
					case 1:
						TS.setPref('browser.link.open_external', nsIBrowserDOMWindow.OPEN_CURRENTWINDOW);
						break;
					case 2:
						TS.setPref('browser.link.open_external', nsIBrowserDOMWindow.OPEN_NEWTAB);
						break;
					case 3:
						TS.setPref('browser.link.open_external', nsIBrowserDOMWindow.OPEN_NEWWINDOW);
						break;
					default:
						break;
				}
			}
		}

		if (navigator.platform == 'Win32') {
			if (value > 1) {
				var DDE = TS.getPref('advanced.system.supportDDEExec');
				if (DDE !== null && DDE)
					TS.setPref('advanced.system.supportDDEExec', false);
			}
			else {
				// if I wish to disable DDE but don't wish to load pages in a tab...
				if (
					aPrefName == 'advanced.system.supportDDEExec' &&
					TS.getPref('advanced.system.supportDDEExec')
					)
					return;

				if (value == 1)
					TS.setPref('advanced.system.supportDDEExec', true);
			}
			return;
		}
		else if ('@mozilla.org/browser/xremoteservice;1' in Components.classes &&
				Components.classes['@mozilla.org/browser/xremoteservice;1']) { // Linux or others
			this.registerRemoteService(value < 4);
			return;
		}
	},
	remoteServiceRegistered : true,
	registerRemoteService : function(aRegister)
	{
		try {
			const remoteService = Components.classes['@mozilla.org/browser/xremoteservice;1'].getService(Components.interfaces.nsIXRemoteService);
			if (aRegister) {
				if (!this.remoteServiceRegistered)
					remoteService.addBrowserInstance(window);
				this.remoteServiceRegistered = true;
			}
			else {
				if (this.remoteServiceRegistered)
					remoteService.removeBrowserInstance(window);
				this.remoteServiceRegistered = false;
			}
		}
		catch(e) {
		}
	}
};
 
var gTWindowModePrefListener = 
{
	domain  : 'browser.tabs.extensions.window_hook_mode',
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (aTopic != 'nsPref:changed') return;

		var TS = TabbrowserService;
		var nsIBrowserDOMWindow = 'nsIBrowserDOMWindow' in Components.interfaces ? Components.interfaces.nsIBrowserDOMWindow : 'nsIBrowserWindow' in Components.interfaces ? Components.interfaces.nsIBrowserWindow : null ;

		// override prefs of native tabbed browsing
		var openExternal = TS.getPref('browser.link.open_external');
		var openWindow   = TS.getPref('browser.link.open_newwindow');
		if (nsIBrowserDOMWindow && TS.winHookMode == 2) {
			if (openExternal != null && nsIBrowserDOMWindow &&
				openExternal != nsIBrowserDOMWindow.OPEN_CURRENTWINDOW &&
				openExternal != nsIBrowserDOMWindow.OPEN_NEWTAB)
				TS.setPref('browser.link.open_external', nsIBrowserDOMWindow.OPEN_NEWTAB);

			if (openWindow !== null && nsIBrowserDOMWindow &&
				openWindow != nsIBrowserDOMWindow.OPEN_CURRENTWINDOW &&
				openWindow != nsIBrowserDOMWindow.OPEN_NEWTAB) {
				TS.setPref('browser.link.open_newwindow', nsIBrowserDOMWindow.OPEN_NEWTAB);
				TS.setPref('browser.link.open_newwindow.ui', nsIBrowserDOMWindow.OPEN_NEWTAB);
			}
		}
		else if (nsIBrowserDOMWindow) {
			var behavior = TS.getPref('browser.tabs.extensions.platform_native.behavior');
			if (openExternal !== null && nsIBrowserDOMWindow &&
				openExternal != nsIBrowserDOMWindow.OPEN_DEFAULTWINDOW &&
				openExternal != nsIBrowserDOMWindow.OPEN_NEWWINDOW)
				TS.setPref('browser.link.open_external', behavior == 3 ? nsIBrowserDOMWindow.OPEN_NEWWINDOW : behavior == 2 ? nsIBrowserDOMWindow.OPEN_NEWTAB : nsIBrowserDOMWindow.OPEN_CURRENTWINDOW );

			if (openWindow != null && nsIBrowserDOMWindow &&
				openExternal != nsIBrowserDOMWindow.OPEN_DEFAULTWINDOW &&
				openExternal != nsIBrowserDOMWindow.OPEN_NEWWINDOW) {
				TS.setPref(
					'browser.link.open_newwindow',
					(
						TS.getPref('browser.tabs.opentabfor.windowopen') &&
						(
							TS.getPref('browser.tabs.opentabfor.links.behavior') > 0 ||
							TS.getPref('browser.tabs.opentabfor.links.targetBehavior') > 0
						)
					) ? nsIBrowserDOMWindow.OPEN_NEWTAB : nsIBrowserDOMWindow.OPEN_NEWWINDOW
				);
				TS.setPref('browser.link.open_newwindow.ui', nsIBrowserDOMWindow.OPEN_NEWTAB);
			}
		}

		if (!TS.winHookMode &&
			!TS.opentabforJS &&
			gTSWindowOpenerType == 'ContentWindow')
			gTSWindowOpenerType = 'PlatformNative'; // reset opener type to use this window for reopen new windows opened from webpages in this window.

		if (window.location.href != TS.browserURI) return;

		var i;
		var isSingleWindow = TS.winHookMode == 2 ? true : false ;

		var items = [
				document.getElementById('menu_newNavigator'),
				document.getElementsByAttribute('oncommand', 'gContextMenu.openFrame();')[0],
				document.getElementById('cmd_newNavigator')
			];

		// Firefox
		if (TS.isNewTypeBrowser) {
			var nodes = document.getElementsByAttribute('command', 'cmd_newNavigator');
			for (i = 0; i < nodes.length; i++)
				if (nodes[i].localName == 'menuitem')
					items.push(nodes[i]);
		}

		for (i in items)
			if (items[i]) {
				if (isSingleWindow) {
					items[i].setAttribute('hidden', true);
					items[i].setAttribute('disabled', true);
				}
				else {
					items[i].removeAttribute('hidden');
					items[i].removeAttribute('disabled');
				}
			}
	}
};
 
var gTSOpenTabForWindowOpenPrefListener = 
{
	domains : [
		'browser.tabs.opentabfor.windowopen',
		'browser.tabs.opentabfor.links.behavior',
		'browser.tabs.opentabfor.links.targetBehavior'
	],
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (aTopic != 'nsPref:changed') return;

		var TS = TabbrowserService;
		if (!aPrefName || aPrefName == 'browser.tabs.opentabfor.windowopen') {
			if (!TS.winHookMode &&
				!TS.opentabforJS &&
				gTSWindowOpenerType == 'ContentWindow')
				gTSWindowOpenerType = 'PlatformNative'; // reset opener type to use this window for reopen new windows opened from webpages in this window.
		}

		this.updateNativeSingleWindowPref();
	},
	updateNativeSingleWindowPref : function()
	{
		var TS = TabbrowserService;
		var nsIBrowserDOMWindow = 'nsIBrowserDOMWindow' in Components.interfaces ? Components.interfaces.nsIBrowserDOMWindow : 'nsIBrowserWindow' in Components.interfaces ? Components.interfaces.nsIBrowserWindow : null ;

		// override prefs of native tabbed browsing
		var openWindow = TS.getPref('browser.link.open_newwindow');
		if (openWindow !== null && nsIBrowserDOMWindow) {
			if (
				TS.winHookMode == 2 ||
				(
					TS.getPref('browser.tabs.opentabfor.windowopen') &&
					(
						TS.getPref('browser.tabs.opentabfor.links.behavior') > 0 ||
						TS.getPref('browser.tabs.opentabfor.links.targetBehavior') > 0
					)
				)
				) {
				TS.setPref('browser.link.open_newwindow', nsIBrowserDOMWindow.OPEN_NEWTAB);
				TS.setPref('browser.link.open_newwindow.ui', nsIBrowserDOMWindow.OPEN_NEWTAB);
			}
			else if (
				TS.winHookMode < 2 &&
				!TS.getPref('browser.tabs.opentabfor.windowopen') &&
				TS.getPref('browser.tabs.opentabfor.links.behavior') < 1 &&
				TS.getPref('browser.tabs.opentabfor.links.targetBehavior') < 1
				) {
				TS.setPref('browser.link.open_newwindow', nsIBrowserDOMWindow.OPEN_NEWWINDOW);
				TS.setPref('browser.link.open_newwindow.ui', nsIBrowserDOMWindow.OPEN_NEWTAB);
			}
		}

		if (!TS.getPref('browser.tabs.extensions.updateNativeSingleWindowPref.done'))
			TS.setPref('browser.tabs.extensions.updateNativeSingleWindowPref.done', true);
	}
};
  
// <tabbrowser> widget 
	
var gTSCloseBoxPrefListener = 
{
	domain  : 'browser.tabs.extensions.show_closebox',
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (aTopic != 'nsPref:changed' ||
			!('TabbrowserService' in window)) return;

		var value = TabbrowserService.getPref(aPrefName);
		var b = TabbrowserService.browser;

		switch (aPrefName)
		{
			case 'browser.tabs.extensions.show_closebox.tabbar':
				b.setAttribute('tabbrowser-tabbar-closebox-hidden', !value);
				break;

			case 'browser.tabs.extensions.show_closebox.tab':
				switch (value)
				{
					case -1:
					default:
						value = 'never';
						break;
					case 0:
						value = 'any';
						break;
					case 1:
						value = 'current';
						break;
					case 2:
						value = 'pointed';
						break;
				}
				b.setAttribute('tabbrowser-tab-closebox', value);
				break;

			case 'browser.tabs.extensions.show_closebox.tab.appearance':
				b.setAttribute('tabbrowser-tab-closebox-style', value);
				break;

			default:
				break;
		}
	}
};
 
var gTSIconOverlayInTabsPrefListener = 
{
	domain  : 'browser.tabs.extensions.overlay_icon',
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (aTopic != 'nsPref:changed') return;

		var shouldOverlay = TabbrowserService.getPref(this.domain);
		var b = TabbrowserService.browser;
		for (i = 0; i < b.mTabs.length; i++)
			b.mTabs[i].setAttribute('overlay-icon', shouldOverlay);
	}
};
 
var gTSTabsWidthPrefListener = 
{
	domains : [
		'browser.tabs.extensions.tabs_width_type',
		'browser.tabs.extensions.tabs_width',
		'browser.tabs.extensions.tabs_min_width',
		'browser.tabs.extensions.tabs_max_width',
		'browser.tabs.extensions.tabs_title_crop'
	],
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (aTopic != 'nsPref:changed') return;

		var b = TabbrowserService.browser;
		for (var i = 0; i < b.mTabs.length; i++)
			b.mTabs[i].initTab();

		b.onTabsModified();
	}
};
 
var gTSTabbarBlankSpacePrefListener = 
{
	domain  : 'browser.tabs.extensions.show_blankspaces',
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (aTopic != 'nsPref:changed') return;

		TabbrowserService.browser.setAttribute('makeblankspace', TabbrowserService.getPref(this.domain));
	}
};
 
var gTSLastTabClosingPrefListener = 
{
	domain  : 'browser.tabs.extensions.last_tab_closing',
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (aTopic != 'nsPref:changed') return;

		if (TabbrowserService.getPref(this.domain) != 2) {
			TabbrowserService.setPref('browser.tabs.autoHide', false);
			TabbrowserService.setPref('browser.tabs.forceHide', false);
		}

		TabbrowserService.browser.setStripVisibilityTo(!TabbrowserService.getPref('browser.tabs.autoHide'));
	}
};
 
var gTSTabsAutoHidePrefListener = 
{
	domain  : 'browser.tabs.autoHide',
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (
			aTopic != 'nsPref:changed' ||
			!TabbrowserService.getPref(this.domain) ||
			TabbrowserService.getPref('browser.tabs.autoHide.temporaryChanged') // when this is temporary change, ignore.
			)
			return;

		// disable the feature automatically
		TabbrowserService.setPref('browser.tabs.extensions.last_tab_closing', 2);

		var b = TabbrowserService.browser;
		b.setStripVisibilityTo(b.mTabs.length > 1);
	}
};
 
var gTSTabbarPlacePrefListener = 
{
	domain  : 'browser.tabs.extensions.tabbar_place',
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (aTopic != 'nsPref:changed') return;

		this.update(TabbrowserService.getPref(this.domain) > -1);
	},
	update : function(aPreventToUpdateNow)
	{
		var TS = TabbrowserService;

		var place = TS.getPref(this.domain);
		var b     = TS.browser;

		if (place > -1 && b.hasAttribute('tabbrowser-tabbar-hidden'))
			b.removeAttribute('tabbrowser-tabbar-hidden');

		if (
			(place == 0 && b.mStrip.getAttribute('class').match(/tabbrowser-strip-top/)) ||
			(place == 1 && b.mStrip.getAttribute('class').match(/tabbrowser-strip-bottom/)) ||
			(place == 2 && b.mStrip.getAttribute('class').match(/tabbrowser-strip-left/)) ||
			(place == 3 && b.mStrip.getAttribute('class').match(/tabbrowser-strip-right/))
			)
			return;

		if (aPreventToUpdateNow) {
			if (TS.PromptService.confirm(
					window,
					TS.strbundle.GetStringFromName('message_alert_tabbar_place_title'),
					TS.strbundle.GetStringFromName('message_alert_tabbar_place')
				))
				window.openDialog('chrome://tabextensions/content/browserRestarter.xul', '_blank', 'chrome,all,dialog');
			return;
		}

		if (place > 1) {
			if(TS.getPref('browser.tabs.extensions.tabs_width_type') != 2)
				TS.setPref('browser.tabs.extensions.tabs_width_type', 2);

			if(TS.getPref('browser.tabs.extensions.tab_scroller') == 3)
				TS.setPref('browser.tabs.extensions.tab_scroller', 0);
		}

		b.updateTabbarPlace();

		var attr = place < 2 ? 'label-for-horizontal-tabbar' : 'label-for-vertical-tabbar' ;
		var nodes = document.getElementsByAttribute(attr, '*');
		for (var i = 0; i < nodes.length; i++)
			nodes[i].setAttribute('label', nodes[i].getAttribute(attr));
	}
};
 
// ^u̐eq֌W𖕏 
// clear the relation of tabs when the TabGroup Mode is disabled
var gTSGroupModePrefListener =
{
	domain  : 'browser.tabs.extensions.group.enabled',
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (aTopic != 'nsPref:changed' ||
			TabbrowserService.getPref(this.domain)) return;

		var b = TabbrowserService.browser;
		for (i = 0; i < b.mTabs.length; i++)
		{
			b.mTabs[i].parentTab = null;
			b.mTabs[i].removeAttribute('tab-childTabs');
			b.mTabs[i].removeAttribute('tab-openedAutomatically');
			b.mTabs[i].removeAttribute('tab-groupTargetHost');
		}
	}
};
 
var gTSTabScrollerPrefListener = 
{
	domain  : 'browser.tabs.extensions.tab_scroller',
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (aTopic != 'nsPref:changed') return;

		var TS = TabbrowserService;

		var value = TS.getPref(this.domain);
		switch (value)
		{
			default:
			case 0:
				value = 'button';
				break;

			case 4:
				value = 'buttonalways';
				break;

			case 1:
				value = 'scrollbar';
				break;

			case 2:
				value = 'scrollbaralways';
				break;

			case 3:
				value = 'multirow';

				if (TS.getPref('browser.tabs.extensions.tabbar_place') > 1)
					TS.setPref('browser.tabs.extensions.tabbar_place', 0);
//				if (TS.getPref('browser.tabs.extensions.tabs_width_type') == 0)
//					TS.setPref('browser.tabs.extensions.tabs_width_type', 2);
				break;

			case -1:
				value = 'never';
				break;
		}
		TS.browser.setAttribute('tab-scrollbar', value);
	}
};
 
var gTSAnotherBindingPrefListener = 
{
	domain  : 'browser.tabs.extensions.use_another_binding',
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (aTopic != 'nsPref:changed') return;

		if (TabbrowserService.getPref(this.domain))
			document.documentElement.setAttribute('tabextensions-another-binding', 'true');
		else
			document.documentElement.removeAttribute('tabextensions-another-binding');
	}
};
  
// initializing: failsafe 
if (
	window == Components.lookupMethod(window, 'top').call(window) &&
	!gTSWindowOpenerType &&
	TabbrowserService.isBrowserWindow
	)
	TabbrowserBrowserService.DOMWindowOpenObserver.observe(window, 'domwindowopened', null);

if (TabbrowserService.isNewTypeBrowser) {
	// Firefox cannot add event listener in "TabbrowserService.init()", so do it in this point.
	window.addEventListener('close', function(aEvent)
	{
		TabbrowserBrowserService.onWindowClose(aEvent);
	},
	false);
}
  
// end of definition 

if (!window.TabbrowserServiceModules)
	window.TabbrowserServiceModules = [];

TabbrowserServiceModules.push(TabbrowserBrowserService);
}
 