C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
               SUBROUTINE CPUSYR
C              *****************
C
     * ( TCPU )
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C
C FONCTION : 
C --------
C           CALCUL DU TEMPS CPU RESTANT EN SECONDE
C
C Pour info, sur station
C        TT(1) = user time 
C        TT(2) = system time
C        TT(3) = user time, children
C        TT(4) = system time, children
C_______________________________________________________________________
C
C               (*)   (*)     ARGUMENTS
C   .________.______.____._____________________________________________.
C   !  NOM   ! TYPE !MODE!                  ROLE                       !
C   !________!______!____!_____________________________________________!
C   ! TREST  !  R   ! R  ! TEMPS CPU RESTANT                           !
C   !________!______!____!_____________________________________________!
C   ! COMMONS                                                          !
C   !__________________________________________________________________!
C   !/PORTAG/!      ! D  !                                             !
C   !/TEMPAC/!      ! D  ! CF DETAILS DANS LE SOUS PROGRAMME LECDON    !
C   !________!____  !____!_____________________________________________!
C
C     TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C            L (LOGIQUE)   .. ET TYPES COMPOSES (EX : TR TABLEAU REEL)
C     MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (AUXILIAIRE MODIFIE)
C
C-----------------------------------------------------------------------
C   SOUS PROGRAMME(S) APPELE(S)   :   TREMAIN (SUR CRAY)
C                                  OU
C                                    DGETCP (programme C) (SUR STATION)
C                                   
C-----------------------------------------------------------------------
C   SOUS PROGRAMME(S) APPELANT(S) : 
C
C**********************************************************************
C
      IMPLICIT NONE
C
C**********************************************************************
C     DONNEES EN COMMON
C**********************************************************************
C
C***********************************************************************
C
C... Variables externes
      DOUBLE PRECISION TCPU
C
C... Variables externes
      LOGICAL LPAS
      DOUBLE PRECISION CPUDEB,S
      DOUBLE PRECISION TT(4)
C
C************************************************************************
C
      SAVE LPAS,CPUDEB
      DATA LPAS / .TRUE. /
      DATA CPUDEB / 0. /
C
C     ================
C     0 - VERSION CRAY
C     ================
C
#ifdef CRAY
      CALL TREMAIN ( TCPU  )
C
C     =========================
C     1 - VERSION AUTRE MACHINE
C     =========================
C
#else

C         
C       1.1 INITIALISATION DU TEMPS CPU - DETERMINATION DE L'ORIGINE
C       ------------------------------------------------------------
C
        IF ( LPAS ) THEN
C         on utilise la fonction C Dgetcp.c
C         CPUDEB est en microsecondes. On ne convertit en secondes 
C         que pour l'affichage de maniere a eviter les problemes de 
C         precisions (si on convertit en secondes pour faire des 
C         soustractions dans le GTCPUT ==> valeur negatives si 
C         le temps progresse peu)
C
          CALL DGETCP ( TT )
C
          CPUDEB = ( (TT (3) + TT (1) ) * 1.D+6 + 
     *              ( TT (4) + TT (2) ) * 1.D0  )
C
          LPAS = .FALSE.
        ENDIF
C
C       1.2 CALCUL DU TEMPS CPU RESTANT
C       -------------------------------
C
C      Appel systeme qui renvoi cpu time sous la forme hhhh:mm:ss.cc
C
C      on utilise la fonction C dgetcp.c
C      temps cpu = temps renvoye par getcpu 
C      (seconde-microsec) - temps au moment initial (CPUDEB)
C
       CALL DGETCP ( TT )
C
       S = ( (TT(3)+TT(1)) * 1.D+6 + (TT(4)+TT(2)) * 1.D0 ) - CPUDEB
C
       TCPU = S * 1.D-6 
C
C++ VERSION HP9000 DONNEE EN 100 IEME DE SECONDE => / 100
C
       TCPU = TCPU / 200.
C++
C
#endif
C
C----
C FIN
C----
C
      END
