/*
 * synaptiks -- a touchpad control tool
 *
 *
 * Copyright (C) 2009, 2010 Sebastian Wiesner <basti.wiesner@gmx.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */


#ifndef SYNAPTIKSWIDGETS_H
#define SYNAPTIKSWIDGETS_H

#include <QtGui/QWidget>

class KConfigSkeleton;


namespace synaptiks {
    class Touchpad;

    class TouchpadInformationPage: public QWidget {
        Q_OBJECT

    public:
        TouchpadInformationPage(QWidget *parent=0);
        void showTouchpad();
    };

    class AutoTouchpadControlPage: public QWidget {
        Q_OBJECT

    public:
        AutoTouchpadControlPage(QWidget *parent=0);
    };

    class GeneralPage: public QWidget {
        Q_OBJECT

    public:
        GeneralPage(QWidget *parent=0);
    };

    class MotionPage: public QWidget {
        Q_OBJECT

    public:
        MotionPage(QWidget *parent=0);

    public Q_SLOTS:
        void disableAccelerationFactor();
    };

    class ScrollingPage: public QWidget {
        Q_OBJECT

    public:
        ScrollingPage(QWidget *parent=0);

    public Q_SLOTS:
        void disableCoastingConfiguration();
    };

    class TappingPage: public QWidget {
        Q_OBJECT

    public:
        TappingPage(QWidget *parent=0);
    };

    class NotificationsPage: public QWidget {
        Q_OBJECT

    public:
        explicit NotificationsPage(const QString &appname, QWidget *parent=0);

    Q_SIGNALS:
        void changed(bool changed);

    public Q_SLOTS:
        void saveNotifications();
    };

    class ErrorPage: public QWidget {
        Q_OBJECT

    public:
        explicit ErrorPage(const QString &message, QWidget *parent=0);
    };
}

#endif /* SYNAPTIKSWIDGETS_H */
