// Copyright (C) 2006-2009 Kent-Andre Mardal and Simula Research Laboratory.
// Licensed under the GNU GPL Version 2, or (at your option) any later version.

#include "MixedFE.h"

using namespace std;

namespace SyFi
{

	MixedFE::MixedFE() : FE()
	{
		description = "MixedFE";
	}

	MixedFE::MixedFE(StandardFE* fe1, StandardFE* fe2) : FE()
	{
		mfe.push_back(fe1);
		mfe.push_back(fe2);
		description = "MixedFE_" + fe1->str() + "_" +  fe2->str();
	}

	MixedFE::~MixedFE()
	{
		mfe.clear();
	}

	StandardFE* MixedFE::get(unsigned int i)
	{
		if ( i < 0 || i > mfe.size())
		{
			throw(std::out_of_range("The index is out of range!"));
		}
		return mfe[i];
	}

	void MixedFE::append(StandardFE* fe)
	{
		mfe.push_back(fe);
		description = description + "_" + fe->str();
	}

	GiNaC::ex MixedFE::N(unsigned int i)
	{

		if ( i < 0 || i > nbf()-1)
		{
			throw(std::out_of_range("The index is out of range!"));
		}

		bool found = false;
		unsigned int e = 0;
		unsigned int tmp_nbf = (*mfe[0]).nbf() ;
		unsigned int tmp_i = i;

		while ( e < mfe.size() && !found)
		{
			tmp_nbf = (*mfe[0]).nbf() ;
			if ( tmp_i < tmp_nbf )
			{
				found = true;
			}
			else
			{
				tmp_i -= (*mfe[e]).nbf();
				e++;
			}
		}
		return (*mfe[e]).N(tmp_i);
	}

	GiNaC::ex MixedFE::dof(unsigned int i)
	{

		if ( i < 0 || i > nbf()-1)
		{
			throw(std::out_of_range("The index is out of range!"));
		}

		bool found = false;
		unsigned int e = 0;
		unsigned int tmp_nbf = (*mfe[0]).nbf() ;
		unsigned int tmp_i = i;

		while ( e < mfe.size() && !found)
		{
			if ( tmp_i < tmp_nbf)
			{
				found = true;
			}
			else
			{
				tmp_i -= (*mfe[e]).nbf();
				e++;
			}
		}
		return (*mfe[e]).dof(tmp_i);
	}

	unsigned int MixedFE::nbf() const
	{
		int sum = 0;
		for (unsigned int i=0; i< mfe.size(); i++)
		{
			sum += (*mfe[i]).nbf();
		}
		return sum;
	}

	std::string MixedFE:: str()
	{
		return description;
	}

}
