# -*- coding: utf-8 -*-
"""
This module contains code generation tools for the ufc::interior_integral class.
"""


__author__ = "Martin Sandve Alnes"
__date__   = "2008-08-13 -- 2008-12-18"
__copyright__ = "(C) 2008 Martin Sandve Alnes and Simula Resarch Laboratory"
__license__  = "GNU GPL Version 2, or (at your option) any later version"

from sfc.common.output import sfc_error
from sfc.codegeneration.integralcg import IntegralCG

class InteriorFacetIntegralCG(IntegralCG):
    def __init__(self, itgrep):
        IntegralCG.__init__(self, itgrep)

    def gen_constructor(self):
        return ""
    
    def gen_destructor(self):
        return ""

    def gen_members(self):
        return ""
    
    def gen_tabulate_tensor_symbolic(self):
        return 'throw std::runtime_error("tabulate_tensor for interior facet integrals not implemented");'
    
    def gen_tabulate_tensor_quadrature(self):
        return 'throw std::runtime_error("tabulate_tensor for interior facet integrals not implemented");'
