// Copyright (C) 2009-2009 Kent Andre Mardal
// Licensed under the GNU LGPL Version 3.0.
//
// Modified by Martin Alnæs 2009.
//
// First added:  2009-01-01
// Last changed: 2009-04-01
//
// This demo program computes the divergence matrix.

#include <dolfin.h>
#include "generated_code/DivMatrix.h"

using namespace dolfin;
using namespace DivMatrix;

int main()
{
  UnitSquare mesh(1, 1);

  BilinearForm::TrialSpace V(mesh);
  BilinearForm::TestSpace Q(mesh);

  BilinearForm a(Q, V);

  Matrix A; 
  assemble(A, a); 
  A.disp(); 

  return 0;
}

