unit SWModule;

interface

uses
	SwordAPI, SWKey, ListKey, Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
    paramt = record
           path, name, disc: pchar;
    end;
    pparamt = ^paramt;
	TModType = (RawText, RawCom, RawLD);
	TSWModule = class(TComponent)
	private
	protected
     	hswmod: integer;
		FModType: TModType;
		FDataPath: AnsiString;
		FDescription: AnsiString;
		FMasterKey: TSWKey;
          FMyKey: TSWKey;
          FMyListKey: TListKey;
		procedure Loaded; override;
          function  GetKeyText: AnsiString; virtual;
          procedure SetKeyText(text: AnsiString); virtual;
          function  GetKey: TSWKey; virtual;
          procedure SetKey(ikey: TSWKey); virtual;
		procedure SetSWHandle(ihandle: integer); virtual;
          function  GetSWHandle: integer; virtual;
		procedure SetMasterKey(ikey: TSWKey); virtual;
          function  GetMasterKey: TSWKey; virtual;
	public
		constructor Create(AOwner:TComponent); override;
          destructor  Destroy; override;
		procedure Initialize; virtual;
          function Text: AnsiString; virtual;
          property SWHandle: integer read GetSWHandle write SetSWHandle;
		procedure Inc;
          procedure Dec;
          function  Search(stext: AnsiString): TListKey; virtual;
		property KeyText: AnsiString read GetKeyText write SetKeyText;
		property Key: TSWKey read GetKey write SetKey;
		function Error: integer; virtual;
	published
		property ModType: TModType read FModType write FModType default RawText;
		property DataPath: AnsiString read FDataPath write FDataPath;
		property Description: AnsiString read FDescription write FDescription;
		property MasterKey: TSWKey read GetMasterKey write SetMasterKey;
	end;

procedure Register;

implementation

constructor TSWModule.Create(AOwner:TComponent);
begin
	inherited Create(AOwner);
     FModType := RawText;
	if not (csDesigning in ComponentState) then
     begin
	     hswmod     := 0;
		FMyKey     := TSWKey.Create(NIL);
		FMyListKey := TListKey.Create(NIL);
     end;
end;


destructor TSWModule.Destroy;
begin
	if not (csDesigning in ComponentState) then
     begin
		if (hswmod <> 0) then
	     begin
	     	DeleteModule(hswmod);
	          hswmod := 0;
               FMyKey.SWHandle := 0;
               FMyKey.Free;
               FMyListKey.SWHandle := 0;
               FMyListKey.Free;
	     end;
     end;
	inherited Destroy;
end;


procedure TSWModule.Loaded;
begin
	inherited Loaded;
	if not (csDesigning in ComponentState) then
	     Initialize;
end;


procedure TSWModule.Initialize;
var
	params: paramt;
     s1: AnsiString;
begin
	if (hswmod <> 0) then
     	DeleteModule(hswmod);
	params.name := PChar(AnsiString(Name));
	params.path := PChar(DataPath);
	params.disc := PChar(Description);

     case ModType of
     RawText: s1 := 'RawText';
     RawCom:  s1 := 'RawCom';
     RawLD:   s1 := 'RawLD';
     end;

	hswmod := NewModule(PChar(s1), @params);

     if (FMasterKey <> NIL) then
     begin
     	if (FMasterKey.SWHandle = 0) then
          	FMasterKey.Initialize;
     	Key := FMasterKey;
     end;
end;


function TSWModule.Text: AnsiString;
var
	s1: AnsiString;
begin
	SetLength(s1, ModGetTextLen(hswmod)+1);
     ModGetText(hswmod, PChar(s1), Length(s1)+1);
	s1 := Trim(s1);
     Text := s1;
end;


function TSWModule.GetSWHandle: integer;
begin
	GetSWHandle := hswmod;
end;


procedure TSWModule.SetSWHandle(ihandle: integer);
begin
	hswmod := ihandle;
end;


function TSWModule.GetKeyText: AnsiString;
var
	s1: AnsiString;
begin
	SetLength(s1, 1024);
     ModGetKeyText(hswmod, PChar(s1), Length(s1));
	s1 := Trim(s1);
     GetKeyText := s1;
end;


procedure TSWModule.SetKeyText(text: AnsiString);
begin
	ModSetKeyText(hswmod, PChar(text));
end;


function TSWModule.GetKey: TSWKey;
begin
     FMyKey.SWHandle := ModGetKey(hswmod);
	GetKey := FMyKey;
end;


function TSWModule.Search(stext: AnsiString): TListKey;
begin
     FMyListKey.SWHandle := ModSearch(hswmod, PChar(stext));
	Search := FMyListKey;
end;


procedure TSWModule.SetKey(ikey: TSWKey);
begin
	ModSetKeyKey(hswmod, ikey.SWHandle);
end;


procedure TSWModule.Inc;
begin
	ModInc(hswmod);
end;


procedure TSWModule.Dec;
begin
	ModDec(hswmod);
end;


procedure TSWModule.SetMasterKey(ikey: TSWKey);
begin
	FMasterKey := ikey;
end;


function  TSWModule.GetMasterKey: TSWKey;
begin
	GetMasterKey := FMasterKey;
end;


function TSWModule.Error: integer;
begin
	Error := ModError(hswmod);
end;




procedure Register;
begin
  RegisterComponents('SWORD', [TSWModule]);
end;



end.
