#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>

int close (int fd) {
  return fclose((FILE*)fd);
}

int open(const char *path, int mode) {
  char cmode[3];
  cmode[0] = cmode[1] = cmode[2] = 0;
  if (mode & O_RDWR) {
    cmode[1] = '+';
	cmode[0] = 'r';
  }
  if (mode & O_RDONLY)
    cmode[0] = 'r';
  if (mode & O_WRONLY)
    cmode[0] = 'w';

  if ((mode & O_CREAT ) && (cmode[0] == 'w')) cmode[1] = '+';
  if (mode & O_APPEND) {
    if (cmode[0] == 'r') cmode[1] = '+';
    cmode[0] = 'a';
  }
  if (mode & O_BINARY) {
    cmode[1] ? (cmode[2] = 'b') : (cmode[1] = 'b');
  }
  return (int)fopen(path, cmode);
}

int open(const char *path, int access, unsigned mode) {
	return open(path, access | mode);
}

int read(int fd, void* buf, size_t count) {
	return fread(buf, 1, count, (FILE*)fd);
}

int write(int fd, const void * buf, size_t count) {
	return fwrite(buf, 1, count, (FILE*)fd);
}

//int write(int fd, const char * buf, size_t count)

typedef long off_t;

off_t lseek(int fildes, off_t offset, int whence) {
	if (!(fseek((FILE*)fildes, offset, whence))) {
	  fgetpos((FILE*)fildes, (fpos_t*)offset);
	  return offset;
	}
	else
	  return (off_t)-1;
}

int access(const char* path, int mode) {
	return 0;
}