/*
** Copyright (C) 1995, 1996, 1997, 1998 Hewlett-Packard Company
** Originally by Kevin Hughes, kev@kevcom.com, 3/11/94
**
** This program and library is free software; you can redistribute it and/or
** modify it under the terms of the GNU (Library) General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
** GNU (Library) General Public License for more details.
**
** You should have received a copy of the GNU (Library) General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
**
**1998-07-04  addfilter   ( R. Scherg)
**
*/

#include "swish.h"
#include "list.h"
#include "mem.h"
#include "string.h"

struct swline *addswline(rp, line)
struct swline *rp;
char *line;
{
	struct swline *newnode;
	static struct swline *nodep;
	
	newnode = (struct swline *) emalloc(sizeof(struct swline));
	newnode->line = (char *) estrdup(line);
	newnode->next = NULL;
	
	if (rp == NULL)
		rp = newnode;
	else
		nodep->next = newnode;
	
	nodep = newnode;
	
	return rp;
}

struct filter *addfilter(rp, suffix,prog,filterdir)
     struct filter *rp;
     char *suffix, *prog;
     char *filterdir;
{
        struct filter *newnode;
        static struct filter *nodep;
        char *buf;
	int ilen1,ilen2;

        newnode = (struct filter *) emalloc(sizeof(struct filter));
        newnode->suffix= (char *) estrdup(suffix);
	ilen1=strlen(filterdir);
	ilen2=strlen(prog);
	buf = (char *)emalloc(ilen1+ilen2+2);
	memcpy(buf,filterdir,ilen1);
		/* If filterdir exists and not ends in DIRDELIMITER 
		** (/ in Unix or \\ in WIN32) add it
		*/
	if(ilen1 && buf[ilen1-1]!=DIRDELIMITER) buf[ilen1++]=DIRDELIMITER;
	memcpy(buf+ilen1,prog,ilen2);
	buf[ilen1+ilen2]='\0';
        newnode->prog= buf;
        newnode->next = NULL;

        if (rp == NULL)
                rp = newnode;
        else
                nodep->next = newnode;

        nodep = newnode;

        return rp;
}

