/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.carbon.DataBrowserCallbacks;
import org.eclipse.swt.internal.carbon.DataBrowserCustomCallbacks;
import org.eclipse.swt.internal.carbon.DataBrowserListViewColumnDesc;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Tree
extends Composite {
    TreeItem[] items;
    GC paintGC;
    int anchorFirst;
    int anchorLast;
    int lastHittest;
    boolean ignoreSelect;
    boolean wasSelected;
    boolean ignoreExpand;
    boolean wasExpanded;
    TreeItem showItem;
    static final int CHECK_COLUMN_ID = 1024;
    static final int COLUMN_ID = 1025;
    static final int EXTRA_WIDTH = 30;
    static final int CHECK_COLUMN_WIDTH = 25;

    public Tree(Composite parent, int style) {
        super(parent, Tree.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addTreeListener(TreeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    int calculateWidth(TreeItem[] items, GC gc) {
        int width = 0;
        int i = 0;
        while (i < items.length) {
            TreeItem item = items[i];
            width = Math.max(width, item.calculateWidth(gc));
            if (item._getExpanded()) {
                width = Math.max(width, this.calculateWidth(item.getItems(), gc));
            }
            ++i;
        }
        return width;
    }

    int callPaintEventHandler(int control, int damageRgn, int visibleRgn, int theEvent, int nextHandler) {
        GC currentGC = this.paintGC;
        if (currentGC == null) {
            GCData data = new GCData();
            data.paintEvent = theEvent;
            data.visibleRgn = visibleRgn;
            this.paintGC = GC.carbon_new(this, data);
        }
        int result = super.callPaintEventHandler(control, damageRgn, visibleRgn, theEvent, nextHandler);
        if (currentGC == null) {
            this.paintGC.dispose();
            this.paintGC = null;
        }
        return result;
    }

    static int checkStyle(int style) {
        return Widget.checkBits(style |= 0x300, 4, 2, 0, 0, 0, 0);
    }

    public org.eclipse.swt.graphics.Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        if (wHint == -1) {
            TreeItem[] items = this.getItems();
            GC gc = new GC(this);
            int i = 0;
            while (i < items.length) {
                TreeItem item = items[i];
                width = Math.max(width, item.calculateWidth(gc));
                ++i;
            }
            gc.dispose();
            width += 30;
            if ((this.style & 0x20) != 0) {
                width += 25;
            }
        } else {
            width = wHint;
        }
        if (width <= 0) {
            width = 64;
        }
        int height = 0;
        height = hHint == -1 ? this.getItemCount() * this.getItemHeight() : hHint;
        if (height <= 0) {
            height = 64;
        }
        Rectangle rect = this.computeTrim(0, 0, width, height);
        return new org.eclipse.swt.graphics.Point(rect.width, rect.height);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        int border = 0;
        int[] outMetric = new int[1];
        OS.GetThemeMetric((int)7, (int[])outMetric);
        border += outMetric[0];
        OS.GetThemeMetric((int)5, (int[])outMetric);
        Rect rect = new Rect();
        OS.GetDataBrowserScrollBarInset((int)this.handle, (Rect)rect);
        return new Rectangle(x -= rect.left + (border += outMetric[0]), y -= rect.top + border, width += rect.left + rect.right + border + border, height += rect.top + rect.bottom + border + border);
    }

    void createHandle() {
        int[] outControl = new int[1];
        int window = OS.GetControlOwner((int)this.parent.handle);
        OS.CreateDataBrowserControl((int)window, null, (int)1819505782, (int[])outControl);
        if (outControl[0] == 0) {
            this.error(2);
        }
        this.handle = outControl[0];
        if (!this.drawFocusRing()) {
            OS.SetControlData((int)this.handle, (int)0, (int)1651663986, (int)1, (byte[])new byte[1]);
        }
        int selectionFlags = (this.style & 4) != 0 ? 66 : 8;
        OS.SetDataBrowserSelectionFlags((int)this.handle, (int)selectionFlags);
        OS.SetDataBrowserListViewHeaderBtnHeight((int)this.handle, (short)0);
        OS.SetDataBrowserHasScrollBars((int)this.handle, ((this.style & 0x100) != 0 ? 1 : 0) != 0, ((this.style & 0x200) != 0 ? 1 : 0) != 0);
        int position = 0;
        if ((this.style & 0x20) != 0) {
            DataBrowserListViewColumnDesc checkColumn = new DataBrowserListViewColumnDesc();
            checkColumn.headerBtnDesc_version = 0;
            checkColumn.propertyDesc_propertyID = 1024;
            checkColumn.propertyDesc_propertyType = 1667785336;
            checkColumn.propertyDesc_propertyFlags = 1;
            checkColumn.headerBtnDesc_minimumWidth = (short)25;
            checkColumn.headerBtnDesc_maximumWidth = (short)25;
            checkColumn.headerBtnDesc_initialOrder = 1;
            OS.AddDataBrowserListViewColumn((int)this.handle, (DataBrowserListViewColumnDesc)checkColumn, (int)position++);
        }
        DataBrowserListViewColumnDesc column = new DataBrowserListViewColumnDesc();
        column.headerBtnDesc_version = 0;
        column.propertyDesc_propertyID = 1025;
        column.propertyDesc_propertyType = 0x3F3F3F3F;
        column.propertyDesc_propertyFlags = 65536;
        column.headerBtnDesc_initialOrder = 1;
        OS.AddDataBrowserListViewColumn((int)this.handle, (DataBrowserListViewColumnDesc)column, (int)position);
        OS.SetDataBrowserListViewDisclosureColumn((int)this.handle, (int)1025, (boolean)true);
        OS.SetDataBrowserTableViewNamedColumnWidth((int)this.handle, (int)1025, (short)0);
        int size = 50;
        Rect rect = new Rect();
        rect.right = rect.bottom = (short)size;
        OS.SetControlBounds((int)this.handle, (Rect)rect);
        int bpl = size * 4;
        int[] gWorld = new int[1];
        int data = OS.NewPtr((int)(bpl * size));
        OS.NewGWorldFromPtr((int[])gWorld, (int)32, (Rect)rect, (int)0, (int)0, (int)0, (int)data, (int)bpl);
        int[] curPort = new int[1];
        int[] curGWorld = new int[1];
        OS.GetGWorld((int[])curPort, (int[])curGWorld);
        OS.SetGWorld((int)gWorld[0], (int)curGWorld[0]);
        OS.DrawControlInCurrentPort((int)this.handle);
        OS.SetGWorld((int)curPort[0], (int)curGWorld[0]);
        OS.DisposeGWorld((int)gWorld[0]);
        OS.DisposePtr((int)data);
        rect.bottom = 0;
        rect.right = 0;
        OS.SetControlBounds((int)this.handle, (Rect)rect);
    }

    void createItem(TreeItem item, TreeItem parentItem, int index) {
        int count = 0;
        int id = this.items.length;
        int i = 0;
        while (i < this.items.length) {
            if (this.items[i] == null) {
                if (id == this.items.length) {
                    id = i;
                }
            } else if (this.items[i].parentItem == parentItem) {
                ++count;
            }
            ++i;
        }
        if (index == -1) {
            index = count;
        }
        if (index < 0 || index > count) {
            this.error(6);
        }
        item.index = index;
        if (index != count) {
            i = 0;
            while (i < this.items.length) {
                if (this.items[i] != null && this.items[i].parentItem == parentItem && this.items[i].index >= item.index) {
                    ++this.items[i].index;
                }
                ++i;
            }
        }
        if (id == this.items.length) {
            TreeItem[] newItems = new TreeItem[this.items.length + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        this.items[id] = item;
        item.id = id + 1;
        int parentID = 0;
        boolean expanded = true;
        if (parentItem != null) {
            parentID = parentItem.id;
            expanded = parentItem._getExpanded();
        }
        if (expanded) {
            if (OS.AddDataBrowserItems((int)this.handle, (int)parentID, (int)1, (int[])new int[]{item.id}, (int)0) != 0) {
                this.items[id] = null;
                this.error(14);
            }
        } else if (count == 0 && parentItem != null) {
            parentItem.redraw(1025);
        }
    }

    ScrollBar createScrollBar(int style) {
        return this.createStandardBar(style);
    }

    void createWidget() {
        super.createWidget();
        this.items = new TreeItem[4];
    }

    Color defaultBackground() {
        return this.display.getSystemColor(25);
    }

    Color defaultForeground() {
        return this.display.getSystemColor(24);
    }

    int defaultThemeFont() {
        if (this.display.smallFonts) {
            return 1;
        }
        return 3;
    }

    public void deselectAll() {
        this.checkWidget();
        this.ignoreSelect = true;
        int[] selectionFlags = null;
        if ((this.style & 4) != 0) {
            selectionFlags = new int[1];
            OS.GetDataBrowserSelectionFlags((int)this.handle, (int[])selectionFlags);
            OS.SetDataBrowserSelectionFlags((int)this.handle, (int)(selectionFlags[0] & 0xFFFFFFBF));
        }
        OS.SetDataBrowserSelectedItems((int)this.handle, (int)0, null, (int)3);
        if ((this.style & 4) != 0) {
            OS.SetDataBrowserSelectionFlags((int)this.handle, (int)selectionFlags[0]);
        }
        this.ignoreSelect = false;
    }

    void destroyItem(TreeItem item) {
        int parentID;
        int n = parentID = item.parentItem == null ? 0 : item.parentItem.id;
        if (OS.RemoveDataBrowserItems((int)this.handle, (int)parentID, (int)1, (int[])new int[]{item.id}, (int)0) != 0) {
            this.error(15);
        }
        this.releaseItems(item.getItems());
        this.releaseItem(item);
        TreeItem parentItem = item.parentItem;
        int i = 0;
        while (i < this.items.length) {
            if (this.items[i] != null && this.items[i].parentItem == parentItem && this.items[i].index >= item.index) {
                --this.items[i].index;
            }
            ++i;
        }
        this.setScrollWidth();
    }

    int drawItemProc(int browser, int id, int property, int itemState, int theRect, int gdDepth, int colorDevice) {
        int index = id - 1;
        if (index < 0 || index >= this.items.length) {
            return 0;
        }
        TreeItem item = this.items[index];
        Rect rect = new Rect();
        OS.memcpy((Rect)rect, (int)theRect, (int)8);
        int x = rect.left;
        int y = rect.top;
        int width = rect.right - rect.left;
        int height = rect.bottom - rect.top;
        Rect controlRect = new Rect();
        OS.GetControlBounds((int)this.handle, (Rect)controlRect);
        x -= controlRect.left;
        y -= controlRect.top;
        GC gc = this.paintGC;
        if (gc == null) {
            GCData data = new GCData();
            int[] port = new int[1];
            OS.GetPort((int[])port);
            data.port = port[0];
            gc = GC.carbon_new(this, data);
        }
        int clip = OS.NewRgn();
        OS.GetClip((int)clip);
        OS.OffsetRgn((int)clip, (short)(-controlRect.left), (short)(-controlRect.top));
        gc.setClipping(Region.carbon_new(this.display, clip));
        OS.DisposeRgn((int)clip);
        Color background = item.getBackground();
        gc.setBackground(background);
        gc.fillRectangle(x, y, width, height);
        Image image = item.image;
        if (image != null) {
            Rectangle bounds = image.getBounds();
            gc.drawImage(image, 0, 0, bounds.width, bounds.height, x, y + (height - bounds.height) / 2, bounds.width, bounds.height);
            x += bounds.width + 2;
        }
        Font font = item.getFont();
        gc.setFont(font);
        org.eclipse.swt.graphics.Point extent = gc.stringExtent(item.text);
        if ((itemState & 1) != 0) {
            gc.setForeground(this.display.getSystemColor(27));
            gc.setBackground(this.display.getSystemColor(26));
            gc.fillRectangle(x - 1, y, extent.x + 2, height);
        } else {
            Color foreground = item.getForeground();
            gc.setForeground(foreground);
        }
        gc.drawString(item.text, x, y + (height - extent.y) / 2);
        if (gc != this.paintGC) {
            gc.dispose();
        }
        return 0;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        int border = 0;
        int[] outMetric = new int[1];
        OS.GetThemeMetric((int)7, (int[])outMetric);
        border += outMetric[0];
        OS.GetThemeMetric((int)5, (int[])outMetric);
        border += outMetric[0];
        Rect rect = new Rect();
        Rect inset = new Rect();
        OS.GetControlBounds((int)this.handle, (Rect)rect);
        OS.GetDataBrowserScrollBarInset((int)this.handle, (Rect)inset);
        int width = Math.max(0, rect.right - rect.left - inset.right - border - border);
        int height = Math.max(0, rect.bottom - rect.top - inset.bottom - border - border);
        return new Rectangle(inset.left, inset.top, width, height);
    }

    public TreeItem getItem(org.eclipse.swt.graphics.Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        Rect rect = new Rect();
        OS.GetControlBounds((int)this.handle, (Rect)rect);
        Point pt = new Point();
        OS.SetPt((Point)pt, (short)((short)(point.x + rect.left)), (short)((short)(point.y + rect.top)));
        int i = 0;
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null && OS.GetDataBrowserItemPartBounds((int)this.handle, (int)item.id, (int)1025, (int)0, (Rect)rect) == 0 && OS.PtInRect((Point)pt, (Rect)rect)) {
                return item;
            }
            ++i;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.getItemCount(null);
    }

    int getItemCount(TreeItem item) {
        this.checkWidget();
        int count = 0;
        int i = 0;
        while (i < this.items.length) {
            if (this.items[i] != null && this.items[i].parentItem == item) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public int getItemHeight() {
        this.checkWidget();
        short[] height = new short[1];
        if (OS.GetDataBrowserTableViewRowHeight((int)this.handle, (short[])height) != 0) {
            this.error(11);
        }
        return height[0];
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        return this.getItems(null);
    }

    TreeItem[] getItems(TreeItem item) {
        if (this.items == null) {
            return new TreeItem[0];
        }
        int count = 0;
        int i = 0;
        while (i < this.items.length) {
            if (this.items[i] != null && this.items[i].parentItem == item) {
                ++count;
            }
            ++i;
        }
        TreeItem[] result = new TreeItem[count];
        int i2 = 0;
        while (i2 < this.items.length) {
            if (this.items[i2] != null && this.items[i2].parentItem == item) {
                result[this.items[i2].index] = this.items[i2];
            }
            ++i2;
        }
        return result;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return null;
    }

    public TreeItem[] getSelection() {
        this.checkWidget();
        int ptr = OS.NewHandle((int)0);
        if (OS.GetDataBrowserItems((int)this.handle, (int)0, (boolean)true, (int)1, (int)ptr) != 0) {
            this.error(9);
        }
        int count = OS.GetHandleSize((int)ptr) / 4;
        TreeItem[] result = new TreeItem[count];
        OS.HLock((int)ptr);
        int[] start = new int[1];
        OS.memcpy((int[])start, (int)ptr, (int)4);
        int[] id = new int[1];
        int i = 0;
        while (i < count) {
            OS.memcpy((int[])id, (int)(start[0] + i * 4), (int)4);
            result[i] = this.items[id[0] - 1];
            ++i;
        }
        OS.HUnlock((int)ptr);
        OS.DisposeHandle((int)ptr);
        return result;
    }

    public int getSelectionCount() {
        this.checkWidget();
        int[] count = new int[1];
        if (OS.GetDataBrowserItemCount((int)this.handle, (int)0, (boolean)true, (int)1, (int[])count) != 0) {
            this.error(36);
        }
        return count[0];
    }

    public TreeItem getTopItem() {
        this.checkWidget();
        Rect rect = new Rect();
        OS.GetControlBounds((int)this.handle, (Rect)rect);
        int offset = 0;
        int[] outMetric = new int[1];
        OS.GetThemeMetric((int)7, (int[])outMetric);
        offset += outMetric[0];
        OS.GetThemeMetric((int)5, (int[])outMetric);
        int y = rect.top + (offset += outMetric[0]);
        int i = 0;
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null && OS.GetDataBrowserItemPartBounds((int)this.handle, (int)item.id, (int)1025, (int)0, (Rect)rect) == 0 && rect.top <= y && y <= rect.bottom) {
                return item;
            }
            ++i;
        }
        return null;
    }

    int hitTestProc(int browser, int id, int property, int theRect, int mouseRect) {
        this.lastHittest = id;
        return 1;
    }

    void hookEvents() {
        super.hookEvents();
        DataBrowserCallbacks callbacks = new DataBrowserCallbacks();
        callbacks.version = 0;
        OS.InitDataBrowserCallbacks((DataBrowserCallbacks)callbacks);
        callbacks.v1_itemCompareCallback = this.display.itemCompareProc;
        callbacks.v1_itemDataCallback = this.display.itemDataProc;
        callbacks.v1_itemNotificationCallback = this.display.itemNotificationProc;
        OS.SetDataBrowserCallbacks((int)this.handle, (DataBrowserCallbacks)callbacks);
        DataBrowserCustomCallbacks custom = new DataBrowserCustomCallbacks();
        custom.version = 0;
        OS.InitDataBrowserCustomCallbacks((DataBrowserCustomCallbacks)custom);
        custom.v1_drawItemCallback = this.display.drawItemProc;
        custom.v1_hitTestCallback = this.display.hitTestProc;
        custom.v1_trackingCallback = this.display.trackingProc;
        OS.SetDataBrowserCustomCallbacks((int)this.handle, (DataBrowserCustomCallbacks)custom);
    }

    int itemCompareProc(int browser, int itemOne, int itemTwo, int sortProperty) {
        int index1 = itemOne - 1;
        if (index1 < 0 || index1 >= this.items.length) {
            return 0;
        }
        int index2 = itemTwo - 1;
        if (index2 < 0 || index2 >= this.items.length) {
            return 0;
        }
        return this.items[index1].index < this.items[index2].index ? 1 : 0;
    }

    int itemDataProc(int browser, int id, int property, int itemData, int setValue) {
        int index = id - 1;
        if (index < 0 || index >= this.items.length) {
            return 0;
        }
        TreeItem item = this.items[index];
        switch (property) {
            case 1024: {
                if (setValue != 0) {
                    boolean bl = item.checked = !item.checked;
                    if (item.checked && item.grayed) {
                        OS.SetDataBrowserItemDataButtonValue((int)itemData, (short)2);
                    } else {
                        boolean theData = item.checked;
                        OS.SetDataBrowserItemDataButtonValue((int)itemData, (short)((short)(theData ? 1 : 0)));
                    }
                    Event event = new Event();
                    event.item = item;
                    event.detail = 32;
                    this.postEvent(13, event);
                    break;
                }
                int theData = 0;
                if (item.checked) {
                    theData = item.grayed ? 2 : 1;
                }
                OS.SetDataBrowserItemDataButtonValue((int)itemData, (short)((short)theData));
                break;
            }
            case 4: {
                int i = 0;
                while (i < this.items.length) {
                    if (this.items[i] != null && this.items[i].parentItem == item) {
                        OS.SetDataBrowserItemDataBooleanValue((int)itemData, (boolean)true);
                    }
                    ++i;
                }
                break;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int itemNotificationProc(int browser, int id, int message) {
        TreeItem item;
        block21: {
            int index = id - 1;
            if (index < 0) return 0;
            if (index >= this.items.length) {
                return 0;
            }
            item = this.items[index];
            switch (message) {
                case 5: 
                case 6: {
                    int modifiers;
                    this.wasSelected = true;
                    if (this.ignoreSelect) {
                        return 0;
                    }
                    int[] first = new int[1];
                    int[] last = new int[1];
                    OS.GetDataBrowserSelectionAnchor((int)this.handle, (int[])first, (int[])last);
                    boolean selected = false;
                    selected = (this.style & 2) != 0 ? (((modifiers = OS.GetCurrentEventKeyModifiers()) & 0x200) != 0 ? (message == 5 ? first[0] == id || last[0] == id : id == this.anchorFirst || id == this.anchorLast) : ((modifiers & 0x100) != 0 ? true : first[0] == last[0])) : message == 5;
                    if (!selected) return 0;
                    this.anchorFirst = first[0];
                    this.anchorLast = last[0];
                    Event event = new Event();
                    event.item = item;
                    this.postEvent(13, event);
                    return 0;
                }
                case 7: {
                    this.wasSelected = true;
                    Event event = new Event();
                    event.item = item;
                    this.postEvent(14, event);
                    return 0;
                }
                case 9: {
                    int count;
                    int ptr = OS.NewHandle((int)0);
                    if (OS.GetDataBrowserItems((int)this.handle, (int)item.id, (boolean)true, (int)1, (int)ptr) == 0 && (count = OS.GetHandleSize((int)ptr) / 4) > 0) {
                        int[] ids = new int[count];
                        OS.HLock((int)ptr);
                        int[] start = new int[1];
                        OS.memcpy((int[])start, (int)ptr, (int)4);
                        OS.memcpy((int[])ids, (int)start[0], (int)(count * 4));
                        OS.HUnlock((int)ptr);
                        this.ignoreSelect = true;
                        int[] selectionFlags = null;
                        if ((this.style & 4) != 0) {
                            selectionFlags = new int[1];
                            OS.GetDataBrowserSelectionFlags((int)this.handle, (int[])selectionFlags);
                            OS.SetDataBrowserSelectionFlags((int)this.handle, (int)(selectionFlags[0] & 0xFFFFFFBF));
                        }
                        OS.SetDataBrowserSelectedItems((int)this.handle, (int)ids.length, (int[])ids, (int)3);
                        if ((this.style & 4) != 0) {
                            OS.SetDataBrowserSelectionFlags((int)this.handle, (int)selectionFlags[0]);
                        }
                        this.ignoreSelect = false;
                        Event event = new Event();
                        event.item = item;
                        this.sendEvent(13, event);
                    }
                    OS.DisposeHandle((int)ptr);
                    return 0;
                }
                case 10: {
                    this.wasExpanded = true;
                    if (!this.ignoreExpand) {
                        Event event = new Event();
                        event.item = item;
                        this.sendEvent(18, event);
                    }
                    this.setScrollWidth();
                    return 0;
                }
                case 8: {
                    this.wasExpanded = true;
                    if (!this.ignoreExpand) {
                        Event event = new Event();
                        event.item = item;
                        try {
                            item.state |= 0x100;
                            this.sendEvent(17, event);
                            break;
                        }
                        catch (Throwable ids) {
                            Object count = null;
                            item.state &= 0xFFFFFEFF;
                            throw ids;
                        }
                    }
                    break block21;
                }
                default: {
                    return 0;
                }
            }
            {
                Object count = null;
                item.state &= 0xFFFFFEFF;
            }
        }
        int count = 0;
        int i = 0;
        while (true) {
            if (i >= this.items.length) break;
            if (this.items[i] != null && this.items[i].parentItem == item) {
                ++count;
            }
            ++i;
        }
        TreeItem[] newItems = new TreeItem[count];
        int[] ids = new int[count];
        int i2 = 0;
        while (true) {
            if (i2 >= this.items.length) break;
            if (this.items[i2] != null && this.items[i2].parentItem == item) {
                ids[this.items[i2].index] = this.items[i2].id;
                newItems[this.items[i2].index] = this.items[i2];
            }
            ++i2;
        }
        OS.AddDataBrowserItems((int)this.handle, (int)id, (int)ids.length, (int[])ids, (int)0);
        this.setScrollWidth(newItems, false);
        return 0;
    }

    int kEventTextInputUnicodeForKeyEvent(int nextHandler, int theEvent, int userData) {
        int result = super.kEventTextInputUnicodeForKeyEvent(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        int[] keyboardEvent = new int[1];
        OS.GetEventParameter((int)theEvent, (int)1953721189, (int)1702261350, null, (int)(keyboardEvent.length * 4), null, (int[])keyboardEvent);
        int[] keyCode = new int[1];
        OS.GetEventParameter((int)keyboardEvent[0], (int)1801678692, (int)1835100014, null, (int)(keyCode.length * 4), null, (int[])keyCode);
        switch (keyCode[0]) {
            case 36: {
                this.postEvent(14);
            }
        }
        return result;
    }

    int kEventMouseDown(int nextHandler, int theEvent, int userData) {
        int index;
        int result = super.kEventMouseDown(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        Shell shell = this.getShell();
        shell.bringToTop(true);
        Control oldFocus = this.display.getFocusControl();
        this.display.ignoreFocus = true;
        this.wasExpanded = false;
        this.wasSelected = false;
        result = OS.CallNextEventHandler((int)nextHandler, (int)theEvent);
        this.display.ignoreFocus = false;
        if (oldFocus != this) {
            if (oldFocus != null && !oldFocus.isDisposed()) {
                oldFocus.sendFocusEvent(false, false);
            }
            if (!this.isDisposed() && this.isEnabled()) {
                this.sendFocusEvent(true, false);
            }
        }
        if (!this.wasSelected && !this.wasExpanded && OS.IsDataBrowserItemSelected((int)this.handle, (int)this.lastHittest) && (index = this.lastHittest - 1) >= 0 && index < this.items.length) {
            Event event = new Event();
            event.item = this.items[index];
            this.postEvent(13, event);
        }
        if (this.wasExpanded) {
            Point outPt = new Point();
            OS.GetGlobalMouse((Point)outPt);
            Rect rect = new Rect();
            int window = OS.GetControlOwner((int)this.handle);
            OS.GetWindowBounds((int)window, (short)33, (Rect)rect);
            int x = outPt.h - rect.left;
            int y = outPt.v - rect.top;
            OS.GetControlBounds((int)this.handle, (Rect)rect);
            x -= rect.left;
            y -= rect.top;
            short[] button = new short[1];
            OS.GetEventParameter((int)theEvent, (int)1835168878, (int)1835168878, null, (int)2, null, (short[])button);
            int chord = OS.GetCurrentEventButtonState();
            int modifiers = OS.GetCurrentEventKeyModifiers();
            this.sendMouseEvent(4, button[0], chord, (short)x, (short)y, modifiers, false);
        }
        this.wasExpanded = false;
        this.wasSelected = false;
        return result;
    }

    boolean releaseItem(TreeItem item) {
        if (item.isDisposed()) {
            return false;
        }
        this.items[item.id - 1] = null;
        return true;
    }

    void releaseItems(TreeItem[] nodes) {
        int i = 0;
        while (i < nodes.length) {
            TreeItem item = nodes[i];
            TreeItem[] sons = item.getItems();
            if (sons.length != 0) {
                this.releaseItems(sons);
            }
            if (this.releaseItem(item)) {
                item.releaseResources();
            }
            ++i;
        }
    }

    void releaseWidget() {
        int i = 0;
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null && !item.isDisposed()) {
                item.releaseResources();
            }
            ++i;
        }
        this.items = null;
        super.releaseWidget();
    }

    public void removeAll() {
        this.checkWidget();
        if (OS.RemoveDataBrowserItems((int)this.handle, (int)0, (int)0, null, (int)0) != 0) {
            this.error(15);
        }
        OS.SetDataBrowserScrollPosition((int)this.handle, (int)0, (int)0);
        int i = 0;
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null && !item.isDisposed()) {
                item.releaseResources();
            }
            ++i;
        }
        this.items = new TreeItem[4];
        this.anchorLast = 0;
        this.anchorFirst = 0;
        this.setScrollWidth();
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeTreeListener(TreeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, listener);
        this.eventTable.unhook(18, listener);
    }

    void resetVisibleRegion(int control) {
        super.resetVisibleRegion(control);
        if (this.showItem != null && !this.showItem.isDisposed()) {
            this.showItem(this.showItem, true);
        }
    }

    public void setInsertMark(TreeItem item, boolean before) {
        this.checkWidget();
        if (item != null && item.isDisposed()) {
            this.error(5);
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        this.ignoreSelect = true;
        OS.SetDataBrowserSelectedItems((int)this.handle, (int)0, null, (int)1);
        this.ignoreSelect = false;
    }

    int setBounds(int control, int x, int y, int width, int height, boolean move, boolean resize, boolean events) {
        int result = super.setBounds(control, x, y, width, height, move, resize, events);
        if (this.showItem != null && !this.showItem.isDisposed()) {
            this.showItem(this.showItem, true);
        }
        return result;
    }

    void setFontStyle(Font font) {
        super.setFontStyle(font);
        if (this.items == null) {
            return;
        }
        int i = 0;
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null) {
                item.width = -1;
            }
            ++i;
        }
        this.setScrollWidth();
    }

    public void setRedraw(boolean redraw) {
        this.checkWidget();
        super.setRedraw(redraw);
        if (redraw && this.drawCount == 0) {
            this.setScrollWidth();
        }
    }

    void setScrollWidth() {
        this.setScrollWidth(this.getItems(), true);
    }

    void setScrollWidth(TreeItem item) {
        if (this.drawCount != 0) {
            return;
        }
        TreeItem parentItem = item.parentItem;
        if (parentItem != null && !parentItem._getExpanded()) {
            return;
        }
        GC gc = new GC(this);
        int newWidth = item.calculateWidth(gc);
        gc.dispose();
        short[] width = new short[1];
        OS.GetDataBrowserTableViewNamedColumnWidth((int)this.handle, (int)1025, (short[])width);
        if (width[0] < newWidth) {
            OS.SetDataBrowserTableViewNamedColumnWidth((int)this.handle, (int)1025, (short)((short)newWidth));
        }
    }

    void setScrollWidth(TreeItem[] items, boolean set) {
        if (this.drawCount != 0) {
            return;
        }
        GC gc = new GC(this);
        int newWidth = this.calculateWidth(items, gc);
        gc.dispose();
        if (!set) {
            short[] width = new short[1];
            OS.GetDataBrowserTableViewNamedColumnWidth((int)this.handle, (int)1025, (short[])width);
            if (width[0] >= newWidth) {
                return;
            }
        }
        OS.SetDataBrowserTableViewNamedColumnWidth((int)this.handle, (int)1025, (short)((short)newWidth));
    }

    public void setSelection(TreeItem[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        this.deselectAll();
        int length = items.length;
        if (length == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        int[] ids = new int[length];
        int i = 0;
        while (i < length) {
            if (items[i] == null) {
                this.error(5);
            }
            if (items[i].isDisposed()) {
                this.error(5);
            }
            ids[i] = items[i].id;
            this.showItem(items[i], false);
            ++i;
        }
        this.ignoreSelect = true;
        int[] selectionFlags = null;
        if ((this.style & 4) != 0) {
            selectionFlags = new int[1];
            OS.GetDataBrowserSelectionFlags((int)this.handle, (int[])selectionFlags);
            OS.SetDataBrowserSelectionFlags((int)this.handle, (int)(selectionFlags[0] & 0xFFFFFFBF));
        }
        OS.SetDataBrowserSelectedItems((int)this.handle, (int)ids.length, (int[])ids, (int)1);
        if ((this.style & 4) != 0) {
            OS.SetDataBrowserSelectionFlags((int)this.handle, (int)selectionFlags[0]);
        }
        this.ignoreSelect = false;
        if (length > 0) {
            this.showItem(items[0], true);
        }
    }

    public void setTopItem(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        this.showItem(item, false);
        OS.RevealDataBrowserItem((int)this.handle, (int)item.id, (int)1025, (byte)2);
    }

    public void showItem(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        this.showItem(item, true);
    }

    void showItem(TreeItem item, boolean scroll) {
        int count = 0;
        TreeItem parentItem = item.parentItem;
        while (parentItem != null && !parentItem._getExpanded()) {
            ++count;
            parentItem = parentItem.parentItem;
        }
        int index = 0;
        parentItem = item.parentItem;
        TreeItem[] path = new TreeItem[count];
        while (parentItem != null && !parentItem._getExpanded()) {
            path[index++] = parentItem;
            parentItem = parentItem.parentItem;
        }
        int i = path.length - 1;
        while (i >= 0) {
            path[i].setExpanded(true);
            --i;
        }
        if (scroll) {
            Rectangle rect = this.getClientArea();
            if (rect.height < this.getItemHeight() || !OS.IsControlVisible((int)this.handle)) {
                this.showItem = item;
                return;
            }
            this.showItem = null;
            Rectangle itemRect = item.getBounds();
            if (!itemRect.isEmpty() && rect.contains(itemRect.x, itemRect.y) && rect.contains(itemRect.x, itemRect.y + itemRect.height)) {
                return;
            }
            int[] top = new int[1];
            int[] left = new int[1];
            OS.GetDataBrowserScrollPosition((int)this.handle, (int[])top, (int[])left);
            OS.RevealDataBrowserItem((int)this.handle, (int)item.id, (int)1025, (byte)2);
            int[] newTop = new int[1];
            int[] newLeft = new int[1];
            OS.GetDataBrowserScrollPosition((int)this.handle, (int[])newTop, (int[])newLeft);
            if (this.horizontalBar != null && newLeft[0] != left[0]) {
                this.horizontalBar.redraw();
            }
            if (this.verticalBar != null && newTop[0] != top[0]) {
                this.verticalBar.redraw();
            }
        }
    }

    public void showSelection() {
        this.checkWidget();
        TreeItem[] selection = this.getSelection();
        if (selection.length > 0) {
            this.showItem(selection[0], true);
        }
    }

    int trackingProc(int browser, int id, int property, int theRect, int startPt, int modifiers) {
        return 1;
    }
}

