/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.handlers;

import java.util.Collections;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.commands.AbstractHandler;
import org.eclipse.ui.commands.ExecutionException;
import org.eclipse.ui.commands.IHandler;
import org.eclipse.ui.commands.NoSuchAttributeException;
import org.eclipse.ui.internal.WorkbenchPlugin;

public final class HandlerProxy
extends AbstractHandler {
    public static final String ATTRIBUTE_ID = "id";
    public static final String ATTRIBUTE_PRIORITY = "priority";
    private static final String HANDLER_ATTRIBUTE_NAME = "handler";
    private final String commandId;
    private final Integer priority;
    private IConfigurationElement configurationElement;
    private IHandler handler;

    public HandlerProxy(String newCommandId, Integer newPriority, IConfigurationElement newConfigurationElement) {
        this.commandId = newCommandId;
        this.priority = newPriority;
        this.configurationElement = newConfigurationElement;
        this.handler = null;
    }

    public void execute(Object parameter) throws ExecutionException {
        if (this.loadHandler()) {
            this.handler.execute(parameter);
        }
    }

    private final boolean loadHandler() {
        if (this.handler == null) {
            try {
                this.handler = (IHandler)this.configurationElement.createExecutableExtension(HANDLER_ATTRIBUTE_NAME);
                this.configurationElement = null;
                return true;
            }
            catch (CoreException e) {
                String message = "The proxied handler for '" + this.commandId + "' could not be loaded";
                Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, message, (Throwable)e);
                WorkbenchPlugin.log(message, (IStatus)status);
                return false;
            }
        }
        return true;
    }

    public Object getAttributeValue(String attributeName) throws NoSuchAttributeException {
        if (this.handler == null) {
            if (ATTRIBUTE_ID.equals(attributeName)) {
                return this.commandId;
            }
            if (ATTRIBUTE_PRIORITY.equals(attributeName)) {
                return this.priority;
            }
        }
        if (this.loadHandler()) {
            return this.handler.getAttributeValue(attributeName);
        }
        throw new NoSuchAttributeException("The proxy does not contain the information, and the real handler could not be loaded.");
    }

    public Set getDefinedAttributeNames() {
        if (this.loadHandler()) {
            return this.handler.getDefinedAttributeNames();
        }
        return Collections.EMPTY_SET;
    }
}

