/*
 * PHP4 Support
 *
 * Richard Palmer
 * richard@magicality.org
 * Nov 2001
 *
 * Portions copyright Sun Microsystems (c) 2001
 * Tim Hockin <thockin@sun.com>
 */

static char cvsroot[] = "$Header: /cvs/projects/SWIG/Source/Modules1.1/Attic/php4.cxx,v 1.1.2.25 2002/01/31 00:47:18 beazley Exp $";

#include <ctype.h>

#include "mod11.h"
#include "php4.h"
#include "swigconfig.h"

static char *usage = (char*)"\
PHP4 Options (available with -php4)\n\
	-shadow		- Create shadow classes.\n\
	-dlname name	- Set module prefix.\n\
	-make		- Create simple makefile.\n\
	-phpfull	- Create full make files.\n\
	-nosync		- No syncronisation of variables.\n\n";

#define PHP_READONLY	1<<0

static String *module = 0;
static String *cap_module = 0;
static String *dlname = 0;

static String *f_cinit = 0;
static String *f_oinit = 0;
static String *f_init = 0;
static String *f_entry = 0;
//static char	*package = 0;	// Name of the package
static char	*c_pkgstr;	// Name of the package
static char	*php_pkgstr;	// Name of the package
static char *shadow_classname;

static Wrapper	*f_c;
static Wrapper  *f_php;
static int	gen_extra = 0;
static int	gen_make = 0;
static int	no_sync = 0;

static File	  *f_runtime = 0;
static File	  *f_h = 0;
static File       *f_header  = 0;
static File       *f_wrappers = 0;
static File	  *f_phpcode = 0;

static String	  *s_header;
static String	  *s_wrappers;
static String	  *s_init;
static String	  *s_vinit;
static String	  *s_cinit;
static String	  *s_oinit;
static String	  *s_entry;
static String	  *pragma_incl;
static String	  *pragma_code;
static String	  *pragma_phpinfo;

/* Variables for using PHP classes */
static String	  *php;		/* Class initialization code */
static String	  *class_name = 0;
static String	  *base_class = 0;
static String	  *real_classname = 0;
static String	  *class_type = 0;
static String	  *realpackage = 0;
static String	  *package = 0;

static Hash	*shadow_classes;
static Hash	*shadow_php_vars;
static Hash	*shadow_c_vars;
static String	*shadow_classdef;
static String 	*shadow_code;
static char	*shadow_variable_name = 0;
static int	classdef_emitted = 0;
static int	have_default_constructor = 0;
static int	native_func = 0;	// Set to 1 when wrapping a native function
static int	enum_flag = 0; // Set to 1 when wrapping an enum
static int	static_flag = 0; // Set to 1 when wrapping a static functions or member variables
static int	const_flag = 0; // Set to 1 when wrapping a const member variables
static int	variable_wrapper_flag = 0; // Set to 1 when wrapping a member variable/enum/const
static int	wrapping_member = 0;
static int	written_base_class = 0; // XX hack to prevent base class duplicated

static String *shadow_enum_code = 0;
static String *php_enum_code = 0;
static String *all_shadow_extra_code = 0; 
		//Extra code for all shadow classes from %pragma
static String *this_shadow_extra_code = 0; 
		//Extra Code for current single shadow class freom %pragma
static String *all_shadow_import = 0; 
		//import for all shadow classes from %pragma
static String *this_shadow_import = 0; 
		//import for current shadow classes from %pragma
static String *module_baseclass = 0; 
		//inheritance for module class from %pragma
static String *all_shadow_baseclass = 0; 
		//inheritence for all shadow classes from %pragma
static String *this_shadow_baseclass = 0; 
		//inheritance for shadow class from %pragma and cpp_inherit
static int	  class_renamed = 0;
static int	  shadow	= 0;

/* Test to see if a type corresponds to something wrapped with a shadow class */
static String *is_shadow(SwigType *t) {
	String *r;
	SwigType *lt = SwigType_ltype(t);
	r = Getattr(shadow_classes,lt);
	Delete(lt);
	return r;
}

// Return the type of the c array
static SwigType *get_array_type(SwigType *t) {
  SwigType *ta = 0;
    if (SwigType_type(t) == T_ARRAY) {
        SwigType *aop;
        ta = Copy(t);
        aop = SwigType_pop(ta);
    }
    return ta;
}


static void emit_banner(File *f) {
Printf(f, "/* ----------------------------------------------------------------------------\n");
Printf(f, " * This file was automatically generated by SWIG (http://www.swig.org).\n");
Printf(f, " * Version: %s\n", SWIG_VERSION);
Printf(f, " *\n");
Printf(f, " * Do not make changes to this file unless you know what you are doing--modify\n");
Printf(f, " * the SWIG interface file instead.\n");
Printf(f, " * ----------------------------------------------------------------------------- */\n\n");
}

/* -----------------------------------------------------------------------------
 * get_pointer()
 * ----------------------------------------------------------------------------- */
static void
get_pointer(char *iname, char *srcname, char *src, char *dest,
            SwigType *t, String *f, char *ret) {

  SwigType_remember(t);
  SwigType *lt = SwigType_ltype(t);
  Printv(f, "if (SWIG_ConvertPtr(", src, ",(void **) ", dest, ",", 0);

  /* If we're passing a void pointer, we give the pointer conversion a NULL
     pointer, otherwise pass in the expected type. */

  if (Cmp(lt,"p.void") == 0) {
    Printf(f, " 0 ) < 0) {\n");
  } else {
    Printv(f, "SWIGTYPE", SwigType_manglestr(t), ") < 0) {\n",0);
  }

  Printv(f,
         "zend_error(E_ERROR, \"Type error in ", srcname, " of ", iname,
	 " Expected %s\", SWIGTYPE", SwigType_manglestr(t), "->name);\n", ret,
	 ";\n",
         "}\n",
         0);
  Delete(lt);
}


void
PHP4::main(int argc, char *argv[]) {
	int i;
	SWIG_library_directory("php4");
	for(i = 1; i < argc; i++) {
	  if (argv[i]) {
	    if(strcmp(argv[i], "-phpfull") == 0) {
	      gen_extra = 1;
	      Swig_mark_arg(i);
	    } else if(strcmp(argv[i], "-dlname") == 0) {
	      if (argv[i+1]) {
		  dlname = NewString(argv[i+1]);
		  Swig_mark_arg(i);
		  Swig_mark_arg(i+1);
		  i++;
	       } else {
		  Swig_arg_error();
	       }
	    }  else if(strcmp(argv[i], "-shadow") == 0) {
		shadow = 1;
		Swig_mark_arg(i);
	    } else if(strcmp(argv[i], "-make") == 0) {
		gen_make = 1;
		Swig_mark_arg(i);
	    } else if(strcmp(argv[i], "-nosync") == 0) {
		no_sync = 1;
		Swig_mark_arg(i);
	    } else if(strcmp(argv[i], "-help") == 0) {
	        fputs(usage, stderr);
	    }
	  }
	}
	  
	Preprocessor_define((void *) "SWIGPHP 1", 0);
	Preprocessor_define((void *) "SWIGPHP4 1", 0);
	SWIG_typemap_lang("php4");
	/* DB: Suggest using a language configuration file */
	SWIG_config_file("php4.swg");
}

static
void create_simple_make(void) {
	File *f_make;

	f_make = NewFile((void *)"makefile", "w");
	if(CPlusPlus)
		Printf(f_make, "CC=g++\n");
	else
		Printf(f_make, "CC=gcc\n");

	Printf(f_make,
	      "OBJS=%s_wrap.o\n"
	      "PROG=lib%s.so\n"
	      "CFLAGS=-fpic\n"
	      "LDFLAGS=-shared\n"
	      "PHP_INC=`php-config --includes`\n"
	      "EXTRA_INC=\n"
	      "EXTRA_LIB=\n\n",
	      module, module);

	Printf(f_make,
	      "$(PROG): $(OBJS)\n"
	      "\t$(CC) $(LDFLAGS) $(OBJS) -o $(PROG) $(EXTRA_LIB)\n\n"
	      "%%.o: %%.%s\n"
	      "\t$(CC) $(EXTRA_INC) $(PHP_INC) $(CFLAGS) -c $<\n",
	      (CPlusPlus?"cxx":"c"));

	Close(f_make);
}

static
void create_extra_files(void) {
	File *f_extra;

	if(gen_extra) {
		/* Write out Makefile.in */
        f_extra = NewFile((void *)"Makefile.in", "w");
        if (!f_extra) {
		Printf(stderr,"Unable to open Makefile.in\n");
		SWIG_exit(EXIT_FAILURE);
	}

	Printf(f_extra,
	    "# $Id: php4.cxx,v 1.1.2.25 2002/01/31 00:47:18 beazley Exp $\n\n");
	Printf(f_extra, "LTLIBRARY_NAME          = lib%s.la\n", module);
	Printf(f_extra, "LTLIBRARY_SOURCES       = %s_wrap.c\n", module);
	Printf(f_extra, "LTLIBRARY_SHARED_NAME   = %s.la\n", module);
	Printf(f_extra, "LTLIBRARY_SHARED_LIBADD = $(%s_SHARED_LIBADD)\n\n",
	    cap_module);
	Printf(f_extra, "include $(top_srcdir)/build/dynlib.mk\n");
	Close(f_extra);

	/* Now config.m4 */
	f_extra = NewFile((void *)"config.m4", "w");
	if (!f_extra) {
		Printf(stderr, "Unable to open config.m4\n");
		SWIG_exit(EXIT_FAILURE);
	}

	Printf(f_extra,
	    "dnl $Id: php4.cxx,v 1.1.2.25 2002/01/31 00:47:18 beazley Exp $\n");
	Printf(f_extra,
	    "dnl config.m4 for extension %s\n\n", module);
	Printf(f_extra,
	    "dnl Comments in this file start with the string 'dnl'.\n");
	Printf(f_extra,
	    "dnl Remove where necessary. This file will not work\n");
	Printf(f_extra,
	    "dnl without editing.\n\n");

	Printf(f_extra,
	    "dnl If your extension references somthing external, use:\n\n");
	Printf(f_extra,
	    "dnl PHP_ARG_WITH(%s, for %s support,\n", module, module);
	Printf(f_extra,
	    "dnl Make sure that the comment is aligned:\n");
	Printf(f_extra,
	    "dnl [  --with-%s           Include %s support])\n\n",
	    module, module);

	Printf(f_extra,
	    "dnl Otherwise use enable:\n\n");
	Printf(f_extra,
	    "PHP_ARG_ENABLE(%s, whether to enable %s support,\n",
	        module, module);
	Printf(f_extra,
	    "dnl Make sure that the comment is aligned:\n");
	Printf(f_extra,
	    "[  --enable-%s     Enable %s support])\n\n", module, module);

	Printf(f_extra,
	    "if test \"$PHP_%s\" != \"no\"; then\n", cap_module);
	Printf(f_extra,
	    "  dnl Write more examples of tests here\n\n");
	Printf(f_extra,
	    "  dnl # --with-%s -> check with-path\n", module);
	Printf(f_extra,
	    "  dnl # you might want to change this\n"
	    "  dnl SEARCH_PATH=\"/usr/local /usr\"\n");
	Printf(f_extra,
	    "  dnl # you most likely want to change this\n"
	    "  dnl SEARCH_FOR=\"/include/%s.h\"\n", module);
	Printf(f_extra,
	    "  dnl # path given as parameter\n"
	    "  dnl if test -r $PHP_%s/; then\n", module);
	Printf(f_extra,
	    "  dnl   %s_DIR=$PHP_%s\n", cap_module, cap_module);
	Printf(f_extra,
	    "  dnl else # search default path list\n");
	Printf(f_extra,
	    "  dnl   AC_MSG_CHECKING(for %s files in default path)\n", module);
	Printf(f_extra,
	    "  dnl   for i in $SEARCH_PATH; do\n");
	Printf(f_extra,
	    "  dnl     if test -r $i/$SEARCH_FOR; then\n");
	Printf(f_extra,
	    "  dnl       %s_DIR=$i\n", cap_module);
	Printf(f_extra,
	    "  dnl       AC_MSG_RESULT(found in $i)\n");
	Printf(f_extra,
	    "  dnl     fi\n");
	Printf(f_extra,
	    "  dnl   done\n");
	Printf(f_extra,
	    "  dnl fi\n");
	Printf(f_extra,
	    "  dnl\n");
	Printf(f_extra,
	    "  dnl if test -z \"$%s_DIR\"; then\n", cap_module);
	Printf(f_extra,
	    "  dnl   AC_MSG_RESULT(not found)\n");
	Printf(f_extra,
	    "  dnl   AC_MSG_ERROR(Please reinstall the %s distribution)\n",
	    module);
	Printf(f_extra,
	    "  dnl fi\n\n");
	Printf(f_extra,
	    "  dnl # --with-%s -> add include path\n", module);
	Printf(f_extra,
	    "  dnl PHP_ADD_INCLUDE($%s_DIR/include)\n\n", cap_module);
	Printf(f_extra,
	    "  dnl #--with-%s -> check for lib and symbol presence\n", module);
	Printf(f_extra,
	    "  dnl LIBNAME=%s # you may want to change this\n", module);
	Printf(f_extra,
	    "  dnl LIBSYMBOL=%s #  you most likely want to change this\n",
	    module);
	Printf(f_extra,
	    "  dnl old_LIBS=$LIBS\n");
	Printf(f_extra,
	    "  dnl LIBS=\"$LIBS -L$%s_DIR/lib -lm -ldl\"\n", cap_module);
	Printf(f_extra,
	    "  dnl AC_CHECK_LIB($LIBNAME, $LIBSYMBOL, [AC_DEFINE(HAVE_%sLIB,1,[ ])],\n",
	    cap_module);
	Printf(f_extra,
	    "  dnl [AC_MSG_ERROR(wrong %s lib version or lib not found)])\n",
	    module);
	Printf(f_extra,
	    "  dnl LIBS=$old_LIBS\n");
	Printf(f_extra,
	    "  dnl\n");
	Printf(f_extra,
	    "  dnl PHP_SUBST(%s_SHARED_LIBADD)\n", cap_module);
	Printf(f_extra,
	    "  dnl PHP_ADD_LIBRARY_WITH_PATH($LIBNAME, $%s_DIR/lib, SAPRFC_SHARED_LIBADD)\n\n",
	    cap_module);
	Printf(f_extra,
	    "  PHP_EXTENSION(%s, $ext_shared)\n", module);
	Printf(f_extra,"fi\n");
	Close(f_extra);

	/*  CREDITS */
	f_extra = NewFile((void *)"CREDITS", "w");
	if (!f_extra) {
		Printf(stderr,"Unable to open CREDITS\n");
		SWIG_exit(EXIT_FAILURE);
	}
	Printf(f_extra, "%s\n", module);
	Close(f_extra);
  }
}

static const char *php_header =
"/*"
"\n  +----------------------------------------------------------------------+"
"\n  | PHP version 4.0                                                      |"
"\n  +----------------------------------------------------------------------+"
"\n  | Copyright (c) 1997, 1998, 1999, 2000, 2001 The PHP Group             |"
"\n  +----------------------------------------------------------------------+"
"\n  | This source file is subject to version 2.02 of the PHP license,      |"
"\n  | that is bundled with this package in the file LICENSE, and is        |"
"\n  | available at through the world-wide-web at                           |"
"\n  | http://www.php.net/license/2_02.txt.                                 |"
"\n  | If you did not receive a copy of the PHP license and are unable to   |"
"\n  | obtain it through the world-wide-web, please send a note to          |"
"\n  | license@php.net so we can mail you a copy immediately.               |"
"\n  +----------------------------------------------------------------------+"
"\n  | Authors:                                                             |"
"\n  |                                                                      |"
"\n  +----------------------------------------------------------------------+"
"\n */\n";

int
PHP4::top(Node *n) {

  String *filen;
  String *outfile;

  /* Initialize all of the output files */
  outfile = Getattr(n,"outfile");
  
  /* main output file */
  f_runtime = NewFile(outfile,"w");
  if (!f_runtime) {
	Printf(stderr,"*** Can't open '%s'\n", outfile);
	SWIG_exit(EXIT_FAILURE);
  }
  
  Swig_banner(f_runtime);

  /* sections of the output file */
  s_init = NewString("/* init section */\n");
  s_header = NewString("/* header section */\n");
  s_wrappers = NewString("/* wrapper section */\n");
  /* subsections of the init section */
  s_vinit = NewString("/* vinit subsection */\n");
  s_cinit = NewString("/* cinit subsection */\n");
  s_oinit = NewString("/* oinit subsection */\n");

  pragma_phpinfo = NewString("");


  /* Register file targets with the SWIG file handler */
  Swig_register_filebyname("runtime",f_runtime);
  Swig_register_filebyname("init",s_init);
  Swig_register_filebyname("header",s_header);
  Swig_register_filebyname("wrapper",s_wrappers);

  shadow_classes = NewHash();
  shadow_classdef = NewString("");
  shadow_code = NewString("");
  php_enum_code = NewString("");
  module_baseclass = NewString("");
  all_shadow_extra_code = NewString("");
  all_shadow_import = NewString("");
  all_shadow_baseclass = NewString("");
  
  /* Set the module name */
  module = Copy(Getattr(n,"name"));
  cap_module = NewStringf("%(upper)s",module);

  if(shadow) {
	realpackage = module;
	package = NewStringf("%sc", module);
   }

  /* Set the dlname */
  if (!dlname) {
#if defined(_WIN32) || defined(__WIN32__)
	 dlname = NewStringf("%s.dll", module);
#else
	 dlname = NewStringf("lib%s.so", module);
#endif
  }

  /* PHP module file */
  filen = NewString(module);
  Printf(filen, ".php");
  f_phpcode = NewFile(filen, "w");
  if (!f_phpcode) {
	  Printf(stderr, "*** Can't open '%s'\n", filen);
	  SWIG_exit(EXIT_FAILURE);
  }

  Printf(f_phpcode, "<?php\n\n");

  emit_banner(f_phpcode);

  Printf(f_phpcode,
	"global $%s_LOADED__;\n"
	"if ($%s_LOADED__) return;\n"
	"$%s_LOADED__ = true;\n\n"
	"/* if our extension has not been loaded, do what we can */\n"
	"if (!extension_loaded(\"%s\")) {\n"
	"	if (!dl(\"%s\")) return;\n"
	"}\n\n", cap_module, cap_module, cap_module, module, dlname);


  /* sub-sections of the php file */
  pragma_code = NewString("");
  pragma_incl = NewString("");

  /* Initialize the rest of the module */

  f_c = NewWrapper();
  f_php = NewWrapper();
  Printf(f_c->def, "static void Swig_sync_c(void) {\n");
  Printf(f_php->def, "static void Swig_sync_php(void) {\n");
  
  /* start the header section */
  Printf(s_header, php_header);
  Printf(s_header,
      "#define SWIG_init	init%s\n\n"
      "#define SWIG_name	\"%s\"\n"
      "#ifdef HAVE_CONFIG_H\n"
      "#include \"config.h\"\n"
      "#endif\n\n"
      "#ifdef __cplusplus\n"
      "extern \"C\" {\n"
      "#endif\n"
      "#include \"php.h\"\n"
      "#include \"php_ini.h\"\n"
      "#include \"php_%s.h\"\n"
      "#ifdef __cplusplus\n"
      "}\n"
      "#endif\n\n",
      module, module, module);

  /* Create the .h file too */
  filen = NewString("");
  Printv(filen, Swig_file_dirname(outfile), "php_", module, ".h", 0);
  f_h = NewFile(filen, "w");
  if (!f_h) {
	Printf(stderr,"Unable to open %s\n", filen);
	SWIG_exit(EXIT_FAILURE);
  }

  Swig_banner(f_h);
  Printf(f_h, php_header);

   Printf(f_h, "\n\n"
      "#ifndef PHP_%s_H\n"
      "#define PHP_%s_H\n\n"
      "extern zend_module_entry %s_module_entry;\n"
      "#define phpext_%s_ptr &%s_module_entry\n\n"
      "#ifdef PHP_WIN32\n"
      "# define PHP_%s_API __declspec(dllexport)\n"
      "#else\n"
      "# define PHP_%s_API\n"
      "#endif\n\n"
      "PHP_MINIT_FUNCTION(%s);\n"
      "PHP_MSHUTDOWN_FUNCTION(%s);\n"
      "PHP_RINIT_FUNCTION(%s);\n"
      "PHP_RSHUTDOWN_FUNCTION(%s);\n"
      "PHP_MINFO_FUNCTION(%s);\n\n",
      cap_module, cap_module, module, module, module, cap_module, cap_module,
      module, module, module, module, module);

  /* start the function entry section */
  s_entry = NewString("/* entry subsection */\n");
  Printf(s_entry, "static void Swig_sync_c(void);\n");
  Printf(s_entry, "static void Swig_sync_php(void);\n\n");

  Printf(s_entry,"/* Every user visible function must have an entry */\n");
  Printf(s_entry,"function_entry %s_functions[] = {\n", module);

  /* Start variable init function (to be put in module init function) */
  Printf(s_cinit,
	"    int i;\n"
	"    for (i = 0; swig_types_initial[i]; i++) {\n"
	"        swig_types[i] = SWIG_TypeRegister(swig_types_initial[i]);\n"
	"    }\n");

  /* start the init section */
  if (gen_extra)
	Printf(s_init,"#ifdef COMPILE_DL_%s\n", cap_module);
  Printf(s_init,
	"#ifdef __cplusplus\n"
  	"extern \"C\" {\n"
	"#endif\n"
	"ZEND_GET_MODULE(%s)\n"
	"#ifdef __cplusplus\n"
	"}\n"
	"#endif\n\n",
	module);
  if (gen_extra)
	Printf(s_init,"#endif\n\n");

  Printf(s_init,"PHP_MINIT_FUNCTION(%s)\n{\n", module);
  Printf(s_init,"    return SUCCESS;\n");
  Printf(s_init,"}\n");

  Printf(s_init,"PHP_MSHUTDOWN_FUNCTION(%s)\n{\n", module);
  Printf(s_init,"    return SUCCESS;\n");
  Printf(s_init,"}\n");


  /* finish our init section */
  Printf(s_vinit, "/* end vinit subsection */\n");

  /* We need this after all classes written out, not sure where to put it
   * but here.
   */
  Printf(s_oinit, "CG(active_class_entry) = NULL;\n");	

  Printf(s_oinit, "/* end oinit subsection */\n");
  Printf(s_init,"PHP_RINIT_FUNCTION(%s)\n{\n", module);

  /* Emit all of the code */
  Language::top(n);
  
  /* Constants generated during top call */
  Printf(s_init, "%s\n", s_cinit); 
  Printf(s_cinit, "/* end cinit subsection */\n");

  Printf(s_init, "%s\n%s\n", s_vinit, s_oinit);
  Delete(s_cinit);
  Delete(s_vinit);

  Printf(s_init, "    return SUCCESS;\n");
  Printf(s_init,"}\n");

  Printf(s_init,"PHP_RSHUTDOWN_FUNCTION(%s)\n{\n", module);
  Printf(s_init,"    return SUCCESS;\n");
  Printf(s_init,"}\n");

  Printf(s_init,"PHP_MINFO_FUNCTION(%s)\n{\n", module);
  Printf(s_init,"%s", pragma_phpinfo);
  Printf(s_init,"}\n");
  Printf(s_init, "/* end init section */\n");

  /* Complete header file */

  Printf(f_h,
    "/*If you declare any globals in php_%s.h uncomment this:\n", module);
  Printf(f_h,"ZEND_BEGIN_MODULE_GLOBALS(%s)\n", module);
  Printf(f_h,"ZEND_END_MODULE_GLOBALS(%s)\n", module);
  Printf(f_h,"*/\n");

  Printf(f_h,"#ifdef ZTS\n");
  Printf(f_h,"#define %s_D  zend_%s_globals *%s_globals\n", cap_module,
    module, module);
  Printf(f_h,"#define %s_DC  , %s_D\n",  cap_module, cap_module);
  Printf(f_h,"#define %s_C  %s_globals\n", cap_module, module);
  Printf(f_h,"#define %s_CC  , %s_C\n", cap_module, cap_module);
  Printf(f_h,"#define %s_SG(v)  (%s_globals->v)\n", cap_module, module);
  Printf(f_h,"#define %s_FETCH()  zend_%s_globals *%s_globals "
    "= ts_resource(%s_globals_id)\n", cap_module, module, module, module);
  Printf(f_h,"#else\n");
  Printf(f_h,"#define %s_D\n", cap_module);  
  Printf(f_h,"#define %s_DC\n", cap_module);
  Printf(f_h,"#define %s_C\n", cap_module);
  Printf(f_h,"#define %s_CC\n", cap_module);
  Printf(f_h,"#define %s_SG(v)  (%s_globals.v)\n", cap_module, module);
  Printf(f_h,"#define %s_FETCH()\n", cap_module);
  Printf(f_h,"#endif\n\n");
  Printf(f_h,"#endif /* PHP_%s_H */\n", cap_module);
	
  Close(f_h);

  Printf(s_header, "%s", s_entry);

  Printf(s_header,"	{NULL, NULL, NULL}\n};\n\n");
  Printf(s_header,"zend_module_entry %s_module_entry = {\n", module);
  Printf(s_header,"#if ZEND_MODULE_API_NO > 20010900\n");
  Printf(s_header,"    STANDARD_MODULE_HEADER,\n");
  Printf(s_header,"#endif\n");
  Printf(s_header,"    \"%s\",\n", module);
  Printf(s_header,"    %s_functions,\n", module);
  Printf(s_header,"    PHP_MINIT(%s),\n", module);
  Printf(s_header,"    PHP_MSHUTDOWN(%s),\n", module);
  Printf(s_header,"    PHP_RINIT(%s),\n", module);
  Printf(s_header,"    PHP_RSHUTDOWN(%s),\n", module);
  Printf(s_header,"    PHP_MINFO(%s),\n", module);
  Printf(s_header,"#if ZEND_MODULE_API_NO > 20010900\n");
  Printf(s_header,"    NO_VERSION_YET,\n");
  Printf(s_header,"#endif\n");
  Printf(s_header,"    STANDARD_MODULE_PROPERTIES\n");
  Printf(s_header,"};\n\n");

  Printv(f_runtime, s_header, 0);

  String *type_table = NewString("");
  SwigType_emit_type_table(f_runtime,type_table);
  Printf(f_runtime,"%s",type_table);
  Delete(type_table);

  Printf(f_c->code, "\n}\n");
  Printf(f_php->code, "\n}\n");

  Wrapper_print(f_c, s_wrappers);
  Wrapper_print(f_php, s_wrappers);

  Printf(s_header, "/* end header section */\n");
  Printf(s_wrappers, "/* end wrapper section */\n");
 
  Printv(f_runtime, s_wrappers, s_init, 0);
  Delete(s_header);
  Delete(s_wrappers);
  Delete(s_init);
  Close(f_runtime);
  Printf(f_phpcode, "%s\n%s\n?>\n", pragma_incl, pragma_code);
  Close(f_phpcode); 

  create_extra_files();

  if(!gen_extra && gen_make)
	  create_simple_make();

  return SWIG_OK;
}


#if 0
void
PHP4::set_module(char *mod_name) {
	char *c;
	if(module) return;
	module = NewString(mod_name);
	cap_module = Copy(module);
	for(c = Char(cap_module); *c != '\0'; c++) {
		if((*c >= 'a') && (*c <= 'z'))
			*c-=32;	
	}
}

#endif

/*
void
PHP4::add_method(char *name, char *function, int kw) {
	fprintf(stderr, "Would add method %s\n", name);
}
*/

/* Just need to append function names to function table to register with
   PHP
*/

void
PHP4::create_command(char *cname, char *iname) {
	char *lower_cname = strdup(cname);
	char *c;

	for(c = lower_cname; *c != '\0'; c++) {
		if(*c >= 'A' && *c <= 'Z')
			*c = *c + 32;
	}

	Printf(s_entry,
	    "	ZEND_NAMED_FE(%s,\n"
	    "		%s, NULL)\n", lower_cname,iname);
	Printf(f_h, "ZEND_NAMED_FUNCTION(%s);\n", iname);

	free(lower_cname);
}

int
PHP4::functionWrapper(Node *n) {
  char *name = GetChar(n,"name");
  char *iname = GetChar(n,"sym:name");
  SwigType *d = Getattr(n,"type");
  ParmList *l = Getattr(n,"parms");
  Parm *p;
  char source[256],target[256],temp[256],argnum[32],args[32];
  int pcount,i,j,numopt;
  String *tm;
  Wrapper *f;
  int need_save, num_saved = 0;
  String *cleanup, *outarg;

  if(shadow && wrapping_member && !enum_flag) {
    String *member_function_name = NewString("");
    String *php_function_name = NewString(iname);
    if(strcmp(iname, Char(Swig_name_set(Swig_name_member(shadow_classname, shadow_variable_name)))) == 0) {
	Printf(member_function_name, "set");
    	if(!no_sync) {
	  Setattr(shadow_c_vars, php_function_name, name);
	}
    } else {
	Printf(member_function_name, "get");
	if(!no_sync) 
	   Setattr(shadow_php_vars, php_function_name, name);
    }
    Putc(toupper((int )*shadow_variable_name), member_function_name);
    Printf(member_function_name, "%s", shadow_variable_name+1);

    cpp_func(Char(member_function_name), d, l, php_function_name);

    Delete(php_function_name);
    Delete(member_function_name);
  }

  if(!shadow)
	  create_command(iname, Char(Swig_name_wrapper(iname)));

  outarg = cleanup = NULL;
  f 	= NewWrapper();
  numopt = 0;

  outarg = NewString("");

  Printv(f->def, "ZEND_NAMED_FUNCTION(" , Swig_name_wrapper(iname), ") {\n", 0);

  emit_args(d, l, f);
  /* Attach standard typemaps */
  emit_attach_parmmaps(l,f);

  int num_arguments = emit_num_arguments(l);
  int num_required  = emit_num_required(l);
  numopt = num_arguments - num_required;

  sprintf(args, "%s[%d]", "zval **args", num_arguments); 
  
  Wrapper_add_local(f, "args",args);

  Printf(f->code, "Swig_sync_c();\n\n");/* Keep PHP4 / C vars in sync */

  if(numopt > 0) {
    Wrapper_add_local(f, "arg_count", "int arg_count");
    Printf(f->code,"arg_count = ZEND_NUM_ARGS();\n");
    Printf(f->code,"if(arg_count<%d || arg_count>%d)\n",num_required,num_arguments);
    Printf(f->code,"\tWRONG_PARAM_COUNT;\n\n");

    /* Verified args, retrieve them... */
    Printf(f->code,"if(zend_get_parameters_array_ex(arg_count,args)!=SUCCESS)");
    Printf(f->code, "\n\t\tWRONG_PARAM_COUNT;\n\n");

  } else {
   Printf(f->code, "if((ZEND_NUM_ARGS() != %d) || (zend_get_parameters_array_ex(%d, args) != SUCCESS)) {\n", num_arguments, num_arguments);
   Printf(f->code, "WRONG_PARAM_COUNT;\n}\n\n");
  }
  
  /* Now convert from php to C variables */

  for (i = 0, p = l; i < num_arguments; i++) {
    /* Skip ignored arguments */
    while (Getattr(p,"tmap:ignore")) {
      p = Getattr(p,"tmap:ignore:next");
    }
    SwigType *pt = Getattr(p,"type");
    String   *pn = Getattr(p,"name");

    sprintf(source, "args[%d]", i);
    sprintf(target, "%s", Char(Getattr(p,"lname")));
    sprintf(argnum, "%d", i+1);

    /* Check if optional */
    
    if(i>= (num_required))
      Printf(f->code,"\tif(arg_count > %d) {\n", i);
    
    Setattr(p,"emit:input", source);

    if ((tm = Getattr(p,"tmap:in"))) {
      Replace(tm,"$target",target,DOH_REPLACE_ANY);
      Replace(tm,"$source",source,DOH_REPLACE_ANY);
      Replace(tm,"$input", source,DOH_REPLACE_ANY);
      Printf(f->code,"%s\n",tm);
      p = Getattr(p,"tmap:in:next");
      if (i >= num_required) {
	Printf(f->code,"}\n");
      }
      continue;
    } else {
      switch(SwigType_type(pt)) {
      case T_BOOL:
      case T_INT :
      case T_SHORT :
      case T_LONG :
      case T_SCHAR :
      case T_UINT :
      case T_USHORT :
      case T_ULONG :
      case T_UCHAR :
	Printf(f->code,"convert_to_long_ex(args[%d]);\n", i);
	Printf(f->code,"%s =(%s)Z_LVAL_PP(args[%d]);\n", target, SwigType_lstr(pt,0),i);
	break;
      case T_CHAR :
	Printf(f->code,"convert_to_string_ex(args[%d]);\n", i);
	Printf(f->code,"\t%s = (char) *Z_STRVAL_PP(args[%d]);\n", target, i);
	break;
      case T_DOUBLE :
      case T_FLOAT :
	Printf(f->code,"convert_to_double_ex(args[%d]);\n", i);
	Printf(f->code,"\t%s = (%s)Z_DVAL_PP(args[%d]);\n", target, SwigType_lstr(pt,0), i);
	break;
      case T_VOID :
	break;
      case T_USER :
	SwigType_add_pointer(pt);
	sprintf(temp,"argument %d", i+1);
	Printf(f->code,"convert_to_string_ex(args[%d]);\n", i);
	get_pointer(iname, temp, source, target, pt, f->code, (char *)"RETURN_FALSE");
	SwigType_del_pointer(pt);
	break;
      case T_POINTER: case T_ARRAY: case T_REFERENCE:
	sprintf(temp,"argument %d", i+1);
	Printf(f->code,"convert_to_string_ex(args[%d]);\n", i);
	get_pointer(iname,temp,source,target, pt, f->code, (char *)"");
	break;
      case T_STRING:
	Printf(f->code,"convert_to_string_ex(args[%d]);\n", i);
	Printf(f->code,"\t%s = (char *)Z_STRVAL_PP(args[%d]);\n", target, i);
	break;
      default :
	Printf(stderr,"%s : Line %d, Unable to use type %s as a function argument.\n", input_file, line_number, SwigType_str(pt,0));
	break;
      }
      p = nextSibling(p);
    }
    if (i>= num_required)
      Printf(f->code,"\t}\n");
  }

  /* Insert constraint checking code */
  for (p = l; p;) {
    if ((tm = Getattr(p,"tmap:check"))) {
      Replace(tm,"$target",Getattr(p,"lname"),DOH_REPLACE_ANY);
      Printv(f->code,tm,"\n",0);
      p = Getattr(p,"tmap:check:next");
    } else {
      p = nextSibling(p);
    }
  }
  
  /* Insert cleanup code */
  for (i = 0, p = l; p; i++) {
    if ((tm = Getattr(p,"tmap:freearg"))) {
      Replace(tm,"$source",Getattr(p,"lname"),DOH_REPLACE_ANY);
      Printv(cleanup,tm,"\n",0);
      p = Getattr(p,"tmap:freearg:next");
    } else {
      p = nextSibling(p);
    }
  }

  /* Insert argument output code */
  num_saved = 0;
  for (i=0,p = l; p;i++) {
    if ((tm = Getattr(p,"tmap:argout"))) {
      Replace(tm,"$source",Getattr(p,"lname"),DOH_REPLACE_ANY);
      Replace(tm,"$input",Getattr(p,"lname"),DOH_REPLACE_ANY);
      Replace(tm,"$target","return_value",DOH_REPLACE_ANY);
      Replace(tm,"$result","return_value",DOH_REPLACE_ANY);
      String *in = Getattr(p,"emit:input");
      if (in) {
	sprintf(temp,"_saved[%d]", num_saved);
	Replace(tm,"$arg",temp, DOH_REPLACE_ANY);
	Printf(f->code,"_saved[%d] = %s;\n", num_saved, in);
	num_saved++;
      }
      Printv(outarg,tm,"\n",0);
      p = Getattr(p,"tmap:argout:next");
    } else {
      p = nextSibling(p);
    }
  }

  if(num_saved) {
    sprintf(temp, "_saved[%d]",num_saved);
    Wrapper_add_localv(f,"_saved","zval *",temp,0);
  }

  /* emit function call*/
  
  emit_action(n,f);

  if((tm = Swig_typemap_lookup((char*)"out",d,iname,(char*)"result",(char*)"result",(char*)"return_value",0))) {
    Replaceall(tm, "$input", "result");
    Replaceall(tm, "$source", "result");
    Replaceall(tm, "$target", "return_value");
    Printf(f->code, "%s\n", tm);
  } else {
    if(SwigType_type(d) != T_VOID) {
      switch(SwigType_type(d)) {
      case T_INT:
      case T_BOOL:
      case T_UINT:
      case T_SHORT:
      case T_USHORT:
      case T_LONG:
      case T_ULONG:
      case T_SCHAR:
      case T_UCHAR:
	Printf(f->code,"RETURN_LONG((long)result);\n");
	break;
      case T_DOUBLE:
      case T_FLOAT:
	Printf(f->code,"RETURN_DOUBLE((double)result);\n");
	break;
      case T_CHAR:
	Wrapper_add_local(f,"_ctemp","char ctemp[2]");
	Printv(f->code,
	       tab4, "ctemp[0] = result;\n",
	       tab4, "ctemp[1] = 0;\n",
	       tab4, "RETURN_STRING(ctemp, 1);\n", 0);
	break;
      case T_USER:
	SwigType_add_pointer(d);
	SwigType_remember(d);
	Printv(f->code, "SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE", SwigType_manglestr(d), ");\n", 0);
	SwigType_del_pointer(d);
	break;
      case T_STRING:
	Printf(f->code,"RETURN_STRING(result, 1);\n");
	break;
	
      case T_POINTER:
	SwigType_remember(d);
	Printv(f->code, tab4, "SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE", SwigType_manglestr(d), ");\n", 0);
	break;
      default:
	Printf(stderr,"%s: Line %d, Unable to use return type %s in function %s.\n", input_file, line_number, SwigType_str(d,0), name);
	break;
	
      }
    }
  }
  
  if(outarg)
    Printv(f->code,outarg,0);
  
  if(cleanup)
    Printv(f->code,cleanup,0);
  
  if((tm = Swig_typemap_lookup((char*)"ret",d,iname,(char *)"result", (char*)"result",(char*)"",0))) {
    Printf(f->code,"%s\n", tm);
  }
  
  Replaceall(f->code,"$cleanup",cleanup);
  Replaceall(f->code,"$symname",iname);
  
  Printf(f->code, "\nSwig_sync_php();\n");
  Printf(f->code, "\n}");
  
  Wrapper_print(f,s_wrappers);
  return SWIG_OK;
}

int
PHP4::variableWrapper(Node *n) {
  char *name = GetChar(n,"name");
  char *iname = GetChar(n,"sym:name");
  SwigType *t = Getattr(n,"type");
  int flags = 0;

  if(ReadOnly) {
	  flags |= PHP_READONLY;
  }


  SwigType_remember(t);

  /* Write out initilization code */
  
  switch(SwigType_type(t)) {
  case T_INT:
  case T_BOOL:
  case T_UINT:
  case T_SHORT:
  case T_USHORT:
  case T_LONG:
  case T_ULONG:
  case T_SCHAR:
  case T_UCHAR:
	Printf(s_vinit,
	    "{\n"
	    "    zval *z_var;\n"
	    "    MAKE_STD_ZVAL(z_var);\n"
	    "    z_var->type = IS_LONG;\n"
	    "    z_var->value.lval = %s;\n"
	    "    zend_hash_add(&EG(symbol_table), \"%s\", %d,"
	    "        (void *)&z_var, sizeof(zval *), NULL);\n"
	    "}\n", name, name, strlen(name)+1);
	break;

  case T_DOUBLE:
  case T_FLOAT:
	Printf(s_vinit,
	    "{\n"
	    "    zval *z_var;\n"
	    "    MAKE_STD_ZVAL(z_var);\n"
	    "    z_var->type = IS_DOUBLE;\n"
	    "    z_var->value.dval = %s;\n"
	    "    zend_hash_add(&EG(symbol_table), \"%s\", %d,"
	    "        (void *)&z_var, sizeof(zval *), NULL);\n"
	    "}\n", name, name, strlen(name)+1);
	break;

  case T_CHAR:
	Printf(s_vinit,
	    "{\n"
	    "    zval *z_var;\n"
	    "    char c[2];\n"
	    "    MAKE_STD_ZVAL(z_var);\n"
	    "    c[0] = %s;\n"
	    "    c[1] = 0;\n"
	    "    z_var->type = IS_STRING;\n"
	    "    z_var->value.str.val = estrdup(c);\n"
	    "    z_var->value.str.len = 2;\n"
	    "    zend_hash_add(&EG(symbol_table), \"%s\", %d,"
	    "        (void *)&z_var, sizeof(zval *), NULL);\n"
	    "}\n", name, name, strlen(name)+1);
	break;

  case T_STRING:
	Printf(s_vinit,
	    "{\n"
	    "    zval *z_var;\n"
	    "    MAKE_STD_ZVAL(z_var);\n"
	    "    z_var->type = IS_STRING;\n"
	    "    if(%s) {\n"
	    "        z_var->value.str.val = estrdup(%s);\n"
	    "        z_var->value.str.len = strlen(%s)+1;\n"
	    "    } else {\n"
	    "        z_var->value.str.val = 0;\n"
	    "        z_var->value.str.len = 0;\n"
	    "    }\n"
	    "    zend_hash_add(&EG(symbol_table), \"%s\", %d,"
	    "        (void *)&z_var, sizeof(zval *), NULL);\n"
	    "}\n", name, name, name, name, strlen(name)+1);

	break;

  case T_USER:
	SwigType_add_pointer(t);
	Printf(s_vinit,
	    "{\n"
	    "    zval *z_var;\n"
	    "    MAKE_STD_ZVAL(z_var);\n"
	    "    SWIG_SetPointerZval(z_var, (void*)&%s, SWIGTYPE%s);\n"
	    "    zend_hash_add(&EG(symbol_table), \"%s\", %d, "
	    "        (void *)&z_var, sizeof(zval *), NULL);\n"
	    "}\n", name, SwigType_manglestr(t), name, strlen(name)+1);
	SwigType_del_pointer(t);
	break;
  case T_ARRAY:
	{
	int setable = 0;
	SwigType *aop;
	SwigType *ta = Copy(t);
	aop = SwigType_pop(ta);
	if(SwigType_type(ta) == T_CHAR) {
		String *dim = SwigType_array_getdim(aop, 0);
	        Printf(s_vinit,
		    "{\n"
		    "    zval *z_var;\n"
		    "    MAKE_STD_ZVAL(z_var);\n"
		    "    z_var->type = IS_STRING;\n"
		    "    if(%s) {\n"
		    "        z_var->value.str.val = estrndup(%s, %s);\n"
		    "        z_var->value.str.len = strlen(%s)+1;\n"
		    "    }\n"
		    "    zend_hash_add(&EG(symbol_table), \"%s\", %d,"
		    "        (void *)&z_var, sizeof(zval *), NULL);\n"
		    "}\n", name, name, Char(dim), name, name, strlen(name)+1);
	} else {
		Printf(s_vinit,
		    "{\n"
		    "    zval *z_var;\n"
		    "    MAKE_STD_ZVAL(z_var);\n"
		    "    SWIG_SetPointerZval(z_var, (void *)%s, SWIGTYPE%s);\n"
		    "    zend_hash_add(&EG(symbol_table), \"%s\", %d,"
		    "        (void *)&z_var, sizeof(zval *), NULL);\n"
		    "}\n", name, SwigType_manglestr(t), name, strlen(name)+1);
	}
	Delete(ta);
	Delete(aop);
	}
	break;
  case T_POINTER:
  case T_REFERENCE:
	Printf(s_vinit, "{\n\tzval *z_var;\n");
	Printf(s_vinit, "\tMAKE_STD_ZVAL(z_var);\n");
	Printf(s_vinit, "\tSWIG_SetPointerZval(z_var, (void*)%s, SWIGTYPE%s);\n", name,SwigType_manglestr(t));
	Printf(s_vinit, "\tzend_hash_add(&EG(symbol_table), \"%s\", %d, (void *)&z_var, sizeof(zval *), NULL);\n}\n", name, strlen(name)+1);
	Printf(s_vinit,
	    "{\n"
	    "    zval *z_var;\n"
	    "    MAKE_STD_ZVAL(z_var);\n"
	    "    SWIG_SetPointerZval(z_var, (void*)%s, SWIGTYPE%s);\n"
            "    zend_hash_add(&EG(symbol_table), \"%s\", %d,"
	    "        (void *)&z_var, sizeof(zval *), NULL);\n"
	    "}\n", name, SwigType_manglestr(t), name, strlen(name)+1);

	break;
  default:
	/* error */
	break;
  }


  /* Now code to set php values */

  switch(SwigType_type(t)) {
  case T_INT:
  case T_BOOL:
  case T_UINT:
  case T_SHORT:
  case T_USHORT:
  case T_LONG:
  case T_ULONG:
  case T_SCHAR:
  case T_UCHAR:
	Wrapper_add_local(f_php, "z_var", "zval **z_var");
	Printf(f_php->code, "zend_hash_find(&EG(symbol_table), \"%s\", %d, (void **)&z_var);\n", name, strlen(name)+1);
	Printf(f_php->code, "if(%s != (%s)((*z_var)->value.lval)) {\n", name, SwigType_lstr(t, 0));
	Printf(f_php->code, "(*z_var)->value.lval = (long)%s;\n", name);
	Printf(f_php->code, "}\n");
	break;

  case T_DOUBLE:
  case T_FLOAT:
	Wrapper_add_local(f_php, "z_var", "zval **z_var");
	Printf(f_php->code, "zend_hash_find(&EG(symbol_table), \"%s\", %d, (void **)&z_var);\n", name, strlen(name)+1);
	Printf(f_php->code, "if(%s != (%s)((*z_var)->value.dval)) {\n", name, SwigType_lstr(t, 0));
	Printf(f_php->code, "(*z_var)->value.dval = (double)%s;\n", name);
	Printf(f_php->code, "}\n");
	break;
  case T_CHAR:
	Wrapper_add_local(f_php, "z_var", "zval **z_var");
	Printf(f_php->code, "zend_hash_find(&EG(symbol_table), \"%s\", %d, (void **)&z_var);\n", name, strlen(name)+1);
	Printf(f_php->code, "if(%s != *((*z_var)->value.str.val)) {\n", name);
	Printf(f_php->code, "char c[2];\n");
	Printf(f_php->code, "efree((*z_var)->value.str.val);\n"); 
	Printf(f_php->code, "c[0] = %s;\n", name);
	Printf(f_php->code, "c[1] = 0;\n");
	Printf(f_php->code, "(*z_var)->value.str.val = estrdup(c);\n");
	Printf(f_php->code, "}\n");
	break;
  case T_STRING:
	Wrapper_add_local(f_php, "z_var", "zval **z_var");
	Wrapper_add_local(f_php, "s1", "char *s1");
	Printf(f_php->code, "zend_hash_find(&EG(symbol_table), \"%s\", %d, (void **)&z_var);\n", name, strlen(name)+1);
	Printf(f_php->code, "s1 = Z_STRVAL_PP(z_var);\n");
	Printf(f_php->code, "if((s1 == NULL) || (%s == NULL) || zend_binary_strcmp(s1, strlen(s1), %s, strlen(%s) )) {\n", name, name, name);
	Printf(f_php->code, "if(s1)\n");
	Printf(f_php->code, "efree(s1);\n");
	Printf(f_php->code, "if(%s) {\n", name);
	Printf(f_php->code, "(*z_var)->value.str.val = estrdup(%s);\n", name);
	Printf(f_php->code, "(*z_var)->value.str.len = strlen(%s)+1;\n", name);
	Printf(f_php->code, "} else {\n");
	Printf(f_php->code, "(*z_var)->value.str.val = 0;\n");
	Printf(f_php->code, "(*z_var)->value.str.len = 0;\n");
	Printf(f_php->code, "}\n}\n");
	break;
  case T_USER:
	SwigType_add_pointer(t);
	Wrapper_add_local(f_php, "z_var", "zval **z_var");
	Printf(f_php->code, "{\nzend_hash_find(&EG(symbol_table), \"%s\", %d, (void **)&z_var);\n", name, strlen(name)+1);
	Printf(f_php->code, "SWIG_SetPointerZval(*z_var, (void*)&%s, SWIGTYPE%s);\n", name, SwigType_manglestr(t));
	Printf(f_php->code, "}\n");
	SwigType_del_pointer(t);
	break;
  case T_ARRAY:
	{
	int setable = 0;
	SwigType *aop;
	SwigType *ta = Copy(t);
	aop = SwigType_pop(ta);
	if(SwigType_type(ta) == T_CHAR) {
		String *dim = SwigType_array_getdim(aop, 0);
		Wrapper_add_local(f_php, "z_var", "zval **z_var");
		Wrapper_add_local(f_php, "s1", "char *s1");
		Printf(f_php->code, "zend_hash_find(&EG(symbol_table), \"%s\", %d, (void **)&z_var);\n", name, strlen(name)+1);
		Printf(f_php->code, "s1 = Z_STRVAL_PP(z_var);\n");
		Printf(f_php->code, "if((s1 == NULL) || zend_binary_strcmp(s1, strlen(s1), %s, strlen(%s) )) {\n", name, name);
		Printf(f_php->code, "if(%s) {\n", name);
		Printf(f_php->code, "(*z_var)->value.str.val = estrdup(%s);\n", name);
		Printf(f_php->code, "(*z_var)->value.str.len = strlen(%s)+1;\n", name);
		Printf(f_php->code, "} else {\n");
		Printf(f_php->code, "(*z_var)->value.str.val = 0;\n");
		Printf(f_php->code, "(*z_var)->value.str.len = 0;\n");
		Printf(f_php->code, "}\n}\n");
	} else {
		Wrapper_add_local(f_php, "z_var", "zval **z_var");
		Printf(f_php->code, "zend_hash_find(&EG(symbol_table), \"%s\", %d, (void **)&z_var);\n", name, strlen(name)+1);
		Printf(f_php->code, "if(%s) {\n", name);
		Printf(f_php->code, "SWIG_SetPointerZval(*z_var, (void*)%s, SWIGTYPE);\n", name, SwigType_manglestr(t));
		/* Arrays are not modified directly by PHP vars */
	}
	Delete(ta);
	Delete(aop);
	}
	break;
  case T_POINTER:
  case T_REFERENCE:
	Wrapper_add_local(f_php, "z_var", "zval **z_var");
	Printf(f_php->code, "zend_hash_find(&EG(symbol_table), \"%s\", %d, (void **)&z_var);\n", name, strlen(name)+1);
	Printf(f_php->code, "SWIG_SetPointerZval(*z_var, (void *)%s, SWIGTYPE%s);\n", name, SwigType_manglestr(t));
	break;
  default:
	/* error */
	break;
  }
	
  /* Now code to set c values */

  if(!(flags & PHP_READONLY)) {

  switch(SwigType_type(t)) {
  case T_INT:
  case T_BOOL:
  case T_UINT:
  case T_SHORT:
  case T_USHORT:
  case T_LONG:
  case T_ULONG:
  case T_SCHAR:
  case T_UCHAR:
	Wrapper_add_local(f_c, "z_var", "zval **z_var");
	Printf(f_c->code, "zend_hash_find(&EG(symbol_table), \"%s\", %d, (void **)&z_var);\n", name, strlen(name)+1);
	Printf(f_c->code, "if(%s != (%s)((*z_var)->value.lval)) {\n", name, SwigType_lstr(t, 0));
	Printf(f_c->code, "%s = Z_LVAL_PP(z_var);\n", name);
	Printf(f_c->code, "}\n");
	break;
  case T_DOUBLE:
  case T_FLOAT:
	Wrapper_add_local(f_c, "z_var", "zval **z_var");
	Printf(f_c->code, "zend_hash_find(&EG(symbol_table), \"%s\", %d, (void **)&z_var);\n", name, strlen(name)+1);
	Printf(f_c->code, "if(%s != (%s)((*z_var)->value.dval)) {\n", name, SwigType_lstr(t, 0));
	Printf(f_c->code, "%s = Z_DVAL_PP(z_var);\n", name);
	Printf(f_c->code, "\n}\n");
	break;
  case T_CHAR:
	Wrapper_add_local(f_c, "z_var", "zval **z_var");
	Printf(f_c->code, "zend_hash_find(&EG(symbol_table), \"%s\", %d, (void **)&z_var);\n", name, strlen(name)+1);
	Printf(f_c->code, "if(%s != *((*z_var)->value.str.val)) {\n", name);
	Printf(f_c->code, "%s = *((*z_var)->value.str.val);\n", name);
	Printf(f_c->code, "\n}\n");
	break;

  case T_STRING:
	Wrapper_add_local(f_c, "z_var", "zval **z_var");
	Wrapper_add_local(f_c, "s1", "char *s1");
	Printf(f_c->code, "zend_hash_find(&EG(symbol_table), \"%s\", %d, (void **)&z_var);\n", name, strlen(name)+1);
	Printf(f_c->code, "s1 = Z_STRVAL_PP(z_var);\n");
	Printf(f_c->code, "if((s1 == NULL) || (%s == NULL) || zend_binary_strcmp(s1, strlen(s1), %s, strlen(%s) )) {\n", name, name, name);
	Printf(f_c->code, "if(s1)\n");
	Printf(f_c->code, "%s = estrdup(s1);\n", name, name);
	Printf(f_c->code, "else\n");
	Printf(f_c->code, "%s = NULL;\n", name);
	Printf(f_c->code, "}\n");
	break;

  case T_USER:
	SwigType_add_pointer(t);
	Wrapper_add_local(f_c, "z_var", "zval **z_var");
	Printf(f_c->code, "{\n %s _temp;\n", SwigType_lstr(t,0));
	Printf(f_c->code, "zend_hash_find(&EG(symbol_table), \"%s\", %d, (void **)&z_var);\n", name, strlen(name)+1);
	get_pointer(name, (char*)"value", (char*)"*z_var", (char*)"&_temp", t, f_c->code,(char*)"return");
	Printv(f_c->code, tab4, name, " = *(", SwigType_str(t,0), ") _temp;\n", 0);
	Printf(f_c->code,"}\n");
	SwigType_del_pointer(t);
	break;
  case T_ARRAY:
	{
	int setable = 0;
	SwigType *aop;
	SwigType *ta = Copy(t);
	aop = SwigType_pop(ta);
	if(SwigType_type(ta) == T_CHAR) {
		String *dim = SwigType_array_getdim(aop, 0);
		Wrapper_add_local(f_c, "z_var", "zval **z_var");
		Wrapper_add_local(f_c, "s1", "char *s1");
		Printf(f_c->code, "zend_hash_find(&EG(symbol_table), \"%s\", %d, (void **)&z_var);\n", name, strlen(name)+1);
		Printf(f_c->code, "s1 = Z_STRVAL_PP(z_var);\n");
		Printf(f_c->code, "if((s1 == NULL) || (%s == NULL) || zend_binary_strcmp(s1, strlen(s1), %s, strlen(%s) )) {\n", name, name, name);
		Printf(f_c->code, "if(s1) {\n");
		Printf(f_c->code, "strncpy(%s, s1, %s);\n", name, Char(dim));
		Printf(f_c->code, "}\n}\n");
	} else {
		Wrapper_add_local(f_c, "z_var", "zval **z_var");
		Printf(f_c->code, "zend_hash_find(&EG(symbol_table), \"%s\", %d, (void **)&z_var);\n", name, strlen(name)+1);
		Printf(f_c->code, "if(%s) {\n", name);
		Printf(f_c->code, "SWIG_SetPointerZval(*z_var, (void*)%s, SWIGTYPE%s);\n", name, SwigType_manglestr(t));
		Printf(f_c->code, "}\n");
		/* Arrays are not modified directly by PHP vars */
	}
	Delete(ta);
	Delete(aop);
	}
	break;
  case T_POINTER:
  case T_REFERENCE:
	Printf(f_c->code, "{\n");
	Printf(f_c->code, "%s _temp;\n", SwigType_lstr(t,0));
	Wrapper_add_local(f_c, "z_var", "zval **z_var");
	Printf(f_c->code, "zend_hash_find(&EG(symbol_table), \"%s\", %d, (void **)&z_var);\n", name, strlen(name)+1);
	get_pointer(name, (char*)"value", (char*)"*(z_var)", (char*)"&_temp", t,f_c->code, (char*)"return");
	Printv(f_c->code, tab4, name, " = (", SwigType_str(t,0), ") _temp;\n", 0);
	Printf(f_c->code, "}\n");
	break;
  default:
	/* error */
	break;
  }
  }
  return SWIG_OK;
}

int
PHP4::constantWrapper(Node *n) {
  char *name = GetChar(n,"name");
  char *iname = GetChar(n,"sym:name");
  SwigType *type = Getattr(n,"type");
  char *value = GetChar(n,"value");
	String *rval;
	String *tm;

	SwigType_remember(type);

	switch(SwigType_type(type)) {
	case T_STRING:
		rval = NewStringf("\"%s\"", value);
		break;
	case T_CHAR:
		rval = NewStringf("\'%s\'", value);
		break;
	default:
		rval = NewString(value);
	}

	if((tm = Swig_typemap_lookup_new("consttab", n, name, 0))) {
		Replaceall(tm, "$source", value);
		Replaceall(tm, "$target", name);
		Replaceall(tm, "$value", value);
		Printf(s_cinit, "%s\n", tm);
	} else {
	switch(SwigType_type(type)) {
		case T_BOOL: 
		case T_INT :
		case T_SHORT :
		case T_SCHAR:
		case T_LONG:
		     Printf(s_cinit,
		     "    REGISTER_LONG_CONSTANT(\"%s\", %s, CONST_CS);\n",
		     name, rval);
		     break;
		case T_DOUBLE: 
		case T_FLOAT:
		     Printf(s_cinit,
		     "    REGISTER_DOUBLE_CONSTANT(\"%s\", %s, CONST_CS);\n",
		     name, rval);
		     break;
		case T_CHAR:
		     Printf(s_cinit,
		     "{\n"
		     "    char c[2];\n"
		     "    c[0] = %s;\n"
		     "    c[1] = '\\0';\n"
		     "    REGISTER_STRING_CONSTANT(\"%s\", estrdup(c),"
		     "        CONST_CS | CONST_PERSISTENT);\n"
		     "}\n", rval, name);
                     break;
		case T_STRING:
		     Printf(s_cinit,
		     "    REGISTER_STRING_CONSTANT(\"%s\", %s,"
		     "        CONST_CS | CONST_PERSISTENT);\n", name, rval);
		     break;
		case T_POINTER:
		case T_ARRAY:
		case T_REFERENCE:
		      Printf(s_cinit,
		      "{\n"
		      "    char *cp;\n"
		      "    SWIG_SetPointerChar(&cp, (void*)%s, SWIGTYPE%s);\n"
		      "    REGISTER_STRING_CONSTANT(\"%s\", cp,"
		      "        CONST_CS | CONST_PERSISTENT);\n"
		      "}\n", value, SwigType_manglestr(type), name);
		      break;
		default:
			break;
	}
	return SWIG_OK;
	}
}

/*
 * PHP4::pragma()
 *
 * Pragma directive.
 *
 * %pragma(php4) code="String"         # Includes a string in the .php file
 * %pragma(php4) include="file.pl"     # Includes a file in the .php file
 */
void PHP4::pragma(char *lang, char *type, char *value) {
       if (strcmp(lang,"php4") != 0) return;

       if (strcmp(type, "code") == 0) {
               if (value)
                       Printf(pragma_code, "%s\n", value);
       } else if (strcmp(type, "include") == 0) {
               if (value)
                       Printf(pragma_incl, "include \"%s\";\n", value);
       } else if (strcmp(type, "phpinfo") == 0) {
               if (value)
                       Printf(pragma_phpinfo, "%s\n", value);
       } else {
	      Printf(stderr, "%s : Line %d. Unrecognized pragma.\n",
		      input_file, line_number);
       }
}

/*
void
PHP4::usage_func(char *iname, SwigType *, ParmList *l) {

	;
}
*/

void 
PHP4::add_native(char *name, char *funcname, SwigType *, ParmList *) {
	;
}

void
PHP4::emit_shadow_classdef() {
	String *baseclass = NULL;

	// Include Base class definition
	
	/*
	if(this_shadow_baseclass && *Char(this_shadow_baseclass))
		Printf(shadow_classdef, 
		      "include(\"%s.php\");\n",
		      this_shadow_baseclass);
        */

	// Import statements
	if(all_shadow_import)
		Printf(shadow_classdef, "%s", all_shadow_import);
	if(this_shadow_import)
		Printf(shadow_classdef, "%s", this_shadow_import);
	Printf(shadow_classdef, "\n");

	// Class modifiers XXX not in php
	
	Printf(shadow_classdef, "class $class ");

	// Inherited classes
	if(this_shadow_baseclass && *Char(this_shadow_baseclass)) {
		Printf(shadow_classdef, "extends %s ", this_shadow_baseclass);
		baseclass = this_shadow_baseclass;
	}
	if(all_shadow_baseclass && *Char(all_shadow_baseclass)) {
		Printf(shadow_classdef, "extends %s ", all_shadow_baseclass);
		baseclass = all_shadow_baseclass;
	}

	Printf(shadow_classdef, "{\n");

	// XXX No interfaces (?)
	
	// Display warning on attempt to use multiple inheritance
	
	char *search_str = Char(shadow_classdef);
	int count = 0;
	while((search_str = strstr(search_str, "extends"))) {
		search_str += strlen("extends");
		count++;
	}
	if(count > 1)
		Printf(stderr, "Warning for shadow class %s: Multiple inheritance is not supported in PHP4.\n", shadow_classname);

	// Different code depending on whether or not the base class is a
	// SWIG shadow class.
	
	if(baseclass && is_shadow(baseclass)) {
		// Control which super constructor is called -
		// we don't want 2 malloc/new c/c++ calls
	} else {
		String *k;

		Printv(shadow_classdef,
		" var $_cPtr;\n",
		" var $_cMemOwn;\n", 0);

		for(k = Firstkey(shadow_php_vars); k; k = Nextkey(shadow_php_vars)) {
			Printf(shadow_classdef, " var $%s;\n", Getattr(shadow_php_vars, k));
		}

		Printv(shadow_classdef,
		"\n",
		" function getCPtr() {\n",
		"    return $this->_cPtr;\n",
		" }\n",
		"\n",
		" function setCPtr($cPtr, $own) {\n",
		"    $this->_cPtr = $cPtr;\n",
		"    $this->_cMemOwn = $own;\n",
		" }\n",
		"\n", 0);

		// No explicit super constructor call as this class does not
		// have a SWIG base class.
	}

	Replace(shadow_classdef, "$class", shadow_classname, DOH_REPLACE_ANY);

	if(all_shadow_extra_code)
		Printv(shadow_classdef, all_shadow_extra_code, 0);

	if(this_shadow_extra_code)
		Printv(shadow_classdef, this_shadow_extra_code, 0);
}



int PHP4::classHandler(Node *n) {

	char bigbuf[1024];

	if(class_name) free(class_name);
	class_name = Swig_copy_string(GetChar(n, "name"));

	if(shadow) {
		char *classname = GetChar(n, "name");
		char *rename = GetChar(n, "sym:name");
		char *ctype = GetChar(n, "kind");

		shadow_classname = Swig_copy_string(rename);

		if(Strcmp(shadow_classname, module) == 0) {
			Printf(stderr, "class name cannot be equal to module name: %s\n", shadow_classname);
			SWIG_exit(1);
		}

		Setattr(shadow_classes, classname, shadow_classname);

		if(ctype && strcmp(ctype, "struct") == 0) {
			sprintf(bigbuf, "struct %s", classname);
			Setattr(shadow_classes, bigbuf, shadow_classname);
		}

		Clear(shadow_classdef);
		Clear(shadow_code);

		have_default_constructor = 0;
		shadow_enum_code = NewString("");
		this_shadow_baseclass = NewString("");
		this_shadow_extra_code = NewString("");
		this_shadow_import = NewString("");

  		shadow_c_vars = NewHash();
		shadow_php_vars = NewHash();

		/* Deal with inheritance */
		List *baselist = Getattr(n, "bases");
		if(baselist) {
			Node *base = Firstitem(baselist);

			if(is_shadow(Getattr(base, "name"))) {
				Printf(this_shadow_baseclass, "%s", Getattr(base, "name"));
			}
			base = Nextitem(baselist);
			if(base) {
				Printf(stderr, "Error: %s inherits from multiple base classes. Multiple inheritance is not supported by PHP4.\n", shadow_classname);
			}
		} else { // XXX Must be base class ?
		  /* Write out class init code */

		  if(!written_base_class) {
		    written_base_class = 1;
		    Printf(s_oinit,"{\nzend_class_entry *ce;\n");
		    Printf(s_oinit,"CG(class_entry).type = ZEND_USER_CLASS;\n");
		    Printf(s_oinit, "CG(class_entry).name = estrdup(\"%s\");\n", package);
		    Printf(s_oinit, "CG(class_entry).name_length = strlen(\"%s\");\n", package);
		    Printf(s_oinit, "CG(class_entry).refcount = (int *) emalloc(sizeof(int));\n");
		    Printf(s_oinit, "*CG(class_entry).refcount = 1;\n");
		    Printf(s_oinit, "CG(class_entry).constants_updated = 0;\n");

		    /* XXX do this ourselves */

		    Printf(s_oinit, "zend_str_tolower(CG(class_entry).name, CG(class_entry).name_length);\n");
	
		    /* Init class function hash */
		
		    Printf(s_oinit, "zend_hash_init(&CG(class_entry).function_table, 10, NULL, ZEND_FUNCTION_DTOR, 0);\n");
		    Printf(s_oinit, "zend_hash_init(&CG(class_entry).default_properties, 10, NULL, ZVAL_PTR_DTOR, 0);\n");

		    /* XXX Handle inheritance ? */

		    Printf(s_oinit, "CG(class_entry).handle_function_call = NULL;\n");
		    Printf(s_oinit, "CG(class_entry).handle_property_set = NULL;\n");
		    Printf(s_oinit, "CG(class_entry).handle_property_get = NULL;\n");

		    /* Save class in class table */
		    Printf(s_oinit, "zend_hash_update(CG(class_table), \"%s\", strlen(\"%s\")+1, &CG(class_entry), sizeof(zend_class_entry), (void **) &CG(active_class_entry));\n", package, package);

		    Printf(s_oinit, "}\n");

		  }

		}

	}


	Language::classHandler(n);

	if(shadow) {

		emit_shadow_classdef();

		Printv(f_phpcode, shadow_classdef, shadow_code, 0);

		// Write the enum initialisation code in a static block
		// These are all the enums defined withing the c++ class.

		// XXX Needed in PHP ?
		if(strlen(Char(shadow_enum_code)) != 0 )
			Printv(f_phpcode, "{\n // enum\n", shadow_enum_code, " }\n", 0);
		Printf(f_phpcode, "}\n");

		free(shadow_classname);
		shadow_classname = NULL;

		Delete(shadow_enum_code); shadow_enum_code = NULL;
		Delete(this_shadow_baseclass); this_shadow_baseclass = NULL;
		Delete(this_shadow_extra_code); this_shadow_extra_code = NULL;
		Delete(this_shadow_import); this_shadow_import = NULL;
		Delete(shadow_c_vars); shadow_c_vars = NULL;
		Delete(shadow_php_vars); shadow_php_vars = NULL;
	}
	return SWIG_OK;
}

int
PHP4::memberfunctionHandler(Node *n) {
	char *name = GetChar(n, "name");
	char *iname = GetChar(n, "sym:name");
	SwigType *t = Getattr(n, "type");
	ParmList *l = Getattr(n, "parms");

	this->Language::memberfunctionHandler(n);

	if(shadow) {
		char *realname = iname ? iname : name;
		String *php_function_name = Swig_name_member(shadow_classname, realname);

		cpp_func(iname, t, l, php_function_name);
		/*

	Printf(s_oinit, "{\nzend_function function;\n");
	Printf(s_oinit, "zend_internal_function *internal_function = (zend_internal_function *)&function;\n");
	Printf(s_oinit, "internal_function->type= ZEND_INTERNAL_FUNCTION;\n");
	Printf(s_oinit, "internal_function->handler = %s;\n", Swig_name_wrapper(iname));
	Printf(s_oinit, "internal_function->arg_types = NULL;\n");
	Printf(s_oinit, "internal_function->function_name = estrdup(\"%s\");\n", Swig_name_wrapper(iname));
	Printf(s_oinit, "zend_hash_add(&CG(active_class_entry)->function_table, \"%s\", %d, &function, sizeof(zend_function), NULL);\n}\n", Swig_name_wrapper(name), strlen(Char(Swig_name_wrapper(name)))+1);

	*/
	}
	return SWIG_OK;
}

int
PHP4::membervariableHandler(Node *n) {
	char *name = GetChar(n,"name");
	char *iname = GetChar(n, "sym:name");
	SwigType *t = Getattr(n, "type");


	shadow_variable_name = Swig_copy_string((iname) ? iname : name);

	wrapping_member = 1;
	variable_wrapper_flag = 1;
	Language::membervariableHandler(n);
	wrapping_member = 0;
	variable_wrapper_flag = 0;

	return SWIG_OK;
}

int PHP4::staticmemberfunctionHandler(Node *n) {

	Language::staticmemberfunctionHandler(n);

	if(shadow) {
		String *symname = Getattr(n, "sym:name");
		String *php_function_name = Swig_name_member(shadow_classname, symname);
		static_flag = 1;
		cpp_func(Char(symname), Getattr(n, "type"), Getattr(n, "parms"), php_function_name);
		static_flag = 0;
	}

	return SWIG_OK;
}

int PHP4::staticmembervariableHandler(Node *n) {
	shadow_variable_name = GetChar(n, "sym:name");
	SwigType *d = Getattr(n, "type");
	ParmList *l = Getattr(n, "parms");
	char *iname = GetChar(n, "sym:name");
	String *static_name = NewStringf("%s::%s", class_name, iname);
	Wrapper *f;

  /* A temporary(!) hack for static member variables.
   * Php currently supports class functions, but not class variables.
   * Until it does, we convert a class variable to a class function
   * that returns the current value of the variable. E.g.
   *
   * class Example {
   * 	public:
   * 		static int ncount;
   * };
   *
   * would be available in php as Example::ncount() 
   */
	static_flag = 1;
	if(ReadOnly) {
		const_flag = 1;
	}
	cpp_func(iname, d, 0, iname);
	static_flag = 0;

	create_command(iname, Char(Swig_name_wrapper(iname)));

	f = NewWrapper();

	Printv(f->def, "ZEND_NAMED_FUNCTION(", Swig_name_wrapper(iname), ") {\n", 0);

	/* If a argument is given we set the variable. Then we return
	 * the current value
	*/

	Printf(f->code, "zval **args[1];\n");
	Printf(f->code, "int argcount;\n\n");

	Printf(f->code, "argcount = ZEND_NUM_ARGS();\n");
	Printf(f->code, "if(argcount > %d) WRONG_PARAM_COUNT;\n\n", (const_flag? 0 : 1));
	if(!const_flag) {
	  Printf(f->code, "if(argcount) {\n");

	  Printf(f->code, "if(zend_get_parameters_array_ex(argcount, args) != SUCCESS) WRONG_PARAM_COUNT;\n");

	  switch(SwigType_type(d)) {
		case T_BOOL:
		case T_INT:
		case T_SHORT:
		case T_LONG:
		case T_SCHAR:
		case T_UINT:
		case T_USHORT:
		case T_ULONG:
		case T_UCHAR:
			Printf(f->code, "convert_to_long_ex(args[0]);\n");
			Printf(f->code, "%s::%s = Z_LVAL_PP(args[0]);\n", class_name, iname);
			break;
		case T_CHAR:
			Printf(f->code, "convert_to_string_ex(args[0]);\n");
			Printf(f->code, "%s::%s = estrdup(Z_STRVAL(args[0]));\n");
			break;
		case T_DOUBLE:
		case T_FLOAT:
			Printf(f->code, "convert_to_double_ex(args[0]);\n");
			Printf(f->code, "%s::%s = Z_DVAL_PP(args[0]);\n", class_name, iname);
			break;
		case T_VOID:
			break;
		case T_USER:
			Printf(f->code, "convert_to_string_ex(args[0]);\n");
			get_pointer(Char(iname), (char*)"variable", (char*)"args[0]", Char(static_name), d, f->code, (char *)"RETURN_FALSE");
			break;
		case T_POINTER:
		case T_ARRAY:
		case T_REFERENCE:
			Printf(f->code, "convert_to_string_ex(args[0]);\n");
			get_pointer(Char(iname), (char*)"variable", (char*)"args[0]", Char(static_name), d, f->code, (char*)"RETURN_FALSE");
			break;
		default:
			Printf(stderr,"%s : Line %d, Unable to use type %s as a class variable.\n", input_file, line_number, SwigType_str(d,0));
			break;
		}
		
	  Printf(f->code, "}\n\n");
	
	} /* end of const_flag */

	switch(SwigType_type(d)) {
		case T_BOOL:
		case T_INT:
		case T_SHORT:
		case T_LONG:
		case T_SCHAR:
		case T_UINT:
		case T_USHORT:
		case T_ULONG:
		case T_UCHAR:
			Printf(f->code, "RETURN_LONG(%s::%s);\n", class_name, iname);
			break;
		case T_DOUBLE:
		case T_FLOAT:
			Printf(f->code, "RETURN_DOUBLE(%s);\n", static_name);
			break;
		case T_CHAR:
			Printf(f->code, "{\nchar ctemp[2];\n");
			Printf(f->code, "ctemp[0] = %s;\n", static_name);
			Printf(f->code, "ctemp[1] = 0;\n");
			Printf(f->code, "RETURN_STRING(ctemp, 1);\n}\n");
			break;
		case T_USER:
		case T_POINTER:
			Printf(f->code, "SWIG_SetPointerZval(return_value, (void *)%s, SWIGTYPE%s);\n", static_name, SwigType_manglestr(d));
			break;
		case  T_STRING:
			Printf(f->code, "RETURN_STRING(%s, 1);\n", static_name);
			break;
		}


	Printf(f->code, "}\n");

	const_flag = 0;

	Wrapper_print(f, s_wrappers);

	return SWIG_OK;
}

void PHP4::SwigToPhpType(SwigType *t, String_or_char *pname, String* php_type, int shadow_flag) {
	char *ptype = 0;

	if(shadow_flag)
		ptype = PhpTypeFromTypemap((char*)"pstype", t, pname,(char*)"");
	if(!ptype)
		ptype = PhpTypeFromTypemap((char*)"ptype",t,pname,(char*)"");


	if(ptype) {
		Printf(php_type, ptype);
		free(ptype);
	}
	else {
		/* Map type here */
		switch(SwigType_type(t)) {
			case T_CHAR:
			case T_SCHAR:
			case T_UCHAR:
			case T_SHORT:
			case T_USHORT:
			case T_INT:
			case T_UINT:
			case T_LONG:
			case T_ULONG:
			case T_FLOAT:
			case T_DOUBLE:
			case T_BOOL:
			case T_STRING:
			case T_VOID:
				Printf(php_type, "");
				break;
			case T_POINTER:
			case T_REFERENCE:
			case T_USER:
				if(shadow_flag && is_shadow(t))
					Printf(php_type, Char(is_shadow(t)));
				else
					Printf(php_type, "");
				break;
			case T_ARRAY:
				/* TODO */
				break;
			default:
				Printf(stderr, "SwigToPhpType: unhandled data type: %s\n", SwigType_str(t,0));
				break;
			}
	}
}


char *PHP4::PhpTypeFromTypemap(char *op, SwigType *t, String_or_char *pname, String_or_char *lname) {
	String *tms;
	char bigbuf[1024];
	char *tm;
	char *c = bigbuf;
	if(!(tms = Swig_typemap_lookup(op, t, pname, lname, (char*)"", (char*)"", NULL))) return NULL;

	tm = Char(tms);
	while(*tm && (isspace(*tm) || *tm == '{')) tm++;
	while(*tm && *tm != '}') *c++ = *tm++;
	*c='\0';
	return Swig_copy_string(bigbuf);
}


int PHP4::constructorHandler(Node *n) {

	char *iname = GetChar(n, "sym:name");
	ParmList *l = Getattr(n, "parms");

	Language::constructorHandler(n);

	if(shadow) {
		String *nativecall = NewString("");
		String *php_function_name = NewString(iname);
		char arg[256];

		 Printf(s_oinit, "{\nzend_function function;\n");
		 Printf(s_oinit, "zend_internal_function *internal_function = (zend_internal_function *)&function;\n");
		 Printf(s_oinit, "internal_function->type= ZEND_INTERNAL_FUNCTION;\n");
		 Printf(s_oinit, "internal_function->handler = _wrap_new_%s;\n", iname);
		 Printf(s_oinit, "internal_function->arg_types = NULL;\n");
		 Printf(s_oinit, "internal_function->function_name = estrdup(\"new_%(lower)s\");\n", php_function_name);
		 Printf(s_oinit, "zend_hash_add(&CG(active_class_entry)->function_table, \"new_%(lower)s\", %d, &function, sizeof(zend_function), NULL);\n}\n", php_function_name, strlen(Char(php_function_name))+5);
		Printf(shadow_code, " function %s(", shadow_classname);

		if(iname != NULL)
			Printv(nativecall, tab4, "$this->_cPtr = ", package, "::", Swig_name_construct(iname), "(", 0);
		else
			Printv(nativecall, tab4, "$this->_cPtr = ", module, "::", Swig_name_construct(shadow_classname), "(", 0);

		int pcount = ParmList_len(l);
		if(pcount == 0) // must have default constructor
			have_default_constructor = 1;

		/* Output each parameter */
		Parm *p = l;
		for (int i = 0; i < pcount ; i++, p = nextSibling(p)) {
			SwigType *pt = Getattr(p, "type");
			String *pn = Getattr(p, "name");

	/* Produce string representation of source and target arguments */

			if(pn && *(Char(pn)))
				strcpy(arg, Char(pn));
			else {
				sprintf(arg, "arg%d", i);
			}

			if(is_shadow(pt)) {
				Printv(nativecall, "$", arg, "->getCPtr()", 0);
			} else 
				Printv(nativecall, "$", arg, 0);

			/* Add to php shadow function header */
			Printf(shadow_code, "$%s", arg);

			if(i != pcount-1) {
				Printf(nativecall, ", ");
				Printf(shadow_code, ", ");
			}
		}

		Printf(shadow_code, ") {\n");
		Printv(nativecall, ");\n", tab4, "$this->_cMemOwn = true;\n", 0);
		/* register our shutdown function */

		Printv(nativecall, tab4,
				   "register_shutdown_function(array(&$this,",
				   "\"_destroy\"));\n", 0);

		/* Store new values in PHP */
		if(!no_sync) {
			Printv(nativecall, tab4,
				   "$this->_sync_php();\n", 0);
		}

		Printf(shadow_code, "%s", nativecall);
		Printf(shadow_code, "  }\n\n");
		Delete(nativecall);
	}
	return SWIG_OK;
}

int PHP4::destructorHandler(Node *n) {

	Language::destructorHandler(n);

	if(shadow) {
	  Printf(shadow_code, " function _destroy() {\n");
	  Printf(shadow_code, "   if($this->_cPtr && $this->_cMemOwn) {\n");
	  Printf(shadow_code, "     %s::%s($this->_cPtr);\n", package, Swig_name_destroy(shadow_classname));
	  Printf(shadow_code, "     $this->_cPtr = 0;\n");
	  Printf(shadow_code, "   }\n");
	  Printf(shadow_code, " }\n\n");

	  if(!no_sync) {
	    String *k;
	    Printf(shadow_code," function _sync_c() {\n ");

	    for(k = Firstkey(shadow_c_vars); k ; k = Nextkey(shadow_c_vars)) {
		    Printf(shadow_code, "%s::%s($this->_cPtr, $this->%s);\n",
			     	        package, k, 
					Getattr(shadow_c_vars, k));
	    }

	    Printf(shadow_code, "\n}\n");

	    Printf(shadow_code," function _sync_php() {\n");

	    for(k = Firstkey(shadow_php_vars);k;k = Nextkey(shadow_php_vars)) {
		    Printf(shadow_code, "$this->%s = %s::%s($this->_cPtr);\n",
					 Getattr(shadow_php_vars, k),
					 package, k);
	    }

	    Printf(shadow_code, "\n}\n");
	  }

	  String *iname = Swig_name_destroy(GetChar(n, "sym:name"));

	  Printf(s_oinit, "{\nzend_function function;\n");
	  Printf(s_oinit, "zend_internal_function *internal_function = (zend_internal_function *)&function;\n");
	  Printf(s_oinit, "internal_function->type= ZEND_INTERNAL_FUNCTION;\n");
	  Printf(s_oinit, "internal_function->handler = %s;\n", Swig_name_wrapper(iname));
	  Printf(s_oinit, "internal_function->arg_types = NULL;\n");
	  Printf(s_oinit, "internal_function->function_name = estrdup(\"%(lower)s\");\n", iname);
	  Printf(s_oinit, "zend_hash_add(&CG(active_class_entry)->function_table, \"%(lower)s\", %d, &function, sizeof(zend_function), NULL);\n}\n", iname, strlen(Char(iname))+1);
	}
	return SWIG_OK;
}

int
PHP4::memberconstantHandler(Node *n) {
	shadow_variable_name = GetChar(n, "sym:name");
	wrapping_member = 1;
	Language::memberconstantHandler(n);
	wrapping_member = 0;
	return SWIG_OK;
}

int
PHP4::classforwardDeclaration(Node *n) {
	String *name = Getattr(n, "name");
	String *rename = Getattr(n, "sym:name");
	String *type = Getattr(n, "kind");
	String *stype;

	if(shadow) {
		stype = NewString(name);
		SwigType_add_pointer(stype);
		Setattr(shadow_classes, stype, rename);
		Delete(stype);
		if(Len(type) > 0) {
			stype = NewStringf("%s %s", type, name);
			SwigType_add_pointer(stype);
			Setattr(shadow_classes, stype, rename);
			Delete(stype);
		}
	}
	return SWIG_OK;
}

int
PHP4::typedefHandler(Node *n) {
	SwigType *t = Getattr(n, "type");
	String *name = Getattr(n, "name");
	if(!shadow) return SWIG_OK;
	if(is_shadow(t)) {
		Setattr(shadow_classes, name, is_shadow(t));
	}
	return SWIG_OK;
}

void 
PHP4::cpp_func(char *iname, SwigType *t, ParmList *l, String *php_function_name) {
	char arg[256];
	String *nativecall = NewString("");
	String *user_arrays = NewString("");
	String *lower;
	int gencomma = 0;

	if(!shadow) return;

	if(l) {
	  if(SwigType_type(Getattr(l, "type")) == T_VOID) {
		l = nextSibling(l);
	  }
	}

	 
	 Printf(s_oinit, "{\nzend_function function;\n");
	 Printf(s_oinit, "zend_internal_function *internal_function = (zend_internal_function *)&function;\n");
	 Printf(s_oinit, "internal_function->type= ZEND_INTERNAL_FUNCTION;\n");
	 Printf(s_oinit, "internal_function->handler = %s;\n", Swig_name_wrapper(php_function_name));
	 Printf(s_oinit, "internal_function->arg_types = NULL;\n");
	 Printf(s_oinit, "internal_function->function_name = estrdup(\"%(lower)s\");\n", php_function_name);
	 Printf(s_oinit, "zend_hash_add(&CG(active_class_entry)->function_table, \"%(lower)s\", %d, &function, sizeof(zend_function), NULL);\n}\n", php_function_name, strlen(Char(php_function_name))+1);

	Printf(shadow_code, "function %s(", iname);
	if(static_flag && !const_flag)
		Printf(shadow_code, "$val = 0");

	if(!no_sync && !static_flag)
		Printf(nativecall, "$this->_sync_c();\n\n");

	if((SwigType_type(t) != T_VOID) && !is_shadow(t)) {
		if(static_flag && !const_flag)
			Printf(nativecall, "if($val) {\n");
		Printf(nativecall, "    return ");
		Printv(nativecall, package, "::", php_function_name, "(", 0);
		if(!const_flag) {
		  if(static_flag)
			Printf(nativecall, "$val");
		  else 
			Printv(nativecall, "$this->_cPtr", 0);
		}
	} else if(SwigType_type(t) == T_VOID) {
		if(static_flag && !const_flag)
			Printf(nativecall, "    if($val) {\n");
		Printv(nativecall,"    ", package, "::",php_function_name,"(",0);
		Printv(nativecall, "$this->_cPtr", 0);
	} else if(is_shadow(t)) {
		if(SwigType_type(t) == T_ARRAY) {
			Printf(nativecall, "    return %s::%s($this->_cPtr", 
			       package, php_function_name);
		} else {
		String *shadowrettype = NewString("");
		SwigToPhpType(t, iname, shadowrettype, shadow);
		Printf(nativecall, "    $_sPtr = new %s();\n", shadowrettype);
		Printf(nativecall, "    $_sPtr->_destroy();\n");
		Printf(nativecall, "    $_iPtr = %s::%s($this->_cPtr",
		       package, php_function_name);
		}
	}



	int pcount = ParmList_len(l);

	/* Output each parameter */

	Parm *p = l;

	/* Workaround to overcome Getignore(p) not working - p does not always
	 * have the Getignore attribute set. Noticeable when cpp_func is called
	 * from cpp_member_func()
	*/

	Wrapper *f = NewWrapper();
	emit_args(NULL, l, f);
	DelWrapper(f);

	/*Workaround end */

	for(int i= 0; i < pcount; i++, p = nextSibling(p)) {
	  if(Getattr(p, "ignore")) continue;

	  if(!(variable_wrapper_flag && i==0))
	  {
	    SwigType *pt = Getattr(p, "type");
	    String   *pn = Getattr(p, "name");

	    /* Produce string repesentation of source and target arguments */

	    if(pn && *(Char(pn)))
		strcpy(arg, Char(pn));
	    else {
		sprintf(arg, "arg%d", i);
	    }

	    Printf(nativecall, ", ");

	    if(gencomma) 
		    Printf(shadow_code, ",");

	    gencomma = 1;

	    if(is_shadow(pt)) {
		Printv(nativecall, "$", arg, "->getCPtr()", 0);
	    } else {
		Printv(nativecall, "$", arg, 0);
	    }

	    /* Add to php shadow function header */

	    Printf(shadow_code, "$%s", arg);

	}
      }
      
      if(SwigType_type(t) == T_ARRAY && is_shadow(get_array_type(t))) {
	      Printf(nativecall, ");\n");
      } else if(is_shadow(t)) {
	switch(SwigType_type(t)) {
		case T_USER:
			Printf(nativecall, ");\n");
			Printf(nativecall, 
			       "    $_sPtr->setCPtr($_iPtr, true);\n");
			Printf(nativecall, "    return $_sPtr;\n");
			break;
		case T_REFERENCE:
		case T_POINTER:
			Printf(nativecall, ");\n");
			Printf(nativecall, 
			       "    $_sPtr->setCPtr($_iPtr, false);\n");
			Printf(nativecall, "    return $_sPtr;\n");
			break;
		default:
			Printf(stderr, "Internal Error: unknown shadow_type: %\n", SwigType_str(t,0));
			break;
	 }
	} else {
		Printf(nativecall,");\n");
		if(static_flag && !const_flag) {
		  Printf(nativecall, "    } else {\n");
		  Printv(nativecall, "    return ", package, "::",
			 php_function_name, "();\n",0);
		}
	}

	if(static_flag &&!const_flag)
		Printf(nativecall, "}\n");

	Printf(shadow_code, ") {\n");
	Printf(shadow_code, "    %s", nativecall);
	if(!no_sync && !static_flag)
		Printf(shadow_code, "    $this->_sync_php();\n");
	Printf(shadow_code, "   }\n\n");

      Delete(nativecall);
}
