/* fileinfo.c, copyright Neven Lovric <nlovric@linux.hr> */

#include <sys/stat.h>
#include <unistd.h>
#include <errno.h>
#include "fileinfo.h"

int isdir(char *dirname)
{
   struct stat sbuf;
   
   if (stat(dirname, &sbuf) == -1)
      return(0);
   if (S_ISDIR(sbuf.st_mode))
      return(1);
   else {
      errno = 0;
      return(0);
   }
}

int isfile(char *filename)
{
   struct stat sbuf;
   
   if (stat(filename, &sbuf) == -1)
      return(0);
   if (S_ISREG(sbuf.st_mode))
      return(1);
   else {
      errno = 0;
      return(0);
   }
}

unsigned long filesize(char *filename)
{
   struct stat sbuf;
   
   if (stat(filename, &sbuf) == -1)
      return(0);
   errno = 0;
   return(sbuf.st_size);
}
