/* cavernlog.h
 * Run cavern inside an Aven window
 *
 * Copyright (C) 2005,2006,2010 Olly Betts
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#ifndef SURVEX_CAVERNLOG_H
#define SURVEX_CAVERNLOG_H

#include "wx.h"
#include <wx/html/htmlwin.h>

class MainFrm;

class CavernLogWindow : public wxHtmlWindow {
    wxString filename;

    MainFrm * mainfrm;

  public:
    CavernLogWindow(MainFrm * mainfrm_, wxWindow * parent);

    /** Process survey data in file.
     *
     *  @return -2 on failure to run cavern, -1 on error from cavern, or the
     *		number of warnings if no errors.
     */
    int process(const wxString &file);

    virtual void OnLinkClicked(const wxHtmlLinkInfo &link);

    void OnRerun(wxCommandEvent &);

    void OnOK(wxCommandEvent &);

    DECLARE_EVENT_TABLE()
};

#endif
