from sugar.activity.activity import Activity, ActivityToolbox

import logging
_logger = logging.getLogger('shtest-activity')

from sharedstate.sharedstate import SharingHelper

from gettext import gettext as _

import pygtk
pygtk.require('2.0')
import gtk

class SharingTest(Activity):
    def __init__(self, handle):
        Activity.__init__(self, handle)

        _logger.info('Starting SharingHelper test...')

        toolbox = ActivityToolbox(self)
        self.set_toolbox(toolbox)
        toolbox.show()

        self.set_title('SharingTest')

        hc = gtk.HBox(spacing=20)
        hc.set_border_width(20)
        vc1 = gtk.VBox()
        self.dict_box = gtk.TextView()          # where the current dict is shown
        self.dict_box.set_editable(False)
        vc1.add(self.dict_box)
        hc2 = gtk.HBox(spacing=20)
        hc2.set_border_width(20)

        self.dict_key_box = gtk.Entry()         # new key => val boxes
        self.dict_key_box.set_size_request(100, 40)
        hc2.add(self.dict_key_box)
        self.dict_val_box = gtk.Entry()
        self.dict_val_box.set_size_request(100, 40)
        hc2.add(self.dict_val_box)
        vc1.add(hc2)
        b2 = gtk.Button('add to dict')          # add button
        b2.connect('clicked', self.add_button_clicked_cb)
        vc1.add(b2)
        hc.add(vc1)

        vc2 = gtk.VBox()
        b1 = gtk.Button('Counter++')            # counter button
        b1.connect('clicked', self.counter_button_clicked_cb)
        vc2.add(b1)
        self.CounterLabel = gtk.Label('0')      # counter label
        vc2.add(self.CounterLabel)

        self.edit_box = gtk.TextView()          # shared editable text
        self.edit_box.set_editable(True)
        self.changed_signal = self.edit_box.get_buffer().connect('changed', self.edit_box_changed_cb)
        vc2.add(self.edit_box)

        hc.add(vc2)
        self.get_child().add(hc)

# Setup the shared objects
        self.helper = SharingHelper(self)
        self.helper.create_shared_object('counter', {
            'changed': self.update_counter_cb
        }, iv=0)

        self.helper.create_shared_object('sdict', {
            'changed': self.update_dict_cb
        }, iv={'key1': 'first key/val'})

        self.helper.create_shared_object('stext', {
            'changed': self.update_text_cb,
            'type': 'python'            # or nothing to autotype to SharedText
        }, iv='start of shared text')

# And show everything
        self.show_all()

    def counter_button_clicked_cb(self, info):
        _logger.debug('Counter clicked')
        self.helper['counter'] = self.helper['counter'] + 1

    def update_counter_cb(self, val):
        _logger.debug('update_counter_cb(): %r', val)
        self.CounterLabel.set_text('%d' % (val))

    def add_button_clicked_cb(self, info):
        _logger.debug('Add clicked')
        self.helper['sdict'][self.dict_key_box.get_text()] = self.dict_val_box.get_text()
        self.dict_key_box.set_text('')
        self.dict_val_box.set_text('')

    def update_dict_cb(self, val):
        _logger.debug('update_dict_cb(): %r', val)
        str = ''
        for k, v in val.iteritems():
            str += "%s => %s\n" % (k, v)
        self.dict_box.get_buffer().set_text(str)

    def edit_box_changed_cb(self, tbuf):
        _logger.debug('text_changed_cb(): changed')
        self.helper['stext'] = tbuf.get_text(tbuf.get_start_iter(), tbuf.get_end_iter())

    def update_text_cb(self, val):
        _logger.debug('update_text_cb(): %s', val)
        buf = self.edit_box.get_buffer()
#        pos = buf.get_iter_at_offset(buf.get_property('cursor_position'))
        buf.handler_block(self.changed_signal)
        buf.set_text(val)
        buf.handler_unblock(self.changed_signal)
#        buf.place_cursor(pos)

