/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */

#include "DialogSplit.h"
#include "ISubtitleEditor.h"
#include <gtkmm/filechooserdialog.h>
#include <gtkmm/stock.h>
#include "Dialog.h"

/*
 *
 */
DialogSplit::DialogSplit(BaseObjectType* cobject, const Glib::RefPtr<Gnome::Glade::Xml>& refGlade)
:Gtk::Dialog(cobject)
{
	refGlade->get_widget("spin-start", m_spinStart);
	refGlade->get_widget("spin-end", m_spinEnd);

	m_spinStart->signal_value_changed().connect(
			sigc::mem_fun(*this, &DialogSplit::on_spin_start_changed));
}


/*
 *
 */
void DialogSplit::execute()
{
	Document *doc = SE::getInstance()->getDocument();
	g_return_if_fail(doc);
	
	show();
	
	unsigned int start = 1;
	unsigned int end = SE::getInstance()->getDocument()->get_subtitle_model()->getSize();

	m_spinStart->set_range(start,end);
	m_spinEnd->set_range(start,end);
	
	m_spinEnd->set_value(end);
	
	if(run() == Gtk::RESPONSE_OK)
	{
		unsigned int start = (unsigned int)m_spinStart->get_value();
		unsigned int end = (unsigned int)m_spinEnd->get_value();

		DialogSaveSubtitle dialog;
		if(dialog.run() == Gtk::RESPONSE_OK)
		{
			Glib::ustring file = dialog.get_filename();
			Glib::ustring encoding = dialog.getEncoding();
			Glib::ustring fmt = dialog.getFormat();

			// création d'une copy du doc tmp
			Document tmp(*doc);

			// on commence par la fin afin de ne pas perdre le numero
			tmp.get_subtitle_model()->remove(end+1, tmp.get_subtitle_model()->getSize());
			tmp.get_subtitle_model()->remove(1,start-1);
			tmp.get_subtitle_model()->rebuild_column_num();

			tmp.save(file, fmt, encoding);

		}
	}

	hide();
}

void DialogSplit::on_spin_start_changed()
{
	/*
	unsigned int start = (unsigned int)m_spinStart->get_value();

	unsigned int end = SE::getInstance()->getDocument()->get_subtitle_model()->getSize();

	m_spinEnd->set_range(start, end);
	*/
}
