/* ====================================================================
 * Copyright 2008  Martin Hauner
 *                 http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_WCVIEWLOGWIDGET_H
#define _SC_WCVIEWLOGWIDGET_H

// qt
#include <QtGui/QTreeWidget>


/** target widget for progress & notification messages. */
class WcViewLogWidget : public QTreeWidget
{
  typedef QTreeWidget super;
  Q_OBJECT 

public:
  WcViewLogWidget( QWidget *parent );
  virtual ~WcViewLogWidget();

  // overwrite
  void customEvent( QEvent* ce );

private slots:
  void canceled();
  void itemDoubleClick(QTreeWidgetItem*,int);

private:
  QTreeWidgetItem* findItem();
  QTreeWidgetItem* findItem(uint);
  void disable(QTreeWidgetItem*);
  void cancel(QTreeWidgetItem*);

  QIcon* _cancel;
  QPoint _lastMousePos;
};

#endif // _SC_WCVIEWLOGWIDGET_H
