/* ====================================================================
 * Copyright (c) 2009  Martin Hauner
 *                     http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "subcommander/wcview/ItemModel.h"
#include "subcommander-test/WcViewItemTest.h"
#include "sublib/OStreamQt.h"
#include "util-test/Link.h"
EXPORT_TESTCASE (AddingARootItemToAModel);

// gmock
#include <gmock/gmock.h>
using ::testing::Return;

namespace wcview
{

class MockWcViewItemData : public WcViewItemDataTest
{
public:
  MOCK_CONST_METHOD0 (columns, int());
};


class AddingARootItemToAModel : public ::testing::Test
{
protected:
  AddingARootItemToAModel () 
    : _model(sc::String("invisible/root"), &_mockData)
  {
    EXPECT_CALL (_mockData, columns()).WillRepeatedly(Return(3));

    _model.insert( createItem("invisible/root",
      WcViewItemTypeDir,WcViewItemStateNormal) );
  }

protected:
  MockWcViewItemData _mockData;
  ItemModel          _model;
};

TEST_F (AddingARootItemToAModel,shouldCreateAValidIndexForTheRootItem)
{
  QModelIndex idx = _model.index(0,0,QModelIndex());

  EXPECT_EQ ( 0, idx.row() );
  EXPECT_EQ ( 0, idx.column() );
  EXPECT_EQ ( QModelIndex(), idx.parent() );
}

TEST_F (AddingARootItemToAModel,shouldCreateAnInvalidIndexForOtherItems)
{
  QModelIndex idx = _model.index(1,0,QModelIndex());

  EXPECT_EQ ( QModelIndex(), idx );
}

TEST_F (AddingARootItemToAModel,shouldReturnNoRowsExceptForColumnZero)
{
  QModelIndex idx;
  EXPECT_EQ ( 1, _model.rowCount(idx) );

  idx = _model.index(0,0,QModelIndex());
  EXPECT_EQ ( 0, _model.rowCount(idx) );
  idx = _model.index(0,1,QModelIndex());
  EXPECT_EQ ( 0, _model.rowCount(idx) );
  idx = _model.index(0,2,QModelIndex());
  EXPECT_EQ ( 0, _model.rowCount(idx) );
}

} // namespace
