/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_BLAMEPARAM_H
#define _SC_BLAMEPARAM_H

// sc
#include "ScParam.h"
#include "svn/BlameBaton.h"
#include "svn/Revision.h"
#include "util/String.h"

namespace svn
{
  class Revision;
  class BlameBaton;
}


/**
 * Parameter class for BlameCmd.
 */
class BlameParam : public ScParam
{
public:
  BlameParam( const sc::String& pathOrUrl, const svn::Revision* start, const svn::Revision* stop,
    svn::BlameBaton* baton ) : _pathOrUrl(pathOrUrl), _startRev(start), _stopRev(stop),
    _baton(baton)
  {
  }

  ~BlameParam()
  {
    delete _startRev;
    delete _stopRev;
    delete _baton;
  }

  const sc::String& getPathOrUrl() const
  {
    return _pathOrUrl;
  }

  const svn::Revision* getStartRevision() const
  {
    return _startRev;
  }

  const svn::Revision* getStopRevision() const
  {
    return _stopRev;
  }

  svn::BlameBaton* getBaton() const
  {
    return _baton;
  }

  ScParamAccept(BlameParam);

private:
  // in
  sc::String           _pathOrUrl;
  const svn::Revision* _startRev;
  const svn::Revision* _stopRev;
  svn::BlameBaton*     _baton;
};

#endif // _SC_BLAMEPARAM_H
