/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_WORKINGCOPYFILESWIDGET_H
#define _SC_WORKINGCOPYFILESWIDGET_H

// sc
#include "sublib/TargetId.h"
#include "svn/WcStatus.h"
class WcModel;
class ScCmd;
class WorkingCopyLvi;
class WcStatusLvi;
class ActionStorage;
class DragInfo;
class QPopupMenu;

namespace svn
{
  class Error;
}

// qt
#include <qlistview.h>

// sys
#include <map>


class WorkingCopyFilesWidget : public QListView, public TargetId
{
  typedef std::map<sc::String,WcStatusLvi*> Entries;

  typedef QListView super;
  Q_OBJECT 

public:
  WorkingCopyFilesWidget( WcModel* model, QWidget* eventTarget,
    QWidget *parent=0, const char *name=0 );
  virtual ~WorkingCopyFilesWidget();

  void focusInEvent( QFocusEvent* );
  void focusOutEvent( QFocusEvent* );
  void clear();

  void customEvent( QCustomEvent* ce );

  void dragMoveEvent( QDragMoveEvent* e );
  void dragLeaveEvent( QDragLeaveEvent* e );
  void dropEvent( QDropEvent* e );
  QDragObject* dragObject();

  QPopupMenu* getMenu();

  void reload();

public slots:
  void updateView();

  void add();
  void revert();
  void diff();
  void commit();
  void edit();
  void resolved();
  void remove();
  void log();
  void move();
  void properties();
  void ignore();
  void blame();
  void lock();
  void unlock();
  void cleanup();
  void mkdir();
  void exportx();
  void updateRev();
  void branch();
  void loggraph();

private slots:
  void itemRenamed( QListViewItem* item, int col, const QString& text );
  void contextMenuRequest( QListViewItem* item, const QPoint& p, int col );
  void updateSelection();
  void expanded( QListViewItem* item );
  void collapsed( QListViewItem* item );
  void doubleClicked( QListViewItem* item, const QPoint& p, int col );
  void dragTimeout();

private:
   void getSelection( svn::WcStatuss& statuss );
   void updateViewFlat();
   void updateViewTree();
   void status( const sc::String& path, bool reload );

private:
  WcModel*       _wcModel;
  QWidget*       _eventTarget;

  ActionStorage* _actions;
  QPopupMenu*    _menu;
  Entries        _entries;      ///< used to remove duplicates

  bool           _doubleClick;  ///< expanded/collapsed triggerd by double click?
  bool           _clearItems;   ///< clear item on next update?
  
  DragInfo*      _dragInfo;     ///< temporary drag&drop info
};

#endif // _SC_WORKINGCOPYFILESWIDGET_H
