/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "BaseModel.h"
#include "ScModel.h"
#include "Project.h"
#include "commands/CopyCmd.h"
#include "commands/CopyParam.h"
#include "commands/DiffCmd.h"
#include "commands/DiffParam.h"
#include "commands/LogCmd.h"
#include "commands/LogParam.h"
#include "commands/CatCmd.h"
#include "commands/CatParam.h"
#include "commands/CheckoutCmd.h"
#include "commands/CheckoutParam.h"
#include "commands/MergeCmd.h"
#include "commands/MergeParam.h"
#include "commands/MoveCmd.h"
#include "commands/MoveParam.h"
#include "commands/PropSetRevCmd.h"
#include "commands/PropSetRevParam.h"
#include "commands/BlameCmd.h"
#include "commands/BlameParam.h"
#include "commands/ExportCmd.h"
#include "commands/ExportParam.h"
#include "commands/LockCmd.h"
#include "commands/LockParam.h"
#include "commands/UnlockCmd.h"
#include "commands/UnlockParam.h"
#include "commands/DeleteCmd.h"
#include "commands/DeleteParam.h"
#include "commands/InfoCmd.h"
#include "commands/InfoParam.h"


BaseModel::BaseModel( ScModel* model ) : _model(model), _drag(false)
{
}

BaseModel::~BaseModel()
{
}

void BaseModel::copy( CopyParam* param, CmdResultCallback* cb )
{
  CopyCmd* cmd = new CopyCmd( param, cb );
  _model->runAsync(cmd);
}

void BaseModel::diff( DiffParam* param, CmdResultCallback* cb )
{
  DiffCmd* cmd = new DiffCmd( param, cb );
  _model->runAsync(cmd);
}

void BaseModel::log( LogParam* param, CmdResultCallback* cb )
{
  LogCmd* cmd = new LogCmd( param, cb );
  _model->runAsync( cmd );
}

void BaseModel::cat( CatParam* param, CmdResultCallback* cb )
{
  CatCmd* cmd = new CatCmd( param, cb );
  _model->runAsync( cmd );
}

void BaseModel::checkout( CheckoutParam* param, CmdResultCallback* cb )
{
  CheckoutCmd* cmd = new CheckoutCmd( param, cb );
  _model->runAsync( cmd );
}

void BaseModel::move( MoveParam* param, CmdResultCallback* cb )
{
  MoveCmd* cmd = new MoveCmd( param, cb );
  _model->runAsync( cmd );
}

void BaseModel::propsetrev( PropSetRevParam* param, CmdResultCallback* cb )
{
  PropSetRevCmd* cmd = new PropSetRevCmd( param, cb );
  _model->runAsync( cmd );
}

void BaseModel::blame( BlameParam* param, CmdResultCallback* cb )
{
  BlameCmd* cmd = new BlameCmd( param, cb );
  _model->runAsync( cmd );
}

void BaseModel::exportx( ExportParam* param, CmdResultCallback* cb )
{
  ExportCmd* cmd = new ExportCmd( param, cb );
  _model->runAsync( cmd );
}

void BaseModel::lock( LockParam* param, CmdResultCallback* cb )
{
  LockCmd* cmd = new LockCmd( param, cb );
  _model->runAsync( cmd );
}

void BaseModel::unlock( UnlockParam* param, CmdResultCallback* cb )
{
  UnlockCmd* cmd = new UnlockCmd( param, cb );
  _model->runAsync( cmd );
}

void BaseModel::remove( DeleteParam* param, CmdResultCallback* cb )
{
  DeleteCmd* cmd = new DeleteCmd( param, cb );
  _model->runAsync( cmd );
}

void BaseModel::merge( MergeParam* param, CmdResultCallback* cb )
{
  MergeCmd* cmd = new MergeCmd( param, cb );
  _model->runAsync(cmd);
}

void BaseModel::info( InfoParam* param, CmdResultCallback* cb )
{
  InfoCmd* cmd = new InfoCmd( param, cb );
  _model->runAsync(cmd);
}

void BaseModel::removeProject( Project* prj )
{
  _model->removeProject(prj);
}

void BaseModel::reorderProjects( Project* src, Project* dst )
{
  _model->reorderProjects(src,dst);
}

void BaseModel::saveProject( Project* prj )
{
  _model->saveProject(prj);
}

bool BaseModel::isCmdRecursive()
{
  return _model->getOptionCommandRecurse();
}

void BaseModel::setCmdRecursive(bool b)
{
  _model->setOptionCommandRecurse(b);
}

bool BaseModel::isCmdForce()
{
  return _model->getOptionCommandForce();
}

void BaseModel::setCmdForce(bool b)
{
  _model->setOptionCommandForce(b);
}

void BaseModel::setDrag(bool b)
{
  _drag = b;
}

bool BaseModel::isDragging() const
{
  return _drag;
}

ScModel* BaseModel::getModel()
{
  return _model;
}
