/*
 * Storm Package Manager
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

/* glob-matching code, copied from older project. */

#include <stdio.h>

#include <sys/types.h>
#include <ctype.h>

#include <match.h>

/* Non-recursive match() -- FAST.
 * Note: this works slightly differently than the match() in ircd:
 * The quote character '\\' _always_ quotes.  "\\a" is treated as "a",
 * not "\\a" in ircd.  "\\*" is still treated as "\\*".
 * This makes more sense to me when it comes to expanding its
 * functionality; eg: if '%' is ever implemented.
 *
 * Written in 1997 by Simon Kirby as part of aircd.
 */
int match(char *m,char *y,int case_sensitive){
   char *x;
   char *wildx,*wildy; 
   char quote,wildcard;

   if (!*m)  
      if (*y)
         return 0;
   wildcard = 0;
   x = m;
   wildx = x;
   wildy = y; 
   for (;;){  
      if (*x){
         if (*x == '*'){
            for (x++;*x == '*';x++);
            wildx = x; 
            wildy = y; 
            wildcard++;
         }
         if (*x)
            if (!*y)
               return 0;
      } else {   
         if (!*y)
            return 1;
         for (x--;((x > m) && (*x == '?'));x--);
         if ((*x == '*') && (x > m))
            if (x[-1] != '\\')
               return 1;
         if (!wildcard) 
            return 0;   
         x = wildx;     
         y = ++wildy;   
      }
      if (*x == '\\'){
         x++;
         quote = 1;
      } else
         quote = 0;
      if (((case_sensitive && (*x == *y)) ||
           (!case_sensitive && (tolower(*x) == tolower(*y)))) ||
          (*x == '?') || (quote)){
         if (*x)
            x++;
         if (*y)
            y++;
      } else {  
         if (!wildcard)
            return 0;  
         x = wildx;    
         y = ++wildy;  
      }
   }   
}      
