/*
 * m i s c . c					-- Misc. functions
 * 
 * Copyright  2000-2001 Erick Gallesio - I3S-CNRS/ESSI <eg@unice.fr>
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 * USA.
 * 
 *           Author: Erick Gallesio [eg@unice.fr]
 *    Creation date:  9-Jan-2000 12:50 (eg)
 * Last file update: 27-Feb-2001 22:59 (eg)
 */

#include "stklos.h"
#include <regex.h>

#ifdef STK_DEBUG
int STk_interactive_debug = 0;
#endif


char *STk_strdup(const char *s)
{
  /* Like standard strdup but with our allocator */
  char *res; 
  
  res = STk_must_malloc_atomic(strlen(s) + 1);
  strcpy(res, s);
  return res;
}


void STk_add_primitive(struct primitive_obj *o)
{
  SCM symbol;

  symbol = STk_intern(o->name);
  STk_define_variable(symbol, (SCM) o, STk_current_module);
}


/*===========================================================================*\
 * 
 * Primitives that feet anywhere else 
 * 
\*===========================================================================*/
/*
<doc ext version
 * (version)
 *
 * Returns a string identifying the current version of the system. A version is 
 * constituted of three numbers separated by a point: the version, the release
 * and sub-release numbers.
doc>
 */
DEFINE_PRIMITIVE("version", version, subr0, (void))
{
  return STk_Cstring2string(VERSION);
}


/*
<doc ext void
 * (void)
 * (void arg1 ...)
 *
 * Returns the special @emph{void} object. If arguments are passed to |void|,
 * they are evalued and simply ignored.
doc>
 */
DEFINE_PRIMITIVE("void", scheme_void, vsubr, (int argc, SCM *argv))
{
  return STk_void;
}


/*
<doc address-of
 * (address-of obj)
 *
 * Returns the address of the object |obj| as an integer.
doc>
*/
DEFINE_PRIMITIVE("address-of", address_of, subr1, (SCM object))
{
  char buffer[50];     /* should be sufficient for a while */

  sprintf(buffer, "%lx", (unsigned long) object); /* not very efficient ... */
  return STk_Cstr2number(buffer, 16L);
}


/*
<doc gc
 * (gc)
 *
 * Returns the address of the object |obj| as an integer.
doc>
*/
DEFINE_PRIMITIVE("gc", scheme_gc, subr0, (void))
{
  STk_gc();
  return STk_void;
}


/*===========================================================================*\
 * 
 * 			Debugging Code
 * 
\*===========================================================================*/
#ifdef STK_DEBUG
DEFINE_PRIMITIVE("%debug", set_debug, subr0, (void))
{
  STk_interactive_debug = !STk_interactive_debug;
  STk_debug("Debug mode %d", STk_interactive_debug);
  return STk_void;
}

DEFINE_PRIMITIVE("%test", test, subr1, (SCM s))
{
  /* A special place for doing tests */
  STk_debug("On a ~S |%s|", s, STRING_CHARS(s));
  return STk_void;
}
#endif 


/*===========================================================================*\
 * 
 * 				Initialization
 * 
\*===========================================================================*/
int STk_init_misc(void)
{
  ADD_PRIMITIVE(version);
  ADD_PRIMITIVE(scheme_void);
  ADD_PRIMITIVE(address_of);
  ADD_PRIMITIVE(scheme_gc);

#ifdef STK_DEBUG
  ADD_PRIMITIVE(set_debug);
  ADD_PRIMITIVE(test);
#endif
  return TRUE;
}

