
/* $Id: phonebook.h,v 201.0 2002/02/14 09:29:14 sgifford Exp $ */

#ifndef PHONEBOOK_H
#define PHONEBOOK_H

#include "startalk.h"

#define STARTALK_PHONETYPE_OFFICE 1
#define STARTALK_PHONETYPE_HOME   2
#define STARTALK_PHONETYPE_MOBILE 3
#define STARTALK_PHONETYPE_PAGER  4
#define STARTALK_PHONETYPE_FAX    5
#define STARTALK_PHONETYPE_QMARK  6

#define MAX_NAMELEN 12
#define MAX_COMPANYLEN 12

struct startalk_phonebook_phonenum {
  int type;
  char num[33];
};

struct startalk_phonebook_entry {
  int pos;
  char name[17];
  char company[17];
  int numphones;
  struct startalk_phonebook_phonenum *phone[4];
};

#define STARTALK_PHONEBOOK_MAX MAX_ENTRIES
struct startalk_phonebook {
  struct startalk_phonebook_entry *entry[STARTALK_PHONEBOOK_MAX];
};

struct startalk_phonebook_phonenum *startalk_new_phonebook_phonenum(int type, char *num);
void startalk_delete_phonebook_phonenum(struct startalk_phonebook_phonenum *d);
struct startalk_phonebook_entry *startalk_new_phonebook_entry(void);
void startalk_delete_phonebook_entry(struct startalk_phonebook_entry *d);
struct startalk_phonebook *startalk_new_phonebook(void);
void startalk_delete_phonebook(struct startalk_phonebook *d);
int startalk_add_phone_to_entry(struct startalk_phonebook_entry *e, int type, char *num);
int startalk_add_phonestruct_to_entry(struct startalk_phonebook_entry *e, struct startalk_phonebook_phonenum *p);
void startalk_print_phonebook_entry(struct startalk_phonebook_entry *e);
void startalk_print_phonebook_phonenum(struct startalk_phonebook_phonenum *p);


#endif /* PHONEBOOK_H */
