// StarPlot - A program for interactively viewing 3D maps of stellar positions.
// Copyright (C) 2000  Kevin B. McCarty
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


// greek.h: This file contains data about the 24 Greek letters used by
//          starplot and starconvert.

#ifndef _GREEK_H
#define _GREEK_H

#include <string>

// there are two different abbreviations for Alpha, so this is 25 not 24,
//  and for loops (other than those matching abbreviations) should start at 1.
const int NUM_GREEK_LETTERS = 25; 

struct greekletter {
  std::string abbrev;    // e.g. ALF or ALP for Alpha
  std::string name;      // e.g. Alpha
  std::string utf8;	 // representation of lowercase letter in UTF-8
};

const greekletter Greek[NUM_GREEK_LETTERS] = {
  { "ALF", "Alpha",   "\xCE\xB1" }, { "ALP", "Alpha", "\xCE\xB1" },
  { "BET", "Beta",    "\xCE\xB2" },
  { "GAM", "Gamma",   "\xCE\xB3" },
  { "DEL", "Delta",   "\xCE\xB4" },
  { "EPS", "Epsilon", "\xCE\xB5" },
  { "ZET", "Zeta",    "\xCE\xB6" },
  { "ETA", "Eta",     "\xCE\xB7" },
  { "THE", "Theta",   "\xCE\xB8" },
  { "IOT", "Iota",    "\xCE\xB9" },
  { "KAP", "Kappa",   "\xCE\xBA" },
  { "LAM", "Lambda",  "\xCE\xBB" },
  { "MU",  "Mu",      "\xCE\xBC" },
  { "NU",  "Nu",      "\xCE\xBD" },
  { "XI",  "Xi",      "\xCE\xBE" },
  { "OMI", "Omicron", "\xCE\xBF" }, // 0xCEBF + 1 == 0xCF80??  Such is the
  { "PI",  "Pi",      "\xCF\x80" }, // wonder of UTF-8
  { "RHO", "Rho",     "\xCF\x81" },
  // skip "\xCF\x82" which is the alternate version of lowercase sigma
  { "SIG", "Sigma",   "\xCF\x83" },
  { "TAU", "Tau",     "\xCF\x84" },
  { "UPS", "Upsilon", "\xCF\x85" },
  { "PHI", "Phi",     "\xCF\x86" },
  { "CHI", "Chi",     "\xCF\x87" },
  { "PSI", "Psi",     "\xCF\x88" },
  { "OME", "Omega",   "\xCF\x89" }
};

#endif // #ifndef _GREEK_H
