/* @(#)error.c	1.13 03/06/15 Copyright 1985, 1989, 1995-2003 J. Schilling */
/*
 *	fprintf() on standard error stdio stream
 *
 *	Copyright (c) 1985, 1989, 1995-2003 J. Schilling
 */
/*
 * Copyright Jrg Schilling. All rights reserved.
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only.
 * See the file CDDL.Schily.txt in this distribution or
 * http://opensource.org/licenses/cddl1.php for details.
 */

#include <mconfig.h>
#include <stdio.h>
#include <standard.h>
#include <vadefs.h>
#include <schily.h>

/* VARARGS1 */
#ifdef	PROTOTYPES
EXPORT int
error(const char *fmt, ...)
#else
EXPORT int
error(fmt, va_alist)
	char	*fmt;
	va_dcl
#endif
{
	va_list	args;
	int	ret;

#ifdef	PROTOTYPES
	va_start(args, fmt);
#else
	va_start(args);
#endif
	ret = js_fprintf(stderr, "%r", fmt, args);
	va_end(args);
	return (ret);
}
