/*
 * Copyright (c) 2002-2009 Moxie Marlinspike
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __DESTINATION_H__
#define __DESTINATION_H__

#include <linux/netfilter_ipv4.h>
#include <arpa/inet.h>
#include <boost/asio.hpp>

class IndeterminateDestinationException : public std::exception {
public:
  virtual const char* what() const throw() {
    return "Could not determine original destination...";
  }  
};

class Destination {

public:
  
  static int getOriginalDestination(boost::asio::ip::tcp::socket &socket,
				    boost::asio::ip::tcp::endpoint &originalDestination) 
  {
    struct sockaddr_in serverAddr;
    int fd   = (int)socket.native();     
    int size = sizeof(serverAddr);
    
    if (getsockopt(fd, SOL_IP, SO_ORIGINAL_DST, &serverAddr, (socklen_t*)&size) < 0) {
      perror("Could not determine socket's original destination.");
      throw IndeterminateDestinationException();
    }

    originalDestination = boost::asio::ip::tcp::endpoint(boost::asio::ip::address_v4(ntohl(serverAddr.sin_addr.s_addr)), ntohs(serverAddr.sin_port));
    
    return 1;
  }
};


#endif
