#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "url.h"

static char *Strdup(char *s)
{
	char   *m;

	if (!s)
		return NULL;
	if (!(m = (char *) malloc(strlen(s) + 1)))
		return NULL;
	return strcpy(m, s);
}
static int cgiHexInt(char x)
{
	return (x >= '0' && x <= '9') ? (x - '0') : (x >= 'a' && x <= 'f') ? (x - 'a' + 10) : (x >= 'A' && x <= 'F') ? (x - 'A' + 10) : 0;
}
static char cgiHexAsc(char x1, char x2)
{
	return (isxdigit(x1) && isxdigit(x2)) ? ((cgiHexInt(x1) << 4) + cgiHexInt(x2)) : ' ';
}
static char *cgiDecodeUrl(char *data)
{
	char   *i, *j;

	for (j = i = data; *i != '\0'; i++, j++)

	{
		if (*i == '%')

		{
			*j = cgiHexAsc(*(i + 1), *(i + 2));
			i += 2;
		}

		else if (*i == '+')
			*j = ' ';

		else
			*j = *i;
	}
	*j = '\0';
	return data;
}


/*************************************************************
Fonctions publiques
**************************************************************/
int     urlAdd(url_t * url, char *var, char *val)
{
	pair_t *pair;

	url->form->pair = (pair_t **) realloc(url->form->pair, (url->form->size + 1) * sizeof(pair_t *));
	if (!(url->form->pair))
		return 0;
	pair = (pair_t *) malloc(sizeof(pair_t));
	pair->var = Strdup(var);
	pair->val = Strdup(val);
	if (!(url->form->pair[url->form->size] = pair))
		return 0;
	url->form->size += 1;

#ifdef DBG
	printf("addVar OK\n");

#endif				
	return 1;
}

int     parseURL(url_t * url)
{
	char   *var, *val;
	int     cnt, stPnt = 0, eqPnt = 0, eqCnt = 0, amPnt = 0, amCnt = 0;
	int     len;
	char   *input;

	len = strlen(url->url);
	input = Strdup(url->url);
	if (!len)
		return 1;
	for (cnt = 0; cnt <= len; cnt++)

	{
		if (input[cnt] == '=')

		{
			eqCnt++;
			eqPnt = cnt;
		}

		else if (input[cnt] == '&' || cnt == len)

		{
			amCnt++;
			amPnt = cnt;
		}
		if (!eqCnt && amCnt)	/* no equal in equal/ampersand pair */
			return 0;

		else if (eqCnt > 1 || amCnt > 1)	/* equal/ampersand followed by same */
			return 0;

		else if (eqCnt && amCnt)

		{
			if (stPnt == eqPnt)	/* not allowed to have a NULL variable */
				return 0;
			if (!(var = (char *) calloc(eqPnt - stPnt + 1, 1)))
				return 0;
			memcpy(var, input + stPnt, eqPnt - stPnt);
			var = cgiDecodeUrl(var);
			if (!(val = (char *) calloc(amPnt - eqPnt, 1)))
				return 0;
			memcpy(val, input + eqPnt + 1, amPnt - eqPnt - 1);
			val = cgiDecodeUrl(val);
			if (!urlAdd(url, var, val))
				return 0;
			free(var);
			free(val);
			eqCnt = amCnt = 0;
			stPnt = amPnt + 1;
		}
	}
	return 1;
}

url_t  *NewURL(void)
{
	url_t  *url;

	url = (url_t *) malloc(sizeof(url_t));
	url->form = (form_t *) malloc(sizeof(form_t));
	url->form->size = 0;
	url->form->pair = NULL;
	url->url = NULL;

#ifdef DBG
	printf("NewURL OK\n");

#endif				
	return url;
}

url_t  *NewURLFromString(char *str)
{
	url_t  *url;

	url = NewURL();
	url->url = Strdup(str);
	parseURL(url);
	return url;
}
char   *getVal(url_t * url, char *var)
{
	int     cnt;

	for (cnt = 0; cnt < url->form->size; cnt++)
		if (!strcmp(var, url->form->pair[cnt]->var))
			return Strdup(url->form->pair[cnt]->val);
	return NULL;
}
char   *urlEncode(char *data)
{
	char   *hex = "0123456789ABCDEF";
	char   *i, *j, *code;
	int     inc;

	for (inc = 0, i = data; *i != '\0'; i++)
		if (!isalnum((unsigned char) (*i)))
			inc += 2;
	if (!(code = (char *) malloc(strlen(data) + inc + 1)))
		return NULL;
	for (j = code, i = data; *i != '\0'; i++, j++)

	{
		if (*i == ' ')
			*j = '+';

		else if (!isalnum((unsigned char) (*i)))

		{
			*j++ = '%';
			*j++ = hex[(unsigned char) (*i) / 16];
			*j = hex[(unsigned char) (*i) % 16];
		}

		else
			*j = *i;
	}
	*j = '\0';
	return code;
}

char   *urlHasString(url_t * url)
{
	char   *retour;
	int     cnt;
	retour = (char *) malloc(sizeof(char));

	*retour = '\0';
	if (url->form->size)

	{
		retour = Strcat(retour, url->form->pair[0]->var);
		retour = Strcat(retour, "=");
		retour = Strcat(retour, urlEncode(url->form->pair[0]->val));
	}
	for (cnt = 1; cnt < url->form->size; cnt++)

	{
		retour = Strcat(retour, "&");
		retour = Strcat(retour, url->form->pair[cnt]->var);
		retour = Strcat(retour, "=");
		retour = Strcat(retour, urlEncode(url->form->pair[cnt]->val));
	}
	return retour;
}
void    urlSetVal(url_t * url, char *var, char *val)
{
	if (!getVal(url, var))
		urlAdd(url, var, val);

	else

	{
		int     cnt;

		for (cnt = 0; cnt < url->form->size; cnt++)

		{
			if (!strcmp(var, url->form->pair[cnt]->var))

			{
				free(url->form->pair[cnt]->val);
				url->form->pair[cnt]->val = Strdup(val);
				break;
			}
		}
	}
}
char   *Strcat(char *s1, char *s2)
{
	s1 = (char *) realloc(s1, (strlen(s1) + strlen(s2) + 1) * sizeof(char));

	strcat(s1, s2);
	return s1;
}

int     urlGetLength(url_t * url)
{
	return url->form->size;
}
char   *urlGetValFromIndex(url_t * url, int idx)
{
	if ((idx > url->form->size - 1) || (idx < 0))
		return NULL;

	else
		return strdup(url->form->pair[idx]->val);
}
