/*****************************************************************************
	$Author: vied $
	$Date: 2004/01/22 09:09:38 $
	$RCSfile: spp_signe.c,v $
	$Revision: 1.8 $
	$Log: spp_signe.c,v $
	Revision 1.8  2004/01/22 09:09:38  vied
	Correction du bug sur l'API calcul_hmac
	
	Revision 1.7  2004/01/19 10:21:24  vied
	Modification calcul_hmac suite  pb sur certains sites. Li  snprintf
	
	Revision 1.6  2004/01/19 10:11:11  vied
	Modification calcul_hmac suite  pb sur certains sites
	
	Revision 1.5  2004/01/19 09:50:55  vied
	Modification calcul_hmac suite  pb sur certains sites
	
	Revision 1.4  2003/12/08 14:42:25  vied
	Correction erreur sur nb arguments de memcpy + Erreurs sur sp_NTHMAC au lieu de NTHMAC
	
	Revision 1.3  2003/12/05 15:58:26  vied
	no message
	
	Revision 1.2  2003/12/05 14:08:18  vied
	Ajout entetes CVS + Modification pour correction buffer overflow
	
******************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
#include "apiweb.h"
#include "url.h"
#include "code.h"

/* encodage en base 64 */
#include "b64.h"

// Constant definitions
#define ASCIIHMACLENGTH	41
#define	HEXADHMACLENGTH	25
#define	URLLENGTH		8192


int getMontant(url_t *url)
{

	char           *buffer;
	char           *ptr;
	int             i;
	char *mnt;

	mnt=getVal(url,"montant");
	if(!mnt)
		return MNT_ERROR;

	/*
	 * Supression des espaces
	 */
	if (strstr(mnt, " "))
	{
		if(buffer = (char*) malloc((strlen(mnt)+1)* sizeof(char)))
		{
			for (ptr = mnt, i = 0; *ptr; ptr++)
			{
				if (!isspace(*ptr))
				{
					buffer[i++] = *ptr;
				}
			}
			buffer[i] = '\0';
			memcpy(mnt, buffer, strlen(buffer));
			free(buffer);
		}
	}

	/*
	 * si "," et "." sont present '.'=separateur decimal et ','=separateur centaines
	 */
	if (strstr(mnt, ",") && strstr(mnt, "."))
	{
		if(buffer = (char*) malloc((strlen(mnt)+1)* sizeof(char)))
		{
			for (ptr = mnt, i = 0; *ptr; ptr++)
			{
				if (*ptr != ',')
				{
					buffer[i++] = *ptr;
				}
			}
			buffer[i] = '\0';
			memcpy(mnt, buffer, strlen(buffer));
			free(buffer);
		}
	}

	/*
	 * si "," est present ','=separateur decimal
	 */
	if ((ptr = strstr(mnt, ",")))
	{
		*ptr = '.';
	}

	urlSetVal(url,"montant",mnt);
	return OK;
}

void getReference(url_t *url)
{
	char           *reference;
	time_t          tps;
	char            buffer[50];

	reference = getVal(url,"reference");
	if (!reference || !strcmp(reference, "NULL"))
	{
		tps = time(NULL);
		snprintf(buffer, sizeof(buffer)-1, "%ld", tps);
		reference = strdup(buffer);
		urlSetVal(url,"reference",reference);
	}
}

void getLangue(url_t *url)
{
	char           *langue;

	langue = getVal(url,"langue");
	if (!langue || !strcmp(langue, "NULL"))
	{
		langue = strdup("FR");
		urlSetVal(url,"langue",langue);
	}
}

int getDevise(url_t *url)
{
	char           *devise;

	devise = getVal(url,"devise");
	if (!devise || !strcmp(devise, "NULL"))
		return DEVISE_ERROR;
	else
		return OK;
}

void getTaxe(url_t *url)
{
	char           *taxe;

	taxe = getVal(url,"taxe");
	if (!taxe || !strcmp(taxe, "NULL"))
	{
		urlSetVal(url,"taxe",strdup("0.00"));
	}
}

void getValidite(url_t *url)
{
	char           *validite;
	struct tm      *tps;
	time_t          tt;

	validite = getVal(url,"validite");
	if (!validite || !strcmp(validite, "NULL"))
	{
		tt = time(NULL);
		tps = localtime(&tt);
		tps->tm_year += 1;
		validite = (char *) malloc(11 * sizeof(char));
		strftime(validite, 11, "%d/%m/%Y", tps);
		urlSetVal(url,"validite",validite);
	}
}

int getCodesiret(url_t *url)
{
	char           *siret;

	siret = getVal(url,"siret");
	if (!siret || !strcmp(siret, "NULL"))
		return SIRET_ERROR;
	else
		return OK;
}


int urlSetDefaultPaiementValues(url_t *url)
{
	int rt;
	rt=OK;
	rt=getCodesiret(url);
	if(rt!=OK)
		return rt;
	/* la date de validite de la commande est maintenant facultative */
    //getValidite(url);
	getTaxe(url);
	rt=getDevise(url);
	if(rt!=OK)
		return rt;
	getLangue(url);
	getReference(url);
	rt=getMontant(url);
	if(rt!=OK)
		return rt;
	return rt;
}

char *sp_NTHMAC(char *clent, char *data)
{
	unsigned int     len, i;
	char    Hmac[ASCIIHMACLENGTH];
	unsigned char hex[HEXADHMACLENGTH];
	char   *cle, *p;

	cle = clent;
	len = strlen(data);
	for (p = cle, i = 0; i * 3 < strlen(cle); p += 3)
	{
		int     c;

		sscanf(p, "%2x", &c);
		hex[i] = c;
		i++;
	}
	hex[HEXADHMACLENGTH - 1] = '\0';
	HMacCalcul((unsigned char *) hex, (unsigned char *) data, len, (unsigned char *) Hmac);
	Hmac[ASCIIHMACLENGTH - 1] = 0;
	return strdup(Hmac);
}




char *sp_signeURLPaiement(char *clent,char *urlstr)
{
	url_t *url;
	char *baseurl;
	char *param;
	char *data;
	char *retour;
    /* encodage en base 64 */
    char url64[URLLENGTH];
    size_t b64_out_len = 0;
        
	baseurl=strdup(urlstr);

	param=strstr(baseurl,"?")+1;
	*strstr(baseurl,"?")='\0';

	url=NewURLFromString(param);

	switch(urlSetDefaultPaiementValues(url))
	{
		case MNT_ERROR:
			return strdup("MNT_ERROR");
		break;
		case DEVISE_ERROR:
			return strdup("DEVISE_ERROR");
		break;
		case SIRET_ERROR:
			return strdup("SIRET_ERROR");
		break;
	}
	data=strdup("");
	data=Strcat(data,getVal(url,"siret"));
	data=Strcat(data,getVal(url,"reference"));
	data=Strcat(data,getVal(url,"langue"));
	data=Strcat(data,getVal(url,"devise"));
	data=Strcat(data,getVal(url,"montant"));
	data=Strcat(data,getVal(url,"taxe"));
    /* la date de validite de la commande est maintenant facultative */
	if (!getVal(url,"validite") || !strcmp(getVal(url,"validite"), "NULL")) {
		// on ne calcul plus de valeur par dfaut
	}
	else {
		data=Strcat(data, getVal(url,"validite"));
	}
	
	urlAdd(url,"hmac",sp_NTHMAC(clent,data));
	retour=strdup(baseurl);
    /* encodage en base 64 */
	retour=Strcat(retour,"?!");
    encode_base64(urlHasString(url), strlen(urlHasString(url)), url64, URLLENGTH, &b64_out_len);
	retour=Strcat(retour, url64);
	return retour;
}

char *sp_CalculHmac(char *clent,char *data)
{
	url_t *url;
	char *retour;
	int i,n;

	url=NewURLFromString(data);

	retour=strdup("");
	n=urlGetLength(url);
	for(i=0;i<n;i++)
	{
		retour=Strcat(retour,urlGetValFromIndex(url,i));
	}
	return sp_NTHMAC(clent,retour);
}

char *sp_calcul_hmac(char *cle,char *siret,char *reference,char *langue,char *devise,char *montant,char *taxe,char *validite)
{
	int datasize;
	char hmac[ASCIIHMACLENGTH];
	char *data;
	int i;
	char hex[HEXADHMACLENGTH];
	char *p;
	FILE *f_debug = NULL;
	
	if(f_debug = fopen("/tmp/test.log","a"))
	{
		fprintf(f_debug,"Donnees recues : Siret = %s, Reference = %s, Langue = %s, Devise = %s, Montant = %s, Taxe = %s, Validite = %s",
		siret, reference, langue, devise, montant, taxe, validite);
	}
	datasize=0;
	datasize=strlen(siret)+strlen(montant)+strlen(reference)+strlen(validite)+strlen(taxe)+strlen(devise)+strlen(langue)+1;
	
	if(data=(char *)malloc((datasize)*sizeof(char)))
	{
		memset(data,0,sizeof(data));
		snprintf(data,datasize,"%s%s%s%s%s%s%s",siret,reference,langue,devise,montant,taxe,validite);
		for(p=cle,i=0;i*3<strlen(cle);p+=3)
		{
			int c;
			sscanf(p,"%2x",&c);
			hex[i]=c;
			i++;
		}	
		hex[HEXADHMACLENGTH - 1]='\0';
		if(f_debug)
		{
			fprintf(f_debug,"\nDonnees envoyes a fonction de calcul = %s\n",data);
		}
	
		HMacCalcul((unsigned char *)hex,(unsigned char *)data,strlen(data),(unsigned char *)hmac);
		hmac[ASCIIHMACLENGTH - 1]=0;
		free(data);
		return strdup(hmac);
	}
	else
	{
		return strdup("MEMORY_ERROR");
	}
}
