#!/usr/local/bin/perl

use SmallPigVars qw($config);
use SmallPig;
use SPDB;
use SPCGI;

use strict;

my $lang;

sub main{
    #print "Content-type: text/html\n\n";

  # --- create a SPDB object
  my $spdb = SPDB->new;
  
  my $spcgi = SPCGI->new($spdb);
  $spcgi->set_state_for_client();
  
  # --- load the lang module
  $lang = $spcgi->{STATE}->{langptr} = SmallPig::get_lang_ptr($spcgi->{STATE}->{lang}, 
							      "comments");

  my $STATE = $spcgi->{'STATE'};

  my ($prev_op, $op, $mode, $display, $userstatus);
  ($prev_op, $op, $mode, $display, $userstatus) = 
      map{ $spcgi->{'STATE'}->{$_} } qw(prev_op op mode display userstatus);

    #print "************* $op, $userstatus";

  my $template;
  if(!can_find_page($spdb, $STATE)){
       require Templates::Caution;
       # --- create a template object
       $template = 
	 Templates::Caution->new($spcgi, $spdb, "", 
				 $lang->{'cant_found_page'}, 
				 "$config->{'cgidir'}/index.cgi");
  }
  # --- if spmail is available
  elsif($op eq "addmsgfav" && $userstatus ne "anon"){
      
      require Ops::Comments;
      my $obj = Ops::Comments->new($STATE, $spdb);
      
      my ($succ, $err_msg, $btitle, $url);
      ($succ, $err_msg, $btitle, $url) = $obj->add_msg_fav();
      
      require Templates::Caution;
      
      # --- create a template object
      $template = 
	Templates::Caution->new($spcgi, $spdb,
				$btitle, 
				$err_msg, $url);
  }
  elsif(can_read($spdb, $STATE)){
    
    # --- send message to friends
    if($config->{'spmail_cgi'} && $op eq "sendtofriends"){

	unshift(@INC, $config->{'spmail_cgi'});

	require Templates::MailSendMsg;
	$template = Templates::MailSendMsg->new($spcgi, $spdb, "sendtofriends");

    }
    # --- list the topics
    elsif($op eq "topicslist"){
      # --- display printable version
      if($mode eq "printable"){
	  require Templates::TopicsList;
	
	  # --- create a template object
	  $template = Templates::TopicsList->new($spcgi, $spdb, "printable");
	  #$opt_blocks = get_printable_topics_index($STATE);
      }
      else{
	
	  # --- found out the page can be written or not
	  $STATE->{'can_write'} = can_write($spdb, $STATE);
	  #$opt_blocks = get_topics_index($STATE);
	  
	  require Templates::TopicsList;
	
	  # --- create a template object
	  $template = Templates::TopicsList->new($spcgi, $spdb);
      }
    }
    
    # --- list a single thread
    elsif($op eq "threadlist" || $op eq $lang->{'Change'}){
	
	# --- recover the threadlist for compatibitlity
	$STATE->{'op'} = "threadlist";

	# --- display printable version
	if($mode eq "printable"){
	    require Templates::ThreadList;
	    $template = Templates::ThreadList->new($spcgi, $spdb, "printable");
	}
	else{
	    require Templates::ThreadList;
	    $template = Templates::ThreadList->new($spcgi, $spdb);
	    $template->get_rid_of_cids();
	}
    }
    
    # --- mark all threads as read
    elsif($op eq "markallthreads"){
	require Templates::Caution;
		
	# --- create a template object
	$template = Templates::Caution->new($spcgi, $spdb);

	require Ops::Comments;
	my $obj = Ops::Comments->new($STATE, $spdb);
	
	my ($succ, $err_msg, $btitle, $url) = $obj->mark_all_threads();
    
	$template->{'btitle'} = $btitle;
	$template->{'bmsg'} = $err_msg;
	$template->{'uri'} = $url;
    }
    else{
      # --- make sure the page is writable
      unless(can_write($spdb, $STATE)){
	  require Templates::Caution;
	  # --- create a template object
	  $template = 
	    Templates::Caution->new($spcgi, $spdb, "", 
				    $lang->{'post_not_allowed'}, 
				    "$config->{'cgidir'}/index.cgi");

	#$ctype = get_caution($STATE, $lang->{'post_not_allowed'});
      }
      else{

	if($op eq $lang->{'Submit'}){
	    require Ops::Comments;
	    my $obj = Ops::Comments->new($STATE, $spdb);

	    my ($succ, $err_msg, $btitle, $url);
	    if($prev_op =~ /newcomment/){
		($succ, $err_msg, $btitle, $url) = $obj->get_submit_post();
	    }
	    elsif($prev_op =~ /reply/){
		($succ, $err_msg, $btitle, $url) = $obj->get_submit_reply();
	    }
	    else{
		($succ, $err_msg, $btitle, $url) = $obj->get_edit_post();
	    }

	    if(!$succ){
		require Templates::Preview;
		
		# --- create a template object
		$template = Templates::Preview->new($spcgi, $spdb, 
						    "", $err_msg);
	    }
	    else{
		require Templates::Caution;
		
		# --- create a template object
		$template = 
		  Templates::Caution->new($spcgi, $spdb,
					  $btitle, 
					  $err_msg, $url);
	    }

	}
	elsif($op eq "newpost"){

	    require Templates::NewComment;
	    
	    # --- create a template object
	    $template = Templates::NewComment->new($spcgi, $spdb);

	    #$title = $lang->{'new_post'};
	}
	elsif($op eq "reply"){

	    require Templates::NewComment;
	    
	    # --- create a template object
	    $template = Templates::NewComment->new($spcgi, $spdb);
	    
	    #  $title = $lang->{'reply'};
	}
	  
	# --- preview 
	elsif($op eq $lang->{'Preview'}){

	    require Templates::Preview;
		
	    # --- create a template object
	    $template = Templates::Preview->new($spcgi, $spdb);

	    # $title = $lang->{'preview_post'};
	    #$title = $lang->{'preview_reply'};
	}
	
	# --- attach file
	elsif($op eq $lang->{'AttachFile'}){
	    
	    if($prev_op eq "newcomment" ||
	       $prev_op eq "reply" || 
	       $prev_op eq "editpost"){

		require Templates::AttachFile;
		
		# --- create a template object
		$template = Templates::AttachFile->new($spcgi, $spdb);

		#$title = $lang->{'file_attach'};

	    }
	    elsif($prev_op eq "newcomment#attachfile" ||
		  $prev_op eq "reply#attachfile" ||
		  $prev_op eq "editpost#attachfile"){
		
		require Ops::FileAttach;

		# --- save the file, and return error if one
		my ($fid, $caution) = 
		  Ops::FileAttach->new("", $spdb, $STATE)->save_file_attachment();

		require Templates::NewComment;

		# --- create a template object
		$template = Templates::NewComment->new($spcgi, $spdb, 
						       $fid, $caution);
	    }
	    elsif($prev_op =~ /preview$/){
		
		require Templates::AttachFile;
		
		# --- create a template object
		$template = Templates::AttachFile->new($spcgi, $spdb);

		#$title = $lang->{'file_attach'};
		
	    }
	    elsif($prev_op =~ /preview\#attachfile$/){
		require Ops::FileAttach;

		# --- save the file, and return error if one
		my ($fid, $caution) = 
		  Ops::FileAttach->new("", $spdb, $STATE)->save_file_attachment();
		
		require Templates::Preview;
		
		# --- create a template object
		$template = Templates::Preview->new($spcgi, $spdb, 
						       $fid, $caution);
		
		# $title = $lang->{'preview_post'};
	    }
	    
	    #$title = $lang->{'submit_attach'};
	}
	else{
	  # --- is op deletefile
	  my $cnt;
	  foreach (keys(%$STATE)){
	    if($_ =~ /DeleteFile.*\((.+)\)\.x/ ){
	      # --- delete file attachment
	      require Ops::FileAttach;
	      my $obj = Ops::FileAttach->new("", $spdb, $STATE);
	      $obj->delete_files("fid=$1", $1);
	      $cnt = 1;
	    }
	  }
	  if($cnt){
	      if($prev_op =~ /preview/){
		  require Templates::Preview;
		  # --- create a template object
		  $template = Templates::Preview->new($spcgi, $spdb);
	      }
	      else{
		  require Templates::NewComment;

		  # --- create a template object
		  $template = Templates::NewComment->new($spcgi, $spdb);
	      }
	      #  ($opt_blocks, $ctype) = get_preview_post($STATE);
	      #  $title = "Preview Reply";
	  }
	  elsif(can_modify($spdb, $STATE)){
	      if($op eq "editpost"){

		  require Templates::NewComment;
	    
		  # --- create a template object
		  $template = Templates::NewComment->new($spcgi, $spdb);
		  
		  #    $title = $lang->{'edit_post'};
	      }
	  }
	  else{
	      require Templates::Caution;
	      # --- create a template object
	      $template = 
		Templates::Caution->new($spcgi, $spdb, "", 
					$lang->{'cant_found_page'}, 
					"$config->{'cgidir'}/index.cgi");
	  }
	}
      }
    }
  }
  else{
      
      require Templates::Caution;
      # --- create a template object
      $template = 
	  Templates::Caution->new($spcgi, $spdb, "", 
				  $lang->{'cannot_read'}."$prev_op", 
				  "$config->{'cgidir'}/index.cgi");

  }
  
  if($template){
      $template->print_http_header();
      $template->print_template();	
  }
}
 
sub can_find_page{
  my ($spdb, $STATE) = @_;
  my $DBH = $spdb->{'dbh'};
  
  my ($sid, $cid) = map{ $STATE->{$_} } qw(sid cid);

  my $succ;
  my $sidq = $DBH->quote($sid);

  my $where = my $where1 = "sid=$sidq" if $sid;
  $succ =  $spdb->db_count("Boards", $where) if $sid;

  if(!$sid && $cid){ return 0; }
  else{
      $where1 .= " AND cid=$cid" if $sid && $cid;
      $succ =  $spdb->db_count("Posts", $where1) if $sid && $cid;
  }

  return $succ;
}

sub can_write{
  my ($spdb, $STATE) = @_;
  my $DBH = $spdb->{'dbh'};

  my ($sid, $username, $uid) = 
    map{ $STATE->{$_} } qw(sid username uid);
 
  my $sidq = $DBH->quote($sid);
    
  my $user_status = $STATE->{'userstatus'};
  my $tuserstatus = $STATE->{'tuserstatus'};
  # --- sid from mod userstatus --> ptr to arr
  my $sfmus = $tuserstatus->{mod};

  return 1 if($user_status eq "admin" || 
	      ($sfmus && grep { $_ eq $sid } @$sfmus));
  
  my $level="";
  ($level) = $spdb->db_select_cols("level", "Boards", 
                                  "sid=$sidq");

  my $status = get_board_status($level);
 
  my $flag = 0;
  if($user_status =~ /gmem/){
      ($flag) = $spdb->db_select_cols("allowwrite", "GroupMems", 
				      "sid=$sidq AND uid=$uid");
  }
 
  return 1 if($status eq "public" || 
              ($status eq "user private" && $user_status ne "anon") ||
	      ($status eq "user public" && $user_status ne "anon") ||
              ($status eq "group private" && $user_status =~ /gmem/ && $flag));
  return 0;
}

sub can_read{
  my ($spdb, $STATE) = @_;
  my $DBH = $spdb->{'dbh'};

  my ($sid, $username, $uid, $user_status, $tuserstatus) = 
    map{ $STATE->{$_} } qw(sid username uid userstatus tuserstatus);
  my $sidq = $DBH->quote($sid);
  my ($level, $active);
  ($level, $active) = $spdb->db_select_cols("level, active", "Boards", 
					    "sid=$sidq");
  return 0 if(($user_status ne "admin" && $user_status ne "mod") &&
	      $active==0);
  my $status = get_board_status($level);

  # --- sid from mod userstatus --> ptr to arr
  my $sfmus = $tuserstatus->{mod};
  my $sfgmus = $tuserstatus->{gmem};

  return 1 if($user_status eq "admin" || 
	      ($sfmus && grep { $_ eq $sid } @$sfmus) || 
	      ($sfgmus && grep { $_ eq $sid } @$sfgmus) ||
	      (($user_status =~ /gmem/ || $user_status eq "ruser" ||
		$user_status =~ /mod/) && $status !~ /group private/) || 
	      ($user_status eq "anon" && $status =~ /public/));
  return 0;
}

sub get_board_status{
  my $level = shift;
  my $status = "public" unless 63^$level;
  $status = "public protected" unless 62^$level;
  $status = "user public" unless 60^$level;
  $status = "user private" unless 56^$level;
  $status = "user private protected" unless 48^$level;
  $status = "group private" unless 32^$level;
  return $status;
}

sub can_modify{
  my ($spdb, $STATE) = @_;
  my $DBH = $spdb->{'dbh'};

  my ($sid, $uid, $cid, $userstatus) = 
    map{ $STATE->{$_} } qw(sid uid cid userstatus);

  my $select = "uid";
  my $from = "Posts";
  my $where = "cid=$cid";
  my ($tuid) = $spdb->db_select_cols($select, $from, $where) if $cid;
  
  # --- if user status is anon return 0
  return 0 if($userstatus eq "anon");

  # --- if user is a moderator of this board
  return 1 if(($userstatus =~ /mod/ && $userstatus =~ /$sid/) || 
	      $userstatus eq "admin" || $tuid == $uid);
  return 0;
}

main();
