#!/usr/local/bin/perl

use SmallPigVars qw($config);
use SmallPig;
use SPDB;
use SPCGI;

use strict;

my $lang;

sub main{
#    print "Content-type: text/html\n\n";
    
    # --- create a SPDB object
    my $spdb = SPDB->new();
    
    my $spcgi = SPCGI->new($spdb);
    $spcgi->set_state_for_client();
    
    # --- load the lang module
    $lang = $spcgi->{STATE}->{langptr} = SmallPig::get_lang_ptr($spcgi->{STATE}->{lang}, 
								"admin");
    
    my $STATE = $spcgi->{'STATE'};
    
    my ($op, $prev_op, $display, $userstatus) = 
	map{ $STATE->{$_} } qw(op prev_op display userstatus);

    my ($template, $cookie);

    if($op eq $lang->{'Login'}){
	require Ops::User;
	my $obj = Ops::User->new($STATE, $spdb);
	
	my ($succ, $err_msg, $btitle, $url);
	
	($succ, $err_msg, $btitle, $url, $cookie) = $obj->login();
	
	require Templates::Caution;
	
	# --- create a template object
	$template = 
	  Templates::Caution->new($spcgi, $spdb,
				  $btitle, 
				  $err_msg, $url);
	
	#$ctype = $userptr->login($STATE);
    }
    elsif($userstatus ne "anon"){
	if($userstatus !~ /mod/ && $userstatus !~ /admin/){
	    require Templates::Caution;
	    
	    # --- create a template object
	    $template = 
	      Templates::Caution->new($spcgi, $spdb, "", 
				      $lang->{'not_admin'});
	}
	elsif($userstatus =~ /admin/){

	    if($op eq $lang->{'SaveModerator'} || $op eq $lang->{'SaveGroup'}){
		require Ops::Admin;
		my $admin = Ops::Admin->new($STATE, $spdb);
		my ($succ, $err_msg, $btitle, $url) = $admin->save_mod_or_group();
		
		require Templates::Caution;
		
		# --- create a template object
		$template = 
		  Templates::Caution->new($spcgi, $spdb,
					  $btitle, 
					  $err_msg, $url);

	    }
	    
	    elsif($op eq "assignmod" || $prev_op =~ "assignmod"){
		
		require Templates::Admin;
		$template = Templates::Admin->new($spcgi, $spdb, "assignmod");
		
		#$opt_blocks = assign_mod_or_group($STATE);
		#$title = ($op eq "assignmod")?$lang->{'assign_mod'}:
		#$lang->{'preview_mod'};	
	    }
      
	    elsif($op eq "grantgroup" || $prev_op =~ "grantgroup"){
		require Templates::Admin;
		$template = Templates::Admin->new($spcgi, $spdb, "grantgroup");

		#$opt_blocks = assign_mod_or_group($STATE);
		#$title = ($op eq $lang->{'grantgroup'})?$lang->{'grant_group1'}:
		#$lang->{'preview_group'};
	    }
	    
	    elsif($op eq "createcategory"){
		require Templates::Admin;
		$template = Templates::Admin->new($spcgi, $spdb, "createcat");
		
		#$opt_blocks = create_or_modify_cat($STATE);
		#$title = $lang->{'create_cat1'};
	    }
	    elsif($op eq $lang->{'SaveCategory'}){

		my $uid = $STATE->{'uid'};
		exit() if !sym_lock($spdb, $uid, "save_category");
		
		require Ops::Admin;
		my $admin = Ops::Admin->new($STATE, $spdb);

		my ($succ, $err_msg, $btitle, $url);
		if($STATE->{'prev_catid'}){
		    ($succ, $err_msg, $btitle, $url) = $admin->save_category();
		    
		    #$ctype = $admin->save_category();
		}
		else{
		    ($succ, $err_msg, $btitle, $url) = $admin->create_cat(); 
		}
		sym_unlock($spdb, $uid, "save_category");

		require Templates::Caution;
		    
		# --- create a template object
		$template = 
		  Templates::Caution->new($spcgi, $spdb,
					  $btitle, 
					  $err_msg, $url);
	    }
	    elsif($op eq "modifycategory"){
		
		require Templates::Admin;
		
		$template = Templates::Admin->new($spcgi, $spdb, "modifycat");
		
	    }
	    elsif($op eq $lang->{'ChooseCategory'}){
		require Templates::Admin;
		$template = Templates::Admin->new($spcgi, $spdb, "createcat");
		#$title = $lang->{'modify_cat1'};
	    }
	    elsif($op eq $lang->{'RemoveCategory'}){

		require Ops::Admin;
		my $admin = Ops::Admin->new($STATE, $spdb);

		my ($succ, $err_msg, $btitle, $url) = $admin->remove_category();

		require Templates::Caution;
		    
		# --- create a template object
		$template = 
		  Templates::Caution->new($spcgi, $spdb,
					  $btitle, 
					  $err_msg, $url);

	    }
	    
	    elsif($op eq "createboard" || $op eq $lang->{'ChooseBoard'}){
		if($op eq $lang->{'ChooseBoard'} && !$STATE->{'selectedboard'}){
		    require Templates::Caution;
		    
		    # --- create a template object
		    $template = 
		      Templates::Caution->new($spcgi, $spdb,
					      "", $lang->{'at_least_one'});
		}
		else{
		    require Templates::Admin;
		
		    $template = Templates::Admin->new($spcgi, $spdb, "createboard");
		    
		    #$opt_blocks = create_board($STATE);
		    #$title = $lang->{'create_board'};
		}
	    }
	    elsif($op eq "modifyboard" || $op eq "removeboard"){
		require Templates::Admin;
		
		$template = Templates::Admin->new($spcgi, $spdb, "modifyboard");
		#$title = ($op eq "modifyboard")?$lang->{'modify_board1'}:
		#$lang->{'remove_board1'};	
	    }    
	    elsif($op eq $lang->{'SaveBoard'}){
		my $uid = $STATE->{'uid'};
		exit() if !sym_lock($spdb, $uid, "save_board");

		require Ops::Admin;
		my $admin = Ops::Admin->new($STATE, $spdb);

		my ($succ, $err_msg, $btitle, $url) = $admin->save_board();
		
		require Templates::Caution;
		
		# --- create a template object
		$template = 
		  Templates::Caution->new($spcgi, $spdb,
					  $btitle, 
					  $err_msg, $url);

		sym_unlock($spdb, $uid, "save_board");
	    }
	    elsif($op eq $lang->{'RemoveBoard'}){
		require Ops::Admin;
		my $admin = Ops::Admin->new($STATE, $spdb);

		my ($succ, $err_msg, $btitle, $url) = $admin->remove_board();
		
		require Templates::Caution;
		
		# --- create a template object
		$template = 
		  Templates::Caution->new($spcgi, $spdb,
					  $btitle, 
					  $err_msg, $url);
	    }
	    
	    elsif($op =~ /grantadmin/){
		require Templates::Admin;
		$template = Templates::Admin->new($spcgi, $spdb, "grantadmin");
		
		#$opt_blocks = grant_admin_or_modify_user($STATE);
		#$title = $lang->{'grant_admin1'};
		
	    }
	    elsif($op eq $lang->{'GrantAdmin'}){
		require Ops::Admin;
		my $admin = Ops::Admin->new($STATE, $spdb);
		my ($succ, $err_msg, $btitle, $url) = $admin->grant_admin();
		
		require Templates::Caution;
		
		# --- create a template object
		$template = 
		  Templates::Caution->new($spcgi, $spdb,
					  $btitle, 
					  $err_msg, $url);
	    }
	    
	    elsif($op eq "revokeadmin"){
		require Templates::Admin;
		$template = Templates::Admin->new($spcgi, $spdb, "revokeadmin");
		
		#$title = $lang->{'revoke_admin1'};
	    }
	    
	    elsif($op eq "revokemod" || $prev_op =~ /revokemod/){
		require Templates::Admin;
		$template = Templates::Admin->new($spcgi, $spdb, "revokemod");
		
		#$opt_blocks = revoke_mod_or_group($STATE);
		#$title = $lang->{'revoke_mod1'};
	    }
	    
	    elsif($op eq "revokegroup" || $prev_op =~ "revokegroup"){
		require Templates::Admin;
		$template = Templates::Admin->new($spcgi, $spdb, "revokegroup");

		#$opt_blocks = revoke_mod_or_group($STATE);
		#$title = $lang->{'revoke_group1'};
	    }

	    elsif($op eq $lang->{'RevokeAdmin'}){
		require Ops::Admin;
		my $admin = Ops::Admin->new($STATE, $spdb);
		my ($succ, $err_msg, $btitle, $url) = $admin->revoke_admin();
		
		require Templates::Caution;
		
		# --- create a template object
		$template = 
		  Templates::Caution->new($spcgi, $spdb,
					  $btitle, 
					  $err_msg, $url);
	    }
	    
	    elsif($op =~ /modifyuser/){
		require Templates::Admin;
		$template = Templates::Admin->new($spcgi, $spdb, "modifyuser");
		
		#$opt_blocks = grant_admin_or_modify_user($STATE);
		#$title = $lang->{'modify_user1'};
	    }
	    elsif($op eq $lang->{'ModifyProfile'}){
		if(!$STATE->{'selecteduid'}){
		    require Templates::Caution;
		    
		    # --- create a template object
		    $template = 
		      Templates::Caution->new($spcgi, $spdb, "",
					      $lang->{'at_least_one'});
	    
		}
		else{
		    require Templates::User;
		    $template = Templates::User->new($spcgi, $spdb, "edituser");
		}

		#($opt_blocks, $ctype, $title) = $admin->edit_user();
	    }
	    elsif($op eq $lang->{'ModifyPreferences'}){
		if(!$STATE->{'selecteduid'}){
		    require Templates::Caution;
		    
		    # --- create a template object
		    $template = 
		      Templates::Caution->new($spcgi, $spdb, "",
					      $lang->{'at_least_one'});
	    
		}
		else{
		    require Templates::User;
		    $template = Templates::User->new($spcgi, $spdb, "preferences");
		}
		
		#($opt_blocks, $ctype, $title) = $admin->edit_user();
	    }
	    elsif($op eq $lang->{'DeleteUser'}){
		require Ops::Admin;
		my $admin = Ops::Admin->new($STATE, $spdb);
		my ($succ, $err_msg, $btitle, $url) = $admin->delete_user();
		
		require Templates::Caution;
		
		# --- create a template object
		$template = 
		  Templates::Caution->new($spcgi, $spdb,
					  $btitle, 
					  $err_msg, $url);
		
	    }

	    elsif($op eq "expirethreads"){

		require Templates::Admin;
		$template = Templates::Admin->new($spcgi, $spdb, "threads");

		#$opt_blocks = threads($STATE);
		#$title = $lang->{'expire_threads1'};
	    }
	    elsif($op eq $lang->{'ExpireThreads'}){
		require Ops::Admin;
		my $admin = Ops::Admin->new($STATE, $spdb);
		my ($succ, $err_msg, $btitle, $url) = 
		    $admin->expire_threads_by_selection();
		
		require Templates::Caution;
		
		# --- create a template object
		$template = 
		  Templates::Caution->new($spcgi, $spdb,
					  $btitle, 
					  $err_msg, $url);
	    }
	    
	    elsif($op eq "closethreads"){
		require Templates::Admin;
		$template = Templates::Admin->new($spcgi, $spdb, "threads");
		#$opt_blocks = threads($STATE);
		#$title = $lang->{'close_threads'};
	    }
	    elsif($op eq $lang->{'CloseThreads'}){
		require Ops::Admin;
		my $admin = Ops::Admin->new($STATE, $spdb);
		my ($succ, $err_msg, $btitle, $url) = 
		    $admin->approve_open_close_threads();
		
		require Templates::Caution;
		
		# --- create a template object
		$template = 
		  Templates::Caution->new($spcgi, $spdb,
					  $btitle, 
					  $err_msg, $url);
	    }
	    
	    elsif($op eq "openthreads"){
		require Templates::Admin;
		$template = Templates::Admin->new($spcgi, $spdb, "threads");
		
		#$opt_blocks = threads($STATE);
		#$title = $lang->{'open_threads1'};
	    }
	    elsif($op eq $lang->{'OpenThreads'}){
		require Ops::Admin;
		my $admin = Ops::Admin->new($STATE, $spdb);
		my ($succ, $err_msg, $btitle, $url) = 
		    $admin->approve_open_close_threads();
		
		require Templates::Caution;
		
		# --- create a template object
		$template = 
		  Templates::Caution->new($spcgi, $spdb,
					  $btitle, 
					  $err_msg, $url);
		#$ctype = $admin->approve_open_close_threads();
	    }
	    
	    elsif($op eq "approvethreads"){
		require Templates::Admin;
		$template = Templates::Admin->new($spcgi, $spdb, "threads");
		
		#$opt_blocks = threads($STATE);
		#$title = $lang->{'approve_threads1'};
	    }
	    elsif($op eq $lang->{'ApproveThreads'}){
		require Ops::Admin;
		my $admin = Ops::Admin->new($STATE, $spdb);
		my ($succ, $err_msg, $btitle, $url) = 
		    $admin->approve_open_close_threads();
		
		require Templates::Caution;
		
		# --- create a template object
		$template = 
		  Templates::Caution->new($spcgi, $spdb,
					  $btitle, 
					  $err_msg, $url);
	    }
	    
	    elsif($op eq "movecopythreads"){
		require Templates::Admin;
		$template = Templates::Admin->new($spcgi, $spdb, "threads");

		#$opt_blocks = threads($STATE);
		#$title = $lang->{'movecopy_threads1'};
	    }
	    elsif($op eq $lang->{'MoveThreads'}){# || $op eq $lang->{'CopyThreads'}){
		require Ops::Admin;
		my $admin = Ops::Admin->new($STATE, $spdb);
		my ($succ, $err_msg, $btitle, $url) = 
		    $admin->move_copy_threads();
		
		require Templates::Caution;
		
		# --- create a template object
		$template = 
		  Templates::Caution->new($spcgi, $spdb,
					  $btitle, 
					  $err_msg, $url);
	    }
	    
	    elsif($op eq "showstat"){
		require Templates::Admin;
		$template = Templates::Admin->new($spcgi, $spdb, "showstat");
		#$opt_blocks = show_stat($STATE);
		#$title = $lang->{'show_stat1'};
	    }
	    
	    else{
		require Templates::Admin;
		$template = Templates::Admin->new($spcgi, $spdb, "index");
		
		#$opt_blocks = control_panel($STATE);
		#$title = $lang->{'ctrpanel'};
	    }
	    
	}
	
	else{
	    if($op eq "modifyboard"){
		require Templates::Admin;
		
		$template = Templates::Admin->new($spcgi, $spdb, "modifyboard");
		#$title = ($op eq "modifyboard")?$lang->{'modify_board1'}:
		#$lang->{'remove_board1'};	
	    } 
	    elsif($op eq $lang->{'SaveBoard'}){
		my $uid = $STATE->{'uid'};
		exit() if !sym_lock($spdb, $uid, "save_board");

		require Ops::Admin;
		my $admin = Ops::Admin->new($STATE, $spdb);

		my ($succ, $err_msg, $btitle, $url) = $admin->save_board();
		
		require Templates::Caution;
		
		# --- create a template object
		$template = 
		  Templates::Caution->new($spcgi, $spdb,
					  $btitle, 
					  $err_msg, $url);

		sym_unlock($spdb, $uid, "save_board");
	    }
	    elsif($op eq $lang->{'ChooseBoard'}){
		
		if($op eq $lang->{'ChooseBoard'} && !$STATE->{'selectedboard'}){
		    require Templates::Caution;
		    
		    # --- create a template object
		    $template = 
		      Templates::Caution->new($spcgi, $spdb,
					      "", $lang->{'at_least_one'});
		}
		else{
		    require Templates::Admin;
		
		    $template = Templates::Admin->new($spcgi, $spdb, "createboard");
		    
		    #$opt_blocks = create_board($STATE);
		   #$title = $lang->{'create_board'};
		}
		
	    }
	    elsif($op eq $lang->{'SaveGroup'}){
		require Ops::Admin;
		my $admin = Ops::Admin->new($STATE, $spdb);
		my ($succ, $err_msg, $btitle, $url) = $admin->save_mod_or_group();
		
		require Templates::Caution;
		
		# --- create a template object
		$template = 
		  Templates::Caution->new($spcgi, $spdb,
					  $btitle, 
					  $err_msg, $url);
	    }
	    elsif($op eq "grantgroup" || $prev_op eq "grantgroup"){
		require Templates::Admin;
		$template = Templates::Admin->new($spcgi, $spdb, "grantgroup");

		#$opt_blocks = assign_mod_or_group($STATE);
		#$title = ($op eq $lang->{'grantgroup'})?$lang->{'grant_group1'}:
		#$lang->{'preview_group'};
	    }
	    elsif($op eq "revokegroup" || $op eq $lang->{'PreviewGroup'}){
		require Templates::Admin;
		$template = Templates::Admin->new($spcgi, $spdb, "revokegroup");

		#$opt_blocks = revoke_mod_or_group($STATE);
		#$title = $lang->{'revoke_group1'};
	    }

	    elsif($op eq "expirethreads"){
		require Templates::Admin;
		$template = Templates::Admin->new($spcgi, $spdb, "threads");

		#$opt_blocks = threads($STATE);
		#$title = $lang->{'expire_threads1'};
	    }
	    elsif($op eq $lang->{'ExpireThreads'}){
		require Ops::Admin;
		my $admin = Ops::Admin->new($STATE, $spdb);
		my ($succ, $err_msg, $btitle, $url) = 
		    $admin->expire_threads_by_selection();
		
		require Templates::Caution;
		
		# --- create a template object
		$template = 
		  Templates::Caution->new($spcgi, $spdb,
					  $btitle, 
					  $err_msg, $url);
	    }
	    
	    elsif($op eq "closethreads"){
		require Templates::Admin;
		$template = Templates::Admin->new($spcgi, $spdb, "threads");
		#$opt_blocks = threads($STATE);
		#$title = $lang->{'close_threads'};
	    }
	    elsif($op eq $lang->{'CloseThreads'}){
		require Ops::Admin;
		my $admin = Ops::Admin->new($STATE, $spdb);
		my ($succ, $err_msg, $btitle, $url) = 
		    $admin->approve_open_close_threads();
		
		require Templates::Caution;
		
		# --- create a template object
		$template = 
		  Templates::Caution->new($spcgi, $spdb,
					  $btitle, 
					  $err_msg, $url);
	    }
	    
	    elsif($op eq "openthreads"){
		require Templates::Admin;
		$template = Templates::Admin->new($spcgi, $spdb, "threads");
		
		#$opt_blocks = threads($STATE);
		#$title = $lang->{'open_threads1'};
	    }
	    elsif($op eq $lang->{'OpenThreads'}){
		require Ops::Admin;
		my $admin = Ops::Admin->new($STATE, $spdb);
		my ($succ, $err_msg, $btitle, $url) = 
		    $admin->approve_open_close_threads();
		
		require Templates::Caution;
		
		# --- create a template object
		$template = 
		  Templates::Caution->new($spcgi, $spdb,
					  $btitle, 
					  $err_msg, $url);
		#$ctype = $admin->approve_open_close_threads();
	    }
	    
	    elsif($op eq "approvethreads"){
		require Templates::Admin;
		$template = Templates::Admin->new($spcgi, $spdb, "threads");
		
		#$opt_blocks = threads($STATE);
		#$title = $lang->{'approve_threads1'};
	    }
	    elsif($op eq $lang->{'ApproveThreads'}){
		require Ops::Admin;
		my $admin = Ops::Admin->new($STATE, $spdb);
		my ($succ, $err_msg, $btitle, $url) = 
		    $admin->approve_open_close_threads();
		
		require Templates::Caution;
		
		# --- create a template object
		$template = 
		  Templates::Caution->new($spcgi, $spdb,
					  $btitle, 
					  $err_msg, $url);
	    }
	    
	    elsif($op eq "movecopythreads"){
		require Templates::Admin;
		$template = Templates::Admin->new($spcgi, $spdb, "threads");

		#$opt_blocks = threads($STATE);
		#$title = $lang->{'movecopy_threads1'};
	    }
	    elsif($op eq $lang->{'MoveThreads'}){# || $op eq $lang->{'CopyThreads'}){
		require Ops::Admin;
		my $admin = Ops::Admin->new($STATE, $spdb);
		my ($succ, $err_msg, $btitle, $url) = 
		    $admin->move_copy_threads();
		
		require Templates::Caution;
		
		# --- create a template object
		$template = 
		  Templates::Caution->new($spcgi, $spdb,
					  $btitle, 
					  $err_msg, $url);
	    }
	    
	    elsif($op eq "showstat"){
		require Templates::Admin;
		$template = Templates::Admin->new($spcgi, $spdb, "showstat");
		#$opt_blocks = show_stat($STATE);
		#$title = $lang->{'show_stat1'};
	    }

	    else{
		require Templates::Admin;
		$template = Templates::Admin->new($spcgi, $spdb, "index");	 
	  
		#$title = $lang->{'ctrpanel'};
	    }
	}
    }
    else{ 
	require Templates::User;
      
	$template = Templates::User->new($spcgi, $spdb, "login");
	#$title = $lang->{'am_login'};
    }
    
    if($template){
	$template->print_http_header($cookie);
	$template->print_template();	
    }
}

sub sym_lock{
  my ($spdb, $uid, $sym) = @_;
  
  my $symq = $spdb->{'dbh'}->quote($sym);

  $spdb->db_lock(("SymLock"));

  my ($slid) = $spdb->db_select_cols("slid", "SymLock", 
  "uid=$uid AND sym=$symq AND 
   UNIX_TIMESTAMP(NOW())-UNIX_TIMESTAMP(date)>15");
  my $cnt = $spdb->db_count("SymLock",
			    "uid=$uid AND sym=$symq");

  if($slid || $cnt<=0){
      my $max = $spdb->db_max("slid", "SymLock"); $max ||= 0; $max++;
      my $date = $spdb->db_date();
      $spdb->db_insert("SymLock", {('slid'=>$max, 
				    'uid'=>$uid,
				    'sym'=>$sym,
				    'date'=>$date)});
      $spdb->db_unlock();
      return 1;
  }

  if($slid){
      $spdb->delete("SymLock", "slid=$slid");
  }

  $spdb->db_unlock();

  return 0;
}

sub sym_unlock{
  my ($spdb, $uid, $sym) = @_;
  my $symq = $spdb->{'dbh'}->quote($sym);  

  $spdb->db_lock(("SymLock"));
  $spdb->db_delete("SymLock", "uid=$uid AND sym=$symq");
  $spdb->db_unlock(); 
}

main();
