package Templates::Default;

use SmallPigVars qw($config);
use SmallPig;

use strict;
use vars qw(@ISA $template);

my $lang;

sub new{
  my ($class, $spcgi, $spdb, $pagetype) = @_;

  $template->{'spcgi'} ||= $spcgi;
  $template->{'STATE'} = $spcgi->{'STATE'};
  $template->{'spdb'} ||= $spdb;
  
  $template->{'title'} = "";
  $template->{'refresh'} = "";
  $template->{'pagetype'} = $pagetype || "default";
  $template->{'dpage'} = $template->{'STATE'}->{'dpage'};

  bless $template, $class;

  $template->initialize();
  
  return $template;
}

sub parse_inc{
  my ($template, $content) = @_;

  $content =~ s/<\?Sporum(.*?)muropS\?>/{$1}/eegs;
  $content .= "<B><I>$@</I></B>" if $@;
  return $content;
}

sub spdb{
    return $template->{'spdb'};
}

sub islogon{
    return ($template->{'STATE'}->{'userstatus'} ne "anon");
}

sub STATE{
    return $template->{'STATE'};
}

#########################################################################
# --- Sun Dec 19 23:06:10 PST 1999
# ---
sub initialize{
 my ($template) = @_;
  my $STATE = $template->{'STATE'};
  my $userstatus = $STATE->{'userstatus'};

  my $pagefiles = {};
  $pagefiles->{'default'} = "default.temp";
  
  my $pagetype = $template->{'pagetype'};
  $pagefiles->{$pagetype} = "$pagetype.temp" if $STATE->{'page'};

  $template->{'pagefiles'} = $pagefiles;

  my $pagesubs = {};
  $pagesubs->{'index'} = \&page_index;
  
  $template->{'pagesubs'} = $pagesubs;

  # --- deal with the cookie
  if($userstatus ne "anon"){
      my $spcgi = $template->{'spcgi'};
      my $spdb = $template->{'spdb'};
      my $DBH = $spdb->{'dbh'};
      my $lastresp = $spcgi->{'STATE'}->{'lastresp'};
      my $lastrespq = $DBH->quote($lastresp);
      
      my ($sids) = $spdb->db_select_many_new(1, "sid", "Boards");
      
      # --- break the cookie to hash
      my $nps_cookie;
      $nps_cookie = $spcgi->cookie(".nps_cookie");
 
      my ($nps_s);
      foreach (@$nps_cookie){
	  $nps_s .= $_;
      }
      $STATE->{'old_nps'} = $nps_s;

      if($sids){
	  while (my ($sid) = $sids->fetchrow_array){
	      next unless $template->can_read($sid);
	      
	      my $sidq = $DBH->quote($sid);
	      
	      my ($cids) = $spdb->db_select_many_new(1, "cid", "Posts",
						     "date>$lastrespq AND
                                              sid=$sidq AND approved=1");
	      if($cids){
		  while (my ($cid) = $cids->fetchrow_array){ 
		      $nps_s .= "$cid," if $nps_s !~ /$cid/;
		  }
		  
		  $spdb->db_handler_done($cids);

	      }
	  }
      }
      
      $spdb->db_handler_done($sids);
      
      $STATE->{'nps'} = $nps_s;
  }

 # --- Sun Jan 16 00:55:33 PST 2000
 # --- get the theme ptr
 $template->{'theme'} = $template->get_themeptr($template->{'STATE'}->{'theme'});
 
 # --- get the lang ptr
 $lang = $template->{'lang'} = $STATE->{'langptr'};
 
 # --- get the mconfig from spmail
 $template->{'mconfig'} = $template->_get_mconfig();
}

sub print_http_header{
  my ($self, $user_cookie) = @_;

  my ($charset) = "";
  $charset = "; charset=$config->{'charset'}" if $config->{'charset'};
  print "Content-type: text/html$charset\n";

  my $STATE = $self->{'STATE'};
  my ($userstatus, $mode, $nps) = 
      map{ $STATE->{$_} } qw(userstatus mode nps);

  my $cookies = [];
  my $tnps;
  
  print "Set-cookie: $user_cookie;\n" if $user_cookie;
  
  if($userstatus ne "anon" && !$user_cookie){
      $template->print_nps_cookie();
  }

  # --- deal with font cookie
  if($self->{'STATE'}->{fontsize}){
      my $fontsize = $self->{'STATE'}->{fontsize};
      print "Set-cookie: font_cookie=$fontsize; expires=Mon, 25-Dec-2010 22:42:19 GMT\n";
  }

  print "\n";
}

sub print_nps_cookie{
  my ($template) = @_;
  my $spdb = $template->{'spdb'};
  my $STATE = $template->{'STATE'};
  my $DBH = $spdb->{'dbh'};
  my $uid = $template->{'STATE'}->{'uid'};

  my $nps_s = $template->{'STATE'}->{'nps'};
  my $old_nps = $template->{'STATE'}->{'old_nps'};

  print "Set-cookie: .nps_cookie=$nps_s\n" if defined($nps_s) && $nps_s ne $old_nps;

  if($STATE->{'op'} ne "userinfo" && $STATE->{'op'} ne "confirm"){
      # --- update lastresp
      my $date = $DBH->quote($spdb->db_date());
      my ($succ, $errmsg) = 
	  $spdb->db_update("Users", {('lastresp'=>$date)}, "uid=$uid");
  }
}

sub print_template{
  my ($template) = @_;
  my $theme = $template->{'theme'};
  
  my ($pagetype, $dpage) = ("", "");
  ($pagetype, $dpage) = map{ $template->{$_} } qw(pagetype dpage);
  my $tempfile = "";
  
  # --- if $config->{'temp_path'} is a directory
  unless(-d $theme->{'temp_path'}){
      print "Please make sure the 'temp_path' has a correct setting.\n";
      return;
  }

  # --- check banned user
  if(!$template->check_banned_user()){
      print "Hi"; return;
  }
  
  # --- if user-defined page
  if($dpage){ $tempfile = "$dpage\.temp"; }
  else{
      $tempfile = $template->{'pagefiles'}->{$pagetype} || "default.temp";
  }
  my $pagefile;
  $pagefile = "$theme->{'temp_path'}/$tempfile";
  
  open(FILE, "$pagefile") || return cant_found_page();
#  print "$template->{'spdb'}->{'dbcalls'}";
  my ($tmp, $line) = ("", "");
  while ($line=<FILE>){ 
      if($line =~ /<!--dont_show_public-->/ && $ENV{SCRIPT_NAME} =~ /default\.cgi/){
	  return cant_found_page();
      }

      if($line =~ /<!--Sporum:Main-->/){
	  &{$template->{'pagesubs'}->{$pagetype}} if defined($template->{'pagesubs'}->{$pagetype});
      }
      elsif($line =~ /<\?Sporum(.*?)muropS\?>/){
	  print $template->parse_inc($line);
      }
      # --- start
      elsif($line =~ /<\?Sporum/ && $line !~ /muropS\?>/){
	  $tmp .= $line;
      }
      # --- end
      elsif($line !~ /<\?Sporum/ && $line =~ /muropS\?>/){
	  $tmp .= $line;
	  print $template->parse_inc($tmp); $tmp = "";
      }
      elsif($tmp){
	  $tmp .= $line;
      }
      else{
	  print $line;
      }
  }
  
  close(FILE);
}

sub print_stylesheet{
   my ($template) = @_;
   
   print $template->{'css'};
   
}

sub print_adjust_font{
    my ($template) = @_;
    my $STATE = $template->{'STATE'};
    my $theme = $template->{'theme'};

    my $sid = $template->url_encode($STATE->{'sid'});
    my $words = $STATE->{'words'};
    my $match = $STATE->{'match'};
    my $page = $STATE->{'page'};
    my $postsper = $STATE->{'postsper'};
    my $sort = $template->url_encode($STATE->{'sort'});
    my $view = $STATE->{'view'};
    my $mode = $STATE->{'mode'};
    my $uid = $STATE->{'uid'};
    my $fontsize = $STATE->{'fontsize'};
    my $op = $STATE->{'op'};
    my $cid = $STATE->{'cid'};
    my $display = $STATE->{'display'};

    my $query;
    $query .= "op=$op&" if $op;
    $query .= "sid=$sid&" if $sid;
    $query .= "words=$words&" if $words;
    $query .= "match=$match&" if $match;
    $query .= "page=$page&" if $page;
    $query .= "postsper=$postsper&" if $postsper;
    $query .= "sort=$sort&" if $sort;
    $query .= "view=$view&" if $view;
    $query .= "display=$display&" if $display;
    $query .= "mode=$mode&" if $mode;
    $query .= "uid=$uid&" if $uid;
    $query .= "cid=$cid&" if $cid;

    my $cookie = $template->{'spcgi'}->cookie('font_cookie');
    my $fontsize1 = $cookie->[0] if $cookie;
    my $fontsize = $fontsize || $fontsize1 || 9;

    my $query1 .= "fontsize=".($fontsize+1);
    my $query2 .= "fontsize=".($fontsize-1);

    $template->print_block_start($theme->{'boxbgcolor'});

    print qq~
	<tr>
	    <td align=right class=header3><b>$lang->{'adjust_font'}:</b>
    	    <a href="$ENV{SCRIPT_NAME}?$query$query2">&lt;&lt;</a>
	    <a href="$ENV{SCRIPT_NAME}?$query$query2">$lang->{'smaller'}</a>
		&nbsp;<b>$fontsize</b>&nbsp;
	    <a href="$ENV{SCRIPT_NAME}?$query$query1">$lang->{'larger'}</a>
	    <a href="$ENV{SCRIPT_NAME}?$query$query1">&gt;&gt;</a>
	</td></tr>
        ~;

    $template->print_block_end();
}

sub print_space{
    my ($template, $h, $w) = @_;
    my $theme = $template->{'theme'};

    $w ||= "100%"; $h ||= 3;
    print qq|<table cellpadding=0 cellspacing=0 border=0 width=100%><tr align=center><td><img src="$theme->{'imagesdir'}/$theme->{'empty_image'}" width=$w height=$h border=0 alt="*"></td></tr></table>|;
}

sub print_page_index{
  my ($template, $totalnums, $url) = @_;
  my $theme = $template->{'theme'};

  my ($op, $postsper, $page, $mode, $sid, $sort, $view, $words, $match) =   
    map{ $template->{'STATE'}->{$_} } 
  qw(op postsper page mode sid sort view words match);

  # --- encode sid
  $sid = $template->url_encode($sid);
  # --- encode sort
  $sort = $template->url_encode($sort);
  # --- encode words
  $words = $template->url_encode($words);
   $url ||= "&postsper=$postsper&sort=$sort&sid=$sid&view=$view&words=$words&match=$match";

  return if $totalnums==0;

  $template->print_block_start($theme->{'inbgcolor'}, $theme->{'inbgcolor'});

  $page ||= 1;
  
  print "<TR><TD ALIGN=center valign=middle CLASS=header3><B>Pages: ";
  if($postsper <= 0){
    return " ";
  }
  my $totalpages = int $totalnums/$postsper;
  my $remain = $totalnums % $postsper;
  $totalpages++ if $remain > 0;
  my $pagelimit = 20;

  my ($start, $end, $larrow, $rarrow) = 
      (1, ($pagelimit < $totalpages)?$pagelimit:$totalpages, 0, 0);
  if($totalpages > $pagelimit && $page + 1< $totalpages){
      $rarrow = $pagelimit + 1; 
  }
  if($page >= $pagelimit){
      $start = ($page >= $totalpages)?
	  $page - $pagelimit + 1:$page - $pagelimit + 2;
      $end = ($start + $pagelimit> $totalpages)?
	  $totalpages:$start + $pagelimit - 1;
      $larrow = $page - 1;
      $rarrow = $page + 1 if $page + 1< $totalpages;
  }
  
  my $cgi = $ENV{SCRIPT_NAME};

  print qq!<A HREF=$config->{'basewwwdir'}$cgi?op=$op$url&page=$larrow&mode=$mode>&lt;&lt;</A>! 
      if $larrow;
  for(my $i=$start; $i<=$end; $i++){
      if($i == $page){
	  print "<B> $i </B>";
      }
      else{
	  my $opts = "$url&page=$i&mode=$mode";
	  print qq!
<A HREF=$config->{'basewwwdir'}$cgi?op=$op$opts>$i</A>
    !;
      }
  }
  print qq!<A HREF=$config->{'basewwwdir'}$cgi?op=$op$url&page=$rarrow&mode=$mode>&gt;&gt;</A>! 
      if $rarrow;
  print "<\TR><\TD>";

  $template->print_block_end();
}

sub print_standard_index{
  my ($template) = @_;
  my $theme = $template->{'theme'};
  my $STATE = $template->{'STATE'};

  $template->print_block_start($theme->{'inbgcolor'}, $theme->{'inbgcolor'});

  my ($username, $uid, $pid, $sid, $cid, $view, $op, $userstatus,
      $page, $postsper, $sort, $display) = 
    map { $STATE->{$_} } 
  qw(username uid pid sid cid view op userstatus page postsper sort
     display);
 
  $view = ($view eq "expanded")?"collapsed":"expanded";
  
  # admin
  print "<TR><TD ALIGN=center valign=middle>";
  print " <A HREF=$config->{'cgidir'}/admin.cgi>$lang->{'admin1'}</A> |" 
    if($userstatus eq "admin");
  print " <A HREF=$config->{'cgidir'}/admin.cgi>$lang->{'mod1'}</A> |" 
    if($userstatus =~ /mod/);

  print " <A HREF=$config->{'cgidir'}/index.cgi>$lang->{'forum_index'}</A> |  ";

  # --- encode sid
  $sid = $template->url_encode($sid);
  print "<A HREF=$config->{'cgidir'}/search.cgi?sid=$sid>$lang->{'search'}</A>";
  
  # user is login
  if($userstatus ne "anon" && $uid){
      print " | <A HREF=$config->{'cgidir'}/user.cgi?page=1&postsper=$postsper>$lang->{'profile'}</A> | 
      <A HREF=$config->{'cgidir'}/user.cgi?op=logout>$lang->{'logout'}</A>";
  }
  else{
      print " | <A HREF=$config->{'cgidir'}/user.cgi?op=login>
      $lang->{'login'}</A>";
  }

  print qq~ | <a href=$config->{'cgidir'}/user.cgi?op=whosonline>$lang->{'whosonline'}</a>~;

  print "</td></tr>";
  
  $template->print_block_end();
}

sub print_block_start{
  my ($template, $bdrcolor, $bgcolor, $title, $width, $tcolspan) = @_;    
  my $theme = $template->{'theme'};

  $title    ||= "";
  $width    ||= $theme->{'intblwidth'};
  $bdrcolor ||= $theme->{'dhdrcolor'};
  $bgcolor  ||= $theme->{'boxbgcolor'};
  
  $tcolspan = "colspan=$tcolspan";
  
  my $tr = qq|
                               <tr>
				  <td bgcolor="$bdrcolor" align="center" class="bheader1" $tcolspan>
				      $title
					  </td></tr>
					      | if $title;

  print qq|
      <!--opt_block--><div align="$theme->{'intblalign'}">
	  <TABLE BORDER="0" CELLSPACING="$theme->{'tblcellspacing'}" 
	      CELLPADDING="$theme->{'tblcellpadding'}" BGCOLOR="$bdrcolor" 
		  WIDTH="$width">
		      <tr><td>
			  <table border="0" cellspacing="$theme->{'intblcsp'}" cellpadding="$theme->{'intblcp'}" width="100%" bgcolor="$bgcolor">
			      $tr
	|;
}

sub print_block_end{
  my ($template) = @_;    
  my ($content) = map { $template->{'block'}->{$_} } qw(space width title bdrcolor bgcolor content);

  print qq|
           </TABLE>
	       </TD>
		   </TR>
		       </TABLE></div>
  |;
}

sub print_caution_msg{
  my ($template, $btitle, $bmsg) = @_;
  
  my $btitle ||= $lang->{'cant_proceed'};
  
  $template->print_block_start("","", $btitle);
  
  print qq|
      <TR><TD>
	  <TABLE border=0 cellpadding=10><TR><TD>
	      <B>$lang->{'caution1'}</B><BR><BR><I>$bmsg</I>
		  </TD></TR></TABLE>
		      </TD></TR>|;
  
  $template->print_block_end();
}

sub print_msg{
  my ($template, $clas, $cellpadding, $btitle, $bmsg, $bdrcolor, $bgcolor) = @_;
  
  $template->print_block_start($bdrcolor, $bgcolor, $btitle);
  
  print qq|
      <tr>
	  <td>
	      <table border=0 cellpadding=$cellpadding>
		  <tr>
		      <td class=$clas>
			  $bmsg
		      </td>
		  </tr>
	      </table>
	   </td>
       </tr>
	   |;
  
  $template->print_block_end();
}

sub get_board_status{
  my ($template, $level) = @_;
  my $status = "public" unless 63^$level;
  $status = "public protected" unless 62^$level;
  $status = "user public" unless 60^$level;
  $status = "user private" unless 56^$level;
  $status = "user private protected" unless 48^$level;
  $status = "group private" unless 32^$level;
  return $status;
}

sub _select_the_most_parent{
  my ($template, $cid) = @_;
  my $spdb = $template->{'spdb'};
  
  # --- find out its parentid
  my ($pid) = $spdb->db_select_cols("parentid", "ParentAndChild",
                                   "childid=$cid");
  if(!$pid){
    return $cid;
  }
  else{
      $template->_select_the_most_parent($pid);
  }
}

sub _select_comment{
  my ($template, $cid) = @_;
  my $spdb = $template->{'spdb'};
  
  my ($subject, $bodytext, $hits, $ip, $time,  
      $closed, $sid, $uid, $hasatt) = 
        $spdb->db_select_cols("subject, bodytext, hits, ip, 
                          date_format(date, \"$config->{date_format}\"),
                          closed, sid, uid, hasatt",
                             "Posts", "cid=$cid");
  my ($name, $email, $privlev);
  if($uid != 0){
      ($name, $email, $privlev) = 
          $spdb->db_select_cols("nickname, fakeemail, privlev",
                                "Users", "uid=$uid");
  }
  else{
      ($name, $email) = 
          $spdb->db_select_cols("anon, email", "AnonPosts", "cid=$cid");
  }
  my ($pid) = $spdb->db_select_cols("parentid", "ParentAndChild", 
                                   "childid=$cid");
  
  my $mpid = $template->_select_the_most_parent($cid);
  my ($lastmod, $replies) =
    $spdb->db_select_cols("date_format(lastmod, \"$config->{date_format}\"),
                          replies",
                         "MostParents",
                         "cid=$mpid");

  # --- lang support
  $time =~ s/(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)/$lang->{$1}/ig;
  $lastmod =~ s/(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)/$lang->{$1}/ig;

  return ($subject, $bodytext, $hits, $ip, $time, $closed, $sid, $uid,
          $name, $email, $pid, $lastmod, $replies, $privlev, $hasatt);
}

sub url_encode{
  my ($template, $words) = @_;
  $words =~ s/([^a-zA-Z0-9_.-])/"%".sprintf("%1X", ord($1))/eg;
  return $words;
}

sub filter_html{
  my ($template, $str) = @_;
  $str =~ s/</&lt;/g;
  $str =~ s/>/&gt;/g;
  $str = $template->filter_quote($str);
  return $str;
}

sub filter_quote{
  my ($template, $str) = @_;
  $str =~ s/\"/&quot;/g;
  return $str;
}

sub allow_html_markup{
  my ($template, $sid) = @_;
  my $spdb = $template->{'spdb'};
  my $DBH = $spdb->{'dbh'};
  my $sidq = $DBH->quote($sid);
  my ($html, $markup) = $spdb->db_select_cols("html, markup", 
					      "Boards", "sid=$sidq");
  return ($html, $markup);
}

sub add_br{
    my $template = shift;
    return SmallPig::add_br(@_);
}

sub format_markup{
    my ($template, $str) = @_;
    return SmallPig::format_markup($str);
}

sub recover_quote{
    my $template = shift;
    return SmallPig::recover_quote(@_);
}

sub recover_html{
  my $template = shift;
  my $str = shift;
  return SmallPig::recover_html($str);
}

sub recover_markup{
  my $template = shift;
  my $str = shift;
  return SmallPig::recover_markup($str);
}

sub count_new_posts{
  my ($self, $sid, $nps) = @_;
  my $spdb = $self->{'spdb'};
  my $DBH = $spdb->{'dbh'};
  my @nps;
  @nps = split(/\,/, $nps);
 
  # --- make sure the posts are in database
  my ($cnt, $where) = ("", "");
  foreach (@nps){
      $where .= "cid=$_ OR ";
  }
  $where =~ s/OR $//;
  if ($where){
      my $sidq = $DBH->quote($sid);
      $where = "($where) AND sid=$sidq";
      $cnt = $spdb->db_count("Posts", $where) if $where;
  }

  return $cnt;
}

sub select_option{
  my ($template, $opts, $name, $sel) = @_;
  my $ret = "<font size=1><select name=\"$name\">";
  foreach (keys(%$opts)){
    my $value = $opts->{$_};
    $ret .= "
<option ".(($value eq $sel)?"selected":"")." value=\"$value\">$_";
  }
  $ret .= "</select></font>";
  return $ret;
}

sub can_read{
  my ($template, $sid) = @_;
  my $spdb = $template->{'spdb'};
  my $STATE = $template->{'STATE'};
  my $DBH = $spdb->{'dbh'};

  my ($username, $uid, $user_status, $tuserstatus) = 
    map{ $STATE->{$_} } qw(username uid userstatus tuserstatus);
  
  my $sidq = $DBH->quote($sid);
  my ($level, $active);
  ($level, $active) = $spdb->db_select_cols("level, active", "Boards", 
					    "sid=$sidq");
  return 0 if(($user_status ne "admin" && $user_status ne "mod") &&
	      $active==0);
  my $status = get_board_status($level);

  # --- sid from mod userstatus --> ptr to arr
  my $sfmus = $tuserstatus->{mod};
  my $sfgmus = $tuserstatus->{gmem};

  return 1 if($user_status eq "admin" || 
	      ($sfmus && grep { $_ eq $sid } @$sfmus) || 
	      ($sfgmus && grep { $_ eq $sid } @$sfgmus) ||
	      (($user_status =~ /gmem/ || $user_status eq "ruser" ||
		$user_status =~ /mod/) && $status !~ /group private/) || 
	      ($user_status eq "anon" && $status =~ /public/));
  return 0;
}

sub cant_found_page{
    require Templates::Caution;
    my $spcgi = $template->{'spdb'};
    my $spdb = $template->{'spdb'};
    # --- create a template object
    $template = 
      Templates::Caution->new($spcgi, $spdb, "", 
			      $lang->{'cant_found_page'}, 
			      "$config->{'cgidir'}/index.cgi");
#    $template->print_http_header();
    $template->{'pagetype'} = "caution";
    $template->{'dpage'} = "caution";
    $template->print_template();	
    return;
}

sub check_banned_user{
    my ($self) = @_;

    if($ENV{REMOTE_ADDR} =~ /204\.201\.36/){
	return 0;
    }
    
    return 1; 
}

sub load_module{
    shift;
    eval "require $_[0]";
    $_[0]->import(@_[1 .. $#_]);
}

sub get_themeptr{
    my ($self, $theme) = @_;
    
    my $stheme = "theme";

    my $thememod = "Themes::$theme\::$stheme";
    # --- load the theme module
    $self->load_module($thememod);
    get_stylesheet($self);
    return get_theme();
}

sub _get_mconfig(){
    return SmallPig::get_spmail_config();
}

sub title_desc{
  my ($self, $title, $desc) = @_; 

  my $theme = $self->{'theme'};
  
  $template->print_msg("header1", 1, "", $title,
		       $theme->{'inbgcolor'}, $theme->{'inbgcolor'});
  
  $template->print_msg("header2", 1, "", $desc,
		       $theme->{'inbgcolor'}, $theme->{'inbgcolor'});
}

return 1;
