package Templates::Admin::RevokeUsers;

use SmallPigVars qw($config);
use SmallPig;

use CGI qw(:standard :cgi-lib);

use Templates::Admin::Block;
use Templates::Admin::OptBlock;
use Templates::Admin::AssignUsersList;
use Templates::Admin::UsersList;
use Templates::Admin::Caution;

use strict;
my @ISA = qw(Templates::Admin::Block);

my %CACHE;

my $lang;

sub new{
  my ($class) = @_;
  my $self = Templates::Admin::Block->new();
  
  my $id = join '', sort values %$self, "revokemodorgroupblock";
  return $CACHE{$id} if $CACHE{$id};
  return $CACHE{$id} = bless $self, $class;
}

sub display{
  my ($self, $STATE) = @_;
  my ($op, $prev_op) = map{ $STATE->{$_} } qw(op prev_op);
  my $msg;
  
  my $theme = $STATE->{'theme'};

  $lang = $STATE->{'langptr'};

  my $standardindex = Templates::Admin::StandardIndex->new($STATE);
  my $userslist = Templates::Admin::UsersList->new($STATE);
  my $caution = Templates::Admin::Caution->new($theme);
  my $assignuserslist = Templates::Admin::AssignUsersList->new($STATE);

  my ($msg, $ul);
  if($op eq "revokemod" || $prev_op =~ /revokemod/){
    $msg = $lang->{'revoke_mod_msg1'};
    $msg .= $lang->{'make_mult_sel'};
    $ul = $userslist->get_modlist($STATE);
  }
  else{
    $msg = $lang->{'revoke_group_msg1'};
    $msg .= $lang->{'make_mult_sel'};
    $ul .= $userslist->get_grouplist($STATE);
  }
  
  my $ret;
  $ret = start_form(-method=>"post",
		    -action=>"$config->{'cgidir'}/admin.cgi");
  $ret .= $standardindex->get();
  $ret .= $ul;
  $ret .= $caution->get($msg);
  $ret .= $assignuserslist->get();
  $ret .= "<font size=1>";
 
  my $op1 = $op;
  if($op eq $lang->{'PreviewModerator'} || $op eq "revokemod"){
      $op1 = "$prev_op\#$op" if $prev_op;
      $ret .= qq|<INPUT TYPE=hidden NAME=prev_op VALUE="$op1">|;
      if($op eq $lang->{'PreviewModerator'}){
	  $ret .= submit(-name=>"op", -value=>$lang->{'SaveModerator'});
      }
  }
  elsif($op eq $lang->{'PreviewGroup'} || $op eq "revokegroup"){
      $op1 = "$prev_op\#$op" if $prev_op;
       $ret .= qq|<INPUT TYPE=hidden NAME=prev_op VALUE="$op1">|;
       if($op eq $lang->{'PreviewGroup'}){
	   $ret .= submit(-name=>"op", -value=>$lang->{'SaveGroup'});
       }
  }
  if($op eq $lang->{'PreviewModerator'} || $op eq "revokemod"){
    $ret .= submit(-name=>"op", -value=>$lang->{'PreviewModerator'});
  }
  else{
    $ret .= submit(-name=>"op", -value=>$lang->{'PreviewGroup'});
  }
  $ret .= "</font>";
  $ret .= end_form()."</TD>";

  return $ret;
}



return 1;
