#include <pthread.h>
#include <gtk/gtk.h>
#include "specimen.h"
#include "gui/gui.h"
#include "midi.h"
#include "driver.h"
#include "lfo.h"
#include "patch.h"
#include "mixer.h"
#include "beef.h"

int main(int argc, char *argv[])
{
     gtk_init(&argc, &argv);

     /* constructors */
     driver_init();
     lfo_init();
     mixer_init();
     patch_init();
     gui_init();

     /* load a bank if specified on cmdline */
     if (argc >= 2)
     {
	 beef_read(argv[1]);
	 gui_refresh();
     }

     /* start */
     midi_start();
     driver_start(0);
     gtk_main();

     /* stop */
     midi_stop();
     driver_stop();

     /* destructors */
     patch_shutdown();
     mixer_shutdown();

     debug("Goodbye.\n");
     return 0;
}
