-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (SparkLex.Lex)
procedure GetString (Curr_Line : in out Line_Context;
                     Token     :    out SP_Symbols.SP_Terminal) is
   String_Not_Ended : Boolean;
   Ch               : Character;
begin
   LineManager.Accept_Char (Curr_Line => Curr_Line); -- Quotation already recognised
   String_Not_Ended := True;
   while String_Not_Ended loop
      --# assert E_Strings.Get_Length (Curr_Line.Conts) = E_Strings.Get_Length (Curr_Line~.Conts) and
      --#   Curr_Line.Curr_Pos > Curr_Line~.Curr_Pos and
      --#   Curr_Line.Curr_Pos <= E_Strings.Get_Length (Curr_Line.Conts) + 1 and
      --#   Curr_Line.Lookahead_Pos = Curr_Line.Curr_Pos and
      --#   Curr_Line.Last_Token_Pos = Curr_Line~.Last_Token_Pos;
      Ch := E_Strings.Get_Element (E_Str => Curr_Line.Conts,
                                   Pos   => Curr_Line.Curr_Pos);
      if Ch = '"' then
         LineManager.Accept_Char (Curr_Line => Curr_Line);
         -- Check for adjacent quotations. (See LRM 2.6).
         if E_Strings.Get_Element (E_Str => Curr_Line.Conts,
                                   Pos   => Curr_Line.Curr_Pos) = '"' then
            LineManager.Accept_Char (Curr_Line => Curr_Line); -- Two adjacent quotations - String not ended.
         else
            String_Not_Ended := False;
         end if;
      elsif Graphic_Character (Ch => Ch) then
         LineManager.Accept_Char (Curr_Line => Curr_Line);
      else
         String_Not_Ended := False;
      end if;
   end loop;

   --# accept F, 501, Ch, "Ch always defined on this path";
   if Ch = '"' then
      Token := SP_Symbols.string_literal;
   else
      Token := SP_Symbols.unterminated_string;
   end if;
   --# end accept;

   --# accept F, 602, Token, Ch, "Ch always defined here";
end GetString;
