///###////////////////////////////////////////////////////////////////////////
//
// Burton Computer Corporation
// http://www.burton-computer.com
// $Id: MessageFactory.h,v 1.25 2004/01/14 17:38:40 bburton Exp $
//
// Copyright (C) 2000 Burton Computer Corporation
// ALL RIGHTS RESERVED
//
// This program is open source software; you can redistribute it
// and/or modify it under the terms of the Q Public License (QPL)
// version 1.0. Use of this software in whole or in part, including
// linking it (modified or unmodified) into other programs is
// subject to the terms of the QPL.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// Q Public License for more details.
//
// You should have received a copy of the Q Public License
// along with this program; see the file LICENSE.txt.  If not, visit
// the Burton Computer Corporation or CoolDevTools web site
// QPL pages at:
//
//    http://www.burton-computer.com/qpl.html
//

#ifndef _MessageFactory_h
#define _MessageFactory_h

#include "AbstractMessageFactory.h"

class AbstractPhraseBuilder;

class MessageFactory : public AbstractMessageFactory
{
public:
  MessageFactory();
  ~MessageFactory();

  void initMessage(Message &msg,
                   MimeMessageReader &reader);

  void setReplaceNonAsciiChars(int value)
  {
    if (value >= 0) {
      m_replaceNonAsciiChars = true;
      m_nonAsciiChar = tolower((char)value);
    } else {
      m_replaceNonAsciiChars = false;
    }
  }

  string::size_type getMinWordLength() const
  {
    return m_minWordLength;
  }

  string::size_type getMaxWordLength() const
  {
    return m_maxWordLength;
  }

  bool getRemoveHTML() const
  {
    return m_removeHTML;
  }

  void setMinWordLength(string::size_type value)
  {
    m_minWordLength = value;
  }

  void setMaxWordLength(string::size_type value)
  {
    m_maxWordLength = value;
  }

  void setRemoveHTML(bool value)
  {
    m_removeHTML = value;
  }

  void setMinPhraseLength(int length);

  void setMaxPhraseLength(int length);

  void setMaxPhraseChars(int length);

  void setSpamProbeFieldName(const string &value)
  {
    m_spamprobeFieldName = value;
  }

  enum HeaderSpec_t {
    NORMAL_HEADERS,
    ALL_HEADERS,
    NO_X_HEADERS,
    NO_HEADERS
  };
  void setHeadersToInclude(HeaderSpec_t value)
  {
    m_headersToInclude = value;
  }

  void clearPrefixedHeaders()
  {
    m_prefixedHeaders.clear();
  }

  void addPrefixedHeader(const string &header_name)
  {
    assert(is_lower(header_name));
    m_prefixedHeaders.insert(make_pair(header_name,
                                       PREFIX_0 + header_name + PREFIX_1));
  }

  void addPrefixedHeader(const string &header_name,
                         const string &prefix)
  {
    assert(is_lower(header_name));
    m_prefixedHeaders.insert(make_pair(header_name,
                                       PREFIX_0 + prefix + PREFIX_1));
  }

  void useProximityPhraser();

  void setKeepSuspiciousTags(bool value)
  {
    m_keepSuspiciousTags = value;
  }

  void addAdditionalHeader(const string &header)
  {
    m_additionalHeaders.push_back(to_lower(header));
  }

  void setIgnoreBody(bool value)
  {
    m_ignoreBody = value;
  }

private:
  string getHeaderPrefix(const string &header_name);

  void addHeaderToMessage(const string &name,
                          Message &msg,
                          MimeMessageReader &reader,
                          bool tag_extra_headers = false,
                          bool decode_header = true);
  void addWordToMessage(const string &value,
                        const string &prefix,
                        Message &msg);
  void addWordPartsToMessage(const string &value,
                             const string &prefix,
                             Message &msg);
  void addStringToMessage(const string &value,
                          const string &prefix,
                          Message &msg);
  void addTextToMessage(const string &value,
                        Message &msg);
  bool isHTML(const string &lower);
  bool isSpaceTag(const string &tag);
  bool isSuspiciousTag(const string &tag);
  bool processUrls(string &tag,
                   Message &msg);
  void processTag(string tag,
                  Message &msg);
  void addHrefFromTag(const string &url,
                      Message &msg);
  void removeHTMLFromText(string &text,
                          Message &msg);
  void expandEntitiesInHTML(string &text);
  void expandCharsInURL(string &url);
  void addHeadersToMessage(Message &msg,
                           MimeMessageReader &reader);
  void assignDigestToMessage(Message &msg,
                             MimeMessageReader &reader);
  void addIPAddressTerm(const string &term,
                        const string &prefix,
                        Message &msg);
  void addTokenToMessage(const string &term,
                         const string &prefix,
                         int token_flags,
                         Message &msg);

private:
  string::size_type m_minWordLength;
  string::size_type m_maxWordLength;
  NewPtr<AbstractPhraseBuilder> m_phraser;

  bool m_replaceNonAsciiChars;
  char m_nonAsciiChar;

  bool m_removeHTML;
  bool m_keepSuspiciousTags;
  bool m_ignoreBody;
  HeaderSpec_t m_headersToInclude;
  vector<string> m_additionalHeaders;

  string m_spamprobeFieldName;
  map<string,string> m_prefixedHeaders;

  static const string PREFIX_0;
  static const string PREFIX_1;
  static const string EXTRA_HEADER_SUFFIX;
};

#endif // _MessageFactory_h
