/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * soup-dav-server.h: DAV server support.
 *
 * Authors:
 *      Alex Graveley (alex@ximian.com)
 *
 * Copyright (C) 2001, Ximian, Inc.
 */

#ifndef SOUP_DAV_SERVER_H
#define SOUP_DAV_SERVER_H 1

#include <glib.h>
#include <libsoup/soup-message.h>
#include <libsoup/soup-server.h>
#include <libsoup/soup-dav.h>

typedef enum {
	SOUP_DAV_OPTIONS,
	SOUP_DAV_COPY,
	SOUP_DAV_MOVE,
	SOUP_DAV_GET,
	SOUP_DAV_PUT,
	SOUP_DAV_MKCOL, 
	SOUP_DAV_DELETE,
	SOUP_DAV_PROPFIND,
	SOUP_DAV_PROPPATCH,
	SOUP_DAV_LOCK,
	SOUP_DAV_UNLOCK,
	SOUP_DAV_SEARCH
} SoupDavAction;

typedef struct {
	SoupDavAction        action;
	gchar               *path;
	SoupMessage         *msg;
	SoupServerAuthToken *auth;
	guint                handler_id;
} SoupDavContext;

void   soup_dav_context_set_mstat    (SoupDavContext     *ctx,
				      SoupDavMultiStatus *ms);

void   soup_dav_context_set_response (SoupDavContext     *ctx,
				      SoupDavMultiStatus *resp);

gchar *soup_dav_context_make_href    (SoupDavContext     *ctx,
				      const gchar        *path);

typedef struct {
	gboolean  (*uri_exists)         (SoupDavContext       *ctx, 
					 const gchar          *path,
					 gpointer              user_data);

	gboolean  (*is_collection)      (SoupDavContext       *ctx, 
					 const gchar          *path,
					 gpointer              user_data);

	GSList   *(*opt_describe_locks) (SoupDavContext       *ctx, 
					 const gchar          *path,
					 gpointer              user_data);

	gboolean  (*opt_lock)           (SoupDavContext       *ctx,  
					 const gchar          *path,
					 const SoupDavLock    *lock, 
					 gpointer              user_data);

	gboolean  (*opt_unlock)         (SoupDavContext       *ctx,  
					 const gchar          *path,
					 const SoupDavLock    *lock, 
					 gpointer              user_data);

	gboolean  (*create_collection)  (SoupDavContext       *ctx,
					 const gchar          *path,
					 gpointer              user_data);

	gboolean  (*create_doc)         (SoupDavContext       *ctx,  
					 const gchar          *path,
					 const SoupDataBuffer *buf, 
					 gpointer              user_data);

	gboolean  (*delete_collection)  (SoupDavContext       *ctx, 
					 const gchar          *path,
					 gpointer              user_data);

	gboolean  (*delete_doc)         (SoupDavContext       *ctx, 
					 const gchar          *path,
					 gpointer              user_data);

	gboolean  (*can_delete)         (SoupDavContext       *ctx, 
					 const gchar          *path,
					 gpointer              user_data);

	GSList   *(*list_contents)      (SoupDavContext       *ctx, 
					 const gchar          *path,
					 gpointer              user_data);

	gboolean  (*get_content)        (SoupDavContext       *ctx,  
					 const gchar          *path,
					 SoupDataBuffer       *out_buf, 
					 gpointer              user_data);

	gboolean  (*set_content)        (SoupDavContext       *ctx,  
					 const gchar          *path,
					 SoupDataBuffer       *in_buf, 
					 gpointer              user_data);

	gboolean  (*get_dav_prop)       (SoupDavContext       *ctx,  
					 const gchar          *path,
					 const SoupDavProp    *out_prop, 
					 gpointer              user_data);

	gboolean  (*set_dav_prop)       (SoupDavContext       *ctx,  
					 const gchar          *path,
					 const SoupDavProp    *prop, 
					 gpointer              user_data);

	GSList   *(*list_custom_props)  (SoupDavContext       *ctx, 
					 const gchar          *path,
					 gpointer              user_data);

	gboolean  (*get_custom_prop)    (SoupDavContext       *ctx,  
					 const gchar          *path,
					 const SoupDavProp    *out_prop, 
					 gpointer              user_data);

	gboolean  (*set_custom_prop)    (SoupDavContext       *ctx,  
					 const gchar          *path,
					 const SoupDavProp    *prop, 
					 gpointer              user_data);

	gboolean  (*delete_custom_prop) (SoupDavContext       *ctx,  
					 const gchar          *path,
					 const SoupDavProp    *prop, 
					 gpointer              user_data);

	void      (*opt_move)           (SoupDavContext       *ctx,
					 const gchar          *path,
					 const gchar          *new_path,
					 gboolean              overwrite,
					 gpointer              user_data);

	void      (*opt_copy)           (SoupDavContext       *ctx,
					 const gchar          *path,
					 const gchar          *new_path,
					 gboolean              overwrite,
					 gpointer              user_data);

	void      (*opt_search)         (SoupDavContext       *ctx,
					 const gchar          *path,
					 const gchar          *content,
					 gpointer              user_data);

	gpointer reserved1;
	gpointer reserved2;
	gpointer reserved3;
	gpointer reserved4;
} SoupDavServerHandlers;

void   soup_dav_server_clear_table    (SoupDavServerHandlers *handlers);

guint  soup_dav_server_register       (const gchar                 *path_regex,
				       const SoupDavServerHandlers *handlers,
				       gpointer                     user_data);

const SoupDavServerHandlers *
       soup_dav_server_get_table      (guint                  table_tag);

void   soup_dav_server_unregister     (guint                  table_tag);

#endif /* SOUP_SERVER_H */
