<?php

$block_name = _("Vacation Summary");

/**
 * $Horde: vacation/lib/Block/summary.php,v 1.7.2.2 2009/01/29 11:57:31 jan Exp $
 *
 * @package Horde_Block
 */
class Horde_Block_Vacation_summary extends Horde_Block {

    var $_app = 'vacation';

    function _title()
    {
        return Horde::link(Horde::applicationUrl($registry->getInitialPage(), true))
            . $registry->get('name') . '</a>';
    }

    function _content()
    {
        require_once dirname(__FILE__) . '/../base.php';
        require_once VACATION_BASE . '/lib/Driver.php';

        // Create the driver.
        $driver = Vacation_Driver::factory(Auth::getAuth());

        // Find out if vacation is active.
        if (!$driver) {
            return '<p><em>' . _("Failed to create a vacation driver") . '</em></p>';
        }

        return '<p><strong>' . (!$driver->isEnabled(Auth::getCredential('password')) ?
                                _("Vacation is not active.") :
                                _("Vacation is active.")) . '</strong></p>';
    }

}
