<?php

$block_name = _("Forwards Summary");

/**
 * $Horde: forwards/lib/Block/summary.php,v 1.7.2.1 2008/10/09 17:36:37 jan Exp $
 *
 * @package Horde_Block
 */
class Horde_Block_Forwards_summary extends Horde_Block {

    var $_app = 'forwards';

    function _title()
    {
        global $registry;
        return Horde::link(Horde::applicationUrl($registry->getInitialPage(), true)) . $registry->get('name') . '</a>';
    }

    function _content()
    {
        global $registry;
        require_once dirname(__FILE__) . '/../base.php';
        require_once FORWARDS_BASE . '/lib/Driver.php';

        // Get the current login credentials.
        $split = explode('@', Auth::getAuth());
        $user = @$split[0];
        $realm = @$split[1];
        $pass = Auth::getCredential('password');

        // Create the driver.
        $driver = &Forwards_Driver::factory();

        // Find out if forwarding is activated or not.
        if (!isset($driver)) {
            return '<p><em>' . _("Failed to create a forwards driver") . '</em></p>';
        }

        if (!$driver->isEnabledForwarding($user, $realm, $pass)) {
            return '<p><strong>' . _("Forward is not active.") . '</strong></p>';
        }

        $to = $driver->currentTarget($user, $realm, $pass);
        if ($to) {
            // FIXME: should we parse the contents returned?
            return '<p><strong>' . _("Forward is active.") . '</strong><p>' .
                '<blockquote>' . nl2br(htmlentities($to)) . '</blockquote>';
        }

        return '<p><strong>' . _("Forward is active, unable to retrieve additional details.") . '</strong></p>';
    }

}
