<?php
/**
 * $Horde: forwards/main.php,v 1.36.2.2 2007/01/02 13:54:05 jan Exp $
 *
 * Copyright 2001-2007 Eric Rostetter <eric.rostetter@physics.utexas.edu>
 *
 * See the enclosed file LICENSE for license information (BSDL). If you
 * did not receive this file, see http://www.horde.org/licenses/bsdl.php.
 */

@define('FORWARDS_BASE', dirname(__FILE__));
require_once FORWARDS_BASE . '/lib/base.php';
require_once FORWARDS_BASE . '/lib/Driver.php';

$driver = &Forwards_Driver::factory();

// Get the current login username and realm.
$split = explode('@', Auth::getAuth());
$user = @$split[0];
$realm = @$split[1];
if (empty($realm)) {
    $realm = 'default';
}

$submit = Util::getFormData('submit', false);
if ($submit) {
    $forwardmode = Util::getFormData('mode', 'error');
    if ($forwardmode === 'error') {
        $notification->push(_("You must specify the mode (set or remove)"), 'horde.warning');
    }

    // Check for refused usernames, using current horde username.
    if (in_array($user, $conf['user']['refused'])) {
        $notification->push(sprintf(_("You can't change Forwards for user %s"), $user), 'horde.error');
        $forwardmode = 'error';
    }

    if ($conf['enabled']['authenticate']) {
        $oldpassword = Util::getFormData('oldpassword', false);
        if (!$oldpassword) {
            $notification->push(_("You must give your password"), 'horde.warning');
            $forwardmode = 'error';
        }
    } else {
        $oldpassword = Auth::getCredential('password');
    }

    $metoo = Util::getFormData('metoo', false);
    if ($metoo != 'on') {
        $metoo = 'off';
    }

    // Do the action requested.
    switch ($forwardmode) {
    case 'set':
        $forwardwhere = Util::getFormData('where', false);
        if (!$forwardwhere) {
            $notification->push(_("You must supply an e-mail address!"), 'horde.warning');
        } else {
            if ($driver->enableForwarding($user, $realm, $oldpassword, $forwardwhere, $metoo)) {
                $notification->push(_("Forward set!"), 'horde.success');
            } else {
                $notification->push(sprintf(_("Failure in setting forward: %s"), $driver->getError()),
                                    'horde.error');
            }
        }
        break;

    case 'unset':
        if ($driver->disableForwarding($user, $realm, $oldpassword)) {
            $notification->push(_("Forward removed!"), 'horde.success');
        } else {
            $notification->push(sprintf(_("Failure in removing forward: %s"), $driver->getError()),
                                'horde.error');
        }
        break;
    }
}

// The backend always returns 'Y' if forwarding is enabled, but may
// not be able to say with certainty that forwarding is *disabled* -
// 'N' means "there is definitely no forwarding address set", false
// means that we can't determine the current state.
$pass = Auth::getCredential('password');
if ($driver->isEnabledForwarding($user, $realm, $pass) == 'Y') {
    $notification->push(_("Forwarding is currently enabled."), 'horde.success');
} elseif ($driver->isEnabledForwarding($user, $realm, $pass) == 'N') {
    $notification->push(_("Forwarding is currently disabled."), 'horde.warning');
}

$notification->push('setFocus()', 'javascript');
$title = _("Set or Remove E-Mail Forwards");
require FORWARDS_TEMPLATES . '/common-header.inc';
require FORWARDS_TEMPLATES . '/main/main.inc';
require $registry->get('templates', 'horde') . '/common-footer.inc';
