/*
 * This file is part of the Sofia-SIP package
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Pekka Pessi <pekka.pessi@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef TEST_PROTOS_H
/** Defined when <test_protos.h> has been included. */
#define TEST_PROTOS_H

/**@ingroup test_msg
 * @file test_protos.h
 *
 * Prototypes and macros for dummy testing protocol headers.
 *
 * This file is automatically generated from <test_class.h> by msg_parser.awk.
 *
 * @author Pekka Pessi <Pekka.Pessi@nokia.com>
 */

#include <sofia-sip/su_config.h>
#include <sofia-sip/su_tag.h>
#include <sofia-sip/su_tag_class.h>

#ifndef MSG_HEADER_H
#include <sofia-sip/msg_header.h>
#endif

#ifndef MSG_MIME_PROTOS_H
#include <sofia-sip/msg_mime_protos.h>
#endif

#ifndef TEST_CLASS_H
#include <test_class.h>
#endif

SOFIA_BEGIN_DECLS

/** Test if tag type marks a msg_test_t structure. @HIDE */
#define TSTTAG_P(tt)     ((tt)->tt_class == tsthdrtag_class)
/** Test if tag type marks a TST header string. @HIDE */
#define TSTTAG_STR_P(tt) ((tt)->tt_class == tststrtag_class)
/** Test if tag type marks a TST header structure. @HIDE */
#define TSTTAG_TST_P(tt) ((tt)->tt_class == tstmsgtag_class)

/** Test if tag item contains msg_test_t structure. @HIDE */
#define TSTTAGI_P(t)     (TSTTAG_P((t)->t_tag))
/** Test if tag item contains a TST header string. @HIDE */
#define TSTTAGI_STR_P(t) (TSTTAG_STR_P((t)->t_tag))
/** Test if tag item contains a TST header structure. @HIDE */
#define TSTTAGI_TST_P(t) (TSTTAG_TST_P((t)->t_tag))

/** Tag class for TST headers */
extern tag_class_t tsthdrtag_class[1];
/** Tag class for string values of TST headers */
extern tag_class_t tststrtag_class[1];
/** Tag class for TST message */
extern tag_class_t tstmsgtag_class[1];

/**Tag list item for header string.
 *
 * The TSTTAG_HEADER_STR() macro is used to include a tag item containing a
 * header string in the tag list, e.g.,
 * @code
 * TSTTAG_HEADER_STR("Priority: urgent").
 * @endcode
 *
 * @param x pointer to a string, or NULL.
 *
 * @HIDE
 */
#define TSTTAG_HEADER(x)       tsttag_header, tsttag_header_v((x))

/** Tag for header string */
extern tag_typedef_t tsttag_header;

#define TSTTAG_HEADER_REF(x)   tsttag_header_ref, tsttag_header_vr(&(x))
extern tag_typedef_t tsttag_header_ref;

#if HAVE_INLINE
su_inline tag_value_t
tsttag_header_v(msg_header_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
tsttag_header_vr(msg_header_t const **vp)
{ return (tag_value_t)vp; }
#else
#define tsttag_header_v(v)   (tag_value_t)(v)
#define tsttag_header_vr(vp) (tag_value_t)(vp)
#endif

/**Tag list item for header string.
 *
 * The TSTTAG_HEADER_STR() macro is used to include a tag item containing a
 * header string in the tag list.
 *
 * @param x pointer to a string, or NULL.
 *
 * @HIDE
 */
#define TSTTAG_HEADER_STR(x)       tsttag_header_str, tag_str_v((x))

/** Tag for header string */
extern tag_typedef_t tsttag_header_str;

#define TSTTAG_HEADER_STR_REF(x)   tsttag_header_str_ref, tag_str_vr(&(x))
extern tag_typedef_t tsttag_header_str_ref;

#if HAVE_INLINE
su_inline
tag_value_t tsttag_tst_v(msg_test_t const *v) { return (tag_value_t)v; }
su_inline
tag_value_t tsttag_tst_vr(msg_test_t const **vp) { return (tag_value_t)vp; }
#else
#define tsttag_tst_v(v)   (tag_value_t)(v)
#define tsttag_tst_vr(vp) (tag_value_t)(vp)
#endif



/**@addtogroup test_msg_request*//**@{*/

/** Parse a request line. @internal */
msg_parse_f msg_request_d;

/** Print a request line. @internal */
msg_print_f msg_request_e;


/**Header class for request line.
 *
 * The header class msg_request_class defines how a
 * request line is parsed and printed.  It also
 * contains methods used by message parser and other functions
 * to manipulate the msg_request_t header structure.
 */
extern msg_hclass_t msg_request_class[];

/**Initializer for structure msg_request_t.
 *
 * A static msg_request_t structure must be initialized
 * with the MSG_REQUEST_INIT() macro. For instance,
 * @code
 *
 *  msg_request_t msg_request = MSG_REQUEST_INIT;
 *
 * @endcode
 * @HI
 */
#define MSG_REQUEST_INIT() MSG_HDR_INIT(request)

/**Initialize a structure msg_request_t.
 *
 * An msg_request_t structure can be initialized with the
 * msg_request_init() function/macro. For instance,
 * @code
 *
 *  msg_request_t msg_request;
 *
 *  msg_request_init(&msg_request);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline msg_request_t *msg_request_init(msg_request_t x[1])
{
  return MSG_HEADER_INIT(x, msg_request_class, sizeof(msg_request_t));
}
#else
#define msg_request_init(x) \
  MSG_HEADER_INIT(x, msg_request_class, sizeof(msg_request_t))
#endif

/**Test if header object is instance of msg_request_t.
 *
 * The function msg_is_request() returns true (nonzero) if
 * the header class is an instance of request line
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function msg_is_xrequest() returns true (nonzero) if
 * the header object is an instance of header request and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline int msg_is_request(msg_header_t const *header)
{
  return header && header->sh_class->hc_hash == msg_request_hash;
}
#else
int msg_is_request(msg_header_t const *header);
#endif

#define msg_request_p(h) msg_is_request((h))

/**Duplicate (deep copy) @c msg_request_t.
 *
 * The function msg_request_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   request = msg_request_dup(home, tst->msg_request);
 *
 * @endcode
 *
 * @return
 * The function msg_request_dup() returns a pointer to the
 * newly duplicated msg_request_t header structure, or NULL
 * upon an error.
 */
msg_request_t *msg_request_dup(su_home_t *home, msg_request_t const *hdr);

/**Copy a msg_request_t header structure.
 *
 * The function msg_request_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   request = msg_request_copy(home, tst->msg_request);
 *
 * @endcode
 *
 * @return
 * The function msg_request_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
msg_request_t *msg_request_copy(su_home_t *home,
				  msg_request_t const *hdr);

/**Make a header structure msg_request_t.
 *
 * The function msg_request_make() makes a new
 * msg_request_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_make().
 *
 * @return
 * The function msg_request_make() returns a pointer to
 * newly maked msg_request_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline msg_request_t *msg_request_make(su_home_t *home, char const *s)
{
  return (msg_request_t *)msg_header_make(home, msg_request_class, s);
}
#else
msg_request_t *msg_request_make(su_home_t *home, char const *s);
#endif

/**Make a request line from formatting result.
 *
 * The function msg_request_format() makes a new
 * request line object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function msg_request_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_request_t *msg_request_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__format__ (printf, 2, 3)));

#if SU_HAVE_INLINE
su_inline msg_request_t *msg_request_format(su_home_t *home, char const *fmt, ...)
{
  msg_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = msg_header_vformat(home, msg_request_class, fmt, ap);
  va_end(ap);

  return (msg_request_t *)h;
}
#endif

/** @} */



/**@addtogroup test_msg_status*//**@{*/

/** Parse a status line. @internal */
msg_parse_f msg_status_d;

/** Print a status line. @internal */
msg_print_f msg_status_e;


/**Header class for status line.
 *
 * The header class msg_status_class defines how a
 * status line is parsed and printed.  It also
 * contains methods used by message parser and other functions
 * to manipulate the msg_status_t header structure.
 */
extern msg_hclass_t msg_status_class[];

/**Initializer for structure msg_status_t.
 *
 * A static msg_status_t structure must be initialized
 * with the MSG_STATUS_INIT() macro. For instance,
 * @code
 *
 *  msg_status_t msg_status = MSG_STATUS_INIT;
 *
 * @endcode
 * @HI
 */
#define MSG_STATUS_INIT() MSG_HDR_INIT(status)

/**Initialize a structure msg_status_t.
 *
 * An msg_status_t structure can be initialized with the
 * msg_status_init() function/macro. For instance,
 * @code
 *
 *  msg_status_t msg_status;
 *
 *  msg_status_init(&msg_status);
 *
 * @endcode
 * @HI
 */
#if SU_HAVE_INLINE
su_inline msg_status_t *msg_status_init(msg_status_t x[1])
{
  return MSG_HEADER_INIT(x, msg_status_class, sizeof(msg_status_t));
}
#else
#define msg_status_init(x) \
  MSG_HEADER_INIT(x, msg_status_class, sizeof(msg_status_t))
#endif

/**Test if header object is instance of msg_status_t.
 *
 * The function msg_is_status() returns true (nonzero) if
 * the header class is an instance of status line
 * object and false (zero) otherwise.
 *
 * @param header pointer to the header structure to be tested
 *
 * @return
 * The function msg_is_xstatus() returns true (nonzero) if
 * the header object is an instance of header status and
 * false (zero) otherwise.
 */
#if SU_HAVE_INLINE
su_inline int msg_is_status(msg_header_t const *header)
{
  return header && header->sh_class->hc_hash == msg_status_hash;
}
#else
int msg_is_status(msg_header_t const *header);
#endif

#define msg_status_p(h) msg_is_status((h))

/**Duplicate (deep copy) @c msg_status_t.
 *
 * The function msg_status_dup() duplicates a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 *
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 *
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 *
 * @par Example
 * @code
 *
 *   status = msg_status_dup(home, tst->msg_status);
 *
 * @endcode
 *
 * @return
 * The function msg_status_dup() returns a pointer to the
 * newly duplicated msg_status_t header structure, or NULL
 * upon an error.
 */
msg_status_t *msg_status_dup(su_home_t *home, msg_status_t const *hdr);

/**Copy a msg_status_t header structure.
 *
 * The function msg_status_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the header
 * structure @a hdr.
 *
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be duplicated
 *
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated.  The new header structure
 * retains all the references to the strings within the old @a
 * header, including the encoding of the old header, if present.
 *
 * @par Example
 * @code
 *
 *   status = msg_status_copy(home, tst->msg_status);
 *
 * @endcode
 *
 * @return
 * The function msg_status_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
msg_status_t *msg_status_copy(su_home_t *home,
				  msg_status_t const *hdr);

/**Make a header structure msg_status_t.
 *
 * The function msg_status_make() makes a new
 * msg_status_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 *
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_make().
 *
 * @return
 * The function msg_status_make() returns a pointer to
 * newly maked msg_status_t header structure, or NULL upon
 * an error.
 */
#if SU_HAVE_INLINE
su_inline msg_status_t *msg_status_make(su_home_t *home, char const *s)
{
  return (msg_status_t *)msg_header_make(home, msg_status_class, s);
}
#else
msg_status_t *msg_status_make(su_home_t *home, char const *s);
#endif

/**Make a status line from formatting result.
 *
 * The function msg_status_format() makes a new
 * status line object using formatting result as its
 * value.  The function first prints the arguments according to
 * the format @a fmt specified.  Then it allocates a new header
 * structure, and uses the formatting result as the header
 * value.
 *
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 *
 * @note This function is usually implemented as a macro calling
 * msg_header_format().
 *
 * @return
 * The function msg_status_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 *
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_status_t *msg_status_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__format__ (printf, 2, 3)));

#if SU_HAVE_INLINE
su_inline msg_status_t *msg_status_format(su_home_t *home, char const *fmt, ...)
{
  msg_header_t *h;
  va_list ap;

  va_start(ap, fmt);
  h = msg_header_vformat(home, msg_status_class, fmt, ap);
  va_end(ap);

  return (msg_status_t *)h;
}
#endif

/** @} */



SOFIA_END_DECLS

#endif /* !defined(TEST_PROTOS_H) */
