/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* $Id: update_db.c,v 1.1.1.1 2005/11/04 07:19:35 tkitame Exp $ 
 *
 * Copyright (c) 2005 VA Linux Systems Japan, K.K. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/un.h>
#include <sys/param.h>
#include <unistd.h>
#include <errno.h>

#include <glib.h>

#include "smtpguard-daemon.h"

#ifndef FG_DISABLE_DEPRECATED
#include "sg_io.h"
#endif

#include "fg-protocol-xml.h"
#include "fg-smtp-info.h"

int smtpguard_debug_level = 0;

//
// for debug. display Hex dump(stderr).
void
disp_data (char *data, int length)
{
	int	i, j, k, n, x;
	char	c;

	if (smtpguard_debug_level < 2) return;
	i = 0; j = 0; k = 0; n = 0; x = 0; c = 0;
	sg_debug_head(2, "");
	while (length) {
		n++;
		if (!x) sg_debug_body(2, "%02X ", (unsigned char)data[i++]);
		if (n == 16) {
			sg_debug_body(2, "\t");
			for (j = k; j < i; j++) {
				c = data[j];
				if (c < 31 || c > 126) c = '.';
				sg_debug_body(2, "%c", c);
			}
			k = i; n = 0;
			sg_debug_tail(2, "");
			sg_debug_head(2, "");
		}
		if (i >= length) {
			if (x) break;
			while (n++ < 14) sg_debug_body(2, "   ");
			sg_debug_body(2, "      ");
			x++;
		}
	}
	sg_debug_tail(2, "data end");
}

#ifndef FG_DISABLE_DEPRECATED
// free smtp_info_data
void
free_smtp_info_data (SmtpInfoData *sid)
{
	if (sid == NULL) return;
	if (sid->ip) g_free (sid->ip);
	if (sid->mailfrom) g_free (sid->mailfrom);
	if (sid->rcptto) g_free (sid->rcptto);
	if (sid->message) g_free (sid->message);
	g_free (sid);
	sid = NULL;
}
#endif
// spam_update_db
// 
// 0  on success
// -1 on error (err msg is stored to spam_errmsg)
gint
fg_spam_update_db (FGSmtpInfo *fsi, GError **error)
{
	struct sockaddr_un	addr;
	gint	fd;
	gint	sel_cnt;
	fd_set	rwfd;
	struct timeval timeout;

	gchar *sockdir = SOCK_DIR;
	gchar *sockname = NULL;
	gchar sockpath[MAXPATHLEN] = SOCK_NAME;

	FGSmtpInfo *sfsi = NULL;
	GIOChannel *ioc;
	GError *tmperror = NULL;
	gchar *xmlbuff;
	gsize buffersize;

	xmlbuff = fg_smtp_info_get_xml (fsi, &tmperror);

	if (tmperror != NULL) {
		g_propagate_error (error, tmperror);
		return -1;
	}
	buffersize = strlen (xmlbuff);

	if (getenv("SMTPGUARD_SOCK_DIR") && getenv("SMTPGUARD_SOCK_NAME")) {
		sockdir = getenv("SMTPGUARD_SOCK_DIR");
		sockname = getenv("SMTPGUARD_SOCK_NAME");
		snprintf (sockpath, sizeof (sockpath), "%s/%s",
			  sockdir, sockname);
	}

	sg_set_debug_level (smtpguard_debug_level);

	if ((fd = socket (PF_UNIX, SOCK_STREAM, 0)) < 0) {
		g_set_error (error, FG_SMTP_INFO_ERROR,
			     FG_SMTP_INFO_ERROR_SOCKET_ERROR,
			     "socket error: %d", errno);
		return -1;
	}

	memset (&addr, 0, sizeof (struct sockaddr_un));

	addr.sun_family = AF_UNIX;
	strcpy(addr.sun_path, sockpath);

	if (connect(fd, (struct sockaddr *)&addr,
		    sizeof (addr.sun_family) + strlen (sockpath)) < 0){
		g_set_error (error, FG_SMTP_INFO_ERROR,
			     FG_SMTP_INFO_ERROR_SOCKET_ERROR,
			     "connect error: %s,%d", sockpath, errno);
		close (fd);
		return -1;
	}

	ioc = g_io_channel_unix_new (fd);

	/* write loop */
	sel_cnt = 0;
	for (;;) {
		FD_ZERO (&rwfd);
		FD_SET (fd, &rwfd);

		/* FIXME: should be configuable timeout */
		timeout.tv_sec = 1;
		timeout.tv_usec = 0;

		if (select (fd + 1, NULL, &rwfd, NULL, &timeout) <= 0) {
			if ((++sel_cnt >= SELECT_TRY_MAX) ||
			    ((errno != EAGAIN) && (errno != EINTR))) {
				g_set_error (error, FG_SMTP_INFO_ERROR,
					     FG_SMTP_INFO_ERROR_SOCKET_ERROR,
					     "select error for write: errno: %d", errno);
				g_io_channel_unref (ioc);
				close (fd);
				g_free (xmlbuff);
				return -1;
			}
			continue; /* timeout */
		}

		if (FD_ISSET (fd, &rwfd)) {
			fg_write_protocol (ioc, xmlbuff, strlen(xmlbuff),
					   &tmperror);			
			if (tmperror != NULL) {
				g_propagate_error (error, tmperror);
				g_io_channel_unref (ioc);
				close (fd);
				g_free (xmlbuff);
				return -1;
			}
			break;
		}
	}
	g_free (xmlbuff);
	xmlbuff = NULL;
	sel_cnt = 0;

	// select loop for receive data
	for (;;) {
		FD_ZERO (&rwfd);
		FD_SET (fd, &rwfd);
		timeout.tv_sec = 1;
		timeout.tv_usec = 0;
		if (select(fd + 1, &rwfd, NULL, NULL, &timeout) <= 0) {
			if ((++sel_cnt >= SELECT_TRY_MAX) ||
			    ((errno != EAGAIN) && (errno != EINTR))) {
				g_set_error (error, FG_SMTP_INFO_ERROR,
					     FG_SMTP_INFO_ERROR_PROTOCOL_ERROR,

					     "select error for read: errno: %d", errno);
				g_io_channel_unref (ioc);
				close (fd);
				return -1;
			}
			continue;
		}
		if (FD_ISSET (fd, &rwfd)) {
			sfsi = fg_read_parse (ioc, &tmperror);
			if (tmperror != NULL) {
                               g_propagate_error (error, tmperror);
                               if (xmlbuff) g_free (xmlbuff);
                               g_io_channel_unref (ioc);
                               close (fd);
			       return -1;
			}
			break;
		}
	}
	g_io_channel_unref (ioc);
	close (fd);

	if (sfsi == NULL) {				
		g_propagate_error (error, tmperror);

		return -1;
	}

	// set for smtpd action
	if (sfsi) {
		fg_smtp_info_set_action (fsi,
					 fg_smtp_info_get_action_message (sfsi),
					 fg_smtp_info_get_wait (sfsi),
					 fg_smtp_info_get_action_code (sfsi));
		fg_smtp_info_free (sfsi);
	}

	return 0;
}

/* backward compatibility */
#ifndef FG_DISABLE_DEPRECATED
gint
spam_update_db (SmtpInfoData *sid)
{
	FGSmtpInfo *fsi;
	GError *error;


	return 0;
}
#endif

